/*
 
 *****************************************************************************
 * Author:                                                                   *
 * ------                                                                    *
 *  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  *
 *  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    *
 *  Jozef Stefan Institute                          Fax: x 386 1 477 3811    *
 *  Jamova 39, SI-1000 Ljubljana                                             *
 *  SLOVENIA                                                                 *
 *                                                                           *
 * Source: $XCRYSDEN_TOPDIR/C/xcFont.c
 * ------                                                                    *
 * Copyright (c) 1996-2003 by Anton Kokalj                                   *
 *****************************************************************************

 TODO: 

       4. make a routine for mapping TkFont -> XLFD and finding correct 
          normal/bold/medium/oblique/italic/roman       
*/

#ifndef WIN32
#  define TOGL_X11
#  define X11
#else
#  define WIN32_LEAN_AND_MEAN
#  include <windows.h>
#  undef WIN32_LEAN_AND_MEAN
#  include <winnt.h>
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>
#ifdef WIN32
#  include <tkPlatDecls.h>
#endif

#include "togl.h"

#ifndef WIN32
#  include <X11/Xutil.h>
#endif

#include "struct.h"
#include "xcGLparam.h"
#include "memory.h"
#include "xcfunc.h"

#define XC_FONT_TKYES_XNO 999

extern GLuint         fontOffset;
extern RasterFontSize rf;
AtomicLabel globalAtomLabel = { 
  0,  0,  0,
  {1.0, 1.0, 1.0},
  {0.0, 0.0, 0.0},
  XC_YES, (char*)NULL, (Tk_Font)NULL
};
AtomicLabel *atomLabel = (AtomicLabel*)NULL;
short *do_not_display_atomlabel = (short*)NULL; /* apply to all kind
						   of labels default
						   and custom  */

struct xcToglFont {
  char              *font;
  Tk_Font            tkfont;
  GLuint             base;
  int                height;
  int                width;
  struct xcToglFont *prev;
};
static struct xcToglFont *xcFont, *xcFontPtr = (struct xcToglFont*) NULL;

typedef struct {
  char    *font;
  char    *string;
  Tk_Font tkfont;
  int     height;
  int     width;
} FontType;


/* xcFont.c */
int XC_SetFontCb(struct Togl *togl, int argc, char *argv[]);
int XC_SetAtomLabelCb(struct Togl *togl, int argc, char *argv[]);
int XC_ClearAtomLabelCb(struct Togl *togl, int argc, char *argv[]);
static void _clearAtomLabel(int atomID);
int XC_QueryFontCb(struct Togl *togl, int argc, char *argv[]);
void xcFont_PrintString(const char *s);
void xcTkFontFreeAll(void);
static int _setFontColor(Tcl_Interp *interp, int argc, int bright_ind, char *bright_argv, int dark_ind, char *dark_argv, AtomicLabel *alabel);
static int _assignFont(int font_found, struct Togl *togl, const char *fontString, FontType thisFont);
static void xcFont_addNew(struct xcToglFont *f, struct Togl *togl, FontType this);
static struct xcToglFont *xcFont_find(char *font);


/* ------------------------------------------------------------------------
 *
 * $togl xc_setfont XLFD_fontname|tkfontname ?bright-fontcolor? ?dark-fontcolor?
 *
 * Format of bright-fontcolor & dark-fontcolor is RGB, where the
 * components are within [0-1].
 * ------------------------------------------------------------------------ */

int
XC_SetFontCb(struct Togl *togl, int argc, char *argv[]) {
  Tcl_Interp        *interp = Togl_Interp (togl);
  FontType          thisFont;
  int               result, font_found = 0;
    
  if (argc < 3 || argc > 5) {
    sprintf(interp->result, "wrong number of arguments, should be togl xc_setfont togl_font ?bright-fontcolor? ?dark-fontcolor?");
    return TCL_ERROR;
  }

  /* assign the font color first */
  
  if ( _setFontColor(interp, argc, 3, argv[3], 4, argv[4], &globalAtomLabel) == TCL_ERROR ) {
    return TCL_ERROR;
  }
  
  /* now parse the font-name */

  if (strlen(argv[2]) > 0) {
    /*
    int i;
    for (i=0; i < NFONTS; i++) {
      if ( strcmp (argv[2], fontType[i].string) == 0 ) {
	thisFont.font   = fontType[i].font;
	thisFont.height = fontType[i].height;
	thisFont.width  = fontType[i].width;
	font_found    = 1;
	break;
      }
    }
    */
    
    result = _assignFont(font_found, togl, argv[2], thisFont);
    /*fprintf(stderr,"_assignFont = %d\n", result);*/
    if ( result == TCL_ERROR ) {
      sprintf(interp->result, "couldn't load font %s", argv[2]);
      return TCL_ERROR;
    } else if ( result == XC_FONT_TKYES_XNO ) {
      return TCL_OK;
    } else {
      /* xcFont should exists by now */
      if ( !xcFont->base ) {
	sprintf(interp->result, "couldn't load font %s", argv[2]);
	return TCL_ERROR;
      }
    }      

    /* the font setting was successful, update the globalAtomLabel */
    globalAtomLabel.base   = xcFont->base;
    globalAtomLabel.tkfont = xcFont->tkfont;
    globalAtomLabel.height = xcFont->height;
    globalAtomLabel.width  = xcFont->width;
    globalAtomLabel.do_display = XC_YES;
    
    /*    
    fprintf(stderr, "FONT-INFO:: (xcFontPtr=%d)\n", xcFontPtr);
    fprintf(stderr, "  base=%d\n  tkfont=%d\n  h=%d, w=%d\n",
	    xcFont->base, &xcFont->tkfont, xcFont->height, xcFont->width);    
    */
  }

  Togl_PostRedisplay (togl);
  return TCL_OK;
}


/* ------------------------------------------------------------------------
   
  togl  xc_setatomlabel  atomID  labelString  ?XLFD_fontname?  ?bright-fontcolor? ?dark-fontcolor?

  dark-fontcolor   == color for ballstick+spacefill for lighting-Off display modes
  bright-fontcolor == color for the rest of display modes

  ------------------------------------------------------------------------ */

int
XC_SetAtomLabelCb(struct Togl *togl, int argc, char *argv[]) {
  Tcl_Interp *interp = Togl_Interp (togl);
  FontType   thisFont;
  int        atomID;
  
  if (argc < 4 || argc > 7) {
    sprintf(interp->result, "wrong number of arguments, must be togl  xc_setatomlabel  atomID  labelString  ?font?  ?fontColor1?  ?fontColor2?");
    return TCL_ERROR;
  }

  if (Tcl_GetInt(interp, argv[2], &atomID) == TCL_ERROR) {
    sprintf(interp->result, "wanted integer but got %s", argv[2]);
    return TCL_ERROR;
  }
  if ( atomID < 1 || atomID > natoms ) {
    sprintf(interp->result, "atomID %d out of range, should be within [1,%d]", atomID, natoms);
    return TCL_ERROR;
  }
  
  /* copy the atom label */
  atomLabel[atomID].label = (char*) xcRealloc ( atomLabel[atomID].label, sizeof(char)*((size_t) strlen(argv[3])+1) );
  strcpy(atomLabel[atomID].label, argv[3]);
  
  if ( argc >= 5 && strlen(argv[4]) > 0 ) {
    int result;
    
    result = _assignFont(0, togl, argv[4], thisFont);
    /*fprintf(stderr,"_assignFont = %d\n", result);*/
    if ( result == TCL_ERROR || !xcFont->base) {
      sprintf(interp->result, "couldn't load font %s", argv[2]);
      return TCL_ERROR;
    } else if ( result == XC_FONT_TKYES_XNO ) {
      return TCL_OK;
    }
    
    /* now assign the font */

    /* fprintf(stderr,"1-base:: %d\n", xcFont->base); */

    atomLabel[atomID].base   = xcFont->base;
    atomLabel[atomID].tkfont = xcFont->tkfont;
    atomLabel[atomID].height = xcFont->height;
    atomLabel[atomID].width  = xcFont->width;    
  } else if (!xcFontPtr) {
    /* default font */

    /* fprintf(stderr,"2-base:: %d\n", fontOffset); */

    atomLabel[atomID].base   = fontOffset;
    atomLabel[atomID].tkfont = (Tk_Font)NULL;
    atomLabel[atomID].height = rf.height;
    atomLabel[atomID].width  = rf.wid; 
  } else {
    /* assign the last font loaded global font */

    /* fprintf(stderr,"3-base:: %d\n", xcFontPtr->base); */

    atomLabel[atomID].base   = xcFontPtr->base;
    atomLabel[atomID].tkfont = xcFontPtr->tkfont;
    atomLabel[atomID].height = xcFontPtr->height;
    atomLabel[atomID].width  = xcFontPtr->width;    
  }
  atomLabel[atomID].do_display = XC_YES;

  /* assign the font color */

  if ( _setFontColor(interp, argc, 5, argv[5], 6, argv[6], atomLabel + atomID) == TCL_ERROR ) {
    return TCL_ERROR;
  }

  Togl_PostRedisplay (togl);
  return TCL_OK;
}



/* ------------------------------------------------------------------------
   
  togl xc_clearatomlabel  atomID  ?atomID? ...

  or

  togl xc_clearatomlabel all

  ------------------------------------------------------------------------ */

int
XC_ClearAtomLabelCb(struct Togl *togl, int argc, char *argv[]) {
  Tcl_Interp *interp = Togl_Interp (togl);
  int i;

  if (argc < 3 ) {
    sprintf(interp->result, "Usage:\n   togl xc_clearatomlabels  atomID  ?atomID? ...\n or \n   togl xc_cleanatomlabels all");
    return TCL_ERROR;
  }

  if ( strcmp(argv[2], "all") == 0 ) {
    /* the "xc_cleanatomlabels all form" */
    for (i=1; i<=natoms; i++) _clearAtomLabel(i);
  } 

  else {
    int atomID;  
    for (i=2; i<argc; i++) {
      if (Tcl_GetInt(interp, argv[i], &atomID) == TCL_ERROR) {
	sprintf(interp->result, "wanted integer but got %s", argv[i]);
	return TCL_ERROR;
      }
      if ( atomID < 1 || atomID > natoms ) {
	sprintf(interp->result, "atom index %d out of range, should be between [0,%d]", 
		atomID, natoms);
	return TCL_ERROR;
      }
      _clearAtomLabel(atomID);
    }
  }

  Togl_PostRedisplay (togl);
  return TCL_OK;
}
    
static void _clearAtomLabel(int atomID) {  
  atomLabel[atomID].base       = 0;
  atomLabel[atomID].do_display = XC_NO;
  xcFree(atomLabel[atomID].label);
  atomLabel[atomID].label      = (char*)NULL; 
}




/* ------------------------------------------------------------------------
 *
 * $togl xc_queryfont XLFD_fontname"tkfontname
 *
 * Format of bright-fontcolor & dark-fontcolor is RGB, where the
 * components are within [0-1].
 * ------------------------------------------------------------------------ */

int
XC_QueryFontCb(struct Togl *togl, int argc, char *argv[]) {
  Tcl_Interp *interp = Togl_Interp (togl);
  FontType   thisFont;
  int        result, font_found = 0;
    
  if (argc != 3 || argc > 5) {
    sprintf(interp->result, "wrong number of arguments, should be togl xc_queryfont XLFD_fontname");
    return TCL_ERROR;
  }
  
  result = _assignFont(font_found, togl, argv[2], thisFont);

  /* fprintf(stderr,"_assignFont = %d\n", result); */

  if ( result == XC_FONT_TKYES_XNO ) {
    return TCL_OK;
  } else if ( result == TCL_ERROR ) {
    char *result = Tcl_Alloc (sizeof(char) * 3);      
    sprintf(result, "-1");
    Tcl_SetResult(interp, result, TCL_DYNAMIC);    
  } else {
    /* xcFont should exists by now */
    if ( xcFont->base ) {
      char *result = Tcl_Alloc (sizeof(char) * 3);      
      sprintf(result, "+1");
      Tcl_SetResult(interp, result, TCL_DYNAMIC);    
    } else {
      char *result = Tcl_Alloc (sizeof(char) * 3);      
      sprintf(result, "-1");
      Tcl_SetResult(interp, result, TCL_DYNAMIC);    
    }
  }    
  return TCL_OK;
}



void xcFont_PrintString (const char *s) {
  glCallLists( strlen(s), GL_UNSIGNED_BYTE, s );
}



void xcTkFontFreeAll(void) {
  struct xcToglFont *f = xcFontPtr;
  while (f) {
    if (f->tkfont) Tk_FreeFont (f->tkfont);
    f = f->prev;
  }
}



static int _setFontColor(Tcl_Interp *interp, int argc, 
			 int bright_ind, char *bright_argv, 
			 int dark_ind, char *dark_argv, AtomicLabel *alabel) {
  GetGlParam  bright, dark;
  
  if ( argc > bright_ind && strlen(bright_argv) > 0 ) {
    if ( ! xcSplitList( XC_GET_RGB, interp, &bright_argv, &bright ) ) {
      sprintf(interp->result, "error parsing bright font color, should be {red green blue}, but got %s", bright_argv);
      return TCL_ERROR;
    }
    COPY_V(3, alabel->bright_color, bright.vec);
  }
  
  if ( argc > dark_ind && strlen(dark_argv) > 0 ) {
    if ( ! xcSplitList( XC_GET_RGB, interp, &dark_argv, &dark ) ) {
      sprintf(interp->result, "error parsing dark font color, should be {red green blue}, but got %s", dark_argv);
      return TCL_ERROR;
    }
    COPY_V(3, alabel->dark_color, dark.vec);
  }

  return TCL_OK;
}


static void xcFont_addNew(struct xcToglFont *f, struct Togl *togl, FontType this) {
  f->font   = this.font;
  f->base   = Togl_LoadBitmapFont (togl, this.font);
  /*fprintf(stderr, "f->base==%d\n", f->base);*/
  f->tkfont = this.tkfont;
  f->height = this.height;
  f->width  = this.width;
  f->prev   = xcFontPtr;
  xcFontPtr = f;
}


static struct xcToglFont *xcFont_find(char *font) {
  struct xcToglFont *f = xcFontPtr;
  while (f) {
    /*fprintf(stderr, "f: %s %s\n", font, f->font);*/
    if (strcmp(font,f->font) == 0) return f;
    f = f->prev;
  }
  return (struct xcToglFont*) NULL;
}



#ifdef WIN32

/*
 * The following structure represents Windows' implementation of a font.
 */

typedef struct {
    Tk_Font font;		/* Stuff used by generic font package.  Must
				 * be first in structure. */
    HFONT hFont;		/* Windows information about font. */
    HWND hwnd;			/* Toplevel window of application that owns
				 * this font, used for getting HDC. */
    int widths[256];		/* Widths of first 256 chars in this font. */
} WinFont;

#include "togl_struct.h"
#endif /* WIN32 */


static int 
_assignFont(int font_found, struct Togl *togl, const char *fontString, FontType thisFont) 
{
  struct xcToglFont *_font;

#ifndef WIN32
  /* X11 */
  XFontStruct *fontinfo;
#else
  /* WIN32 */
  WinFont    *winfont;
  TEXTMETRIC tm;
#endif

  if (!font_found) {
    Tcl_Interp  *interp = Togl_Interp(togl);
    /* 
       use the Tk-wrapper to prevent segmentation-fault of XLoadQueryFont 
       when font-name is invalid 
    */
    Tk_Font tkfont;

    tkfont = Tk_GetFont(interp, Togl_TkWin(togl), fontString);
    if (!tkfont) {
      return TCL_ERROR;
    }
    /*_font = Tk_NameOfFont (tkfont);*/
#ifndef WIN32
    /* X11 */
    fontinfo = (XFontStruct *) XLoadQueryFont( Tk_Display(Togl_TkWin(togl)), fontString );
    if (!fontinfo) {
      char *result = Tcl_Alloc (sizeof(char) * 3);      
      sprintf(result, "-1");
      Tk_FreeFont (tkfont);
      Tcl_SetResult(interp, result, TCL_DYNAMIC);
      return XC_FONT_TKYES_XNO;
    }    

    thisFont.height = fontinfo->max_bounds.ascent - fontinfo->max_bounds.descent;
    thisFont.width  = fontinfo->max_bounds.rbearing - fontinfo->max_bounds.lbearing;
#else
    /* WIN32 */

    /*HFONT      oldFont;*/
    /*oldFont = SelectObject(togl->tglGLHdc, winfont->hFont);*/

    winfont = (WinFont*) tkfont;
    if (!winfont) {
      return 0;
    }

    SelectObject(togl->tglGLHdc, winfont->hFont);
    GetTextMetrics(togl->tglGLHdc, &tm);
    /*fontString      = Tk_NameOfFont(tkfont);
      fprintf(stderr,"FONT-STRING: %s\n", fontString);*/
    thisFont.height = tm.tmHeight - tm.tmInternalLeading;
    thisFont.width  = tm.tmAveCharWidth;
#endif

    thisFont.font = (char*) xcMalloc(sizeof(char) * (strlen(fontString)+1));
    strcpy(thisFont.font, fontString);
    thisFont.tkfont = tkfont;
  }
  
  /* now find if the font was already loaded */
  
  _font = xcFont_find(thisFont.font);
  /*fprintf(stderr,"Font12: %d , %s\n", _font, thisFont.font); fflush(stderr);*/
	
  if ( !_font ) {
    /* the font was not yet loaded */
    xcFont = (struct xcToglFont *) xcMalloc ( sizeof (struct xcToglFont) );
    xcFont_addNew (xcFont, togl, thisFont);
  } else {
    /* the font was already loaded */
    xcFont = _font;
  }
  return TCL_OK;
}
