/* typereference.c generated by valac, the Vala compiler
 * generated from typereference.vala, do not modify */

/* typereference.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>

enum  {
	VALADOC_API_TYPEREFERENCE_0_PROPERTY,
	VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY,
	VALADOC_API_TYPEREFERENCE_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))

struct _ValadocApiTypeReferencePrivate {
	ValaArrayList* type_arguments;
	gchar* dbus_type_signature;
	ValadocApiOwnership ownership;
	ValadocApiItem* _data_type;
	gboolean _is_dynamic;
	gboolean _is_nullable;
};

static gint ValadocApiTypeReference_private_offset;
static gpointer valadoc_api_typereference_parent_class = NULL;

static void valadoc_api_typereference_set_is_nullable (ValadocApiTypeReference* self,
                                                gboolean value);
static void valadoc_api_typereference_set_is_dynamic (ValadocApiTypeReference* self,
                                               gboolean value);
static ValadocApiOwnership valadoc_api_typereference_get_type_reference_ownership (ValadocApiTypeReference* self,
                                                                            ValaDataType* element);
static ValadocContentInline* valadoc_api_typereference_real_build_signature (ValadocApiItem* base);
static void valadoc_api_typereference_finalize (GObject * obj);
static GType valadoc_api_typereference_get_type_once (void);
static void _vala_valadoc_api_typereference_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_valadoc_api_typereference_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
valadoc_api_typereference_get_instance_private (ValadocApiTypeReference* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiTypeReference_private_offset);
}

ValadocApiTypeReference*
valadoc_api_typereference_construct (GType object_type,
                                     ValadocApiItem* parent,
                                     gboolean is_dynamic,
                                     gboolean is_nullable,
                                     const gchar* dbus_type_signature,
                                     ValaDataType* data)
{
	ValadocApiTypeReference * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (ValadocApiTypeReference*) valadoc_api_item_construct (object_type, (ValaCodeNode*) data);
	_tmp0_ = g_strdup (dbus_type_signature);
	_g_free0 (self->priv->dbus_type_signature);
	self->priv->dbus_type_signature = _tmp0_;
	valadoc_api_typereference_set_is_nullable (self, is_nullable);
	valadoc_api_typereference_set_is_dynamic (self, is_dynamic);
	self->priv->ownership = valadoc_api_typereference_get_type_reference_ownership (self, data);
	valadoc_api_item_set_parent ((ValadocApiItem*) self, parent);
	return self;
}

ValadocApiTypeReference*
valadoc_api_typereference_new (ValadocApiItem* parent,
                               gboolean is_dynamic,
                               gboolean is_nullable,
                               const gchar* dbus_type_signature,
                               ValaDataType* data)
{
	return valadoc_api_typereference_construct (VALADOC_API_TYPE_TYPEREFERENCE, parent, is_dynamic, is_nullable, dbus_type_signature, data);
}

static ValadocApiOwnership
valadoc_api_typereference_get_type_reference_ownership (ValadocApiTypeReference* self,
                                                        ValaDataType* element)
{
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValadocApiOwnership result = 0;
	g_return_val_if_fail (self != NULL, 0);
	type = element;
	_tmp0_ = type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaDataType* _tmp26_;
		_tmp1_ = type;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_PARAMETER)) {
			ValaDataType* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaCodeNode* _tmp6_;
			ValaParameterDirection _tmp7_;
			ValaParameterDirection _tmp8_;
			_tmp4_ = type;
			_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_parameter_get_direction (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_PARAMETER, ValaParameter));
			_tmp8_ = _tmp7_;
			if (_tmp8_ == VALA_PARAMETER_DIRECTION_IN) {
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = type;
				_tmp10_ = vala_data_type_get_value_owned (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					result = VALADOC_API_OWNERSHIP_OWNED;
					return result;
				}
			} else {
				ValaDataType* _tmp12_;
				_tmp12_ = type;
				if (vala_data_type_is_weak (_tmp12_)) {
					result = VALADOC_API_OWNERSHIP_UNOWNED;
					return result;
				}
			}
			result = VALADOC_API_OWNERSHIP_DEFAULT;
			return result;
		} else {
			ValaDataType* _tmp13_;
			ValaCodeNode* _tmp14_;
			ValaCodeNode* _tmp15_;
			_tmp13_ = type;
			_tmp14_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_PROPERTY_ACCESSOR)) {
				ValaDataType* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp16_ = type;
				_tmp17_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_property_accessor_get_value_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_data_type_get_value_owned (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_) {
					result = VALADOC_API_OWNERSHIP_OWNED;
					return result;
				}
				result = VALADOC_API_OWNERSHIP_DEFAULT;
				return result;
			} else {
				ValaDataType* _tmp23_;
				ValaCodeNode* _tmp24_;
				ValaCodeNode* _tmp25_;
				_tmp23_ = type;
				_tmp24_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_CONSTANT)) {
					result = VALADOC_API_OWNERSHIP_DEFAULT;
					return result;
				}
			}
		}
		_tmp26_ = type;
		if (vala_data_type_is_weak (_tmp26_)) {
			result = VALADOC_API_OWNERSHIP_UNOWNED;
			return result;
		}
	}
	result = VALADOC_API_OWNERSHIP_DEFAULT;
	return result;
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaCollection*
valadoc_api_typereference_get_type_arguments (ValadocApiTypeReference* self)
{
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_arguments;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
valadoc_api_typereference_add_type_argument (ValadocApiTypeReference* self,
                                             ValadocApiTypeReference* type_ref)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_ref != NULL);
	_tmp0_ = self->priv->type_arguments;
	vala_collection_add ((ValaCollection*) _tmp0_, type_ref);
}

ValadocApiItem*
valadoc_api_typereference_get_data_type (ValadocApiTypeReference* self)
{
	ValadocApiItem* result;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
valadoc_api_typereference_set_data_type (ValadocApiTypeReference* self,
                                         ValadocApiItem* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_data_type (self) != value) {
		ValadocApiItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_type);
		self->priv->_data_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY]);
	}
}

gboolean
valadoc_api_typereference_get_is_owned (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_OWNED;
	return result;
}

gboolean
valadoc_api_typereference_get_is_weak (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_WEAK;
	return result;
}

gboolean
valadoc_api_typereference_get_is_unowned (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_UNOWNED;
	return result;
}

gboolean
valadoc_api_typereference_get_is_dynamic (ValadocApiTypeReference* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dynamic;
	return result;
}

static void
valadoc_api_typereference_set_is_dynamic (ValadocApiTypeReference* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_is_dynamic (self) != value) {
		self->priv->_is_dynamic = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY]);
	}
}

gboolean
valadoc_api_typereference_get_is_nullable (ValadocApiTypeReference* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_nullable;
	return result;
}

static void
valadoc_api_typereference_set_is_nullable (ValadocApiTypeReference* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_is_nullable (self) != value) {
		self->priv->_is_nullable = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY]);
	}
}

gchar*
valadoc_api_typereference_get_dbus_type_signature (ValadocApiTypeReference* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dbus_type_signature;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * {@inheritDoc}
 */
static ValadocContentInline*
valadoc_api_typereference_real_build_signature (ValadocApiItem* base)
{
	ValadocApiTypeReference * self;
	ValadocApiSignatureBuilder* signature = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValadocApiItem* _tmp12_;
	ValaArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp38_;
	ValadocApiSignatureBuilder* _tmp40_;
	ValadocContentRun* _tmp41_;
	ValadocContentInline* result = NULL;
	self = (ValadocApiTypeReference*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	signature = _tmp0_;
	_tmp1_ = self->priv->_is_dynamic;
	if (_tmp1_) {
		ValadocApiSignatureBuilder* _tmp2_;
		_tmp2_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp2_, "dynamic", TRUE);
	}
	_tmp3_ = valadoc_api_typereference_get_is_weak (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ValadocApiSignatureBuilder* _tmp5_;
		_tmp5_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp5_, "weak", TRUE);
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = valadoc_api_typereference_get_is_owned (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			ValadocApiSignatureBuilder* _tmp8_;
			_tmp8_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp8_, "owned", TRUE);
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = valadoc_api_typereference_get_is_unowned (self);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				ValadocApiSignatureBuilder* _tmp11_;
				_tmp11_ = signature;
				valadoc_api_signature_builder_append_keyword (_tmp11_, "unowned", TRUE);
			}
		}
	}
	_tmp12_ = self->priv->_data_type;
	if (_tmp12_ == NULL) {
		ValadocApiSignatureBuilder* _tmp13_;
		_tmp13_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp13_, "void", TRUE);
	} else {
		ValadocApiItem* _tmp14_;
		_tmp14_ = self->priv->_data_type;
		if (VALADOC_API_IS_SYMBOL (_tmp14_)) {
			ValadocApiSignatureBuilder* _tmp15_;
			ValadocApiItem* _tmp16_;
			_tmp15_ = signature;
			_tmp16_ = self->priv->_data_type;
			valadoc_api_signature_builder_append_type (_tmp15_, (ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), TRUE);
		} else {
			ValadocApiSignatureBuilder* _tmp17_;
			ValadocApiItem* _tmp18_;
			ValadocContentInline* _tmp19_;
			ValadocContentInline* _tmp20_;
			_tmp17_ = signature;
			_tmp18_ = self->priv->_data_type;
			_tmp19_ = valadoc_api_item_get_signature (_tmp18_);
			_tmp20_ = _tmp19_;
			valadoc_api_signature_builder_append_content (_tmp17_, _tmp20_, TRUE);
		}
	}
	_tmp21_ = self->priv->type_arguments;
	_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		ValadocApiSignatureBuilder* _tmp24_;
		gboolean first = FALSE;
		ValadocApiSignatureBuilder* _tmp37_;
		_tmp24_ = signature;
		valadoc_api_signature_builder_append (_tmp24_, "<", FALSE);
		first = TRUE;
		{
			ValaArrayList* _param_list = NULL;
			ValaArrayList* _tmp25_;
			ValaArrayList* _tmp26_;
			gint _param_size = 0;
			ValaArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_index = 0;
			_tmp25_ = self->priv->type_arguments;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				ValadocApiItem* param = NULL;
				ValaArrayList* _tmp30_;
				gpointer _tmp31_;
				ValadocApiSignatureBuilder* _tmp33_;
				ValadocApiItem* _tmp34_;
				ValadocContentInline* _tmp35_;
				ValadocContentInline* _tmp36_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp30_ = _param_list;
				_tmp31_ = vala_list_get ((ValaList*) _tmp30_, _param_index);
				param = (ValadocApiItem*) ((ValadocApiTypeReference*) _tmp31_);
				if (!first) {
					ValadocApiSignatureBuilder* _tmp32_;
					_tmp32_ = signature;
					valadoc_api_signature_builder_append (_tmp32_, ",", FALSE);
				}
				_tmp33_ = signature;
				_tmp34_ = param;
				_tmp35_ = valadoc_api_item_get_signature (_tmp34_);
				_tmp36_ = _tmp35_;
				valadoc_api_signature_builder_append_content (_tmp33_, _tmp36_, FALSE);
				first = FALSE;
				_g_object_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp37_ = signature;
		valadoc_api_signature_builder_append (_tmp37_, ">", FALSE);
	}
	_tmp38_ = self->priv->_is_nullable;
	if (_tmp38_) {
		ValadocApiSignatureBuilder* _tmp39_;
		_tmp39_ = signature;
		valadoc_api_signature_builder_append (_tmp39_, "?", FALSE);
	}
	_tmp40_ = signature;
	_tmp41_ = valadoc_api_signature_builder_get (_tmp40_);
	result = (ValadocContentInline*) _tmp41_;
	_valadoc_api_signature_builder_unref0 (signature);
	return result;
}

static void
valadoc_api_typereference_class_init (ValadocApiTypeReferenceClass * klass,
                                      gpointer klass_data)
{
	valadoc_api_typereference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiTypeReference_private_offset);
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_typereference_real_build_signature;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_typereference_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_typereference_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_typereference_finalize;
	/**
	 * The referred data type.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY] = g_param_spec_object ("data-type", "data-type", "data-type", VALADOC_API_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Specifies that the expression is owned.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY] = g_param_spec_boolean ("is-owned", "is-owned", "is-owned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is weak.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY] = g_param_spec_boolean ("is-weak", "is-weak", "is-weak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is unwoned.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY] = g_param_spec_boolean ("is-unowned", "is-unowned", "is-unowned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is dynamic.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY] = g_param_spec_boolean ("is-dynamic", "is-dynamic", "is-dynamic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression may be null.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY] = g_param_spec_boolean ("is-nullable", "is-nullable", "is-nullable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
valadoc_api_typereference_instance_init (ValadocApiTypeReference * self,
                                         gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = valadoc_api_typereference_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	self->priv->type_arguments = _tmp1_;
}

static void
valadoc_api_typereference_finalize (GObject * obj)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	_vala_iterable_unref0 (self->priv->type_arguments);
	_g_free0 (self->priv->dbus_type_signature);
	_g_object_unref0 (self->priv->_data_type);
	G_OBJECT_CLASS (valadoc_api_typereference_parent_class)->finalize (obj);
}

/**
 * A reference to a data type.
 */
static GType
valadoc_api_typereference_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocApiTypeReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_typereference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiTypeReference), 0, (GInstanceInitFunc) valadoc_api_typereference_instance_init, NULL };
	GType valadoc_api_typereference_type_id;
	valadoc_api_typereference_type_id = g_type_register_static (VALADOC_API_TYPE_ITEM, "ValadocApiTypeReference", &g_define_type_info, 0);
	ValadocApiTypeReference_private_offset = g_type_add_instance_private (valadoc_api_typereference_type_id, sizeof (ValadocApiTypeReferencePrivate));
	return valadoc_api_typereference_type_id;
}

GType
valadoc_api_typereference_get_type (void)
{
	static volatile gsize valadoc_api_typereference_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_typereference_type_id__volatile)) {
		GType valadoc_api_typereference_type_id;
		valadoc_api_typereference_type_id = valadoc_api_typereference_get_type_once ();
		g_once_init_leave (&valadoc_api_typereference_type_id__volatile, valadoc_api_typereference_type_id);
	}
	return valadoc_api_typereference_type_id__volatile;
}

static void
_vala_valadoc_api_typereference_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	switch (property_id) {
		case VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY:
		g_value_set_object (value, valadoc_api_typereference_get_data_type (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_owned (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_weak (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_unowned (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_dynamic (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_nullable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_valadoc_api_typereference_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	switch (property_id) {
		case VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY:
		valadoc_api_typereference_set_data_type (self, g_value_get_object (value));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY:
		valadoc_api_typereference_set_is_dynamic (self, g_value_get_boolean (value));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY:
		valadoc_api_typereference_set_is_nullable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

