/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#ifndef ONLINEMUSICSCOPE_H
#define ONLINEMUSICSCOPE_H

#include <unity.h>
#include <QString>
#include <QStringList>
#include <QSet>

class QCoreApplication;

enum Category {
    POPULAR_ONLINE,
    ONLINE
};

class OnlineMusicScope
{
public:
    static OnlineMusicScope& instance();
    UnityAbstractScope* getUnityScope();
    ~OnlineMusicScope();

private:
    OnlineMusicScope();
    void setupUnityScope();

    void appendIfEnabled(QStringList &scopeToQuery, const QString &scopeId) const;

    static void search_func(UnityScopeSearchBase* search, UnityScopeSearchBaseCallback cb, void* cb_target, void* user_data);
    static void preview_func(UnityResultPreviewer *previewer, UnityAbstractPreviewCallback cb, void *cb_target, void *user_data);
    static void disabled_scopes_changed(GObject *obj, GParamSpec *spec, gpointer user_data);

    UnityAbstractPreview * previewFunc(UnityResultPreviewer *previewer);
    void searchFunc(UnityScopeSearchBase* search);
    void updateDisabledScopes();

    static const char* UNIQUE_NAME;
    static const char* GROUP_NAME;
    static const char* SSS_SCOPE_ID;

    UnitySimpleScope* m_unityScope;
    QCoreApplication *m_app;
    QString m_locale;
    QSet<QString> m_disabledScopes;
    gulong m_disabledScopesSig;
};

#endif
