/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This file is part of unity-chromium-extension
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UNITY_WEBAPPS_WEBAPPS_HANDLER
#define UNITY_WEBAPPS_WEBAPPS_HANDLER

#include <QObject>
#include <QVariantMap>

namespace UnityWebapps {

class WebappsHandlerPrivate;

class WebappsHandler: public QObject
{
    Q_OBJECT

public:
    explicit WebappsHandler(QObject *parent = 0);
    ~WebappsHandler();

public Q_SLOTS:
    QVariantMap url_loaded(const QVariantMap &message);
    QVariantMap dont_ask(const QVariantMap &message);
    QVariantMap install(const QVariantMap &message);
    QVariantMap ping(const QVariantMap &message);

#if defined(UCX_UNDER_TEST)
public:
#else
private:
#endif
    QString createApplicationDesktopName(
            const QString &appName,
            const QString &appDomain
        ) const;

    WebappsHandlerPrivate *d_ptr;
    Q_DECLARE_PRIVATE(WebappsHandler)
};

} // namespace

#endif // UNITY_WEBAPPS_WEBAPPS_HANDLER
