# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2014 Canonical Ltd.
#
# This file is part of ubuntu-integration-tests.
#
# ubuntu-integration-tests is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import os
import subprocess

from autopilot import platform
from autopilot.matchers import Eventually
from testtools.matchers import Equals

from ubuntu_experience_tests import tests


class URLDispatcherTestCase(tests.UbuntuExperienceTestCase):

    def setUp(self):
        super(URLDispatcherTestCase, self).setUp()
        if platform.model() == 'Desktop':
            self.skipTest('URL dispatcher does not work on the desktop.')

    def test_swipe_out_online_accounts_launched_with_url_dispatcher(self):
        """Test online accounts launched with URL Dispatcher.

        Check that the application can be swiped out showing the dashboard and
        no focused application.

        """
        self.assertEqual(
            'unity8-dash', self.unity.get_current_focused_app_id())
        self.addCleanup(os.system, 'pkill system-settings')
        self.addCleanup(os.system, 'pkill online-accounts')

        subprocess.check_call(
            ['url-dispatcher', 'settings:///system/online-accounts'])

        self.assertThat(
            self.unity.get_current_focused_app_id,
            Eventually(Equals('online-accounts-ui')))

        self.unity.show_dash_swiping()
        self.assertThat(
            self.unity.get_current_focused_app_id,
            Eventually(Equals('unity8-dash')))
