[comment {Copyright (c) 2002-2003 Christian Krone.

  See the file "license.terms" for information on usage and redistribution
  of this file, and for a DISCLAIMER OF ALL WARRANTIES.

  $Id: treectrl.man,v 1.57 2008/10/08 19:48:50 treectrl Exp $}
]
[manpage_begin treectrl n 2.2.8]
[moddesc {Tk Commands}]
[titledesc {Create and manipulate hierarchical multicolumn widgets}]
[require treectrl 2.2.8]

[description]
[list_begin definitions] 
[call [cmd treectrl] [arg pathName] [opt [arg options]]]
[list_end]

[para]
The [cmd treectrl] command creates a new window (given by the
[arg pathName] argument) and makes it into a treectrl widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the treectrl such as its background color
and relief.  The [cmd treectrl] command returns the
path name of the new window.
At the time this command is invoked, there must not
exist a window named [arg pathName], but [arg pathName]'s parent must exist.

[para]
A treectrl is a widget which displays items in a one- or two-dimensional arrangement.
Items have a parent-child relationship with other items.
Items have a set of states, which are boolean properties.
Items may be spread about one or more columns.
For each column of an item there is a style associated,
which determines how to display the item's column
taking into account the item's current state set.
One column can be defined to display the data in a hierarchical structure.

[para]
Normally the origin of the coordinate system is at the
upper-left corner of the window containing the treectrl.
It is possible to adjust the origin of the coordinate system
relative to the origin of the window using the
[cmd xview] and [cmd yview] widget commands;
this is typically used for scrolling.

[para]
A treectrl widget can be horizontal or vertical oriented
like many other Tk widgets.
For displaying hierarchical data only vertical orientation is useful,
since only then the children of an item
are displayed directly below their parent.
If the treectrl widget is used only
to display data in a multicolumn listbox,
the specification of an orientation will give useful results.

[section {STANDARD OPTIONS}]
[list_begin opt]
[opt_def [option -background]]
[opt_def [option -borderwidth]]
[opt_def [option -cursor]]
[opt_def [option -font]]
[opt_def [option -highlightbackground]]
[opt_def [option -highlightcolor]]
[opt_def [option -highlightthickness]]
[opt_def [option -orient]]
[opt_def [option -relief]]
[opt_def [option -takefocus]]
[opt_def [option -xscrollcommand]]
[opt_def [option -yscrollcommand]]
[opt_def [option -foreground]]
[list_end]
See the [cmd option] manual entry for details on the standard options.

[section {WIDGET SPECIFIC OPTIONS}]
[list_begin tkoption]
[tkoption_def -backgroundimage backgroundImage BackgroundImage]
Specifies the name of an image to draw as the list background. The image is
tiled horizontally and vertically to fill the content area of the list. If
the image is transparent it is drawn on top of the background color(s).

[tkoption_def -backgroundmode backgroundMode BackgroundMode]
Specifies how the background color of items is chosen in each column.
The value should be one of [const row], [const column], [const order],
or [const ordervisible]. The default is [const row].
This option has only an effect
for columns which have [option -itembackground] defined as list of two or more
colors (see section [sectref COLUMNS] below for more on this). If [const row] or
[const column] is specified, the background color is chosen based on the location
of the item in the 1- or 2-dimensional grid of items as layed out on the screen;
this layout of items is affected by the [option -orient] and [option -wrap] options as
well as item visibility.
When [const order] or [const ordervisible] is specified,
the background color is chosen based on the result of the [cmd {item order}]
command, regardless of the layout of items.

[tkoption_def -buttonbitmap buttonBitmap ButtonBitmap]
Specifies the bitmap to be used as the expand/collapse button to the left of
an item. This is a [sectref {PER-STATE OPTIONS} per-state] option. If
a bitmap is specified for a certain item state, it overrides the effects of
-usetheme.

[tkoption_def -buttoncolor buttonColor ButtonColor]
Specifies the foreground color which should be used for drawing the outline
and the plus or minus sign of the button to the left of an item.

[tkoption_def -buttonimage buttonImage ButtonImage]
Specifies the image to be used as the expand/collapse button to the left of
an item. This is a [sectref {PER-STATE OPTIONS} per-state] option.
If an image is specified for a certain item state, it overrides the effects of
-buttonbitmap and -usetheme.

[tkoption_def -buttonsize buttonSize ButtonSize]
Specifies the width and height of the button drawn to the left of an item
in any of the forms acceptable to [fun Tk_GetPixels].

[tkoption_def -buttonthickness buttonThickness ButtonThickness]
Specifies the width of the outline and the plus or minus sign
of the button to the left of an item
in any of the forms acceptable to [fun Tk_GetPixels].

[tkoption_def -columnprefix columnPrefix ColumnPrefix]
Specifies an ascii string that changes the way column ids are reported and
processed. If this option is a non-empty string, the usual integer value
of a column id is prefixed with the given string. This can aid debugging
but it is important your code doesn't assume column ids are integers if you
use it.

[tkoption_def -columnproxy columnProxy ColumnProxy]
If this option specifies a non empty value,
it should be a screen distance
in any of the forms acceptable to [fun Tk_GetPixels].
Then a 1 pixel thick vertical line will be drawn
at the specified screen distance from the left edge of the treectrl widget,
which reaches from top to bottom of the treectrl widget
and uses an inverting color
(i.e black on lighter background, white on darker background).
This line can be used to give the user a visual feedback
during column resizing.

[tkoption_def -columnresizemode columnResizeMode ColumnResizeMode]
Specifies the visual feedback used when resizing columns. The value should be
one of [const proxy] or [const realtime]. For [const proxy], a 1-pixel thick
vertical line is drawn representing where the right edge of the column will
be after resizing. For [const realtime], the column's size is changed while
the user is dragging the right edge of the column.

[tkoption_def -columntagexpr columnTagExpr ColumnTagExpr]
Specifies a boolean that enables or disables tag expressions in column
descriptions. See [sectref {ITEM AND COLUMN TAGS}].

[tkoption_def -defaultstyle defaultStyle DefaultStyle]
This option is deprecated; use the column option [option -itemstyle] instead.
Specifies a list of styles, one per column, to apply to each item created by
the [cmd "item create"] command. The number of styles in the list can be
different from the number of tree columns.
Each list element should be a valid style name or an empty string to
indicate no style should be applied to a specific column. The list of styles
is updated if a style is deleted or if a column is moved.

[tkoption_def -doublebuffer doubleBuffer DoubleBuffer]
Specifies if double-buffering should be used to improve displaying.
The value should be one of [const none], [const window], or [const item].
For [const none] no double-buffering is used at all, which may be most memory
efficient, but will probably generate some flickering on the screen.
For [const window] the complete tree is double-buffered, which requires
a buffer big enough to contain the complete widget.
For [const item], which is the default, every item is separately
double-buffered, so it works with a buffer size as big as the biggest item.

[tkoption_def -height height Height]
Specifies the desired height for the window
in any of the forms acceptable to [fun Tk_GetPixels].
The default is 200 pixels.
If this option is less than or equal to zero then the window will
not request any size at all.

[tkoption_def -indent indent Indent]
Specifies the screen distance an item is indented relative to its parent item
in any of the forms acceptable to [fun Tk_GetPixels].
The default is 19 pixels.

[tkoption_def -itemheight itemHeight ItemHeight]
Specifies a fixed height for every item
in any of the forms acceptable to [fun Tk_GetPixels]. If non-zero, this
option overrides the requested height of an item and the -minitemheight option.
The default is 0, which means that
every item has the height requested by the arrangement of elements
in each column. Items are never shorter than the maximum height of a button.

[tkoption_def -itemprefix itemPrefix ItemPrefix]
Specifies an ascii string that changes the way item ids are reported and
processed. If this option is a non-empty string, the usual integer value
of an item id is prefixed with the given string. This can aid debugging
but it is important your code doesn't assume item ids are integers if you
use it.

[tkoption_def -itemtagexpr itemTagExpr ItemTagExpr]
Specifies a boolean that enables or disables tag expressions in item
descriptions. See [sectref {ITEM AND COLUMN TAGS}].

[tkoption_def -itemwidth itemWidth ItemWidth]
Specifies a fixed width for every item in any of the forms acceptable to [fun Tk_GetPixels].
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).

[tkoption_def -itemwidthequal itemWidthEqual ItemWidthEqual]
Specifies a boolean that says whether all items should have the same width.
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).
If the -itemwidth option is specified, then this option has no effect.

[tkoption_def -itemwidthmultiple itemWidthMultiple ItemWidthMultiple]
Specifies a screen distance that every item's width will be evenly divisible by in any of the forms acceptable to [fun Tk_GetPixels].
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).
If the -itemwidth option is specified, then this option has no effect.

[tkoption_def -linecolor lineColor LineColor]
Specifies the color which should be used for drawing
the connecting lines between related items.

[tkoption_def -linestyle lineStyle LineStyle]
Specifies the style of the connecting lines between related items,
should be [const dot] which is the default, or [const solid].

[tkoption_def -linethickness lineThickness LineThickness]
Specifies the thickness of the connecting lines between related items
in any of the forms acceptable to [fun Tk_GetPixels].

[tkoption_def -minitemheight minItemHeight MinItemHeight]
Specifies a minimum height for every item
in any of the forms acceptable to [fun Tk_GetPixels].
The default is 0, which means that
every item has the height requested by the arrangement of elements
in each column. This option has no effect if the -itemheight option is specified.
Items are never shorter than the maximum height of a button.

[tkoption_def -rowproxy rowProxy RowProxy]
If this option specifies a non empty value,
it should be a screen distance
in any of the forms acceptable to [fun Tk_GetPixels].
Then a 1 pixel thick horizontal line will be drawn
at the specified screen distance from the top edge of the treectrl widget,
which reaches from left to right of the treectrl widget
and uses an inverting color
(i.e black on lighter background, white on darker background).
This line can be used to give the user a visual feedback
during row resizing.

[tkoption_def -scrollmargin scrollMargin ScrollMargin]
Specifies a positive screen distance
in any of the forms acceptable to [fun Tk_GetPixels].
This option is used by the default bindings to determine how close to the
edges of the contentbox the mouse pointer must be before scrolling occurs.
Specifying a positive value is useful when items may be drag-and-dropped.
Defaults to 0.

[tkoption_def -selectmode selectMode SelectMode]
Specifies one of several styles for manipulating the selection.
The value of the option may be arbitrary, but the default bindings
expect it to be either [const single], [const browse], [const multiple],
or [const extended];  the default value is [const browse].

[tkoption_def -showbuttons showButtons ShowButtons]
Specifies a boolean value that determines whether this widget
leaves indentation space to display the expand/collapse buttons next to items.
The default value is true.
The item option [option -button] determines whether any item has a button.
See also the treectrl option [option -showrootbutton]. 

[tkoption_def -showheader showHeader ShowHeader]
Specifies a boolean value that determines whether this widget
should display the header line with the column names at the top of the widget.
The default value is true.

[tkoption_def -showlines showLines ShowLines]
Specifies a boolean value that determines whether this widget
should draw the connecting lines between related items.
The default value is true.

[tkoption_def -showroot showRoot ShowRoot]
Specifies a boolean value that determines whether this widget
should draw the root item.
By suppressing the drawing of the root item the widget can have
multiple items that appear as [emph toplevel] items.
The default value is true.

[tkoption_def -showrootbutton showRootButton ShowRootButton]
Specifies a boolean value that determines whether this widget
leaves indentation space to display the expand/collapse button next to the
root item. The default value is false.
The item option [option -button] determines whether the root item has a button.

[tkoption_def -showrootchildbuttons showRootChildButtons ShowRootChildButtons]
Specifies a boolean value that determines whether this widget
should draw the expand/collapse buttons next to children of the root item.
The default value is true.

[tkoption_def -showrootlines showRootLines ShowRootLines]
Specifies a boolean value that determines whether this widget
should draw the connecting lines between children of the root item.
The default value is true.

[tkoption_def -treecolumn treeColumn TreeColumn]
Specifies a [sectref {COLUMN DESCRIPTION} {column description}] that determines which
column displays the buttons and lines.
The default is unspecified.

[tkoption_def -usetheme useTheme UseTheme]
Specifies a boolean value that determines whether this widget should draw
parts of itself using a platform-specific theme manager.
The default is false.

[tkoption_def -width width Width]
Specifies the desired width for the window
in any of the forms acceptable to [fun Tk_GetPixels].
The default is 200 pixel.
If this option is less than or equal to zero then the window will
not request any size at all.

[tkoption_def -wrap wrap Wrap]
Specifies whether items are arranged in a 1- or 2-dimensional layout.

If the value is an empty string (the default), then items are arranged from top
to bottom (-orient vertical) or from left to right (-orient horizontal) in
a 1-dimensional layout.

If the value is "[emph N] [const items]", then a no more than [emph N] items will appear in
a vertical group (-orient vertical) or horizontal group (-orient horizontal).

If the value is "[emph N] [const pixels]", then a no vertical group of items will be
taller than [emph N] pixels (-orient vertical) or no horizontal group of items will
be wider than [emph N] pixels (-orient horizontal).

If the value is [const window], then a no vertical group of items will be
taller than the window (-orient vertical) or no horizontal group of items will
be wider than the window (-orient horizontal).

[tkoption_def -xscrolldelay xScrollDelay ScrollDelay]
This option controls how quickly horizontal scrolling occurs while dragging
the mouse with button 1 pressed.
The value should be a list of 1 or 2 integers interpreted as microseconds.
If 2 values are specified, then the first value determines the intial delay 
after the first scroll, and the second value determines the delay for all
scrolling after the first. If only 1 value is specified, each scroll takes
place after that delay.

[tkoption_def -xscrollincrement xScrollIncrement ScrollIncrement]
Specifies an increment for horizontal scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the horizontal view in the window will be constrained so that
the x coordinate at the left edge of the window is always an even
multiple of [option -xscrollincrement];  furthermore, the units for scrolling
(e.g., the change in view when the left and right arrows of a scrollbar
are selected) will also be [option -xscrollincrement].  If the value of
this option is less than or equal to zero, then horizontal scrolling
snaps to the left of an item, or part of an item if items are wider than the
contentbox.

[tkoption_def -yscrolldelay yScrollDelay ScrollDelay]
This option controls how quickly vertical scrolling occurs while dragging
the mouse with button 1 pressed.
The value should be a list of 1 or 2 integers interpreted as microseconds.
If 2 values are specified, then the first value determines the intial delay 
after the first scroll, and the second value determines the delay for all
scrolling after the first. If only 1 value is specified, each scroll takes
place after that delay.

[tkoption_def -yscrollincrement yScrollIncrement ScrollIncrement]
Specifies an increment for vertical scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the vertical view in the window will be constrained so that
the y coordinate at the top edge of the window is always an even
multiple of [option -yscrollincrement];  furthermore, the units for scrolling
(e.g., the change in view when the top and bottom arrows of a scrollbar
are selected) will also be [option -yscrollincrement].  If the value of
this option is less than or equal to zero, then vertical scrolling
snaps to the top of an item, or part of an item if items are taller than the
contentbox.
[list_end]

[section {ITEM AND COLUMN TAGS}]
Columns and items may have any number of tags associated with them.
A tag is just a string of characters, and it may take any form,
including that of an integer, although the characters '(', ')', '&', '|', '^'
and '!' should be avoided.
[para]
The same tag may be associated with many columns or items. This is commonly done to group
items in various interesting ways; for example, in a file browser all directories
might be given the tag "directory".
[para]
Tag expressions are used in [sectref {COLUMN DESCRIPTION} {column descriptions}]
and [sectref {ITEM DESCRIPTION} {item descriptions}] to specify which columns
and items to operate on.
A tag expression can be a single tag name or a logical expression of tags
using operators '&&', '||', '^' and '!', and parenthesized subexpressions.
For example:
[example_begin]
.t item id "tag {(a && !b) || (!a && b)}"
[example_end]
or equivalently:
[example_begin]
.t item id "tag {a ^ b}"
[example_end]
will return the unique ids of any items with either "a" or "b" tags, but not both.
[para]
Within a tag expression a tag name may be enclosed in double quotes to avoid special
processing of the operator characters. For example:
[example_begin]
.t item id {tag {"a&&b"||c}}
[example_end]
will return the unique ids of any items with either "a&&b" or "c" tags; in this
example the && is not treated as an operator. A double-quote may be escaped within
a quoted tag name using a backslash '\'.
[para]
Tag operators may be bypassed completely by setting the [option -columntagexpr] and
[option -itemtagexpr] options. This can be useful if your application has column
or item tags containing arbitrary text.
[example_begin]
.t configure -itemtagexpr false
.t item delete "tag a&&b"
[example_end]

[section {WIDGET COMMAND}]
The [cmd treectrl] command creates a new Tcl command whose
name is the same as the path name of the treectrl's window.
This command may be used to invoke various
operations on the widget.  It has the following general form:

[para]
[arg pathName] [arg option] [opt [arg {arg arg ...}]]

[para]
[arg PathName] is the name of the command, which is the same as
the treectrl widget's path name.  [arg Option] and the [arg arg]s
determine the exact behavior of the command.  The following
commands are possible for treectrl widgets:

[list_begin definitions]

[call [arg pathName] [cmd activate] [arg itemDesc]]
Sets the active item to the one described by [arg itemDesc],
and switches on the state [const active] for this item.
From now on the item can be retrieved with the item description [const active].
An [const <ActiveItem>] event is generated.

[call [arg pathName] [cmd bbox] [opt [arg area]]]
Returns a list with four elements giving the bounding box (left, top, right
and bottom) of an area of the window. If [arg area] is not specified, then
the result is the bounding box of the entire window.
If [arg area] is [const content], then the result is the part of the window
not including borders, headers, or locked columns.
If [arg area] is [const header], then the result is the part of the window
not including borders where column titles are displayed.
If [arg area] is [const left], then the result is the part of the window
not including borders or headers where left-locked columns are displayed.
If [arg area] is [const right], then the result is the part of the window
not including borders or headers where right-locked columns are displayed.
An empty string is returned if the display area has
no height or width, which can be true for various reasons such as the window
is too small, or the header is not displayed, or there aren't any locked
columns.

[call [arg pathName] [cmd canvasx] [arg screenx]]
Given a window x-coordinate in the treectrl [arg screenx],
this command returns the treectrl x-coordinate
that is displayed at that location.

[call [arg pathName] [cmd canvasy] [arg screeny]]
Given a window y-coordinate in the treectrl [arg screeny],
this command returns the treectrl y-coordinate
that is displayed at that location.

[call [arg pathName] [cmd cget] [arg option]]
Returns the current value of the configuration option given
by [arg option].
[arg Option] may have any of the values accepted by the [cmd tree]
command.

[call [arg pathName] [cmd collapse] [opt [option -recurse]] \
     [opt [arg {itemDesc ...}]]]
Use [cmd {item collapse}] instead.

[call [arg pathName] [cmd column] [arg option] [arg column] \
     [opt [arg {arg ...}]]]
This command is used to manipulate the columns of the treectrl widget
(see section [sectref COLUMNS] below).
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd column] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {column bbox}] [arg columnDesc]]
Returns a list with four elements giving the bounding box
of the header of the column specified by the
[sectref {COLUMN DESCRIPTION} {column description}] [arg columnDesc].
If the treectrl is configured not to display the column headers
by means of the [option -showheader] option, then
an empty list is returned instead.

[call [arg pathName] [cmd {column cget}] [arg columnDesc] [arg option]]
This command returns the current value of the option named [arg option]
for the column specified by the
[sectref {COLUMN DESCRIPTION} {column description}] [arg columnDesc],
[arg ColumnDesc] may also be the string [const tail] to specify the tail column.
[arg Option] may have any of the values accepted by the
[cmd {column configure}] widget command.

[call [arg pathName] [cmd {column configure}] [arg columnDesc] \
     [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies options associated with the columns specified by the
[sectref {COLUMN DESCRIPTION} {column description}] [arg columnDesc]
instead of modifying options for the overall treectrl widget.
[arg ColumnDesc] may be the string [const tail] to specify the tail column.
If [arg columnDesc] refers to more than one column, then at least one option-value pair
must be given.
If no [arg option] is specified, the command returns a list describing
all of the available options for [arg columnDesc] (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) for [arg columnDesc];
in this case the command returns an empty string.
[nl]

See [sectref COLUMNS] below for details on the options available for columns.

[call [arg pathName] [cmd {column compare}] [arg column1] [arg op] [arg column2]]
For both [sectref {COLUMN DESCRIPTION} {column descriptions}] [arg column1]
and [arg column2] the index is retrieved
(as returned from the [cmd {column order}] widget command).
Then these indexes are compared using the operator [arg op], which must
be either [const <],  [const <=],  [const ==], [const >=], [const >],
or [const !=].
The return value of this command is 1 if the comparison evaluated to true,
0 otherwise.

[call [arg pathName] [cmd {column count}] [opt [arg columnDesc]]]
If no additional arguments are given, the result is a decimal string giving the number of
columns created by the [cmd "column create"] widget command which haven't been
deleted by the [cmd "column delete"] widget command; in this case the [const tail] column
is not counted.
If [arg columnDesc] is given, then the result is the number of columns that
match that [sectref {COLUMN DESCRIPTION} {column description}].

[call [arg pathName] [cmd {column create}] [opt [arg {option value ...}]]]
This command creates a new column in the treectrl widget. The new column is
placed to the right of all other columns (except the [const tail] column). Any
[arg option]-[arg value] arguments configure the new column according to the
[cmd "column configure"] command. The return value is the unique identifier
of the new column.

[call [arg pathName] [cmd {column delete}] [arg first] [opt [arg last]]]
Deletes the specified column(s). [arg First] and [arg last] must be valid
[sectref {COLUMN DESCRIPTION} {column descriptions}]. If both [arg first]
and [arg last] are specified, then they may refer to a single column only.
The [const tail] column cannot be deleted and it is an error to specify it.
The order of [arg first] and [arg last] doesn't matter, and [arg first] may
be equal to [arg last].

[call [arg pathName] [cmd {column dragcget}] [arg option]]
[call [arg pathName] [cmd {column dragconfigure}] \
     [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
The user can move a column within a treectrl by drag-and-drop. Feedback consists
of a semi-transparent photo image of the header of the column being dragged
and a 2-pixel-thick vertical line to indicate where the column may be dropped.
The drag image consists of a colored background rectangle plus the image and/or
text displayed in the column header. The 2-pixel-thick line will be drawn
over the left edge of the column before which the dragged column may be dropped.
[nl]

The library scripts generate a <ColumnDrag-accept> event when the user has
successfully drag-and-drop'd a column. You will have to bind a script to this
event if you want to move the dragged column.
[nl]

The following configuration options are supported:
[list_begin opt]
[opt_def [option -enable] [arg boolean]]
Controls whether the user is allowed to rearrange columns by drag-and-drop.

[opt_def [option -imagealpha] [arg alpha]]
[arg Alpha] is an integer from 0 (invisible) to 255 (opaque) controlling the
transparency of the drag image. Any value outside this range is clipped.

[opt_def [option -imagecolor] [arg background]]
[arg Background] is the color of the drag image background rectangle.

[opt_def [option -imagecolumn] [arg column]]
[arg Column] specifies the column to create the drag image from.

[opt_def [option -imageoffset] [arg offset]]
[arg Offset] is the horizontal screen distance the drag image is offset from its
starting position.

[opt_def [option -indicatorcolor] [arg color]]
[arg Color] is the color of the 2-pixel-thick line.

[opt_def [option -indicatorcolumn] [arg column]]
The 2-pixel-thick line will be drawn over the left or right edge of [arg column].

[opt_def [option -indicatorside] [arg side]]
Specifies whether the 2-pixel-thick line will be drawn over the [const left]
or [const right] edge of the column specified by [option -indicatorcolumn].
[list_end]

[call [arg pathName] [cmd {column index}] [arg columnDesc]]
Deprecated. Use [cmd {column id}] instead.

[call [arg pathName] [cmd {column id}] [arg columnDesc]]
This command resolves the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc] into a list of unique column identifiers. If the column(s) described by
[arg columnDesc] don't exist, this command returns an empty list.

[call [arg pathName] [cmd {column list}] [opt [arg -visible]]]
This command returns a list of identifiers for every column (except the tail)
from left to right. If [arg -visible] is given, only columns whose -visible
option is true are returned.

[call [arg pathName] [cmd {column move}] [arg columnDesc] [arg beforeDesc]]
Moves the column specified by [arg columnDesc] to the left of the column
specified by [arg beforeDesc]. Both [arg columnDesc] and [arg beforeDesc]
must be valid [sectref {COLUMN DESCRIPTION} {column descriptions}].
If [arg beforeDesc] is the string [const tail],
the column [arg columnDesc] will become the last column.

[call [arg pathName] [cmd {column neededwidth}] [arg columnDesc]]
This command returns a decimal string giving the needed width
of the column specified by the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc].
The needed width is the maximum of the width of the column header
and the width of the widest style in any visible item.

[call [arg pathName] [cmd {column order}] [arg columnDesc] [opt [arg -visible]]]
This command returns a decimal string giving the position of the column
specified by the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc]
in the list of columns starting from zero for the leftmost column.
If [arg -visible] is given, only columns whose -visible
option is true are considered, and -1 is returned if [arg columnDesc]'s -visible
option is false.



[call [arg pathName] [cmd {column tag}] [arg option] [opt [arg {arg arg ...}]]]
This command is used to manipulate tags on columns.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd {column tag}] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {column tag add}] [arg columnDesc] [arg tagList]]
Adds each tag in [arg tagList] to the columns specified by the
[sectref {COLUMN DESCRIPTION} {column description}] [arg columnDesc].
Duplicate tags are ignored. The list of tags for a column can also be
changed via a column's [option -tags] option.

[call [arg pathName] [cmd {column tag expr}] [arg columnDesc] [arg tagExpr]]
Evaluates the tag expression [arg tagExpr] against every column
specified by the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc]. The result is 1 if the tag expression evaluates to true
for every column, 0 otherwise.

[call [arg pathName] [cmd {column tag names}] [arg columnDesc]]
Returns a list of tag names assigned to the columns
specified by the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc]. The result is the union of any tags assigned to the
columns.

[call [arg pathName] [cmd {column tag remove}] [arg columnDesc] [arg tagList]]
Removes each tag in [arg tagList] from the columns specified by the
[sectref {COLUMN DESCRIPTION} {column description}] [arg columnDesc].
It is not an error if any of the columns do not use any of the tags.
The list of tags for a column can also be changed via a column's
[option -tags] option.
[list_end]



[call [arg pathName] [cmd {column width}] [arg columnDesc]]
This command returns a decimal string giving the width in pixels
of the column specified by the [sectref {COLUMN DESCRIPTION} {column description}]
[arg columnDesc],
even if the treectrl is configured to not display the column headers
by means of the [option -showheader] option.
[list_end]

[call [arg pathName] [cmd compare] [arg itemDesc1] [arg op] [arg itemDesc2]]
Deprecated. Use the [cmd {item compare}] command instead.

[call [arg pathName] [cmd configure] [opt [arg option]] \
     [opt [arg {value option value ...}]]]
Query or modify the configuration options of the widget.
If no [arg option] is specified, returns a list describing all of
the available options for [arg pathName] (see [fun Tk_ConfigureInfo] for
information on the format of this list).  If [arg option] is specified
with no [arg value], then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no [arg option] is specified).  If
one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
[arg Option] may have any of the values accepted by the [cmd treectrl]
command.

[call [arg pathName] [cmd contentbox]]
Returns a list with four elements giving the bounding box
of the screen area used to display items.
This is the area of the window not including borders, column headers, or
locked columns. An empty string is returned if the display area has
no height or width, which can happen if the window is too small.

[call [arg pathName] [cmd debug] [arg option] [opt [arg {arg arg ...}]]]
This command is used to facilitate debugging of the treectrl widget.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd debug] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {debug alloc}]]
Returns a string giving partial statistics on memory allocations, if the package
was built with TREECTRL_DEBUG defined.

[call [arg pathName] [cmd {debug cget}] [arg option]]
This command returns the current value of the debugging option
named [arg option].
[arg Option] may have any of the values accepted by the
[cmd {debug configure}] widget command.

[call [arg pathName] [cmd {debug configure}] \
     [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies debugging options
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list describing
all of the available debugging options (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given debugging option(s) to have the given value(s);
in this case the command returns an empty string.
[nl]

The following debugging options are supported:
[list_begin opt]
[opt_def [option -displaydelay] [arg millis]]
Specifies a time duration in milliseconds, which should be waited
after something has been drawn to the screen.
Setting this option has only an effect, if the
debugging options [option -enable] and [option -display] are switched on.

[opt_def [option -data] [arg boolean]]
If this option is switched on
(together with the debugging option [option -enable]),
at various places a consistence check
on the internal data structure is made
(e.g. for every item is checked,
if the registered number of children is equal to the number of child items).
If an inconsistency was found, a Tcl background error is raised.

[opt_def [option -display] [arg boolean]]
If this option is switched on
(together with the debugging option [option -enable]),
at varios places additional debugging output is printed to stdout.

[opt_def [option -drawcolor] [arg color]]
When specified, areas of the window are painted with this color when drawing
in those areas is about to occur.
Setting this option has only an effect if the
debugging options [option -enable] and [option -display] are switched on.

[opt_def [option -enable] [arg boolean]]
All other debugging options only take effect
if this option is also switched on.

[opt_def [option -erasecolor] [arg color]]
When specified, areas of the window which have been marked as "invalid"
(for example, when part of the window is exposed) are
painted with this color.
If you use an unusual color for this option (like [const pink]),
superflous screen redraws can be spotted more easily.
Setting this option has only an effect if the
debugging options [option -enable] and [option -display] are switched on.

[opt_def [option -span] [arg boolean]]
Debugging related to column spanning.

[opt_def [option -textlayout] [arg boolean]]
Debugging related to text-element layout.

[list_end]

[call [arg pathName] [cmd {debug dinfo}] [arg option]]
Returns a string describing display-related stuff. [arg Option] must be one
of [const alloc], [const ditem], [const onscreen] or [const range].

[call [arg pathName] [cmd {debug expose}] [arg x1] [arg y1] [arg x2] [arg y2]]
Causes the area of the window bounded by the given window-coords to be
marked as invalid. This simulates uncovering part of the window.

[call [arg pathName] [cmd {debug scroll}]]
Returns a string useful for debugging vertical scrolling.
[list_end]

[call [arg pathName] [cmd depth] [opt [arg itemDesc]]]
If the additional argument [arg itemDesc] is given,
then the result is a decimal string giving the depth of
the item described by [arg itemDesc].
If no [arg itemDesc] is specified, then the maximum depth of all
items in the treectrl widget is returned instead.
Depth is defined as the number of ancestors an item has.

[call [arg pathName] [cmd dragimage] [arg option] [opt [arg {arg ...}]]]
This command is used to manipulate the dragimage,
one or more dotted lines around rectangular regions of the treectrl widget.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd dragimage] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {dragimage add}] [arg itemDesc] \
     [opt [arg column]] [opt [arg element]]]
Adds the shapes of the item described by [arg itemDesc]
to the shapes of the dragimage.
Specifying additional arguments reduces
the number of rectangles that are added to the dragimage.
If no additional arguments is specified,
for every element of the item in every column a dotted rectangles is added.
If [arg column] is specified, all elements in other columns are ignored.
If also [arg element] is specified, only a rectangle for this one element
of the specified item in the given column is added.

[call [arg pathName] [cmd {dragimage cget}] [arg option]]
This command returns the current value of the dragimage option
named [arg option].
[arg Option] may have any of the values accepted by the
[cmd {dragimage configure}] widget command.

[call [arg pathName] [cmd {dragimage clear}]]
Removes all shapes (if there are any) from the dragimage.
This command does not modify the dragimage offset.

[call [arg pathName] [cmd {dragimage configure}] [opt [arg option]] \
     [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies the dragimage options
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list describing
all of the available dragimage options (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named dragimage option (this list will be identical
to the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given dragimage option(s) to have the given value(s);
in this case the command returns an empty string.
[nl]

The following dragimage options are supported:

[list_begin opt]
[opt_def [option -visible] [arg boolean]]
Specifies a boolean value which determines
whether the dragimage should currently be visible.
[list_end]

[call [arg pathName] [cmd {dragimage offset}] [opt [arg {x y}]]]
Returns a list containing the x and y offsets of the dragimage,
if no additional arguments are specified.
The dragimage offset is the screen distance, the image is displayed
relative to the item its shape is derived from.
If two coordinates are specified,
sets the dragimage offset to the given coordinates [arg x] and [arg y].

[list_end]

[call [arg pathName] [cmd element] [arg option] [opt [arg element]] \
     [opt [arg {arg arg ...}]]]
This command is used to manipulate elements (see [sectref ELEMENTS] below).
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd element] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {element cget}] [arg element] [arg option]]
This command returns the current value of the option named [arg option]
associated with the element given by [arg element].
[arg Option] may have any of the values accepted by the
[cmd {element configure}] widget command.

[call [arg pathName] [cmd {element configure}] [arg element] \
     [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies options associated with the element given by [arg element]
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list describing
all of the available options for [arg element] (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) in [arg element];
in this case the command returns an empty string.
See [sectref ELEMENTS] below for details on the options available for elements.

[call [arg pathName] [cmd {element create}] [arg element] [arg type] \
     [opt [arg {option value ...}]]]
Create a new elememt in [arg pathName] of type [arg type]
with name [arg element].
The exact format of the arguments after [arg type] depends on [arg type],
but generally consist of specifications for zero or more element options.
See the subsections on individual element types below for more
on the syntax of this command.
This command returns the name for the new element.

[call [arg pathName] [cmd {element delete}] [opt [arg {element ...}]]]
Deletes each of the named elements and returns an empty string.
If an element is deleted while it is still configured
as an element of one or more styles
by means of the [cmd {style elements}] widget command,
it is also removed from the element lists of these styles.

[call [arg pathName] [cmd {element names}]]
Returns a list containing the names of all existing elements.

[call [arg pathName] [cmd {element perstate}] [arg element] [arg option] [arg stateList]]
This command returns the value of the [sectref {PER-STATE OPTIONS} per-state]
option named [arg option] for [arg element] for a certain state.
[arg StateList] is a list of state names (static and dynamic, see [sectref STATES])
which specifies the state to use.

[call [arg pathName] [cmd {element type}] [arg element]]
Returns the type of the element given by [arg element],
such as [const rect] or [const text].
[list_end]

[call [arg pathName] [cmd expand] [opt [option -recurse]] \
     [opt [arg {itemDesc ...}]]]
Use [cmd {item expand}] instead.

[call [arg pathName] [cmd identify] [arg x] [arg y]]
Returns a list describing what
is displayed at the given window coordinates [arg x] and [arg y].
If the coordinates are outside the window, over the borders, or over any
whitespace in the window, then the result is an empty string;
otherwise the first word of the result is [const header] or [const item].
[nl]

If the coordinates are over a column header, then
the first word of the result is [const header], followed by
the unique id of the column (or the string [const tail]).
If the x coordinate is near the left or right end of a column, then
a third word [const left] or [const right] is appended to the result.
[nl]

If the coordinates are over an item, then the first word of the result
is [const item] followed by the unique id of that item.
If the coordinates are not over the area for displaying buttons and lines,
then [const column] and a unique column id are the
3rd and 4th words of the result. If the coordinates are over an element within
that column, then [const element] and an element name are the 5th and 6th
words of the result.
[nl]

If the coordinates are over a button, then the first word of the result is
[const item], followed by the unique id of that item, followed by the word
[const button].
[nl]
If the coordinates are over a line descending from an ancestor of an item
(but not the parent of that item), then the first word of the result is
[const item], followed by the unique id of that item, followed by the word
[const line], followed by the unique id of the item the line is coming
from. This is used to collapse the ancestor when the line is clicked on.

[call [arg pathName] [cmd index] [arg itemDesc]]
Deprecated. Use [cmd {item id}] instead.

[call [arg pathName] [cmd item] [arg option] [opt [arg {arg ...}]]]
This command is used to manipulate items.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd item] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {item ancestors}] [arg itemDesc]]
Returns a list containing the item ids of the ancestors
of the item specified by [arg itemDesc]. The first list value is the parent,
the second is the parent's parent, an so on. The last list value will be the
root item if [arg itemDesc] is a descendant of the root item.

[call [arg pathName] [cmd {item bbox}] [arg itemDesc] [opt [arg column]] \
     [opt [arg element]]]
Returns a list with four elements giving the bounding box
of the item described by [arg itemDesc].
If no further argument is specified, the bbox spans the area of the item
over all non-locked columns. If a [arg column] is specified, only the area of the item
in this column is considered. If an additional [arg element] is specified,
the area of this [arg element] in [arg column] of the specified item is
returned.

[call [arg pathName] [cmd {item cget}] [arg itemDesc] [arg option]]
Returns the current value of the configuration option for the item specified by
[arg itemDesc] whose name is [arg option]. [arg Option] may have any of the
values accepted by the [cmd "item configure"] command.

[call [arg pathName] [cmd {item children}] [arg itemDesc]]
Returns a list containing the item ids of all children
of the item specified by [arg itemDesc] in the correct order from
the first child to the last child.

[call [arg pathName] [cmd {item collapse}] [arg itemDesc] [opt [option -recurse]]]
Switches off the [const open] state of the item(s) described by [arg itemDesc].
If an item has descendants, then they are no longer displayed.
If an item is already closed, then this command has no effect on that item.
If [option -recurse] is specified, then all descendants of the items described
by [arg itemDesc] will also be collapsed.
For every item that actually will be collapsed, two events are generated:
a [const <Collapse-before>] event before the item state is changed,
and a [const <Collapse-after>] event after the item state was changed.

[call [arg pathName] [cmd {item compare}] [arg itemDesc1] [arg op] [arg itemDesc2]]
From both items described by the [arg itemDesc]s the index is retrieved
(as returned from the [cmd {item order}] widget command).
Then these indexes are compared using the operator [arg op], which must
be either [const <],  [const <=],  [const ==], [const >=], [const >],
or [const !=].
The return value of this command is 1 if the comparison evaluated to true,
0 otherwise.

[call [arg pathName] [cmd {item complex}] [arg itemDesc] [opt [arg list...]]]
This horrible command is now deprecated. Use [cmd {item element configure}]
instead. For every column of the treectrl there may be specified one [arg list].
Each [arg list] should look like this:
[example_begin]
{ {element option value ...} {element option value ...} ...}
[example_end]
Every [arg option] must be known by the element's type
(see [sectref ELEMENTS] below).
Each [arg option] will be set to [arg value] for the element in this
one column in this item.

[call [arg pathName] [cmd {item configure}] [arg itemDesc] [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
If no [arg option] is specified, returns a list describing all of the available
options for the item given by [arg itemDesc] (see [fun Tk_ConfigureInfo] for
information on the format of this list). If [arg option] is specified with no
value, then the command returns a list describing the one named option (this
list will be identical to the corresponding sublist of the value returned if
no [arg option] is specified).
[nl]
If one or more [arg option]-[arg value] pairs
are specified, then the command modifies the given item option(s) to have the
given value(s); in this case the command returns an empty string. This is the
only case where [arg itemDesc] may refer to multiple items.
[nl]
The following options are supported by this command (see [cmd {item create}] for
the meaning of each option):

[list_begin opt]

[opt_def [option -button] [arg boolean|auto]]
[opt_def [option -height] [arg height]]
[opt_def [option -tags] [arg tagList]]
[opt_def [option -visible] [arg boolean]]

[list_end]

[call [arg pathName] [cmd {item count}] [opt [arg itemDesc]]]
If no additional arguments are given, the result is a decimal string giving the number of
items created by the [cmd "item create"] widget command which haven't been
deleted by the [cmd "item delete"] widget command, plus 1 for the ever-present
root item.
If the optional argument [arg itemDesc] is given, then the result is the
number of items that match that [sectref {ITEM DESCRIPTION} {item description}].

[call [arg pathName] [cmd {item create}] [opt [arg {option value ...}]]]
Creates some new items and optionally returns a list of unique identifiers for
those items.
The new items have the states [const open] and [const enabled] set by default.
If the treectrl widget currently has the focus,
the state [const focus] is also set.
[nl]
The following options are supported by this command:

[list_begin opt]

[opt_def [option -button] [arg boolean|auto]]
The value of this option must have one of the forms accepted by [fun Tcl_GetBoolean]
or be the word [const auto] (or any abbreviation of it). It indicates whether or not an expand/collapse
button should be drawn next to the item, typically to indicate that the item has
children.
If the value of this option is [const auto], then a button is displayed next to the
item whenever the item has any children whose item option [option -visible] is true.
The button will only be displayed if:
[list_begin enum]
[enum]
the column specified by the treectrl option [option -treecolumn] is visible, and
[enum]
the treectrl option [option -showbuttons] is true, and
[enum]
for the root item, the treectrl option [option -showrootbutton] is true.
[list_end]

[opt_def [option -count] [arg numItems]]
Specifies the number of items to create. Must be >= 0. Defaults to 1.

[opt_def [option -height] [arg height]]
Specifies a fixed height in any of the forms acceptable to [fun Tk_GetPixels].
Must be >= 0. If [arg height] is zero then the item's height is unspecified.
Defaults to 0.

[opt_def [option -nextsibling] [arg itemDesc]]
Specifies the item before which the new items will be inserted. The new items
will have the same parent as [arg itemDesc].

[opt_def [option -open] [arg boolean]]
Specifies whether the items should be open or closed. Default is true.

[opt_def [option -parent] [arg itemDesc]]
Specifies the item which the new items will be the children of. The new items
will be appended to the list of children of [arg itemDesc].

[opt_def [option -prevsibling] [arg itemDesc]]
Specifies the item after which the new items will be inserted. The new items
will have the same parent as [arg itemDesc].

[opt_def [option -returnid] [arg boolean]]
Specifies whether or not to return a list of item identifiers for the newly
created items. Specifying false is useful when creating a large number of items in the
console or to improve performance. Default is true.

[opt_def [option -tags] [arg tagList]]
[arg TagList] is a list of tag names to be added to the new items.

[opt_def [option -visible] [arg boolean]]
[arg Boolean] must have one of the forms accepted by [fun Tcl_GetBoolean]. It
indicates that the item should be displayed in the list. The item will only be
displayed if:
a) each ancestor is a descendant of the root item (not an orphan);
and b) each ancestor's [option -visible] option is true 

[list_end]

[call [arg pathName] [cmd {item delete}] [arg first] [opt [arg last]]]
Deletes the specified item(s).
[arg First] and [arg last] must be valid
[sectref {ITEM DESCRIPTION} {item descriptions}].
If [arg last] isn't specified, then [arg first] may specify multiple items.
If both [arg first] and [arg last] are specified,
they must each decribe a single item with a common ancestor;
then the range of items between [arg first] and [arg last] is deleted.
The order of [arg first] and [arg last] doesn't matter.
[nl]
Deleting an item deletes any child items of the deleted item recursively.
If the current [const active] item is deleted, the root item becomes the new active item.
If the current selection [const anchor] item is deleted, the root item becomes the new anchor item.
There is no way to delete the root item of the treectrl widget;
in all cases the specification of the root item is ignored.
[nl]
For each call to this command, two events may be generated.
If any of the deleted items are selected, then a [const <Selection>] event
is generated just before the items are deleted.
If any items are going to be deleted, then an [const <ItemDelete>] event event is generated just before the items
are deleted.

[call [arg pathName] [cmd {item descendants}] [arg itemDesc]]
Returns a list containing the item ids of the descendants
of the item specified by [arg itemDesc], i.e. the children, grandchildren,
great-grandchildren etc, of the item.

[call [arg pathName] [cmd {item dump}] [arg itemDesc]]
Returns a list with 4 words in the form
[const index] [emph index] [const indexVis] [emph indexVis].

[call [arg pathName] [cmd {item element}] [arg command] [arg itemDesc] \
     [arg column] [arg element] [opt [arg {arg ...}]]]
This command is used to manipulate elements of the item.
The exact behavior of the command depends on the [arg command] argument
that follows the [cmd element] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {item element actual}] [arg itemDesc] [arg column] \
     [arg element] [arg option]]
Deprecated. Use [cmd {item element perstate}] instead.

[call [arg pathName] [cmd {item element cget}] [arg itemDesc] [arg column] \
     [arg element] [arg option]]
This command returns the value of the option named [arg option]
associated with [arg element] inside [arg column] of the item described by
[arg itemDesc], if it was already configured for the actual item.
[arg Option] may have any of the values accepted by the type of the
specified element (see [sectref ELEMENTS] below)

[call [arg pathName] [cmd {item element configure}] [arg itemDesc] \
     [arg column] [arg element] [opt [arg option]] [opt [arg value]] \
     [opt [arg {option value ...}]]]
This command modifies configuration options for an element in a column of
an item.
If no [arg option] is specified, the command returns a list describing
all of the available options for the element (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
[nl]
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) in the
[arg element] inside [arg column] of the item(s) described by [arg itemDesc];
in this case the command returns an empty string. This is the only case where
[arg itemDesc] may refer to multiple items.
[nl]
It is possible to configure multiple elements in multiple columns with
a single call. To configure another element in the same column, append a
'[const +]' argument followed by the element name. To configure elements in
another column, append a '[const ,]' argument followed by the column.
For example:
[example_begin]
.t item element configure $I \
	$C1 $E1 -text "hello" + $E2 -text "world" , \
	$C2 $E3 -fill Blue , \
	$C3 $E1 -text "apples and oranges"
[example_end]
Each of the [sectref {COLUMN DESCRIPTION} {column description}] arguments
to this command may refer to multiple columns if at least one
[arg option]-[arg value] pair is given.

[call [arg pathName] [cmd {item element perstate}] [arg itemDesc] [arg column] \
     [arg element] [arg option] [opt [arg stateList]]]
This command returns the current value of the [sectref {PER-STATE OPTIONS} per-state]
option named [arg option] for [arg element] inside [arg column] of the item described by
[arg itemDesc]. If [arg stateList] is specified, the list of state names (static
and dynamic, see [sectref STATES]) is used in place of the current state for
[arg item] and [arg column.]

[list_end]

[call [arg pathName] [cmd {item enabled}] [arg itemDesc] [opt [arg boolean]]]
Returns 1 if the item described by [arg itemDesc] has the
state [const enabled] switched on, 0 otherwise. If [arg boolean] is specified,
then the [const enabled] state of every item described by the
[sectref {ITEM DESCRIPTION} {item description}] [arg itemDesc] is set accordingly.
All items are enabled when first created. Disabled items cannot be selected,
and are ignored by the default key-navigation and mouse bindings.

[call [arg pathName] [cmd {item expand}] [arg itemDesc] [opt [option -recurse]]]
Switches on the [const open] state of the item(s) described by [arg itemDesc].
If an item has descendants, then they are now displayed.
If an item is already open, then this command has no effect on that item.
If [option -recurse] is specified, then all descendants of the items described by
[arg itemDesc] will also be expanded.
For every item that actually will be expanded, two events are generated:
an [const <Expand-before>] event before the item state is changed,
and an [const <Expand-after>] event after the item state was changed.

[call [arg pathName] [cmd {item firstchild}] [arg parent] [opt [arg child]]]
If [arg child] is not specified, returns the item id of the first
child of the item described by [arg parent].
If [arg child] is specified, it must describe an item
that is neither the root item nor an ancestor of [arg parent].
Then it will become the new first child of [arg parent].

[call [arg pathName] [cmd {item id}] [arg itemDesc]]
This command resolves the [sectref {ITEM DESCRIPTION} {item description}]
[arg itemDesc] into a list of unique item identifiers. If [arg itemDesc]
doesn't refer to any existing items, then this command returns an empty list.

[call [arg pathName] [cmd {item image}] [arg itemDesc] [opt [arg column]] \
     [opt [arg image]] [opt [arg {column image ...}]]]
This command sets or retrieves the value of the [sectref {PER-STATE OPTIONS} per-state]
-image option for the first image element in one or more columns.

If no [arg column] is specified, this command returns a list of values,
one per column.

If no [arg image] is specified, this command returns the value for [arg column].
[nl]
If one or more [arg column]-[arg image] pairs is specified,
then the value of the -image option in each [arg column] is set to [arg image].
In this case [arg itemDesc] may refer to multiple items and each [arg column]
may refer to multiple columns.
[nl]
Note that this command is provided as a convenience. Use the
[cmd "item element configure"] or [cmd "item element cget"] commands if you want
to set or retrieve the value of the -image option for a specific image element.

[call [arg pathName] [cmd {item isancestor}] [arg itemDesc] [arg descendant]]
Returns 1 if the item described by [arg itemDesc] is a direct or indirect
parent of the item decribed by [arg descendant], 0 otherwise.

[call [arg pathName] [cmd {item isopen}] [arg itemDesc]]
Returns 1 if the item described by [arg itemDesc] has the
state [const open] switched on, 0 otherwise.

[call [arg pathName] [cmd {item lastchild}] [arg parent] [opt [arg child]]]
If [arg child] is not specified, returns the item id of the last
child of the item described by [arg parent].
If [arg child] is specified, it must describe an item
that is not an ancestor of [arg parent].
Then it will become the new last child of [arg parent].

[call [arg pathName] [cmd {item nextsibling}] [arg sibling] [opt [arg next]]]
If [arg next] is not specified, returns the item id of the next
sibling of the item described by [arg sibling].
If [arg next] is specified, it must describe an item
that is not an ancestor of [arg sibling].
Then it will become the new next sibling of [arg sibling].

[call [arg pathName] [cmd {item numchildren}] [arg itemDesc]]
Returns the number of children of the item described by [arg itemDesc].

[call [arg pathName] [cmd {item order}] [arg itemDesc] [opt [arg -visible]]]
This command returns the position of the item [arg itemDesc] relative to
its toplevel ancestor (usually the root item, unless the ancestor is an
orphan). If you imagine all the items flattened into a vertical list, the
result of this command is the row the item falls in. If the optional argument
[arg -visible] is given, only the items whose ancestors are expanded, and whose
-visible option is true, get counted; in this case -1 is returned if the item
is not visible.

[call [arg pathName] [cmd {item parent}] [arg itemDesc]]
Returns the item id of the parent of the item
described by [arg itemDesc].

[call [arg pathName] [cmd {item prevsibling}] [arg sibling] [opt [arg prev]]]
If [arg prev] is not specified, returns the item id of the previous
sibling of the item described by [arg sibling].
If [arg prev] is specified, it must describe an item
that is not an ancestor of [arg sibling].
Then it will become the new previous sibling of [arg sibling].

[call [arg pathName] [cmd {item range}] [arg first] [arg last]]
Returns a list containing the item ids of all items
in the range between [arg first] and [arg last], inclusive.
The order between [arg first] and [arg last] doesn't matter,
and the result is always sorted by the increasing order of the items (as
returned by the [cmd {item order}] command).
The items specified by [arg first] and [arg last] must share a common
ancestor.

[call [arg pathName] [cmd {item remove}] [arg itemDesc]]
Removes the item described by [arg itemDesc]
from the list of children of its parent, so that it will become an orphan.

[call [arg pathName] [cmd {item rnc}] [arg itemDesc]]
Returns a list of two integers, which corresponds to the row and column
of the item described by [arg itemDesc]. The row and column corresponds to
the on-screen arrangement of items as determined by the -orient and -wrap
options. If the item is not displayed, this command returns an empty string.

[call [arg pathName] [cmd {item sort}] [arg itemDesc] [opt [arg {option ...}]]]
Sorts the children of the item described by [arg itemDesc],
and redisplays the tree with the items in the new order.
[nl]

The range of items which should be sorted can be restricted
by means of the [option -first] and/or [option -last] options,
which should be children of the item described by [arg itemDesc];
the order between these two limiting items doesn't matter.
[nl]

The sort column can be specified by means of the [option -column] option;
this option can be used repeatedly to define a multicolumn sort.
The sorting is done by looking at the [arg text]
of the element specified by the [option -element] option,
which must be a text element defined in the style of the sorting column,
by default the first text element is used.
[nl]

If the [option -notreally] option is specified,
no rearranging of the items is done;
instead the sorted items are returned as result of the command.
[nl]

By default ASCII sorting is used with the result returned in increasing order.
Any of the following options may be specified to control
the sorting process of the previously specified column
(unique abbreviations are accepted):

[list_begin opt]
[opt_def [option -ascii]]
Use string comparison with ASCII collation order. This is the default.

[opt_def [option -command] [arg command]]
Use [arg command] as a comparison command.
To compare two items, evaluate a Tcl script consisting of
[arg command] with the numerical ids of the two items appended as additional
arguments.  The script should return an integer less than,
equal to, or greater than zero if the first item is to
be considered less than, equal to, or greater than the second,
respectively.

[opt_def [option -decreasing]]
Sort the items in decreasing order ("largest" items first).

[opt_def [option -dictionary]]
Use dictionary-style comparison. This is the same as [option -ascii]
except (a) case is ignored except as a tie-breaker and (b) if two
strings contain embedded numbers, the numbers compare as integers,
not characters.  For example, in [option -dictionary] mode, [term bigBoy]
sorts between [term bigbang] and [term bigboy], and [term x10y]
sorts between [term x9y] and [term x11y].

[opt_def [option -increasing]]
Sort the items in increasing order ("smallest" items first). This is the default.

[opt_def [option -integer]]
Convert to integers and use integer comparison.

[opt_def [option -real]]
Convert to floating-point values and use floating comparison.
[list_end]

[call [arg pathName] [cmd {item span}] [arg itemDesc] [opt [arg column]] \
     [opt [arg numColumns]] [opt [arg {column numColumns ...}]]]
This command sets or retrieves the number of columns that a style covers.
If no [arg column] is specified, the return value is a list of spans, one per column.
If no [arg numColumns] is specified, the return value is the span for [arg column].
[nl]
If one or more [arg column]-[arg numColumns] pairs is specified, the
span for each [arg column] is set to [arg numColumns]. In this case [arg itemDesc]
may refer to multiple items and each [arg column] may refer to multiple
columns.

[call [arg pathName] [cmd {item state}] [arg command] [arg itemDesc] \
     [opt [arg {arg ...}]]]
This command is used to manipulate the states of an item.
The exact behavior of the command depends on the [arg command] argument
that follows the [cmd style] argument.
The following forms of the command are supported:

[list_begin definitions]

[call [arg pathName] [cmd {item state forcolumn}] [arg itemDesc] [arg column] \
     [opt [arg stateDescList]]]
Just like [cmd {item state set}] but manipulates dynamic states for a single
item column, not the item as a whole. If [arg stateDescList] is unspecified,
this command returns a list containing the names of all the dynamic states
which are switched on in [arg column].
[nl]
If [arg stateDescList] is specified, then [arg itemDesc] may refer to multiple
items and [arg column] may refer to multiple columns.

[call [arg pathName] [cmd {item state get}] [arg itemDesc] \
     [opt [arg {stateName}]]]
If no [arg stateName] is specified, returns a list containing
the names of all (static and dynamic) states
which are currently switched on for the item described by [arg itemDesc].
If a [arg stateName] is specified,
1 is returned if the specified state is currently switched on for the item,
0 otherwise.

[call [arg pathName] [cmd {item state set}] [arg itemDesc] \
     [opt [arg lastItem]] [arg stateDescList]]
Every element of [arg stateDescList]
must be the name of a dynamic state (see [sectref STATES] below),
optionally preceded by a [const ~] or [const !] character.
Every state with a leading [const !] will be switched off for the
item described by [arg itemDesc],
every state with a leading [const ~] will be toggled, and
every state without leading [const !] or [const ~] will be switched on.
If [arg lastItem] is specified, the state changes will be made for all items
in the range between [arg itemDesc] and [arg lastItem].
If [arg lastItem] unspecified,
then the state changes are made for all items described by [arg itemDesc].

[list_end]

[call [arg pathName] [cmd {item style}] [arg command] [arg itemDesc] \
     [opt [arg {arg ...}]]]
This command is used to manipulate the styles of an item.
The exact behavior of the command depends on the [arg command] argument
that follows the [cmd style] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {item style elements}] [arg itemDesc] [arg column]]
This command returns a list containing the names of elements which were
configured by the [cmd {item element configure}] command for the item
described by [arg itemDesc] in [arg column]. If there is no style assigned
to [arg column] an error is returned.

[call [arg pathName] [cmd {item style map}] [arg itemDesc] [arg column] \
     [arg style] [arg map]]
Like the [cmd "item style set"] command, this command may be used to assign a
style to a specific column of an item. Unlike [cmd "item style set"], this
command can transfer configuration values of elements in the current style
to elements in the new style specified by [arg style].

[arg Map] must be a list of [arg elementOld]-[arg elementNew] pairs, where
[arg elementOld] is an element in the current style, and [arg elementNew] is
an element in the style specified by [arg style]. Both [arg elementOld] and
[arg elementNew] must be of the same type ([const bitmap], [const text] etc).
[arg ItemDesc] may refer to multiple items and [arg column] may refer to
multiple columns.

[call [arg pathName] [cmd {item style set}] [arg itemDesc] [opt [arg column]] \
     [opt [arg style]] [opt [arg {column style ...}]]]
This command sets or retrieves the style assigned to one or more columns.

If no [arg column] is specified, this command returns a list containing the names of the
styles set for all columns of the item described by [arg itemDesc].

If no [arg style] is specified, this command
returns the name of the style set for the item described by
[arg itemDesc] in [arg column].
[nl]
If one or more [arg column]-[arg style] pairs is specified,
then the style in each [arg column] is set to [arg style]. In this case
[arg itemDesc] may refer to multiple items and each [arg column] may refer to
multiple columns.
[list_end]


[call [arg pathName] [cmd {item tag}] [arg option] [opt [arg {arg arg ...}]]]
This command is used to manipulate tags on items.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd {item tag}] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {item tag add}] [arg itemDesc] [arg tagList]]
Adds each tag in [arg tagList] to the items specified by the
[sectref {ITEM DESCRIPTION} {item description}] [arg itemDesc].
Duplicate tags are ignored. The list of tags for an item can also be
changed via an item's [option -tags] option.

[call [arg pathName] [cmd {item tag expr}] [arg itemDesc] [arg tagExpr]]
Evaluates the tag expression [arg tagExpr] against every item
specified by the [sectref {ITEM DESCRIPTION} {item description}]
[arg itemDesc]. The result is 1 if the tag expression evaluates to true
for every item, 0 otherwise.

[call [arg pathName] [cmd {item tag names}] [arg itemDesc]]
Returns a list of tag names assigned to the items
specified by the [sectref {ITEM DESCRIPTION} {item description}]
[arg itemDesc]. The result is the union of any tags assigned to the
items.

[call [arg pathName] [cmd {item tag remove}] [arg itemDesc] [arg tagList]]
Removes each tag in [arg tagList] from the items specified by the
[sectref {ITEM DESCRIPTION} {item description}] [arg itemDesc].
It is not an error if any of the items do not use any of the tags.
The list of tags for an item can also be changed via an item's
[option -tags] option.
[list_end]


[call [arg pathName] [cmd {item text}] [arg itemDesc] [opt [arg column]] \
     [opt [arg text]] [opt [arg {column text ...}]]]
This command sets or retrieves the value of the -text option for the first
text element in one or more columns.

If no [arg column] is specified, this command returns a list of values,
one per column.

If no [arg text] is specified, this command returns the value for [arg column].
[nl]
If one or more [arg column]-[arg text] pairs is specified,
then the value of the -text option in each [arg column] is set to [arg text].
In this case [arg itemDesc] may refer to multiple items and each [arg column]
may refer to multiple columns.
[nl]
Note that this command is provided as a convenience. Use the
[cmd "item element configure"] or [cmd "item element cget"] commands if you
want to set or retrieve the value of the -text option for a specific text element.

[call [arg pathName] [cmd {item toggle}] [arg itemDesc] [opt [option -recurse]]]
Changes the [const open] state of the item(s) described by [arg itemDesc].
If the [const open] state is currently switched off, then
this command does the same as the [cmd {item expand}] widget command;
otherwise the same as the [cmd {item collapse}] widget command.
If [option -recurse] is specified, then the [const open] state of all descendants of
the items described by [arg itemDesc] will also be toggled.

[list_end]

[call [arg pathName] [cmd marquee] [arg option] [opt [arg {arg ...}]]]
This command is used to manipulate the marquee,
a rectangular region of the treectrl widget
optionally marked with a surrounding dotted line.
One corner point of the marquee is fixed as long as the marquee is visible
and called the anchor; the diagonally opposite corner is dragged with the
mouse while resizing the marquee and simply called the corner.
All coordinates handled by this widget command are treectrl coordinates,
i.e. the [cmd canvasx] or [cmd canvasy] widget command should be
used before any window coordinates can be used.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd marquee] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {marquee anchor}] [opt [arg {x y}]]]
Returns a list containing the x and y coordinates of the anchor,
if no additional arguments are specified.
If two coordinates are specified,
sets the anchor to the given coordinates [arg x] and [arg y].

[call [arg pathName] [cmd {marquee cget}] [arg option]]
This command returns the current value of the marquee option
named [arg option].
[arg Option] may have any of the values accepted by the
[cmd {marquee configure}] widget command.

[call [arg pathName] [cmd {marquee configure}] [opt [arg option]] \
     [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies the marquee options
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list describing
all of the available marquee options (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named marquee option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given marquee option(s) to have the given value(s);
in this case the command returns an empty string.
[nl]

The following marquee options are supported:

[list_begin opt]
[opt_def [option -visible] [arg boolean]]
Specifies a boolean value which determines
whether the dotted line surrounding the region of the marquee
should currently be visible.
[list_end]

[call [arg pathName] [cmd {marquee coords}] [opt [arg {x1 y1 x2 y2}]]]
Returns a list containing the x and y coordinates of the anchor
followed by the x and y coordinates of the corner,
if no additional arguments are specified.
If four coordinates are specified,
sets the anchor to the given coordinates [arg x1] and [arg y1]
and the corner to the coordinates [arg x2] and [arg y2].

[call [arg pathName] [cmd {marquee corner}] [opt [arg {x y}]]]
Returns a list containing the x and y coordinates of the corner,
if no additional arguments are specified.
If two coordinates are specified,
sets the corner to the given coordinates [arg x] and [arg y].

[call [arg pathName] [cmd {marquee identify}]]
Returns a list with information about any items intersecting the marquee.
The format of the returned list is:
[example_begin]
{
    {item {column element element ...} {column element element ...} ...}
    {item {column element element ...} {column element element ...} ...}
    ...
}
[example_end]
There may be zero sublists following an item id if the marquee is in the
button/line area of an item. There may be zero element names following a
column id if the item-column has no style or if the marquee does not
intersect any elements in that column.

[list_end]

[call [arg pathName] [cmd notify] [arg option] [opt [arg {arg ...}]]]
Many Tk widgets communicate with the outside world via [option -command]
callbacks and/or virtual events. For example, the Text widget
evaluates its [option -yscrollcommand] when the view in the widget changes,
and generates a <<Modified>> virtual event when text is inserted or deleted.
A treectrl widget replaces both methods of communication with its own event
mechanism accessed through the [cmd notify] subcommands.
[nl]

The exact behavior of the command depends on the [arg option] argument
that follows the [cmd notify] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {notify bind}] [opt [arg object]] \
     [opt [arg pattern]] [opt +][opt [arg script]]]
This command associates Tcl scripts with events generated by a
treectrl widget.

If all three arguments are specified, [cmd {notify bind}] will arrange for
[arg script] (a Tcl script) to be evaluated whenever the event(s) specified
by [arg pattern] are generated by this treectrl widget.

If [arg script] is prefixed with a "+", then it is appended to any existing
binding for [arg pattern];  otherwise [arg script] replaces any existing binding.

If [arg script] is an empty string then the current binding for [arg pattern]
is destroyed, leaving [arg pattern] unbound. In all of the cases where a script
argument is provided, [cmd {notify bind}] returns an empty string.
[nl]
If [arg pattern] is specified without a [arg script], then the script currently
bound to [arg pattern] is returned, or an empty string is returned if there is
no binding for [arg pattern]. If neither [arg pattern] nor [arg script] is
specified, then the return value is a list whose elements are all the patterns
for which there exist bindings for [arg object]. 
[nl]
The [arg object] argument determines which window(s) the binding applies to.
If [arg object] begins with a dot, as in .a.b.c, then it must be the path name
for a window; otherwise it may be an arbitrary string. Like the regular
[cmd bind] command, bindings on window names are automatically removed if
that window is destroyed.

[call [arg pathName] [cmd {notify configure}] [arg object] \
     [arg pattern] [opt [arg option]] [opt [arg value]] \
     [opt [arg {option value ...}]]]
This command sets and retrieves options for bindings created by the
[cmd {notify bind}] command.
[nl]
If no [arg option] is specified, the command returns a list with
[arg option]-[arg value] pairs describing all
the available binding options for [arg pattern] on [arg object].
If [arg option] is specified with no [arg value],
then the command returns the current value of that option.
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) for the binding;
in this case the command returns an empty string.
[nl]

The following binding options are supported:
[list_begin opt]
[opt_def [option -active] [arg boolean]]
Specifies if the binding should be active.
As long as this option is specified as false,
a binding script will not be evaluated when the corresponding event is
generated.
[list_end]

[call [arg pathName] [cmd {notify detailnames}] [arg eventName]]
Returns a list containing the names of all details,
which are installed for the event with the name [arg eventName]
by means of the [cmd {notify install}] widget command
or by the treectrl widget itself.

[call [arg pathName] [cmd {notify eventnames}]]
Returns a list containing the names of all events,
which are installed by means of the [cmd {notify install}] widget command
or by the treectrl widget itself.

[call [arg pathName] [cmd {notify generate}] [arg pattern] \
	[opt [arg charMap]] [opt [arg percentsCommand]]]
This command causes the treectrl widget to generate an event. This command is
typically used to generate dynamic events created by the [cmd {notify install}]
command, but may be used to generate static events also.
The event specified by [arg pattern] is generated, and any active binding
scripts on the event are evaluated after undergoing %-substitution.
If there are details defined for the event,
[arg pattern] must describe an <[arg eventName]-[arg detail]> pair,
otherwise [arg pattern] should be <[arg eventName]>.
[nl]

The optional [arg charMap] is a list of [arg char]-[arg value] pairs
as in the form returned by [cmd {array get}].
Each [arg char] has to be exactly one character.
The [arg charMap] is used in %-substitution.
[nl]

If [arg percentsCommand] is specified, then it will be used to perform %-substitution
on any scripts bound to the event. If [arg percentsCommand] is not specified and
the event is dynamic, then the %-subtitution command passed to [cmd {notify install}]
will be used if it was provided. If the event is static or no %-substitution
command is available, then all %-substitution is done using [arg charMap] only .
See [cmd {notify install}] for a description of [arg percentsCommand].

[call [arg pathName] [cmd {notify install}] [arg pattern] [opt [arg percentsCommand]]]
This command installs a new event or detail specified by [arg pattern]. 
Events created by this command are called dynamic,
whereas events created by the treectrl widget itself are called static.
This command may be called to set or retrieve the [arg percentsCommand] for
an existing dynamic event.
[nl]

The optional [arg percentsCommand] is a list containing the name of a Tcl
command, plus any optional arguments, to which five additional arguments
will be appended. The command will be called to perform %-substitution on any
scripts bound to the event specified by [arg pattern] (see [sectref {EVENTS AND SCRIPT SUBSTITUTIONS}]).
[arg PercentsCommand] should be defined as follows:
[example_begin]
proc percentsCommand {?arg arg ...? char object event detail charMap} {
	switch -- $char {
		...
	}
	return $value
}
[example_end]

The optional [arg arg] arguments are part of the [arg percentsCommand] list.
[arg Char] is the %-character to be substituted. [arg Object] is the same
as the argument to [cmd {notify bind}]. [arg Event] and [arg detail] specify
the event. [arg CharMap] is the same as the argument to [cmd {notify generate}].
[arg PercentsCommand] should return the value to replace the %-character by.
If an error occurs evaluating [arg percentsCommand], the %-character is replaced
by itself.
[nl]
[cmd {notify install}] returns the current [arg percentsCommand] for the event,
or an error if the event is not dynamic.

[call [arg pathName] [cmd {notify install detail}] [arg eventName] \
     [arg detail] [opt [arg percentsCommand]]]
Deprecated.
Use [cmd {notify install}] with a [arg pattern] of <[arg eventName]-[arg detail]> instead.

[call [arg pathName] [cmd {notify install event}] [arg eventName] \
     [opt [arg percentsCommand]]]
Deprecated.
Use [cmd {notify install}] with a [arg pattern] of <[arg eventName]> instead.

[call [arg pathName] [cmd {notify linkage}] [arg pattern]]
Returns a string indicating
whether the specified event or detail is created
by means of the [cmd {notify install}] widget command ([const dynamic])
or by the treectrl widget itself ([const static]).

[call [arg pathName] [cmd {notify linkage}] [arg eventName] [opt [arg detail]]]
Deprecated.
Use [cmd {notify linkage}] with a [arg pattern] of <[arg eventName]> or
<[arg eventName]-[arg detail]> instead.

[call [arg pathName] [cmd {notify unbind}] [arg object] [opt [arg pattern]]]
If no [arg pattern] is specified, all bindings on [arg object] are removed.
If [arg pattern] is specified, then the current binding for [arg pattern]
is destroyed, leaving [arg pattern] unbound.

[call [arg pathName] [cmd {notify uninstall}] [arg pattern]]
If the event or detail specified by [arg pattern] is static
(i.e. created by the treectrl widget itself), an error is generated.
Otherwise the dynamic event or detail is removed. If an event name is specified
without a detail, all details for that event are also removed.

[call [arg pathName] [cmd {notify uninstall detail}] \
     [arg eventName] [arg detail]]
Deprecated.
Use [cmd {notify uninstall}] with a [arg pattern] of <[arg eventName]-[arg detail]> instead.

[call [arg pathName] [cmd {notify uninstall event}] [arg eventName]]
Deprecated.
Use [cmd {notify uninstall}] with a [arg pattern] of <[arg eventName]> instead.
[list_end]

[call [arg pathName] [cmd numcolumns]]
Deprecated. Use the [cmd {column count}] command instead.

[call [arg pathName] [cmd numitems]]
Deprecated. Use the [cmd {item count}] command instead.

[call [arg pathName] [cmd orphans]]
Returns a list containing the item ids of all items
which have no parent.
When an item is created, it has no parent by default,
and can later become an orphan
by means of the [cmd {item remove}] widget command. The root item is not returned.

[call [arg pathName] [cmd range] [arg first] [arg last]]
Deprecated. Use the [cmd {item range}] command instead.

[call [arg pathName] [cmd scan] [arg option] [arg args]]
This command is used to implement scanning on treectrls. It has two forms,
depending on [arg option]: 
[list_begin definitions]

[call [arg pathName] [cmd {scan mark}] [arg x] [arg y]]
Records [arg x] and [arg y] and the treectrl's current view;  used in conjunction with
later [cmd {scan dragto}] commands. Typically this command is associated with a
mouse button press in the widget and [arg x] and [arg y] are the coordinates of the
mouse. It returns an empty string. 

[call [arg pathName] [cmd {scan dragto}] [arg x] [arg y] [opt [arg gain]]]
This command computes the difference between its [arg x] and [arg y] arguments (which
are typically mouse coordinates) and the [arg x] and [arg y] arguments to the last
[cmd {scan mark}] command for the widget. It then adjusts the view by [arg gain]
times the difference in coordinates, where [arg gain] defaults to 10. This
command is typically associated with mouse motion events in the widget,
to produce the effect of dragging the treectrl at high speed through its window.
The return value is an empty string.
[list_end]

[call [arg pathName] [cmd state] [arg option] [arg args]]
This command is used to manipulate the list of user-defined states,
see section [sectref STATES] below.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd state] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {state define}] [arg stateName]]
Defines a new state with the name [arg stateName],
which must not be the name of an existing state.

[call [arg pathName] [cmd {state linkage}] [arg stateName]]
Returns a string indicating
whether the specified state is user-defined
by means of the [cmd {state define}] widget command ([const dynamic])
or predefined by the treectrl widget itself ([const static]).

[call [arg pathName] [cmd {state names}]]
Returns a list containing the names of all user-defined states.

[call [arg pathName] [cmd {state undefine}] [opt [arg {stateName ...}]]]
Every [arg stateName] must be the name of a user-defined state.
Removes this state from the list of user-defined states.
[list_end]

[call [arg pathName] [cmd see] [arg itemDesc]]
Adjust the view in the treectrl so that the item
described by [arg itemDesc] is visible.
If the item is already visible then the command has no effect;
otherwise the treectrl scrolls to bring the item into view,
and the corresponding [const <Scroll-x>] and/or [const <Scroll-y>]
events are generated.

[call [arg pathName] [cmd selection] [arg option] [arg args]]
This command is used to adjust the selection within a treectrl.
It has several forms, depending on [arg option]:

[list_begin definitions]
[call [arg pathName] [cmd {selection add}] [arg first] [opt [arg last]]]
[arg First] and [arg last] (if specified)
must be valid [sectref {ITEM DESCRIPTION} {item descriptions}]. If both
[arg first] and [arg last] are specified, then they may refer to a single
item only; in this case
the command adds every unselected item in the range between
[arg first] and [arg last], inclusive, to the selection
without affecting the selected state of items outside that range.
If only [arg first] is specified, then
every unselected item specified by [arg first] is added to the selection.
A [const <Selection>] event is generated if any items were added to the
selection.

[call [arg pathName] [cmd {selection anchor}] [opt [arg itemDesc]]]
If [arg itemDesc] is specified,
the selection anchor is set to the described item.
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The item description [const anchor] may be used to refer to the anchor item.
This command doesn't modify the selection state of any item.
Returns the unique id of the selection anchor item.

[call [arg pathName] [cmd {selection clear}] [opt [arg first]] [opt [arg last]]]
[arg First] and [arg last] (if specified)
must be valid [sectref {ITEM DESCRIPTION} {item descriptions}]. If both
[arg first] and [arg last] are specified, then they may refer to a single
item only; in this case any selected items between [arg first] and [arg last]
(inclusive) are removed from the selection without affecting
the selected state of items outside that range.
If only [arg first] is specified, then
every selected item specified by [arg first] is removed from the selection.
If neither [arg first] nor [arg last] are specified,
then all selected items are removed from the selection.
A [const <Selection>] event is generated if any items were removed from the
selection.

[call [arg pathName] [cmd {selection count}]]
Returns an integer indicating the number
of items in the treectrl that are currently selected.

[call [arg pathName] [cmd {selection get}] [opt [arg first]] [opt [arg last]]]
When no additional arguments are given, the result is an unsorted list
containing the item ids of all of the items in the treectrl that are currently selected.
If there are no items selected in the treectrl, then an empty string is returned.
The optional arguments [arg first] and [arg last] are treated as indices into
the sorted list of selected items; these arguments allow in-place [cmd lindex]
and [cmd lrange] operations on the selection. For example:
[example_begin]
.t selection get 0       ; # return the first selected item
.t selection get end     ; # return the last selected item
.t selection get 1 end-1 ; # return every selected item except the first and last
[example_end]

[call [arg pathName] [cmd {selection includes}] [arg itemDesc]]
Returns 1 if the item described by [arg itemDesc] is currently
selected, 0 if it isn't.

[call [arg pathName] [cmd {selection modify}] [arg select] [arg deselect]]
Both arguments [arg select] and [arg deselect] are
a possibly-empty list of [sectref {ITEM DESCRIPTION} {item descriptions}].
Any unselected items in [arg select] are added to the selection,
and any selected items in [arg deselect] are removed from the selection (except
for those items which are also in [arg select]).
A [const <Selection>] event is generated if any items were selected or deselected.
[list_end]

[call [arg pathName] [cmd style] [arg option] [opt [arg element]] \
     [opt [arg {arg arg ...}]]]
This command is used to manipulate styles, which can be thought of
as a geometry manager for elements.
The exact behavior of the command depends on the [arg option] argument
that follows the [cmd style] argument.
The following forms of the command are supported:

[list_begin definitions]
[call [arg pathName] [cmd {style cget}] [arg style] [arg option]]
This command returns the current value of the option named [arg option]
associated with the style given by [arg style].
[arg Option] may have any of the values accepted by the
[cmd {style configure}] widget command.

[call [arg pathName] [cmd {style configure}] [arg style] [opt [arg option]] \
     [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies options associated with the style given by [arg style]
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list describing
all of the available options for [arg style] (see [fun Tk_ConfigureInfo]
for information on the format of this list).
If [arg option] is specified with no [arg value], then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no [arg option]
is specified).
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) in [arg style];
in this case the command returns an empty string.
[nl]

The options of a style have effect on all elements managed by the style.
The following options are supported:

[list_begin opt]
[opt_def [option -orient] [arg varName]]
This option specifies which orientation should be used
when laying out the elements associated with this style.
Must be either [const horizontal] (the default)
or [const vertical] or an abbreviation of one of these.
[list_end]

[call [arg pathName] [cmd {style create}] [arg style] \
     [opt [arg {option value ...}]]]
Create a new style in [arg pathName] with name [arg style].
After [arg style] there may be any number of [arg option]-[arg value]
pairs, each of which sets one of the configuration options
for the style.  These same [arg option]-[arg value] pairs may be
used in [cmd {style configure}] widget commands to change the style's
configuration.
Returns the name of the new style.

[call [arg pathName] [cmd {style delete}] [opt [arg {style ...}]]]
Deletes each of the named styles and returns an empty string.
If a style is deleted while it is still used to display
one or more items,
it is also removed from the style list of these items.

[call [arg pathName] [cmd {style elements}] [arg style] \
     [opt [arg elementList]]]
Specifies the elements which should be layed out by this style.
Each element of [arg elementList] must be the name of an element
created by the widget command [cmd {element create}].
Duplicate names in [arg elementList] are ignored.
An element which was specified in a former call of this command
for [arg style] but is not included in [arg elementList],
will be deleted from the elements layed out by [arg style].
[nl]

If the [arg elementList] argument is not specified, a list is returned
containing the currently defined elements of [arg style].

[call [arg pathName] [cmd {style layout}] [arg style] [arg element] \
     [opt [arg option]] [opt [arg value]] [opt [arg {option value ...}]]]
This command is similar to the [cmd configure] widget command except
that it modifies options used by [arg style] for laying out [arg element]
instead of modifying options for the overall treectrl widget.
If no [arg option] is specified, the command returns a list with
[arg option]-[arg value] pairs describing
all of the available options for the layout.
If [arg option] is specified with no [arg value], then the command returns
the value of the named option.
If one or more [arg option]-[arg value] pairs are specified, then the command
modifies the given option(s) to have the given value(s) for the layout;
in this case the command returns an empty string.
[nl]

The options of a layout have effect on exactly the one element [arg element]
managed by [arg style].
The following options are supported:

[list_begin opt]
[opt_def [option -detach] [arg boolean]]
Specifies whether the element should be positioned by itself,
i.e. independent from the other elements.

[opt_def [option -draw] [arg boolean]]
This is a [sectref {PER-STATE OPTIONS} per-state] option that determines whether
an element should be drawn. If the value of the option evaluates to false for a given
item state, then the element is not drawn, although it still consumes space in
the layout.

[opt_def [option -expand] [arg flags]]
This option allows the external padding around the element
to increase when a style has more screen space than it needs.
[arg Flags] is a string that contains zero or more of the characters
[const n], [const s], [const w] or [const e].
Each letter refers to the padding on the top, bottom,
left, or right that should be allowed to increase.
This option is typically used to justify an element.

[opt_def [option -iexpand] [arg flags]]
This option allows the internal padding of the element
and the display area of the element to increase
when a style has more screen space than it needs.
[arg Flags]  is a string that contains zero or more of the characters
[const x], [const y], [const n], [const s], [const w] or [const e].
For [const n], [const s], [const w] and [const e], each letter refers to the
padding on the top, bottom, left, or right that should be allowed to increase.
For [const x] and [const y], each letter refers to the horizontal and
vertical screen space the element can display itself in (i.e., the space
between the padding). Note that if the
[option -union] option is specified for this element, then the [const x] and
[const y] flags have no effect, since the size of an element with
[option -union] layout is determined by the elements it surrounds.

[opt_def [option -indent] [arg boolean]]
Specifies whether the element should be positioned to the right of the
button/line area in the tree column. This option is ignored unless the
[option -detach] option is true.

[opt_def [option -ipadx] [arg amount]]
[opt_def [option -ipady] [arg amount]]
[arg Amount] specifies how much internal padding to
leave on the left and right (for [option -ipadx])
or top and bottom (for [option -ipady]) side of the element.
[arg Amount] may be a list
of two values to specify padding for the two sides separately,
it defaults to 0.

[opt_def [option -minheight] [arg pixels]]
[opt_def [option -height] [arg pixels]]
[opt_def [option -maxheight] [arg pixels]]
Specifies the minimum, fixed, and maximum height of the element.

[opt_def [option -minwidth] [arg pixels]]
[opt_def [option -width] [arg pixels]]
[opt_def [option -maxwidth] [arg pixels]]
Specifies the minimum, fixed, and maximum width of the element.

[opt_def [option -padx] [arg amount]]
[opt_def [option -pady] [arg amount]]
[arg Amount] specifies how much external padding to
leave on the left and right (for [option -padx])
or top and bottom (for [option -pady]) side of the element.
[arg Amount] may be a list
of two values to specify padding for the two sides separately,
it defaults to 0.

[opt_def [option -squeeze] [arg flags]]
This option allows the display area of an element to decrease when a
style has less space than it needs.
[arg Flags] is a string that contains zero or more of the characters
[const x] or [const y].
[const x] allows display area to decrease horizontally,
[const y] allows display area to decrease vertically.
This option is typically used for [const text] elements and will cause
the text element to display an ellipsis (...) and/or wrap lines.

[opt_def [option -sticky] [arg flags]]
This option controls how the actual display information (image, text, etc)
of an element is positioned (or stretched) within its display area.
[arg Flags] is a
string that contains zero or more of the characters [const n], [const s],
[const w] or [const e]. Each letter refers to the top, bottom, left or right
side of the display area that the display information should "stick" to.

[opt_def [option -union] [arg elementList]]
Specifies a list of other elements which this element will surround.
The size of an element with [option -union] layout is determined by the
size and position of the elements in [arg elementList].
The [option -ipadx] and [option -ipady] options in this case refer to the
distance of the edges of the display area of this element from those elements
it surrounds. This option is typically used to display a selection rectangle
around a piece of text. If none of the elements in [arg elementList] are
visible, then the element is not displayed.

[opt_def [option -visible] [arg boolean]]
This is a [sectref {PER-STATE OPTIONS} per-state] option that controls visibility
of an element. If the value of the option evaluates to false for a given
item state, then the element is not displayed and consumes no space in the layout.

[list_end]

[call [arg pathName] [cmd {style names}]]
Returns a list containing the names of all existing styles.
[list_end]

[call [arg pathName] [cmd toggle] [opt [option -recurse]] \
     [opt [arg {itemDesc ...}]]]
Use [cmd {item toggle}] instead.

[call [arg pathName] [cmd xview] [opt [arg args]]]
This command is used to query and change the horizontal position of the
information displayed in the treectrl's window.
It can take any of the following forms:

[list_begin definitions]
[call [arg pathName] [cmd xview]]
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the tree's area
is off-screen to the left, the middle 40% is visible
in the window, and 40% of the tree is off-screen to the right.
These are the same values passed to scrollbars via the [option -xscrollcommand]
option.

[call [arg pathName] [cmd {xview moveto}] [arg  fraction]]
Adjusts the view in the window so that [arg fraction] of the
total width of the tree is off-screen to the left.
[arg Fraction] must be a fraction between 0 and 1.
A [const <Scroll-x>] event is generated.

[call [arg pathName] [cmd {xview scroll}] [arg number] [arg what]]
This command shifts the view in the window left or right according to
[arg number] and [arg what].
[arg Number] must be an integer.
[arg What] must be either [const units] or [const pages] or an abbreviation
of one of these.
If [arg what] is [const units], the view adjusts left or right in units
determined by the [option -xscrollincrement] option (which may be zero,
see the description of that option).
If [arg what] is [const pages] then the view
adjusts in units of nine-tenths the window's width.
If [arg number] is negative then information farther to the left
becomes visible;  if it is positive then information farther to the right
becomes visible.
A [const <Scroll-x>] event is generated.
[list_end]

[call [arg pathName] [cmd yview] [opt [arg args]]]
This command is used to query and change the vertical position of the
information displayed in the treectrl's window.
It can take any of the following forms:

[list_begin definitions]
[call [arg pathName] [cmd yview]]
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the vertical span that is visible in the window.
For example, if the first element is .6 and the second element is 1.0,
the lowest 40% of the tree's area is visible in the window.
These are the same values passed to scrollbars via the [option -yscrollcommand]
option.

[call [arg pathName] [cmd {yview moveto}] [arg fraction]]
Adjusts the view in the window so that [arg fraction] of the tree's
area is off-screen to the top.
[arg Fraction] is a fraction between 0 and 1.
A [const <Scroll-y>] event is generated.

[call [arg pathName] [cmd {yview scroll}] [arg number] [arg what]]
This command adjusts the view in the window up or down according to
[arg number] and [arg what].
[arg Number] must be an integer.
[arg What] must be either [const units] or [const pages].
If [arg what] is [const units], the view adjusts up or down in units
of the [option -yscrollincrement] option (which may be zero,
see the description of that option).
If [arg what] is [const pages] then
the view adjusts in units of nine-tenths the window's height.
If [arg number] is negative then higher information becomes
visible;  if it is positive then lower information
becomes visible.
A [const <Scroll-y>] event is generated.
[list_end]
[list_end]

[section COLUMNS]
A treectrl widget is capable of displaying multiple columns next to each
other.
An item can be considered as a row, which reaches over all columns.

[para]
Columns in a treectrl may be specified in a number of ways.
See [sectref {COLUMN DESCRIPTION}] below.

[para]
There is always one special column, the [const tail] column, which fills
all space to the right of the last ordinary column.
This column has no number;
it can only be specified by the keyword [const tail].

[para]
When a column configuration option is specified as [sectref {PER-STATE OPTIONS} per-state],
the state names are [const normal], [const active], [const pressed] or [const up], i.e.
do not use item state names.

[para]
The following options are supported for columns:

[list_begin opt]
[opt_def [option -arrow] [arg direction]]
Indicates whether or not an arrow should be drawn in the column header.
[arg Direction] must have one of the values
[const none] (the default), [const up], or [const down].

[opt_def [option -arrowbitmap] [arg bitmap]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the bitmap to
use to draw the arrow if this column's -arrow option is not [const none].

[opt_def [option -arrowimage] [arg image]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the image to
use to draw the arrow if this column's -arrow option is not [const none].
If an image is specified for a certain state, it overrides the -arrowbitmap option.

[opt_def [option -arrowside] [arg side]]
Indicates on which side of the bitmap/image/text the arrow should be drawn.
[arg Side] must be either [const left] or [const right] (the default).

[opt_def [option -arrowgravity] [arg side]]
Indicates onto which side an arrow should be packed,
if there is more space available for drawing the arrow then needed.
[arg Side] must be either [const left] (the default) or [const right].

[opt_def [option -arrowpadx] [arg amount]]
[arg Amount] specifies how much padding to
leave on the left and right of the arrow.
[arg Amount] may be a list
of two values to specify padding for left and right separately;
it defaults to 6.

[opt_def [option -arrowpady] [arg amount]]
[arg Amount] specifies how much padding to
leave on the top and bottom of the arrow.
[arg Amount] may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.

[opt_def [option -bitmap] [arg bitmap]]
Specifies the bitmap to display in the element
to the left of the column title.

[opt_def [option -background] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the color to
use for the background of the column header.

[opt_def [option -borderwidth] [arg size]]
Specifies a non-negative value indicating the width
of the 3-D border to draw around the outside of the column header
 (if such a border is being drawn;  the [option -relief] column option
determines this).
The value may have any of the forms acceptable to [fun Tk_GetPixels].

[opt_def [option -button] [arg boolean]]
Indicates whether or not the column header should be treated like a pushbutton.
When this option is true, the default bindings track <Button-1> events
in the header and generate a <Header-invoke> event when a <ButtonRelease-1>
event occurs in the header. See [sectref {DYNAMIC EVENTS}].

[opt_def [option -expand] [arg boolean]]
Indicates whether or not any extra horizontal space should be distributed
to this column.
This option has no effect if the [option -width] option is set.

[opt_def [option -font] [arg fontName]]
Specifies the font to use for the column title inside the column header.

[opt_def [option -image] [arg image]]
Specifies the image to display in the element
to the left of the column title.
This option overrides the [option -bitmap] column option.

[opt_def [option -imagepadx] [arg amount]]
[arg Amount] specifies how much padding to
leave on the left and right of the image (or bitmap).
[arg Amount] may be a list
of two values to specify padding for left and right separately;
it defaults to 6.

[opt_def [option -imagepady] [arg amount]]
[arg Amount] specifies how much padding to
leave on the top and bottom of the image (or bitmap).
[arg Amount] may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.

[opt_def [option -itembackground] [arg colorList]]
Specifies a list of zero or more colors, which are used as
alternating background colors for items in this column.
See also the [option -backgroundmode] widget option for more on this.

[opt_def [option -itemjustify] [arg justification]]
This option determines how the item styles in this column line up with each other.
Must be one of [const left], [const center], or [const right]. The default
value is an empty string (for compatibility with older versions), in which
case the column option [option -justify] is used to align item styles in this
column.

[opt_def [option -itemstyle] [arg style]]
[arg Style] is the name of a style that should be set in this column
for newly-created items.

[opt_def [option -justify] [arg justification]]
This option determines how the image and text in the column header are
positioned. It also affects the position of item styles in this column unless
the column option [option -itemjustify] is specified.
Must be one of [const left] (the default), [const center], or [const right].

[opt_def [option -lock] [arg lock]]
This option allows a column to stick to the left or right edge of the window.
A locked column scrolls vertically but not horizontally.
Must be one of [const none] (the default), [const left], or [const right].

[opt_def [option -maxwidth] [arg size]]
Specifies the maximum size, in screen units, that will be permitted for this column.
If [arg size] is an empty string, then there is no limit on the maximum size of the column.
This option has no effect if the [option -width] option is set.

[opt_def [option -minwidth] [arg size]]
Specifies the minimum size, in screen units, that will be permitted for this column.
If [arg size] is an empty string, then the minimum size of the column is zero.
This option has no effect if the [option -width] option is set.

[opt_def [option -resize] [arg boolean]]
Specifies a boolean value that indicates whether the user should be allowed to
resize the column by dragging the edge of the column's header. Default is true.

[opt_def [option -squeeze] [arg boolean]]
Specifies a boolean value that indicates whether or not the column should
shrink when the content width of the treectrl is less than the total needed width
of all visible columns. Defaults to false, which means the column will not get
smaller than its needed width. The column will not get smaller than the value
of its [option -minwidth] option, if specified. This option has no effect if the
[option -width] option is set.

[opt_def [option -state] [arg state]]
Specifies one of three states for the column header: [const normal], [const active],
or [const pressed]. The active state is used when the mouse is over the header.
The pressed state is used when the mouse button is pressed in the header.

[opt_def [option -stepwidth] [arg size]]
Deprecated. Use the treectrl's [option -itemwidthmultiple] option instead.

[opt_def [option -tags] [arg tagList]]
[arg TagList] is a list of tag names that can be used to identify the column.
See also the [cmd {column tag}] command.

[opt_def [option -text] [arg text]]
Specifies a text string to be displayed as the column title.

[opt_def [option -textcolor] [arg color]]
Specifies a color, which should be used as foreground color
to display the column title.

[opt_def [option -textlines] [arg count]]
Specifies the maximum number of lines of text to display in the column title.
If this value is zero, the number of lines displayed is determined by any newline
characters and the effects of wrapping when the column width is less than
needed. The default is 1. Note: Under OSX/Aqua this value is always set to 1 when the
treectrl's [option -usetheme] option is true, because the Appearance Manager
uses a fixed height for the column header; there is only room for a single line
of text.

[opt_def [option -textpadx] [arg amount]]
[arg Amount] specifies how much padding to
leave on the left and right of the text.
[arg Amount] may be a list
of two values to specify padding for left and right separately;
it defaults to 6.

[opt_def [option -textpady] [arg amount]]
[arg Amount] specifies how much padding to
leave on the top and bottom of the text.
[arg Amount] may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.

[opt_def [option -uniform] [arg group]]
When a non-empty value is supplied, this option places the column in a
[emph "uniform group"] with other columns that have the same value for
[option -uniform]. The space for columns belonging to a uniform group is
allocated so that their sizes are always in strict proportion to their
[option -weight] values.
This option is based on the grid geometry manager.

[opt_def [option -visible] [arg boolean]]
Indicates whether or not the column should be displayed.

[opt_def [option -weight] [arg integer]]
Sets the relative weight for apportioning any extra space among columns.
A weight of zero (0) indicates the column will not deviate from its requested
size.  A column whose weight is two will grow at twice the rate as a column of
weight one when extra space is allocated to columns.
This option is based on the grid geometry manager.

[opt_def [option -width] [arg size]]
Specifies a fixed width for the column. If this value is an empty string,
then the column width is calculated as the maximum of:
a) the width requested by items;
b) the width requested by the column's header;
and c) the column's [option -minwidth] option.
This calculated width is also affected by the [option -expand],
[option -squeeze], [option -uniform] and [option -weight] options. In any case,
the calculated width will not be greater than the [option -maxwidth] option,
if specified.

[opt_def [option -widthhack] [arg boolean]]
Deprecated. Use the treectrl's [option -itemwidthequal] option instead.

[list_end]

[section {COLUMN DESCRIPTION}]
Many of the commands and options for a treectrl take as an argument a
description of which column to operate on.
See the [sectref EXAMPLES] section for examples.
The initial part of a column description must begin with one of the following terms:

[list_begin definitions]
[lst_item [arg id]]
Specifies the unique column identifier, where [arg id] should be
the return value of a prior call of the [cmd {column create}] widget command.
See also the [option -columnprefix] option.

[lst_item [arg QUALIFIERS]]
Specifies a list of qualifiers. This gives the same result as [const all] followed
by [arg QUALIFIERS]; i.e., every column is tested for a match.

[lst_item "[arg tagExpr] [arg QUALIFIERS]"]
[arg TagExpr] is a tag expression (see [sectref {ITEM AND COLUMN TAGS}]) against which
every column's tags are tested for a match.
This keyword cannot be followed by any modifiers unless a single column is
matched. You may run into trouble if [arg tagExpr] looks like a column id
or other keyword; also, [arg tagExpr] must look like a single list element
since column descriptions are properly-formed lists. To be safe you may want to
use the [const tag] qualifier followed by [arg tagExpr].

[lst_item "[const all] [arg QUALIFIERS]"]
Indicates every column, including the tail column if the command allows it,
which match [arg QUALIFIERS].

[lst_item "[const first] [arg QUALIFIERS]"]
Indicates the leftmost column of the treectrl which matches [arg QUALIFIERS].

[lst_item "[const end] [arg QUALIFIERS]"]
[lst_item "[const last] [arg QUALIFIERS]"]
Indicates the rightmost column of the treectrl (but not the tail column)
which matches [arg QUALIFIERS].

[lst_item "[const list] [arg columnDescs]"]
[arg ColumnDescs] is a list (a single argument, i.e. "list {a b c}" not "list a b c")
of other column descriptions.
This keyword cannot be followed by any modifiers unless a single column is matched.

[lst_item "[const order] [arg n] [arg QUALIFIERS]"]
Indicates the [arg n]th column in the list of columns as returned by the
[cmd {column order}] command.

[lst_item "[const range] [arg {first last}] [arg QUALIFIERS]"]
[arg First] and [arg last] specify a range of columns.
This keyword cannot be followed by any modifiers unless a single column is specified.

[lst_item [const tail]]
Indicates the ever-present tail column of the treectrl.

[lst_item [const tree]]
Indicates the column specified by the -treecolumn option of the treectrl.
[list_end]

[para]
The initial part of the column description (matching any of the values above)
may be followed by one or more [arg modifier]s.
A modifier changes the column used relative to
the description up to this point.
It may be specified in any of the following forms:

[list_begin definitions]

[lst_item "[const next] [arg QUALIFIERS]"]
Use the column to the right matching [arg QUALIFIERS].

[lst_item "[const prev] [arg QUALIFIERS]"]
Use the column to the left matching [arg QUALIFIERS].

[list_end]

The word [arg QUALIFIERS] above represents a sequence of zero or more of the
following terms that changes which column is chosen:

[list_begin definitions]
[lst_item "[const state] [arg stateList]"]
[arg StateList] is a list of column state names.
Only columns that have the given states set (or unset if the '!' prefix is used)
are considered.

[lst_item "[const tag] [arg tagExpr]"]
[arg TagExpr] is a tag expression (see [sectref {ITEM AND COLUMN TAGS}]) against which
a column's tags are tested for a match.

[lst_item [const !tail]]
When this qualifier is given, the tail column is not matched.

[lst_item [const visible]]
When this qualifier is given, only columns whose [option -visible] option is
TRUE are considered.

[lst_item [const !visible]]
When this qualifier is given, only columns whose [option -visible] option is
FALSE are considered.
[list_end]

[section STATES]
For every item a set of boolean states is managed. These states play an
integral role in the appearance of each item.
The following states are predefined for every item:

[list_begin definitions]
[lst_item [const active]]
At all times this state is set for exactly one item. The active item is
used with keyboard navigation.
When the treectrl widget is created or when the active item is deleted,
the root item will become the active item.
This state can be modified by means of the widget command [cmd activate].

[lst_item [const enabled]]
This state is set for every item when it is created.
Disabled items cannot be selected and are ignored by the default bindings
when navigating via the keyboard.
This state can be modified by means of the widget command [cmd {item enabled}].

[lst_item [const focus]]
This state is set for every item,
if the treectrl widget currently has the focus.
It cannot be modified by means of a widget command,
but is maintained in reaction to the <FocusIn> and <FocusOut> events.

[lst_item [const open]]
If this state is switched on,
the descendants of the item are displayed
- the item is expanded.
If this state is switched off,
the descendants of the item are not displayed
- the item is collapsed.
For a new item this state is switched on by default.
This state can be modified by means of the widget commands
[cmd {item expand}], [cmd {item collapse}], or [cmd {item toggle}].

[lst_item [const selected]]
This state is set for every item included in the selection.
It can be modified by means of the widget command [cmd selection].
[list_end]

[para]
By means of the [cmd {state define}] widget command
up to 27 additional states can be defined.

[section {PER-STATE OPTIONS}]

The visual appearance of an item can change depending on the state the item
is in, such as being the active item, being included in the selection, being
collapsed, or some combination of those or other states. When a configuration
option is described as [emph per-state], it means the option describes a
value which varies depending on the state of the item. If a per-state option is
specified as a single value, the value is used for all states. Otherwise
the per-state option must be specified as an even-numbered list. For example,
to use the font "Times 12 bold" in a [const text] element regardless of the
item state you can write:
[example_begin]
$T element configure MyTextElement -font {{Times 12 bold}}
[example_end]
However, to use a different font when the item is selected you could write:
[example_begin]
$T element configure MyTextElement -font {{Courier 10} selected {Times 12 bold} {}}
[example_end]
In the example above, the -font option reads "value stateList value stateList".
If [arg stateList] is an empty list, the preceding [arg value] is used regardless
of the item state. A non-empty stateList specifies a list of states which must be
set for the item in order to use the preceding value. Each stateList can also
include state names preceded by a ! sign, indicating the state must *not* be
set for the item. For example:
[example_begin]
$T element configure MyRectElement -fill {blue {selected focus} gray {selected !focus}}
[example_end]
In the example above, the [const rect] element is filled with blue when the treectrl
has the focus and the item is selected. If the treectrl does not have the focus, the
example specifies that gray should be used for selected items. Also note that if the
item is not selected, no color is specified for the -fill option.
[para]
Each value-stateList pair is checked in order from left to right. The value
associated with the first stateList that matches the current item state is
used. So stateLists should be listed from most-specific to least-specific.
[example_begin]
$T element configure MyRectElement -fill {gray {selected} blue {selected focus}}
[example_end]
Written this way, gray will always be used for selected items since
it appears first, and blue will never be used for selected items regardless
of the focus.
[para]
A value followed by an empty stateList should always be last since it will be
chosen regardless of the item's state.

[section ELEMENTS]
Elements are the smallest building blocks
which are handled by a treectrl widget.
One or more elements together can be combined to a style,
which can be considered as a blueprint for an item.
An element can be of type [const bitmap], [const border], [const image],
[const rect], [const text] or [const window].
For each element type there is a section below describing the options
which can modify an element of that type.

[para]
All of the element configuration options described below are unspecified
by default, meaning that no value whatsoever has been given to the option.
It may seem strange to you that a boolean option would be unspecified
instead of simply "true" or "false". The reason for this is that when an
element displayed by an item has no value specified for an option, the element refers
to the master element created by the [cmd {element create}] command for a
value for that option. This allows items which are displaying a certain
element to be redisplayed when the master element's options change.
The [cmd {item element configure}] command can be used to override the
master element's configuration options for a specific item.

[section {BITMAP ELEMENT}]
An element of type [const bitmap] can be used to display a bitmap in an item.
The following options are supported for bitmap elements:

[list_begin opt]
[opt_def [option -background] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
the color to use for each of the bitmap's '0' valued pixels.
If the value for a certain state is an empty string (the default),
the bitmap is drawn transparent.

[opt_def [option -bitmap] [arg bitmap]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
the bitmap to display in the element.

[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -foreground] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
the color to use for each of the bitmap's '1' valued pixels.
If the value for a certain state is an empty string (the default),
the bitmap's foreground color is black.
[list_end]

[section {BORDER ELEMENT}]
An element of type [const border] can be used to display a 3D border in an item.
The following options are supported for border elements:

[list_begin opt]
[opt_def [option -background] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
the color to use for the background of the border.
If the value for a certain state is an empty string (the default), the
element will not be drawn.

[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -filled] [arg boolean]]
Specifies whether the interior of the border should be filled with
the background color. If this option is unspecified (the default),
it it treated as false which means that only the edges of the
border will be drawn.

[opt_def [option -height] [arg size]]
Specifies the height of the border. If this value is unspecified
(the default), the border will be exactly as tall as its display area as
determined by the style layout options.

[opt_def [option -relief] [arg relief]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the
relief of the border. If the value for a certain state is an empty string
(the default), it is treated as flat.
For acceptable values see the description of the
[option -relief] option in the [cmd options] manual page.

[opt_def [option -thickness] [arg thickness]]
Specifies the thickness of the edges of the border.

[opt_def [option -width] [arg size]]
Specifies the width of the border. If this value is unspecified
(the default), the border will be exactly as wide as its display area as
determined by the style layout options.

[list_end]

[section {IMAGE ELEMENT}]
An element of type [const image] can be used to display an image in an item.
The following options are supported for image elements:

[list_begin opt]

[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -height] [arg size]]
Specifies the requested height of the display area for this element.
If unspecified (the default), the element requests a height equal to the
height of the image, or zero if there is no image.

[opt_def [option -image] [arg image]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
the image to display in the element.

[opt_def [option -width] [arg size]]
Specifies the requested width of the display area for this element.
If unspecified (the default), the element requests a width equal to the
width of the image, or zero if there is no image.

[list_end]

[section {RECTANGLE ELEMENT}]
An element of type [const rect] can be used to display a rectangle in an item.
The following options are supported for rectangle elements:

[list_begin opt]

[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -fill] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the color to
be used to fill the rectangle's area.
If the color for a certain state is an empty string (the default), then
the rectangle will not be filled (but the outline may still be drawn).

[opt_def [option -height] [arg size]]
Specifies the height of the rectangle. If this value is unspecified
(the default), the rectangle will be exactly as tall as its display area as
determined by the style layout options.

[opt_def [option -open] [arg open]]
This option may be used to get an incomplete drawing of the outline.
[arg Open] is a string that contains zero or more of the characters
[const n], [const s], [const e] or [const w].
Each letter refers to a side (north, south, east, or west) that the outline
will not be drawn. 
The default is the empty string, which causes the outline to be drawn completely.

[opt_def [option -outline] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the color to
be used to draw the outline of the rectangle.
If the color for a certain state is an empty string (the default),
then no outline is drawn for the rectangle.

[opt_def [option -outlinewidth] [arg outlineWidth]]
Specifies the width of the outline to be drawn around the rectangle's region.
[arg outlineWidth] may be in any of the forms acceptable to [fun Tk_GetPixels].
If this option is specified as an empty string (the default), then no outline
is drawn.

[opt_def [option -showfocus] [arg boolean]]
Specifies a boolean value indicating whether
a "focus ring" should be drawn around the rectangle,
if the item containing the rectangle is the active item
and the treectrl widget currently has the focus.
If this option is specified as an empty string (the default),
then a focus rectangle is not drawn.

[opt_def [option -width] [arg size]]
Specifies the width of the rectangle. If this value is unspecified
(the default), the rectangle will be exactly as wide as its display area as
determined by the style layout options.

[list_end]

[section {TEXT ELEMENT}]
An element of type [const text] can be used to display a text in an item.
The following options are supported for text elements:

[list_begin opt]
[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -data] [arg data]]
Specifies a value that together with the [option -datatype] and [option -format]
options will be displayed as text.

[opt_def [option -datatype] [arg dataType]]
Specifies the type of information in the [option -data] option.
Acceptable values are [const double], [const integer], [const long],
[const string], or [const time].

[opt_def [option -fill] [arg color]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the
foreground color to use when displaying the text.
If the color for a certain state is an empty string (the default), then
the text will be displayed using the color specified by the treectrl's
[option -foreground] option.

[opt_def [option -format] [arg formatString]]
This option specifies the format string used to display the value of the [option -data] option.
If [option -datatype] is [const time], [arg formatString] should be
a valid format string for the Tcl [cmd clock] command.
For all other [option -datatype] values [arg formatString] should be
a valid format string for the Tcl [cmd format] command.
If this value is unspecified the following defaults are used:
for -datatype double "%g", for -datatype integer "%d", for -datatype long "%ld",
for -datatype string "%s", and for -datatype time the default format string of the Tcl [cmd clock]
command.

[opt_def [option -font] [arg font]]
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option the font to
use when displaying the text.
If the font for a certain state is an empty string, the text is displayed
using the font specified by the treectrl's [option -font] option.

[opt_def [option -justify] [arg how]]
Specifies how to justify the text when multiple lines are displayed.
[arg How] must be one of the values [const left], [const right], or [const center].
If this option is specified as an empty string (the default), [const left] is used.

[opt_def [option -lines] [arg lineCount]]
Specifies the maximum number of lines to display.
If more than [arg lineCount] lines would be displayed, the last line will
be truncated with an ellipsis at the right.
If this option is specified as zero or an empty string (the default),
there is no limit to the number of lines displayed.

[opt_def [option -text] [arg string]]
[arg String] specifies a string to be displayed by the element.
[arg String] may contain newline characters in which case multiple lines of text
will be displayed.
If this option is specified, the [option -data], [option -datatype],
[option -format], and [option -textvariable] options are ignored.

[opt_def [option -textvariable] [arg varName]]
Specifies the name of a variable.  The value of the variable is a string
to be displayed by the element;  if the variable value changes then the element
will automatically update itself to display the new value.
If this option is specified, the [option -data], [option -datatype],
and [option -format] options are ignored.

[opt_def [option -underline] [arg charIndex]]
Specifies the integer index of a character to underline.
0 corresponds to the first character.
If [arg charIndex] is unspecified (the default), less than zero or greater
than the index of the last displayed character, the underline is not drawn.

[opt_def [option -width] [arg size]]
Specifies the maximum line length in any of the forms acceptable to [fun Tk_GetPixels].
For text to wrap lines the value of the [option -width]
option must be less than the needed width of the text, or the display area
for this element must be less than the needed width of the text.
For the display area to be less than the needed width of the text,
one of the style layout options [option -maxwidth], [option -width] or
[option -squeeze] must be used.

[opt_def [option -wrap] [arg mode]]
[arg Mode] specifies how to handle lines in the text that are longer than the
maximum line length.
Acceptable values are [const none], [const char] or [const word].
If this option is unspecified (the default), [const word] is used.
See the [option -width] option for a description of how the maximum line
length is determined.

[list_end]

[section {WINDOW ELEMENT}]
An element of type [const window] can be used to display a Tk window in an item.
The following options are supported for window elements:

[list_begin opt]
[opt_def [option -clip] [arg boolean]]
Specifies whether the associated Tk window is a borderless frame which should
be used to clip its child window so it doesn't overlap the header, borders, or
other items or columns. When this option is true, the treectrl manages the
geometry of both the [option -window] widget and its first child widget; in
this case the [option -window] widget (which should be a borderless frame) is
kept sized and positioned so that it is never out-of-bounds.

[opt_def [option -destroy] [arg boolean]]
Specifies whether the associated Tk window should be destroyed when the
element is deleted. The element is deleted when the item containing the
element is deleted, when the column containing the element is deleted,
or when the style assigned to the item's column is changed. If this option
is unspecified (the default), it is treated as false and the Tk window
will not be destroyed.

[opt_def [option -draw] [arg boolean]]
Deprecated; use the style layout option [option -draw] instead.
Specifies as a [sectref {PER-STATE OPTIONS} per-state] option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.

[opt_def [option -window] [arg pathName]]
Specifies the window to associate with this element. The window specified by
[arg pathName] must either be a child of the treectrl widget or a child of
some ancestor of the treectrl widget. [arg PathName] may not refer to a
top-level window. This option cannot be specified by
the [cmd {element create}] or [cmd {element configure}] commands, only by the
[cmd {item element configure}] command; i.e., the element must be associated
with a particular item.
[list_end]

[section {ITEM DESCRIPTION}]
Many of the commands for a treectrl take as an argument a
description of which items to operate on. An item description is a properly-formed
tcl list of keywords and arguments.
The first word of an item description must be one of the following:

[list_begin definitions]
[lst_item [arg id]]
Specifies the unique item identifier, where [arg id] should be
the return value of a prior call of the [cmd {item create}] widget command,
or [const 0] to specify the ever-present root item. See also the
[option -itemprefix] option.

[lst_item [arg QUALIFIERS]]
Specifies a list of qualifiers. This gives the same result as [const all] followed
by [arg QUALIFIERS]; i.e., every item is tested for a match.

[lst_item "[arg tagExpr] [arg QUALIFIERS]"]
[arg TagExpr] is a tag expression (see [sectref {ITEM AND COLUMN TAGS}]) against which
every item's tags are tested for a match.
This keyword cannot be followed by any modifiers unless a single item is
matched. You may run into trouble if [arg tagExpr] looks like an item id
or other keyword; also, [arg tagExpr] must look like a single list element
since item descriptions are properly-formed lists. To be safe you may want to
use the [const tag] qualifier followed by [arg tagExpr].

[lst_item [const active]]
Indicates the item that is currently active, i.e. normally
the item specified as argument of the last successful [cmd activate]
widget command, or the root item if no such call happened yet.

[lst_item [const anchor]]
Indicates the anchor item of the selection, i.e. normally
the item specified as argument of the last successful [cmd {selection anchor}]
widget command, or the root item if no such call happened yet.

[lst_item "[const all] [arg QUALIFIERS]"]
Indicates every item including orphans which match [arg QUALIFIERS].
This keyword cannot be followed by any modifiers unless a single item is matched.

[lst_item "[const first] [arg QUALIFIERS]"]
Indicates the first item of the treectrl (the root item),
or the first item matching [arg QUALIFIERS].

[lst_item "[const end] [arg QUALIFIERS]"]
[lst_item "[const last] [arg QUALIFIERS]"]
Indicates the last item which matches [arg QUALIFIERS].

[lst_item "[const list] [arg itemDescs]"]
[arg ItemDescs] is a list (a single argument, i.e. "list {a b c}" not "list a b c")
of other item descriptions.
This keyword cannot be followed by any modifiers unless a single item is matched.

[lst_item "[const nearest] [arg {x y}]"]
Indicates the item nearest to the point given by [arg x] and [arg y].

[lst_item "[const rnc] [arg {row column}]"]
Indicates the item in the given [arg row] and [arg column].
The row and column corresponds to
the on-screen arrangement of items as determined by the -orient and -wrap
options.
You can memorize [const rnc] as an abbreviation of "row 'n' column".

[lst_item "[const range] [arg {first last}] [arg QUALIFIERS]"]
[arg First] and [arg last] specify a range of items.
This keyword cannot be followed by any modifiers unless a single item is matched.

[lst_item [const root]]
Indicates the root item of the treectrl.

[list_end]

[para]
The initial part of the item description (matching any of the values above)
may be followed by one or more [arg modifier]s.
A modifier changes the item used relative to
the description up to this point.
It may be specified in any of the following forms:

[list_begin definitions]
[lst_item [const above]]
Use the item one row above in this column.

[lst_item "[const ancestors] [arg QUALIFIERS]"]
Use the ancestors of the item (like [cmd {item ancestors}] but QUALIFIERS
may change which ancestors match).
This keyword cannot be followed by any modifiers.

[lst_item [const below]]
Use the item one row below in this column.

[lst_item [const bottom]]
Use the item in the last row of this column.

[lst_item "[const child] [arg n] [arg QUALIFIERS]"]
Use the [arg n]th child of the item.

[lst_item "[const children] [arg QUALIFIERS]"]
Use the children of the item (like [cmd {item children}] but QUALIFIERS
may change which children match).
This keyword cannot be followed by any modifiers.

[lst_item "[const descendants] [arg QUALIFIERS]"]
Use the descendants of the item (like [cmd {item descendants}] but QUALIFIERS
may change which descendants match).
This keyword cannot be followed by any modifiers.

[lst_item "[const firstchild] [arg QUALIFIERS]"]
Use the first child of the item.

[lst_item "[const lastchild] [arg QUALIFIERS]"]
Use the last child of the item.

[lst_item [const left]]
Use the item one column to the left in the same row.

[lst_item [const leftmost]]
Use the item of the first column in the same row.

[lst_item "[const next] [arg QUALIFIERS]"]
Use the next item, which is the first item from the
following list: the first child, the next sibling or the next sibling of
the nearest ancestor which has one.

[lst_item "[const nextsibling] [arg QUALIFIERS]"]
Use the next sibling of the item.

[lst_item [const parent]]
Use the parent of the item.

[lst_item "[const prev] [arg QUALIFIERS]"]
Use the last child of the previous sibling,
or the parent if there is no previous sibling.

[lst_item "[const prevsibling] [arg QUALIFIERS]"]
Use the previous sibling of the item.

[lst_item [const right]]
Use the item one column to the right in the same row.

[lst_item [const rightmost]]
Use the item of the last column in the same row.

[lst_item "[const sibling] [arg n] [arg QUALIFIERS]"]
Use the [arg n]th child of the item's parent.

[lst_item [const top]]
Use the item in the first row of this column.
[list_end]

The word [arg QUALIFIERS] above represents a series of zero or more of the
following terms that changes which item is chosen:

[list_begin definitions]
[lst_item "[const depth] [arg depth]"]
Matches items whose depth (as returned by the [cmd depth] command) is equal to
[arg depth].

[lst_item "[const state] [arg stateList]"]
[arg StateList] is a list of item state names (static and dynamic, see [sectref STATES]).
Only items that have the given states set (or unset if the '!' prefix is used)
are considered.

[lst_item "[const tag] [arg tagExpr]"]
[arg TagExpr] is a tag expression (see [sectref {ITEM AND COLUMN TAGS}]) against which
an item's tags are tested for a match.

[lst_item [const visible]]
When this qualifier is given, only items that are displayed are considered.

[lst_item [const !visible]]
When this qualifier is given, only items that are *not* displayed are considered.
[list_end]

To get the first item in the list that is enabled:
[example_begin]
$T item id "first state enabled"
[example_end]

To get the ancestors that are not open of the last item in the list:
[example_begin]
$T item id "last ancestors state !open"
[example_end]

To get the visible descendants of the root item:
[example_begin]
$T item id "root descendants visible"
[example_end]

To get the every hidden item with tag "a" or "b":
[example_begin]
$T item id "all !visible tag a||b"
$T item id "!visible tag a||b"
$T item id "tag a||b !visible"
$T item id "a||b !visible"
[example_end]

[section {EVENTS AND SCRIPT SUBSTITUTIONS}]

The [arg script] argument to [cmd {notify bind}] is a Tcl script, which will be
evaluated whenever the given event is generated. [arg Script] will be executed
in the same interpreter that the [cmd {notify bind}] command was executed in,
and it will run at global level (only global variables will be accessible).
If [arg script] contains any [const %] characters, then the script will not be
evaluated directly.  Instead, a new script will be generated by replacing each
[const %], and the character following it, with information from the current
event. Unlike the regular Tk [cmd bind] mechanism, each event generated by
a treectrl widget has its own set of %-substitutions.
[para]
The following %-substitutions are valid for all static events:
[list_begin opt]
[opt_def %%] Replaced with a single %
[opt_def %d] The detail name
[opt_def %e] The event name
[opt_def %P] The pattern, either <event> or <event-detail>
[opt_def %W] The object argument to the [cmd "notify bind"] command
[opt_def %T] The treectrl widget which generated the event
[opt_def %?] A list of the format {char value char value ...} for each
%-substitution character and the value it is replaced by
[list_end]

[para]
The following events may be generated by a treectrl widget:

[list_begin definitions]
[lst_item [const <ActiveItem>]]
Generated whenever the active item changes.
[list_begin opt]
[opt_def %c] The current active item
[opt_def %p] The previous active item
[list_end]

[lst_item [const <Collapse-before>]]
Generated before an item is collapsed.
[list_begin opt]
[opt_def %I] The item id
[list_end]

[lst_item [const <Collapse-after>]]
Generated after an item is collapsed.
[list_begin opt]
[opt_def %I] The item id
[list_end]

[lst_item [const <Expand-before>]]
Generated before an item is expanded. This event is useful if you want to add
child items to the item just before the item is expanded.
[list_begin opt]
[opt_def %I] The item id
[list_end]

[lst_item [const <Expand-after>]]
Generated after an item is expanded.
[list_begin opt]
[opt_def %I] The item id
[list_end]

[lst_item [const <ItemDelete>]]
Generated when items are about to be deleted by the [cmd {item delete}] command.
[list_begin opt]
[opt_def %i] List of items ids being deleted.
[list_end]

[lst_item [const <ItemVisibility>]]
Generated when items become visible on screen and when items are no longer visible on screen.
This event is useful if you have a very large number of items and want to assign
styles only when items are actually going to be displayed.
[list_begin opt]
[opt_def %h] List of items ids which are no longer visible.
[opt_def %v] List of items ids which are now visible.
[list_end]

[lst_item [const <Scroll-x>]]
Generated whenever the view in the treectrl changes in such a way that a
horizontal scrollbar should be redisplayed.
[list_begin opt]
[opt_def %l] Same as the first fraction appended to [const -xscrollcommand]. Think [emph lower].
[opt_def %u] Same as the second fraction appended to [const -xscrollcommand]. Think [emph upper].
[list_end]

[lst_item [const <Scroll-y>]]
Generated whenever the view in the treectrl changes in such a way that a
vertical scrollbar should be redisplayed.
[list_begin opt]
[opt_def %l] Same as the first fraction appended to [const -yscrollcommand]. Think [emph lower].
[opt_def %u] Same as the second fraction appended to [const -yscrollcommand]. Think [emph upper].
[list_end]

[lst_item [const <Selection>]]
Generated whenever the selection changes. This event gives information about
how the selection changed.
[list_begin opt]
[opt_def %c] Same as the [cmd "selection count"] widget command
[opt_def %D] List of newly-deselected item ids
[opt_def %S] List of newly-selected item ids
[list_end]

[list_end]

[section {DYNAMIC EVENTS}]
In addition to the pre-defined static events such as <ActiveItem>
and <Selection>, new dynamic events can be created by using the
[cmd {notify install}] command.

[para]
The following events may be generated by the library scripts:

[list_begin definitions]

[lst_item [const <ColumnDrag-begin>]]
[lst_item [const <ColumnDrag-receive>]]
[lst_item [const <ColumnDrag-end>]]
Generated whenever the user drag-and-drops a column header. The library scripts
do not actually move a dragged column. You must bind to the receive event to
move the column. See [sectref EXAMPLES].
[list_begin opt]
[opt_def %C] The column that was dragged
[opt_def %b] The column to move the dragged column before
[list_end]

[lst_item [const <Drag-begin>]]
[lst_item [const <Drag-receive>]]
[lst_item [const <Drag-end>]]
Generated whenever the user drag-and-drops a file into a directory. This
event is generated by the filelist-bindings.tcl library code, which is not
used by default. See the "Explorer" demos.
[list_begin opt]
[opt_def %I] The item that the user dropped the dragged items on.
[opt_def %l] (lowercase L) The list of dragged items.
[list_end]

[lst_item [const <Edit-begin>]]
[lst_item [const <Edit-accept>]]
[lst_item [const <Edit-end>]]
The filelist-bindings.tcl code will display a text-editing window if the user
clicks on a selected file/folder name. See the "Explorer" demos.
[list_begin opt]
[opt_def %I] The item containing the edited text element
[opt_def %C] The column containing the edited text element
[opt_def %E] The name of the edited text element
[opt_def %t] The edited text
[list_end]

[lst_item [const <Header-invoke>]]
Generated whenever the user clicks and releases the left mouse button
in a column header if the column's -button option is true. You can bind a
script to this event to sort the list.
[list_begin opt]
[opt_def %C] The column whose header was clicked
[list_end]

[list_end]

The library scripts provide an example
of using a dynamic event called <Header-invoke>, which is generated when
the mouse button is released over a column header.
[example_begin]
treectrl .t
.t notify install <Header-invoke>
.t notify bind ConsoleTag <Header-invoke> {
	puts "header %C clicked in treectrl %T"
}
proc ::TreeCtrl::Release1 {w x y} {
	...
	$w notify generate <Header-invoke> [lb]list C $Priv(column)[rb] \
		[lb]list ::TreeCtrl::PercentsCmd $w[rb]
	...
}
[example_end]
In the example a new treectrl widget is created and the <Header-invoke> event
is installed. For convenience there is no [arg percentsCommand] argument to
[cmd {notify install}]; instead the call to [cmd {notify generate}] specifies
the %-substitution command. A script is
bound to the event with [cmd {notify bind}] which will print out the column
number and widget
name to the console (in the demos, <Header-invoke> is used to sort the list
based on the column that was clicked). The [arg charMap] argument to
[cmd {notify generate}]
provides a list of %-substitution characters and values which is used by
::TreeCtrl::PercentsCmd. In this example any %C in any script bound to the
<Header-invoke> event will be replaced by the value of $Priv(column).

[section {DEFAULT BINDINGS}]
Tk automatically creates class bindings for treectrl widgets that give them
the following default behavior.
[list_begin enum]
[enum]
Clicking mouse button 1 over an item positions the active cursor
on the item, sets the input focus to this widget,
and resets the selection of the widget to this item, if it is not
already in the selection.
[enum]
Clicking mouse button 1 with the Control key down will reposition the
active cursor and add the item to the selection
without ever removing any items from the selection.
[enum]
If the mouse is dragged out of the widget
while button 1 is pressed, the treectrl will automatically scroll to
make more items visible (if there are more items off-screen on the side
where the mouse left the window).
[enum]
The Left and Right keys move the active cursor one item to the left or right;
for an hierarchical tree with vertical orientation nothing will happen,
since it has no two items in the same row.
The selection is set to include only the active item.
If Left or Right is typed with the Shift key down, then the active
cursor moves and the selection is extended to include the new item.
[enum]
The Up and Down keys move the active cursor one item up or down.
The selection is set to include only the active item.
If Up or Down is typed with the Shift key down, then the active
cursor moves and the selection is extended to include the new item.
[enum]
The Next and Prior keys move the active cursor forward or backwards
by one screenful, without affecting the selection.
[enum]
Control-Next and Control-Prior scroll the view right or left by one page
without moving the active cursor or affecting the selection.
Control-Left and Control-Right behave the same.
[enum]
The Home and End keys scroll to the left or right end of the widget
without moving the active cursor or affecting the selection.
[enum]
The Control-Home and Control-End keys scroll to the top or bottom
of the widget, they also activate and select the first or last item.
If also the Shift key is down, then the active
cursor moves and the selection is extended to include the new item.
[enum]
The Space and Select keys set the selection to the active item.
[enum]
Control-/ selects the entire contents of the widget.
[enum]
Control-\\ clears any selection in the widget.
[enum]
The + and - keys expand or collapse the active item,
the Return key toggles the active item.
[enum]
The mousewheel scrolls the view of the widget four lines up or down
depending on the direction, the wheel was turned.
The active cursor or the selection is not affected.
[list_end]

[section EXAMPLES]

Get the unique identifier for the leftmost visible column:
[example_begin]
set id [lb]$T column index "first visible"[rb]
[example_end]

Delete the leftmost column:
[example_begin]
$T column delete "order 0"
[example_end]

Take the visible column that is to the left of the last column, and move that
column in front of the tail column:
[example_begin]
$T column move "last prev visible" tail
[example_end]


Get the unique identifier for the first visible item:
[example_begin]
set id [lb]$T item index "first visible"[rb]
[example_end]

Delete the parent of the item that is under the point x,y:
[example_begin]
$T item delete "nearest $x $y parent"
[example_end]

Add the 10th child of the second child of the root item to the selection:
[example_begin]
$T selection add "root firstchild nextsibling child 10"
[example_end]


Move a column that the user drag-and-dropped:
[example_begin]
$T column dragconfigure -enable yes
$T notify install <ColumnDrag-receive>
$T notify bind MyTag <ColumnDrag-receive> {
	%T column move %C %b
}
[example_end]

[see_also listbox(n) image(n) bitmap(n) bind(n) options(n)]
[keywords tree widget]
[manpage_end]
