/*
 * $Id: TemplateAttributeRendererTest.java 821299 2009-10-03 12:15:05Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.renderer.impl;

import static org.easymock.EasyMock.*;
import static org.junit.Assert.*;

import java.io.IOException;

import org.apache.tiles.Attribute;
import org.apache.tiles.Expression;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.junit.Before;
import org.junit.Test;

/**
 * Tests {@link TemplateAttributeRenderer}.
 *
 * @version $Rev: 821299 $ $Date: 2009-10-03 14:15:05 +0200 (sab, 03 ott 2009) $
 */
public class TemplateAttributeRendererTest {

    /**
     * The renderer.
     */
    private TemplateAttributeRenderer renderer;

    /** {@inheritDoc} */
    @Before
    public void setUp() throws Exception {
        renderer = new TemplateAttributeRenderer();
        renderer.setAttributeEvaluatorFactory(new BasicAttributeEvaluatorFactory(
                new DirectAttributeEvaluator()));
    }

    /**
     * Tests
     * {@link StringAttributeRenderer#write(Object, Attribute, TilesRequestContext)}.
     *
     * @throws IOException If something goes wrong during rendition.
     */
    @Test
    public void testWrite() throws IOException {
        Attribute attribute = new Attribute("/myTemplate.jsp",
                (Expression) null, null, "template");
        TilesApplicationContext applicationContext = createMock(TilesApplicationContext.class);
        TilesRequestContextFactory contextFactory = createMock(TilesRequestContextFactory.class);
        TilesRequestContext requestContext = createMock(TilesRequestContext.class);
        requestContext.dispatch("/myTemplate.jsp");
        replay(applicationContext, contextFactory, requestContext);
        renderer.setApplicationContext(applicationContext);
        renderer.setRequestContextFactory(contextFactory);
        renderer.render(attribute, requestContext);
        verify(applicationContext, contextFactory, requestContext);
    }

    /**
     * Tests
     * {@link StringAttributeRenderer#isRenderable(Object, Attribute, TilesRequestContext)}.
     *
     * @throws IOException If something goes wrong during rendition.
     */
    @Test
    public void testIsRenderable() throws IOException {
        Attribute attribute = new Attribute("/myTemplate.jsp",
                (Expression) null, null, "template");
        TilesApplicationContext applicationContext = createMock(TilesApplicationContext.class);
        TilesRequestContextFactory contextFactory = createMock(TilesRequestContextFactory.class);
        TilesRequestContext requestContext = createMock(TilesRequestContext.class);
        replay(applicationContext, contextFactory, requestContext);
        renderer.setApplicationContext(applicationContext);
        renderer.setRequestContextFactory(contextFactory);
        assertTrue(renderer.isRenderable("/myTemplate.jsp", attribute,
                requestContext));
        verify(applicationContext, contextFactory, requestContext);
    }
}
