/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file NetTools.h
    \author Romain BONDUE
    \date 08/05/2006 */
#ifndef __NETTOOLS_H__
#define __NETTOOLS_H__

#include <string>

extern "C"{
#include <stdint.h>
}

#include "Exceptions.h"



namespace nsNet
{
    class CIPAddress
    {
      public :
        CIPAddress (uint32_t) throw();
        void Set (uint32_t) throw();
        uint32_t Get () const throw();
        /** \warning Pos must be between 0 and 3. */
        uint8_t Get (unsigned) const throw();
        /** \warning Pos must be between 0 and 3. */
        void Set (uint8_t, unsigned) throw();
        std::string GetStr () const throw();


      private :
        uint32_t m_Addr;

    }; // CIPAddress()


    class CInterface
    {
      public :
        CInterface (const std::string& = "IfaceName not set") throw();
        virtual ~CInterface () throw();
        const std::string& GetName () const throw();
        void SetName (const std::string&) throw();
        void RefreshStats () throw (nsErrors::CException);
        unsigned long GetRXBytes () const throw();
        unsigned long GetRXPackets () const throw();
        unsigned long GetRXErrors () const throw();
        unsigned long GetRXDropped () const throw();
            /// The number of FIFO buffer errors.
        unsigned long GetRXFifo () const throw();
            /// The number of packet framing errors.
        unsigned long GetRXFrame () const throw();
        unsigned long GetRXCompressed () const throw();
            /** The number of multicast frames transmitted or received by the
               device driver. */
        unsigned long GetMulticast () const throw();
        unsigned long GetTXBytes () const throw();
        unsigned long GetTXPackets () const throw();
        unsigned long GetTXErrors () const throw();
        unsigned long GetTXDropped () const throw();
            /// The number of FIFO buffer errors.
        unsigned long GetTXFifo () const throw();
        unsigned long GetCollisions () const throw();
            /// The number of carrier losses detected by the device driver.
        unsigned long GetCarrier () const throw();
        unsigned long GetTXCompressed () const throw();
            /* Comments above from :
    http://www.linuxdevcenter.com/pub/a/linux/2000/11/16/LinuxAdmin.html */

        CIPAddress GetIP () const throw (nsErrors::CSystemExc);
        virtual void SetIPFromDHCP (const std::string&)
                                                throw (nsErrors::CException);
        bool IsUp () throw (nsErrors::CSystemExc);
        virtual void Up () throw (nsErrors::CSystemExc);
        virtual void Down () throw (nsErrors::CSystemExc);


      protected :
        void ClearStats () throw();


      private :
        std::string m_IfName;
        unsigned long m_RXBytes;
        unsigned long m_RXPackets;
        unsigned long m_RXErrors;
        unsigned long m_RXDropped;
        unsigned long m_RXFifo;
        unsigned long m_RXFrame;
        unsigned long m_RXCompressed;
        unsigned long m_Multicast;
        unsigned long m_TXBytes;
        unsigned long m_TXPackets;
        unsigned long m_TXErrors;
        unsigned long m_TXDropped;
        unsigned long m_TXFifo;
        unsigned long m_Collisions;
        unsigned long m_Carrier;
        unsigned long m_TXCompressed;

    }; // CInterface

} // namespace nsNet

#include "private/NetTools.hxx"

#endif // __NETTOOLS_H__
