// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{ffi, AuthDomain, ServerListenOptions, ServerMessage};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SoupServer")]
    pub struct Server(Object<ffi::SoupServer, ffi::SoupServerClass>);

    match fn {
        type_ => || ffi::soup_server_get_type(),
    }
}

impl Server {
    pub const NONE: Option<&'static Server> = None;

    //#[doc(alias = "soup_server_new")]
    //pub fn new(optname1: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> Option<Server> {
    //    unsafe { TODO: call ffi:soup_server_new() }
    //}

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Server`] objects.
    ///
    /// This method returns an instance of [`ServerBuilder`](crate::builders::ServerBuilder) which can be used to create [`Server`] objects.
    pub fn builder() -> ServerBuilder {
        ServerBuilder::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Server`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ServerBuilder {
    builder: glib::object::ObjectBuilder<'static, Server>,
}

impl ServerBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn raw_paths(self, raw_paths: bool) -> Self {
        Self {
            builder: self.builder.property("raw-paths", raw_paths),
        }
    }

    pub fn server_header(self, server_header: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("server-header", server_header.into()),
        }
    }

    pub fn tls_auth_mode(self, tls_auth_mode: gio::TlsAuthenticationMode) -> Self {
        Self {
            builder: self.builder.property("tls-auth-mode", tls_auth_mode),
        }
    }

    pub fn tls_certificate(self, tls_certificate: &impl IsA<gio::TlsCertificate>) -> Self {
        Self {
            builder: self
                .builder
                .property("tls-certificate", tls_certificate.clone().upcast()),
        }
    }

    pub fn tls_database(self, tls_database: &impl IsA<gio::TlsDatabase>) -> Self {
        Self {
            builder: self
                .builder
                .property("tls-database", tls_database.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Server`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Server {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Server>> Sealed for T {}
}

pub trait ServerExt: IsA<Server> + sealed::Sealed + 'static {
    #[doc(alias = "soup_server_accept_iostream")]
    fn accept_iostream(
        &self,
        stream: &impl IsA<gio::IOStream>,
        local_addr: Option<&impl IsA<gio::SocketAddress>>,
        remote_addr: Option<&impl IsA<gio::SocketAddress>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::soup_server_accept_iostream(
                self.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
                local_addr.map(|p| p.as_ref()).to_glib_none().0,
                remote_addr.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "soup_server_add_auth_domain")]
    fn add_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>) {
        unsafe {
            ffi::soup_server_add_auth_domain(
                self.as_ref().to_glib_none().0,
                auth_domain.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_server_add_websocket_extension")]
    fn add_websocket_extension(&self, extension_type: glib::types::Type) {
        unsafe {
            ffi::soup_server_add_websocket_extension(
                self.as_ref().to_glib_none().0,
                extension_type.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_server_disconnect")]
    fn disconnect(&self) {
        unsafe {
            ffi::soup_server_disconnect(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_server_get_listeners")]
    #[doc(alias = "get_listeners")]
    fn listeners(&self) -> Vec<gio::Socket> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::soup_server_get_listeners(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_get_tls_auth_mode")]
    #[doc(alias = "get_tls_auth_mode")]
    #[doc(alias = "tls-auth-mode")]
    fn tls_auth_mode(&self) -> gio::TlsAuthenticationMode {
        unsafe {
            from_glib(ffi::soup_server_get_tls_auth_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_get_tls_certificate")]
    #[doc(alias = "get_tls_certificate")]
    #[doc(alias = "tls-certificate")]
    fn tls_certificate(&self) -> Option<gio::TlsCertificate> {
        unsafe {
            from_glib_none(ffi::soup_server_get_tls_certificate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_get_tls_database")]
    #[doc(alias = "get_tls_database")]
    #[doc(alias = "tls-database")]
    fn tls_database(&self) -> Option<gio::TlsDatabase> {
        unsafe {
            from_glib_none(ffi::soup_server_get_tls_database(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_get_uris")]
    #[doc(alias = "get_uris")]
    fn uris(&self) -> Vec<glib::Uri> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_server_get_uris(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_is_https")]
    fn is_https(&self) -> bool {
        unsafe { from_glib(ffi::soup_server_is_https(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_server_listen")]
    fn listen(
        &self,
        address: &impl IsA<gio::SocketAddress>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::soup_server_listen(
                self.as_ref().to_glib_none().0,
                address.as_ref().to_glib_none().0,
                options.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "soup_server_listen_all")]
    fn listen_all(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::soup_server_listen_all(
                self.as_ref().to_glib_none().0,
                port,
                options.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "soup_server_listen_local")]
    fn listen_local(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::soup_server_listen_local(
                self.as_ref().to_glib_none().0,
                port,
                options.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "soup_server_listen_socket")]
    fn listen_socket(
        &self,
        socket: &impl IsA<gio::Socket>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::soup_server_listen_socket(
                self.as_ref().to_glib_none().0,
                socket.as_ref().to_glib_none().0,
                options.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg_attr(feature = "v3_2", deprecated = "Since 3.2")]
    #[allow(deprecated)]
    #[doc(alias = "soup_server_pause_message")]
    fn pause_message(&self, msg: &ServerMessage) {
        unsafe {
            ffi::soup_server_pause_message(self.as_ref().to_glib_none().0, msg.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_server_remove_auth_domain")]
    fn remove_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>) {
        unsafe {
            ffi::soup_server_remove_auth_domain(
                self.as_ref().to_glib_none().0,
                auth_domain.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_server_remove_handler")]
    fn remove_handler(&self, path: &str) {
        unsafe {
            ffi::soup_server_remove_handler(self.as_ref().to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_server_remove_websocket_extension")]
    fn remove_websocket_extension(&self, extension_type: glib::types::Type) {
        unsafe {
            ffi::soup_server_remove_websocket_extension(
                self.as_ref().to_glib_none().0,
                extension_type.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_server_set_tls_auth_mode")]
    #[doc(alias = "tls-auth-mode")]
    fn set_tls_auth_mode(&self, mode: gio::TlsAuthenticationMode) {
        unsafe {
            ffi::soup_server_set_tls_auth_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "soup_server_set_tls_certificate")]
    #[doc(alias = "tls-certificate")]
    fn set_tls_certificate(&self, certificate: &impl IsA<gio::TlsCertificate>) {
        unsafe {
            ffi::soup_server_set_tls_certificate(
                self.as_ref().to_glib_none().0,
                certificate.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_server_set_tls_database")]
    #[doc(alias = "tls-database")]
    fn set_tls_database(&self, tls_database: &impl IsA<gio::TlsDatabase>) {
        unsafe {
            ffi::soup_server_set_tls_database(
                self.as_ref().to_glib_none().0,
                tls_database.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v3_2", deprecated = "Since 3.2")]
    #[allow(deprecated)]
    #[doc(alias = "soup_server_unpause_message")]
    fn unpause_message(&self, msg: &ServerMessage) {
        unsafe {
            ffi::soup_server_unpause_message(self.as_ref().to_glib_none().0, msg.to_glib_none().0);
        }
    }

    #[doc(alias = "raw-paths")]
    fn is_raw_paths(&self) -> bool {
        ObjectExt::property(self.as_ref(), "raw-paths")
    }

    #[doc(alias = "server-header")]
    fn server_header(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "server-header")
    }

    #[doc(alias = "server-header")]
    fn set_server_header(&self, server_header: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "server-header", server_header)
    }

    #[doc(alias = "request-aborted")]
    fn connect_request_aborted<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_aborted_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-aborted\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    request_aborted_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "request-finished")]
    fn connect_request_finished<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_finished_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-finished\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    request_finished_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "request-read")]
    fn connect_request_read<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_read_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-read\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    request_read_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "request-started")]
    fn connect_request_started<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_started_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-started\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    request_started_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "server-header")]
    fn connect_server_header_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_server_header_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::server-header\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_server_header_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-auth-mode")]
    fn connect_tls_auth_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_auth_mode_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-auth-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tls_auth_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-certificate")]
    fn connect_tls_certificate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_certificate_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-certificate\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tls_certificate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-database")]
    fn connect_tls_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_database_trampoline<P: IsA<Server>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-database\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tls_database_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Server>> ServerExt for O {}
