# this file has been automatically generated by valabind
from ctypes import *
from ctypes.util import find_library
lib = CDLL (find_library ('r_core'))
def rlist2array(x,y):
	it = x.iterator ()
	ret = []
	while True:
		data = it.get_data ()
		ds = cast (data, POINTER(y)).contents
		ret.append (ds)
		if it.n == None:
			break
		it = it.get_next ()
	return ret

class AddressHolder(object):
	def __get__(self, obj, type_):
		if getattr(obj, '_address', None) is None:
			obj._address = addressof(obj)
		return obj._address

	def __set__(self, obj, value):
		obj._address = value

class WrappedRMethod(object):
	def __init__(self, cname, args, ret):
		self.cname = cname
		self.args = args
		self.ret = ret
		self.args_set = False
		self.method = getattr(lib, cname)

	def __call__(self, *a):
		if not self.args_set:
			if self.args:
				self.method.argtypes = [eval(x.strip()) for x in self.args.split(',')]
			self.method.restype = eval(self.ret) if self.ret else None
			self.args_set = True
		return self.method(*a)

class WrappedApiMethod(object):
	def __init__(self, method, ret2, last):
		self.method = method
		self._o = None
		self.ret2 = ret2
		self.last = last

	def __call__(self, *a):
		result = self.method(self._o, *a)
		if self.ret2:
			result = eval(self.ret2)(result)
		if self.last:
			return getattr(result, self.last)
		return result

	def __get__(self, obj, type_):
		self._o = obj._o
		return self

def register(cname, args, ret):
	ret2 = last = None
	if ret:
		if ret[0]>='A' and ret[0]<='Z':
			x = ret.find('<')
			if x != -1:
				ret = ret[0:x]
			last = 'contents'
			ret = 'POINTER('+ret+')'
		else:
			last = 'value'
			ret2 = ret
			
	method = WrappedRMethod(cname, args, ret)
	wrapped_method = WrappedApiMethod(method, ret2, last)
	return wrapped_method, method

class RLibStruct(Structure): #0
	_fields_ = [
		("type", c_long),
		("data", c_void_p),
	]
class RCoreAsmHit(Structure): #3
	_fields_ = [
		("code", c_char_p),
		("len", c_int),
		("addr", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_core_asm_hit_new = lib.r_core_asm_hit_new
		r_core_asm_hit_new.restype = c_void_p
		self._o = r_core_asm_hit_new ()

	_o = AddressHolder()


class RCmd(Structure): #4
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_cmd_new = lib.r_cmd_new
		r_cmd_new.restype = c_void_p
		self._o = r_cmd_new ()

	_o = AddressHolder()

	set_data, r_cmd_set_data = register('r_cmd_set_data','c_void_p, c_void_p',None)
	add, r_cmd_add = register('r_cmd_add','c_void_p, c_char_p, c_char_p, RCmdCallback','c_bool')
	add_long, r_cmd_add_long = register('r_cmd_add_long','c_void_p, c_char_p, c_char_p, c_char_p','c_bool')
	_del, r_cmd_del = register('r_cmd_del','c_void_p, c_char_p','c_bool')
	call, r_cmd_call = register('r_cmd_call','c_void_p, c_char_p','c_bool')
	call_long, r_cmd_call_long = register('r_cmd_call_long','c_void_p, c_char_p','c_bool')

class RNum(Structure): #5
	_fields_ = [
	]
	def __init__(self, cb, user):
		Structure.__init__(self)
		r_num_new = lib.r_num_new
		r_num_new.restype = c_void_p
		self._o = r_num_new (cb, user)

	_o = AddressHolder()

	get, r_num_get = register('r_num_get','c_void_p, c_char_p','c_ulonglong')
	math, r_num_math = register('r_num_math','c_void_p, c_char_p','c_ulonglong')

class RBuffer(Structure): #6
	_fields_ = [
		("buf", POINTER(c_ubyte)),
		("length", c_int),
		("cur", c_int),
		("base", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_buf_new = lib.r_buf_new
		r_buf_new.restype = c_void_p
		self._o = r_buf_new ()

	_o = AddressHolder()

	read_at, r_buf_read_at = register('r_buf_read_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	write_at, r_buf_write_at = register('r_buf_write_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	set_bytes, r_buf_set_bytes = register('r_buf_set_bytes','c_void_p, POINTER(c_ubyte), c_int','c_bool')

class RList(Structure): #7
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_list_new = lib.r_list_new
		r_list_new.restype = c_void_p
		self._o = r_list_new ()
	def to_list(self,type):
		return rlist2array(self,type)

	_o = AddressHolder()

	append, r_list_append = register('r_list_append','c_void_p, c_void_p',None)
	prepend, r_list_prepend = register('r_list_prepend','c_void_p, c_void_p',None)
	iterator, r_list_iterator = register('r_list_iterator','c_void_p','RListIter')
	length, r_list_length = register('r_list_length','c_void_p','c_uint')
	del_n, r_list_del_n = register('r_list_del_n','c_void_p, c_int','c_bool')
	get_top, r_list_get_top = register('r_list_get_top','c_void_p','c_bool')
	pop, r_list_pop = register('r_list_pop','c_void_p','c_void_p')

class RListIter(Structure): #8
	_fields_ = [
		("data", c_void_p),
		("n", c_void_p),
		("p", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	get_data, r_list_iter_get_data = register('r_list_iter_get_data','c_void_p','c_void_p')
	get_next, r_list_iter_get_next = register('r_list_iter_get_next','c_void_p','RListIter')

class RRange(Structure): #9
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_range_new = lib.r_range_new
		r_range_new.restype = c_void_p
		self._o = r_range_new ()
		r_range_new_from_string = lib.r_range_new_from_string
		r_range_new_from_string.restype = c_void_p
		self._o = r_range_new_from_string (str)

	_o = AddressHolder()

	item_get, r_range_item_get = register('r_range_item_get','c_void_p, c_ulonglong','POINTER(RRangeItem)')
	size, r_range_size = register('r_range_size','c_void_p','c_ulonglong')
	add_from_string, r_range_add_from_string = register('r_range_add_from_string','c_void_p, c_char_p','c_ulonglong')
	contains, r_range_contains = register('r_range_contains','c_void_p, c_ulonglong','c_bool')
	sort, r_range_sort = register('r_range_sort','c_void_p','c_bool')
	list, r_range_list = register('r_range_list','c_void_p, c_bool','c_bool')
	get_n, r_range_get_n = register('r_range_get_n','c_void_p, c_int, POINTER(c_ulonglong), POINTER(c_ulonglong)','c_bool')
	inverse, r_range_inverse = register('r_range_inverse','c_void_p, c_ulonglong, c_ulonglong, c_int','POINTER(RRange)')

class RRangeItem(Structure): #10
	_fields_ = [
		("fr", c_ulonglong),
		("to", c_ulonglong),
		("data", POINTER(c_ubyte)),
		("datalen", c_int),
	]
class RLib(Structure): #11
	_fields_ = [
	]
	def __init__(self, symname):
		Structure.__init__(self)
		r_lib_new = lib.r_lib_new
		r_lib_new.restype = c_void_p
		self._o = r_lib_new (symname)

	_o = AddressHolder()

	close, r_lib_close = register('r_lib_close','c_void_p, c_char_p','c_bool')
	opendir, r_lib_opendir = register('r_lib_opendir','c_void_p, c_char_p','c_int')
	path, r_lib_path = register('r_lib_path','c_char_p','c_char_p')
	dl_open, r_lib_dl_open = register('r_lib_dl_open','c_char_p','c_void_p')
	dl_sym, r_lib_dl_sym = register('r_lib_dl_sym','c_void_p, c_char_p','c_void_p')
	dl_close, r_lib_dl_close = register('r_lib_dl_close','c_void_p','c_bool')
	dl_check_filename, r_lib_dl_check_filename = register('r_lib_dl_check_filename','c_char_p','c_bool')
	del_handler, r_lib_del_handler = register('r_lib_del_handler','c_void_p, c_int','c_bool')

class RCons(Structure): #12
	_fields_ = [
		("is_interactive", c_bool),
		("is_html", c_bool),
		("rows", c_int),
		("columns", c_int),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	singleton, r_cons_singleton = register('r_cons_singleton','','RCons')
	eof, r_cons_eof = register('r_cons_eof','','c_bool')
	pipe_open, r_cons_pipe_open = register('r_cons_pipe_open','c_char_p, c_bool','c_int')
	pipe_close, r_cons_pipe_close = register('r_cons_pipe_close','c_int',None)
	clear, r_cons_clear = register('r_cons_clear','',None)
	clear00, r_cons_clear00 = register('r_cons_clear00','',None)
	reset, r_cons_reset = register('r_cons_reset','',None)
	gotoxy, r_cons_gotoxy = register('r_cons_gotoxy','c_int, c_int',None)
	set_raw, r_cons_set_raw = register('r_cons_set_raw','c_bool',None)
	printf, r_cons_printf = register('r_cons_printf','c_char_p',None)
	strcat, r_cons_strcat = register('r_cons_strcat','c_char_p',None)
	memcat, r_cons_memcat = register('r_cons_memcat','c_char_p, c_int',None)
	newline, r_cons_newline = register('r_cons_newline','',None)
	flush, r_cons_flush = register('r_cons_flush','',None)
	filter, r_cons_filter = register('r_cons_filter','',None)
	visual_flush, r_cons_visual_flush = register('r_cons_visual_flush','',None)
	readchar, r_cons_readchar = register('r_cons_readchar','','c_int')
	any_key, r_cons_any_key = register('r_cons_any_key','',None)
	get_size, r_cons_get_size = register('r_cons_get_size','POINTER(c_int)','c_int')
	yesno, r_cons_yesno = register('r_cons_yesno','c_bool, c_char_p','c_bool')
	html_print, r_cons_html_print = register('r_cons_html_print','c_char_p','c_int')
	arrow_to_hjkl, r_cons_arrow_to_hjkl = register('r_cons_arrow_to_hjkl','c_int','c_int')
	get_buffer, r_cons_get_buffer = register('r_cons_get_buffer','','c_char_p')
	grep, r_cons_grep = register('r_cons_grep','c_char_p',None)
	invert, r_cons_invert = register('r_cons_invert','c_bool, c_int',None)

class RLine(Structure): #13
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	singleton, r_line_singleton = register('r_line_singleton','','RLine')
	readline, r_line_readline = register('r_line_readline','','c_bool')
	set_prompt, r_line_set_prompt = register('r_line_set_prompt','c_char_p',None)
	hist_load, r_line_hist_load = register('r_line_hist_load','c_char_p','c_bool')
	hist_add, r_line_hist_add = register('r_line_hist_add','c_char_p','c_bool')
	hist_save, r_line_hist_save = register('r_line_hist_save','c_char_p','c_bool')

class RAnalDiff(Structure): #18
	_fields_ = [
		("type", c_long),
		("name", c_char_p),
		("addr", c_ulonglong),
	]
class RAnalBlock(Structure): #16
	_fields_ = [
		("addr", c_ulonglong),
		("size", c_ulonglong),
		("jump", c_ulonglong),
		("fail", c_ulonglong),
		("type", c_long),
		("ninstr", c_int),
		("returnbb", c_bool),
		("conditional", c_bool),
		("traced", c_bool),
		("fingerprint", POINTER(c_ubyte)),
		("diff", RAnalDiff),
	]
class RAnalFunction(Structure): #19
	_fields_ = [
		("name", c_char_p),
		("dsc", c_char_p),
		("size", c_int),
		("bits", c_int),
		("type", c_short),
		("rets", c_short),
		("fmod", c_short),
		("call", c_short),
		("attr", c_char_p),
		("addr", c_ulonglong),
		("stack", c_int),
		("ninstr", c_int),
		("nargs", c_int),
		("depth", c_int),
		("diff", RAnalDiff),
		("fingerprint", POINTER(c_ubyte)),
		("bbs", c_void_p),
		("vars", c_void_p),
		("refs", c_void_p),
		("xrefs", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	_get_bbs, r_anal_fcn_get_bbs = register('r_anal_fcn_get_bbs','c_void_p','RList<RAnalBlock>')
	_get_vars, r_anal_fcn_get_vars = register('r_anal_fcn_get_vars','c_void_p','RList<RAnalVar>')
	_get_refs, r_anal_fcn_get_refs = register('r_anal_fcn_get_refs','c_void_p','RList<RAnalRef>')
	_get_xrefs, r_anal_fcn_get_xrefs = register('r_anal_fcn_get_xrefs','c_void_p','RList<RAnalRef>')
	def get_bbs(self):
		return rlist2array(self._get_bbs(),RAnalBlock)
	def get_vars(self):
		return rlist2array(self._get_vars(),RAnalVar)
	def get_refs(self):
		return rlist2array(self._get_refs(),RAnalRef)
	def get_xrefs(self):
		return rlist2array(self._get_xrefs(),RAnalRef)

class RAnalVar(Structure): #20
	_fields_ = [
		("name", c_char_p),
		("type", c_char_p),
		("delta", c_int),
		("accesses", c_void_p),
	]
class RAnalVarAccess(Structure): #21
	_fields_ = [
		("addr", c_ulonglong),
		("set", c_bool),
	]
class RAnalRef(Structure): #22
	_fields_ = [
		("type", c_int),
		("addr", c_ulonglong),
		("at", c_ulonglong),
	]
class RAnalRefline(Structure): #23
	_fields_ = [
		("from", c_ulonglong),
		("to", c_ulonglong),
		("index", c_int),
	]
class RMeta(Structure): #24
	_fields_ = [
		("data", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	add, r_meta_add = register('r_meta_add','c_void_p, c_long, c_ulonglong, c_ulonglong, c_char_p','c_bool')
	_del, r_meta_del = register('r_meta_del','c_void_p, c_long, c_ulonglong, c_ulonglong, c_char_p','c_bool')
	find, r_meta_find = register('r_meta_find','c_void_p, c_ulonglong, c_long, c_long','RMetaItem')
	cleanup, r_meta_cleanup = register('r_meta_cleanup','c_void_p, c_ulonglong, c_ulonglong','c_bool')
	type_to_string, r_meta_type_to_string = register('r_meta_type_to_string','c_long','c_char_p')
	list, r_meta_list = register('r_meta_list','c_void_p, c_long, c_ulonglong','c_int')

class RMetaItem(Structure): #25
	_fields_ = [
		("from", c_ulonglong),
		("to", c_ulonglong),
		("size", c_ulonglong),
		("type", c_int),
		("str", c_char_p),
	]
class RReg(Structure): #26
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_reg_new = lib.r_reg_new
		r_reg_new.restype = c_void_p
		self._o = r_reg_new ()

	_o = AddressHolder()

	set_profile, r_reg_set_profile = register('r_reg_set_profile','c_void_p, c_char_p','c_bool')
	set_profile_string, r_reg_set_profile_string = register('r_reg_set_profile_string','c_void_p, c_char_p','c_bool')
	get, r_reg_get = register('r_reg_get','c_void_p, c_char_p, c_int','RRegItem')
	set_name, r_reg_set_name = register('r_reg_set_name','c_void_p, c_int, c_char_p','c_bool')
	get_name, r_reg_get_name = register('r_reg_get_name','c_void_p, c_int','c_char_p')
	get_name_idx, r_reg_get_name_idx = register('r_reg_get_name_idx','c_char_p','c_int')
	type_by_name, r_reg_type_by_name = register('r_reg_type_by_name','c_char_p','c_int')
	get_type, r_reg_get_type = register('r_reg_get_type','c_int','c_char_p')
	get_value, r_reg_get_value = register('r_reg_get_value','c_void_p, RRegItem','c_ulonglong')
	set_value, r_reg_set_value = register('r_reg_set_value','c_void_p, RRegItem, c_ulonglong','c_bool')
	get_fvalue, r_reg_get_fvalue = register('r_reg_get_fvalue','c_void_p, RRegItem','float')
	set_fvalue, r_reg_set_fvalue = register('r_reg_set_fvalue','c_void_p, RRegItem, float','c_bool')
	get_pvalue, r_reg_get_pvalue = register('r_reg_get_pvalue','c_void_p, RRegItem, c_int','c_ulonglong')
	set_pvalue, r_reg_set_pvalue = register('r_reg_set_pvalue','c_void_p, RRegItem, c_ulonglong, c_int','c_bool')
	get_bytes, r_reg_get_bytes = register('r_reg_get_bytes','c_void_p, c_long, POINTER(c_int)','POINTER(c_ubyte)')
	set_bytes, r_reg_set_bytes = register('r_reg_set_bytes','c_void_p, c_long, POINTER(c_ubyte), c_int','c_int')
	fit_arena, r_reg_fit_arena = register('r_reg_fit_arena','c_void_p',None)
	arena_set, r_reg_arena_set = register('r_reg_arena_set','c_void_p, c_int, c_bool',None)
	arena_push, r_reg_arena_push = register('r_reg_arena_push','c_void_p','c_bool')
	arena_pop, r_reg_arena_pop = register('r_reg_arena_pop','c_void_p',None)

class RRegItem(Structure): #27
	_fields_ = [
		("name", c_char_p),
		("size", c_int),
		("offset", c_int),
		("packed_size", c_int),
		("type", c_long),
	]
class RAnalValue(Structure): #15
	_fields_ = [
		("absolute", c_bool),
		("memref", c_bool),
		("base", c_ulonglong),
		("delta", c_longlong),
		("imm", c_longlong),
		("mul", c_int),
		("reg", RRegItem),
		("regdelta", RRegItem),
	]
class RAnalOp(Structure): #17
	_fields_ = [
		("mnemonic", c_char_p),
		("addr", c_ulonglong),
		("type", c_int),
		("stackop", c_bool),
		("cond", c_int),
		("length", c_int),
		("nopcode", c_int),
		("family", c_int),
		("eob", c_bool),
		("delay", c_int),
		("jump", c_ulonglong),
		("fail", c_ulonglong),
		("selector", c_uint),
		("ptr", c_longlong),
		("val", c_ulonglong),
		("stackptr", c_longlong),
		("refptr", c_bool),
		('esil', c_char * 64),
		('src', RAnalValue * 3),
		("dst", RAnalValue),
	]
class RRegArena(Structure): #28
	_fields_ = [
		("bytes", POINTER(c_ubyte)),
		("size", c_int),
	]
class RRegSet(Structure): #29
	_fields_ = [
		("arena", RRegArena),
		("regs", c_void_p),
	]
class RHash(Structure): #30
	_fields_ = [
	]
	def __init__(self, rst, bits):
		Structure.__init__(self)
		r_hash_new = lib.r_hash_new
		r_hash_new.restype = c_void_p
		self._o = r_hash_new (rst, bits)

	_o = AddressHolder()

	crc16, r_hash_crc16 = register('r_hash_crc16','c_ushort, POINTER(c_ubyte), c_ulonglong','c_ushort')
	crc32, r_hash_crc32 = register('r_hash_crc32','POINTER(c_ubyte), c_ulonglong','c_uint')
	xor, r_hash_xor = register('r_hash_xor','POINTER(c_ubyte), c_ulonglong','c_ushort')
	xorpair, r_hash_xorpair = register('r_hash_xorpair','POINTER(c_ubyte), c_ulonglong','c_uint')
	parity, r_hash_parity = register('r_hash_parity','POINTER(c_ubyte), c_ulonglong','c_ubyte')
	mod255, r_hash_mod255 = register('r_hash_mod255','POINTER(c_ubyte), c_ulonglong','c_ubyte')
	hamdist, r_hash_hamdist = register('r_hash_hamdist','POINTER(c_ubyte), c_ulonglong','c_ubyte')
	entropy, r_hash_entropy = register('r_hash_entropy','POINTER(c_ubyte), c_ulonglong','double')
	pcprint, r_hash_pcprint = register('r_hash_pcprint','POINTER(c_ubyte), c_ulonglong','c_int')
	do_md4, r_hash_do_md4 = register('r_hash_do_md4','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')
	do_md5, r_hash_do_md5 = register('r_hash_do_md5','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')
	do_sha1, r_hash_do_sha1 = register('r_hash_do_sha1','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')
	do_sha256, r_hash_do_sha256 = register('r_hash_do_sha256','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')
	do_sha384, r_hash_do_sha384 = register('r_hash_do_sha384','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')
	do_sha512, r_hash_do_sha512 = register('r_hash_do_sha512','c_void_p, POINTER(c_ubyte), c_uint','POINTER(c_ubyte)')

class REggPlugin(Structure): #31
	_fields_ = [
	]
class REgg(Structure): #32
	_fields_ = [
		("arch", c_int),
		("endian", c_int),
		("bits", c_int),
		("os", c_uint),
	]
	def __init__(self):
		Structure.__init__(self)
		r_egg_new = lib.r_egg_new
		r_egg_new.restype = c_void_p
		self._o = r_egg_new ()

	_o = AddressHolder()

	to_string, r_egg_to_string = register('r_egg_to_string','c_void_p','c_char_p')
	reset, r_egg_reset = register('r_egg_reset','c_void_p',None)
	setup, r_egg_setup = register('r_egg_setup','c_void_p, c_char_p, c_int, c_bool, c_char_p','c_bool')
	load, r_egg_load = register('r_egg_load','c_void_p, c_char_p, c_int',None)
	syscall, r_egg_syscall = register('r_egg_syscall','c_void_p, c_char_p',None)
	alloc, r_egg_alloc = register('r_egg_alloc','c_void_p, c_int',None)
	label, r_egg_label = register('r_egg_label','c_void_p, c_char_p',None)
	include, r_egg_include = register('r_egg_include','c_void_p, c_char_p, c_int',None)
	raw, r_egg_raw = register('r_egg_raw','c_void_p, POINTER(c_ubyte), c_int','c_bool')
	encode, r_egg_encode = register('r_egg_encode','c_void_p, c_char_p','c_bool')
	shellcode, r_egg_shellcode = register('r_egg_shellcode','c_void_p, c_char_p','c_bool')
	option_set, r_egg_option_set = register('r_egg_option_set','c_void_p, c_char_p, c_char_p',None)
	option_get, r_egg_option_get = register('r_egg_option_get','c_void_p, c_char_p','c_char_p')
	padding, r_egg_padding = register('r_egg_padding','c_void_p, c_char_p','c_bool')
	compile, r_egg_compile = register('r_egg_compile','c_void_p','c_bool')
	assemble, r_egg_assemble = register('r_egg_assemble','c_void_p','c_bool')
	get_source, r_egg_get_source = register('r_egg_get_source','c_void_p','c_char_p')
	get_bin, r_egg_get_bin = register('r_egg_get_bin','c_void_p','RBuffer')
	get_assembly, r_egg_get_assembly = register('r_egg_get_assembly','c_void_p','c_char_p')
	append, r_egg_append = register('r_egg_append','c_void_p, c_char_p',None)
	run, r_egg_run = register('r_egg_run','c_void_p','c_int')

class RAsm(Structure): #33
	_fields_ = [
		("bits", c_int),
		("big_endian", c_bool),
		("syntax", c_int),
		("pc", c_ulonglong),
		("plugins", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)
		r_asm_new = lib.r_asm_new
		r_asm_new.restype = c_void_p
		self._o = r_asm_new ()

	_o = AddressHolder()

	use, r_asm_use = register('r_asm_use','c_void_p, c_char_p','c_bool')
	set_bits, r_asm_set_bits = register('r_asm_set_bits','c_void_p, c_int','c_bool')
	set_syntax, r_asm_set_syntax = register('r_asm_set_syntax','c_void_p, c_long','c_bool')
	set_pc, r_asm_set_pc = register('r_asm_set_pc','c_void_p, c_ulonglong','c_bool')
	set_big_endian, r_asm_set_big_endian = register('r_asm_set_big_endian','c_void_p, c_bool','c_bool')
	disassemble, r_asm_disassemble = register('r_asm_disassemble','c_void_p, POINTER(RAsmOp), POINTER(c_ubyte), c_int','c_int')
	assemble, r_asm_assemble = register('r_asm_assemble','c_void_p, POINTER(RAsmOp), c_char_p','c_int')
	mdisassemble, r_asm_mdisassemble = register('r_asm_mdisassemble','c_void_p, POINTER(c_ubyte), c_int','RAsmCode')
	mdisassemble_hexstr, r_asm_mdisassemble_hexstr = register('r_asm_mdisassemble_hexstr','c_void_p, c_char_p','RAsmCode')
	massemble, r_asm_massemble = register('r_asm_massemble','c_void_p, c_char_p','RAsmCode')
	assemble_file, r_asm_assemble_file = register('r_asm_assemble_file','c_void_p, c_char_p','RAsmCode')
	filter_input, r_asm_filter_input = register('r_asm_filter_input','c_void_p, c_char_p','c_bool')
	filter_output, r_asm_filter_output = register('r_asm_filter_output','c_void_p, c_char_p','c_bool')
	free, r_asm_free = register('r_asm_free','c_void_p',None)

class RAsmOp(Structure): #34
	_fields_ = [
		("inst_len", c_int),
		("payload", c_int),
		('buf', c_ubyte * 1024),
		('buf_asm', c_char * 1024),
		('buf_hex', c_char * 1024),
		('buf_err', c_char * 1024),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	get_hex, r_asm_op_get_hex = register('r_asm_op_get_hex','c_void_p','c_char_p')
	get_asm, r_asm_op_get_asm = register('r_asm_op_get_asm','c_void_p','c_char_p')

class RAsmCode(Structure): #35
	_fields_ = [
		("len", c_int),
		("buf", POINTER(c_ubyte)),
		("buf_hex", c_char_p),
		("buf_asm", c_char_p),
	]
class RAsmPlugin(Structure): #36
	_fields_ = [
		("name", c_char_p),
		("arch", c_char_p),
		("desc", c_char_p),
		('bits', c_int * 0),
	]
class RSyscall(Structure): #37
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_syscall_new = lib.r_syscall_new
		r_syscall_new.restype = c_void_p
		self._o = r_syscall_new ()

	_o = AddressHolder()

	setup, r_syscall_setup = register('r_syscall_setup','c_void_p, c_char_p, c_char_p, c_int',None)
	setup_file, r_syscall_setup_file = register('r_syscall_setup_file','c_void_p, c_char_p',None)
	get, r_syscall_get = register('r_syscall_get','c_void_p, c_int, c_int','RSyscallItem')
	get_num, r_syscall_get_num = register('r_syscall_get_num','c_void_p, c_char_p','c_int')
	get_i, r_syscall_get_i = register('r_syscall_get_i','c_void_p, c_int, c_int','c_char_p')
	list, r_syscall_list = register('r_syscall_list','c_void_p',None)

class RAnal(Structure): #14
	_fields_ = [
		("bits", c_int),
		("big_endian", c_bool),
		("split", c_bool),
		("user", c_void_p),
		("fcns", c_void_p),
		("meta", RMeta),
		("reg", RReg),
		("syscall", RSyscall),
	]
	def __init__(self):
		Structure.__init__(self)
		r_anal_new = lib.r_anal_new
		r_anal_new.restype = c_void_p
		self._o = r_anal_new ()

	_o = AddressHolder()

	op_hexstr, r_anal_op_hexstr = register('r_anal_op_hexstr','c_void_p, c_ulonglong, c_char_p','c_bool')
	esil_eval, r_anal_esil_eval = register('r_anal_esil_eval','c_void_p, c_char_p','c_bool')
	set_bits, r_anal_set_bits = register('r_anal_set_bits','c_void_p, c_int','c_bool')
	set_big_endian, r_anal_set_big_endian = register('r_anal_set_big_endian','c_void_p, c_bool','c_bool')
	diff_setup, r_anal_diff_setup = register('r_anal_diff_setup','c_void_p, c_bool, double, double',None)
	diff_setup_i, r_anal_diff_setup_i = register('r_anal_diff_setup_i','c_void_p, c_bool, c_int, c_int',None)
	_get_fcns, r_anal_get_fcns = register('r_anal_get_fcns','c_void_p','RList<RAnalFunction>')
	get_fcn_at, r_anal_get_fcn_at = register('r_anal_get_fcn_at','c_void_p, c_ulonglong','RAnalFunction')
	trace_bb, r_anal_trace_bb = register('r_anal_trace_bb','c_void_p, c_ulonglong',None)
	bb, r_anal_bb = register('r_anal_bb','c_void_p, RAnalBlock, c_ulonglong, POINTER(c_ubyte), c_ulonglong, c_bool',None)
	bb_from_offset, r_anal_bb_from_offset = register('r_anal_bb_from_offset','c_void_p, c_ulonglong','POINTER(RAnalBlock)')
	op_to_string, r_anal_op_to_string = register('r_anal_op_to_string','c_void_p, RAnalOp','c_char_p')
	op_to_esil_string, r_anal_op_to_esil_string = register('r_anal_op_to_esil_string','c_void_p, RAnalOp','c_char_p')
	def get_fcns(self):
		return rlist2array(self._get_fcns(),RAnalFunction)

class RSyscallItem(Structure): #38
	_fields_ = [
	]
class RDatabase(Structure): #39
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_db_new = lib.r_db_new
		r_db_new.restype = c_void_p
		self._o = r_db_new ()

	_o = AddressHolder()

	free, r_db_free = register('r_db_free','c_void_p',None)
	add_id, r_db_add_id = register('r_db_add_id','c_void_p, c_int, c_int','c_int')
	add, r_db_add = register('r_db_add','c_void_p, c_void_p','c_bool')
	add_unique, r_db_add_unique = register('r_db_add_unique','c_void_p, c_void_p','c_bool')
	delete, r_db_delete = register('r_db_delete','c_void_p, c_void_p','c_bool')
	get, r_db_get = register('r_db_get','c_void_p, c_int, POINTER(c_ubyte)','c_void_p')

class RPair(Structure): #40
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_pair_new = lib.r_pair_new
		r_pair_new.restype = c_void_p
		self._o = r_pair_new ()
		r_pair_new_from_file = lib.r_pair_new_from_file
		r_pair_new_from_file.restype = c_void_p
		self._o = r_pair_new_from_file (file)

	_o = AddressHolder()

	free, r_pair_free = register('r_pair_free','c_void_p',None)
	delete, r_pair_delete = register('r_pair_delete','c_void_p, c_char_p',None)
	get, r_pair_get = register('r_pair_get','c_void_p, c_char_p','c_char_p')
	set, r_pair_set = register('r_pair_set','c_void_p, c_char_p, c_char_p',None)
	sync, r_pair_sync = register('r_pair_sync','c_void_p',None)
	reset, r_pair_reset = register('r_pair_reset','c_void_p',None)

class RIOPlugin(Structure): #42
	_fields_ = [
	]
class RIOMap(Structure): #43
	_fields_ = [
	]
class RIOSection(Structure): #44
	_fields_ = [
	]
class RIODesc(Structure): #45
	_fields_ = [
		("fd", c_int),
		("flags", c_int),
		("name", c_char_p),
	]
class RCoreFile(Structure): #2
	_fields_ = [
		("uri", c_char_p),
		("filename", c_char_p),
		("seek", c_ulonglong),
		("size", c_ulonglong),
		("map", RIOMap),
		("rwx", c_int),
		("dbg", c_bool),
		("fd", RIODesc),
	]
class RIO(Structure): #41
	_fields_ = [
		("fd", RIODesc),
		("cached", c_bool),
		("cached_read", c_bool),
		("enforce_rwx", c_bool),
		("enforce_seek", c_bool),
		("off", c_ulonglong),
		("debug", c_bool),
		("va", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_io_new = lib.r_io_new
		r_io_new.restype = c_void_p
		self._o = r_io_new ()

	_o = AddressHolder()

	free, r_io_free = register('r_io_free','c_void_p','RIO')
	set_write_mask, r_io_set_write_mask = register('r_io_set_write_mask','c_void_p, POINTER(c_ubyte), c_int','c_bool')
	open, r_io_open = register('r_io_open','c_void_p, c_char_p, c_int, c_int','RIODesc')
	open_as, r_io_open_as = register('r_io_open_as','c_void_p, c_char_p, c_char_p, c_int, c_int','RIODesc')
	redirect, r_io_redirect = register('r_io_redirect','c_void_p, c_char_p','c_int')
	set_fd, r_io_set_fd = register('r_io_set_fd','c_void_p, RIODesc','c_int')
	read, r_io_read = register('r_io_read','c_void_p, POINTER(POINTER(c_ubyte)), c_int','c_int')
	read_at, r_io_read_at = register('r_io_read_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	read_buf, r_io_read_buf = register('r_io_read_buf','c_void_p, c_ulonglong, c_int','POINTER(RBuffer)')
	write, r_io_write = register('r_io_write','c_void_p, POINTER(c_ubyte), c_int','c_int')
	write_at, r_io_write_at = register('r_io_write_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	seek, r_io_seek = register('r_io_seek','c_void_p, c_ulonglong, c_int','c_ulonglong')
	system, r_io_system = register('r_io_system','c_void_p, c_char_p','c_int')
	close, r_io_close = register('r_io_close','c_void_p, RIODesc','c_int')
	size, r_io_size = register('r_io_size','c_void_p','c_ulonglong')
	cache_commit, r_io_cache_commit = register('r_io_cache_commit','c_void_p',None)
	cache_init, r_io_cache_init = register('r_io_cache_init','c_void_p',None)
	cache_list, r_io_cache_list = register('r_io_cache_list','c_void_p, c_bool','c_int')
	cache_reset, r_io_cache_reset = register('r_io_cache_reset','c_void_p, c_bool',None)
	cache_enable, r_io_cache_enable = register('r_io_cache_enable','c_void_p, c_bool, c_bool',None)
	cache_write, r_io_cache_write = register('r_io_cache_write','c_void_p, c_ulonglong, POINTER(POINTER(c_ubyte)), c_int',None)
	cache_read, r_io_cache_read = register('r_io_cache_read','c_void_p, c_ulonglong, POINTER(POINTER(c_ubyte)), c_int',None)
	undo_init, r_io_undo_init = register('r_io_undo_init','c_void_p','c_bool')
	undo_enable, r_io_undo_enable = register('r_io_undo_enable','c_void_p, c_bool, c_bool',None)
	plugin_open, r_io_plugin_open = register('r_io_plugin_open','c_void_p, c_int, RIOPlugin','c_bool')
	plugin_close, r_io_plugin_close = register('r_io_plugin_close','c_void_p, c_int, RIOPlugin','c_bool')
	plugin_add, r_io_plugin_add = register('r_io_plugin_add','c_void_p, RIOPlugin','c_bool')
	plugin_generate, r_io_plugin_generate = register('r_io_plugin_generate','c_void_p','c_int')
	plugin_list, r_io_plugin_list = register('r_io_plugin_list','c_void_p',None)
	map_resolve, r_io_map_resolve = register('r_io_map_resolve','c_void_p, c_int','RIOMap')
	map_add, r_io_map_add = register('r_io_map_add','c_void_p, c_int, c_int, c_ulonglong, c_ulonglong, c_ulonglong','c_bool')
	map_del, r_io_map_del = register('r_io_map_del','c_void_p, c_int','c_bool')
	section_next, r_io_section_next = register('r_io_section_next','c_void_p, c_ulonglong','c_ulonglong')
	section_list, r_io_section_list = register('r_io_section_list','c_void_p, c_ulonglong, c_bool',None)
	section_list_visual, r_io_section_list_visual = register('r_io_section_list_visual','c_void_p, c_ulonglong, c_ulonglong',None)
	section_get, r_io_section_get = register('r_io_section_get','c_void_p, c_ulonglong','RIOSection')
	section_get_offset, r_io_section_get_offset = register('r_io_section_get_offset','c_void_p, c_ulonglong','c_ulonglong')
	section_get_vaddr, r_io_section_get_vaddr = register('r_io_section_get_vaddr','c_void_p, c_ulonglong','c_ulonglong')
	section_get_rwx, r_io_section_get_rwx = register('r_io_section_get_rwx','c_void_p, c_ulonglong','c_int')
	section_overlaps, r_io_section_overlaps = register('r_io_section_overlaps','c_void_p, RIOSection','c_bool')
	section_vaddr_to_offset, r_io_section_vaddr_to_offset = register('r_io_section_vaddr_to_offset','c_void_p, c_ulonglong','c_ulonglong')
	section_offset_to_vaddr, r_io_section_offset_to_vaddr = register('r_io_section_offset_to_vaddr','c_void_p, c_ulonglong','c_ulonglong')
	desc_add, r_io_desc_add = register('r_io_desc_add','c_void_p, POINTER(RIODesc)',None)
	desc_del, r_io_desc_del = register('r_io_desc_del','c_void_p, c_int','c_bool')

class RBreakpoint(Structure): #46
	_fields_ = [
		("bps", c_void_p),
		("traces", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)
		r_bp_new = lib.r_bp_new
		r_bp_new.restype = c_void_p
		self._o = r_bp_new ()

	_o = AddressHolder()

	use, r_bp_use = register('r_bp_use','c_void_p, c_char_p','c_bool')
	enable, r_bp_enable = register('r_bp_enable','c_void_p, c_ulonglong, c_bool',None)
	at_addr, r_bp_at_addr = register('r_bp_at_addr','c_void_p, c_ulonglong, c_int','RBreakpointItem')
	add_sw, r_bp_add_sw = register('r_bp_add_sw','c_void_p, c_ulonglong, c_int, c_int','RBreakpointItem')
	add_hw, r_bp_add_hw = register('r_bp_add_hw','c_void_p, c_ulonglong, c_int, c_int','RBreakpointItem')
	add_fault, r_bp_add_fault = register('r_bp_add_fault','c_void_p, c_ulonglong, c_int, c_int','c_bool')
	add_cond, r_bp_add_cond = register('r_bp_add_cond','c_void_p, c_char_p','c_int')
	_del, r_bp_del = register('r_bp_del','c_void_p, c_ulonglong','c_bool')
	del_cond, r_bp_del_cond = register('r_bp_del_cond','c_void_p, c_int','c_bool')
	set_trace, r_bp_set_trace = register('r_bp_set_trace','c_void_p, c_ulonglong, c_int','c_int')
	restore, r_bp_restore = register('r_bp_restore','c_void_p, c_bool','c_int')
	recoil, r_bp_recoil = register('r_bp_recoil','c_void_p, c_ulonglong','c_int')
	list, r_bp_list = register('r_bp_list','c_void_p, c_bool','c_int')
	traptrace_enable, r_bp_traptrace_enable = register('r_bp_traptrace_enable','c_void_p, c_bool',None)
	traptrace_reset, r_bp_traptrace_reset = register('r_bp_traptrace_reset','c_void_p, c_bool',None)
	traptrace_next, r_bp_traptrace_next = register('r_bp_traptrace_next','c_void_p, c_ulonglong','c_ulonglong')
	traptrace_add, r_bp_traptrace_add = register('r_bp_traptrace_add','c_void_p, c_ulonglong, c_ulonglong','c_int')
	traptrace_free_at, r_bp_traptrace_free_at = register('r_bp_traptrace_free_at','c_void_p, c_ulonglong','c_int')
	traptrace_list, r_bp_traptrace_list = register('r_bp_traptrace_list','c_void_p',None)
	traptrace_at, r_bp_traptrace_at = register('r_bp_traptrace_at','c_void_p, c_ulonglong, c_int','c_int')

class RBreakpointItem(Structure): #47
	_fields_ = [
	]
class RBreakpointTrace(Structure): #48
	_fields_ = [
	]
class RDebug(Structure): #49
	_fields_ = [
		("arch", c_int),
		("bits", c_int),
		("pid", c_int),
		("tid", c_int),
		("swstep", c_bool),
		("steps", c_int),
		("newstate", c_int),
		("reason", c_int),
		("signum", c_int),
		("bp", RBreakpoint),
	]
	def __init__(self, hard):
		Structure.__init__(self)
		r_debug_new = lib.r_debug_new
		r_debug_new.restype = c_void_p
		self._o = r_debug_new (hard)

	_o = AddressHolder()

	use, r_debug_use = register('r_debug_use','c_void_p, c_char_p','c_bool')
	attach, r_debug_attach = register('r_debug_attach','c_void_p, c_int','c_bool')
	detach, r_debug_detach = register('r_debug_detach','c_void_p, c_int','c_bool')
	start, r_debug_start = register('r_debug_start','c_void_p, c_char_p','c_bool')
	stop_reason, r_debug_stop_reason = register('r_debug_stop_reason','c_void_p','c_long')
	hold, r_debug_wait = register('r_debug_wait','c_void_p','c_bool')
	is_dead, r_debug_is_dead = register('r_debug_is_dead','c_void_p','c_bool')
	kill, r_debug_kill = register('r_debug_kill','c_void_p, c_int, c_int, c_int','c_bool')
	kill_setup, r_debug_kill_setup = register('r_debug_kill_setup','c_void_p, c_int, c_int','c_bool')
	select, r_debug_select = register('r_debug_select','c_void_p, c_int, c_int','c_bool')
	step, r_debug_step = register('r_debug_step','c_void_p, c_int','c_bool')
	step_over, r_debug_step_over = register('r_debug_step_over','c_void_p, c_int','c_bool')
	cont, r_debug_continue = register('r_debug_continue','c_void_p','c_bool')
	continue_kill, r_debug_continue_kill = register('r_debug_continue_kill','c_void_p, c_int','c_bool')
	continue_until, r_debug_continue_until = register('r_debug_continue_until','c_void_p, c_ulonglong','c_bool')
	continue_until_optype, r_debug_continue_until_optype = register('r_debug_continue_until_optype','c_void_p, c_int, c_int','c_bool')
	continue_until_nontraced, r_debug_continue_until_nontraced = register('r_debug_continue_until_nontraced','c_void_p','c_bool')
	continue_syscall, r_debug_continue_syscall = register('r_debug_continue_syscall','c_void_p, c_int','c_bool')
	map_dealloc, r_debug_map_dealloc = register('r_debug_map_dealloc','c_void_p, RDebugMap','c_bool')
	map_list, r_debug_map_list = register('r_debug_map_list','c_void_p, c_ulonglong, c_bool',None)
	map_get, r_debug_map_get = register('r_debug_map_get','c_void_p, c_ulonglong','RDebugMap')
	map_alloc, r_debug_map_alloc = register('r_debug_map_alloc','c_void_p, c_ulonglong, c_int','RDebugMap')
	map_sync, r_debug_map_sync = register('r_debug_map_sync','c_void_p','c_bool')
	child_fork, r_debug_child_fork = register('r_debug_child_fork','c_void_p','c_bool')
	child_clone, r_debug_child_clone = register('r_debug_child_clone','c_void_p','c_bool')
	arg_get, r_debug_arg_get = register('r_debug_arg_get','c_void_p, c_int, c_int','c_ulonglong')
	arg_set, r_debug_arg_set = register('r_debug_arg_set','c_void_p, c_int, c_int, c_ulonglong','c_bool')
	execute, r_debug_execute = register('r_debug_execute','c_void_p, POINTER(c_ubyte), c_int, c_bool','c_ulonglong')
	desc_open, r_debug_desc_open = register('r_debug_desc_open','c_void_p, c_char_p','c_int')
	desc_close, r_debug_desc_close = register('r_debug_desc_close','c_void_p, c_int','c_int')
	desc_dup, r_debug_desc_dup = register('r_debug_desc_dup','c_void_p, c_int, c_int','c_int')
	desc_read, r_debug_desc_read = register('r_debug_desc_read','c_void_p, c_int, c_ulonglong, c_int','c_int')
	desc_seek, r_debug_desc_seek = register('r_debug_desc_seek','c_void_p, c_int, c_ulonglong','c_int')
	desc_write, r_debug_desc_write = register('r_debug_desc_write','c_void_p, c_int, c_ulonglong, c_int','c_int')
	desc_list, r_debug_desc_list = register('r_debug_desc_list','c_void_p, c_int','c_int')
	reg_sync, r_debug_reg_sync = register('r_debug_reg_sync','c_void_p, c_long, c_bool','c_bool')
	reg_list, r_debug_reg_list = register('r_debug_reg_list','c_void_p, c_int, c_int, c_bool','c_bool')
	_pids, r_debug_pids = register('r_debug_pids','c_void_p, c_int','RList<RDebugPid>')
	pid_list, r_debug_pid_list = register('r_debug_pid_list','c_void_p, c_int','c_int')
	thread_list, r_debug_thread_list = register('r_debug_thread_list','c_void_p, c_int','c_int')
	trace_reset, r_debug_trace_reset = register('r_debug_trace_reset','c_void_p',None)
	trace_pc, r_debug_trace_pc = register('r_debug_trace_pc','c_void_p','c_int')
	trace_at, r_debug_trace_at = register('r_debug_trace_at','c_void_p, c_char_p',None)
	trace_list, r_debug_trace_list = register('r_debug_trace_list','c_void_p, c_int',None)
	trace_tag, r_debug_trace_tag = register('r_debug_trace_tag','c_void_p, c_int','c_bool')
	def pids(selfpid):
		return rlist2array(self._pids(pid),RDebugPid)

class RDebugFrame(Structure): #50
	_fields_ = [
		("addr", c_ulonglong),
		("size", c_int),
	]
class RDebugPid(Structure): #51
	_fields_ = [
		("pid", c_int),
		("status", c_int),
		("runnable", c_int),
		("path", c_char_p),
	]
	def __init__(self, path, pid, status, pc):
		Structure.__init__(self)
		r_debug_pid_new = lib.r_debug_pid_new
		r_debug_pid_new.restype = c_void_p
		self._o = r_debug_pid_new (path, pid, status, pc)

	_o = AddressHolder()


class RDebugMap(Structure): #52
	_fields_ = [
		("name", c_char_p),
		("addr", c_ulonglong),
		("addr_end", c_ulonglong),
		("size", c_ulonglong),
		("file", c_char_p),
		("perm", c_int),
		("user", c_int),
	]
class RDebugTrace(Structure): #53
	_fields_ = [
	]
class RDebugTracepoint(Structure): #54
	_fields_ = [
	]
class RDiff(Structure): #55
	_fields_ = [
	]
	def __init__(self, off_a, off_b):
		Structure.__init__(self)
		r_diff_new = lib.r_diff_new
		r_diff_new.restype = c_void_p
		self._o = r_diff_new (off_a, off_b)

	_o = AddressHolder()

	buffers, r_diff_buffers = register('r_diff_buffers','c_void_p, POINTER(c_ubyte), c_int, POINTER(c_ubyte), c_int','c_int')
	buffers_distance, r_diff_buffers_distance = register('r_diff_buffers_distance','c_void_p, POINTER(c_ubyte), c_int, POINTER(c_ubyte), c_int, POINTER(c_uint), POINTER(double)','c_int')
	set_delta, r_diff_set_delta = register('r_diff_set_delta','c_void_p, c_int','c_bool')

class RDiffOp(Structure): #56
	_fields_ = [
		("a_off", c_ulonglong),
		("a_buf", POINTER(c_ubyte)),
		("a_len", c_int),
		("b_off", c_ulonglong),
		("b_buf", POINTER(c_ubyte)),
		("b_len", c_int),
	]
class RSearch(Structure): #57
	_fields_ = [
		("kws", c_void_p),
	]
	def __init__(self, mode):
		Structure.__init__(self)
		r_search_new = lib.r_search_new
		r_search_new.restype = c_void_p
		self._o = r_search_new (mode)

	_o = AddressHolder()

	set_mode, r_search_set_mode = register('r_search_set_mode','c_void_p, c_long','c_bool')
	begin, r_search_begin = register('r_search_begin','c_void_p','c_bool')
	reset, r_search_reset = register('r_search_reset','c_void_p, c_int',None)
	update, r_search_update = register('r_search_update','c_void_p, POINTER(c_ulonglong), POINTER(c_ubyte), long','c_int')
	update_i, r_search_update_i = register('r_search_update_i','c_void_p, c_ulonglong, POINTER(c_ubyte), long','c_int')
	_find, r_search_find = register('r_search_find','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','RList<RSearchHit>')
	kw_add, r_search_kw_add = register('r_search_kw_add','c_void_p, RSearchKeyword','c_bool')
	kw_reset, r_search_kw_reset = register('r_search_kw_reset','c_void_p',None)
	set_callback, r_search_set_callback = register('r_search_set_callback','c_void_p, RSearchCallback, c_void_p',None)
	strings_update, r_search_strings_update = register('r_search_strings_update','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	def find(selfaddr, buf, len):
		return rlist2array(self._find(addr, buf, len),RSearchHit)

class RSearchKeyword(Structure): #58
	_fields_ = [
		('keyword', c_char * 128),
		('binmask', c_char * 128),
		('bin_keyword', c_ubyte * 128),
		('bin_binmask', c_ubyte * 128),
		("keyword_length", c_int),
		("binmask_length", c_int),
		("count", c_int),
		("type", c_int),
	]
	def __init__(self, str, bmask, data, icase):
		Structure.__init__(self)
		r_search_keyword_new_str = lib.r_search_keyword_new_str
		r_search_keyword_new_str.restype = c_void_p
		self._o = r_search_keyword_new_str (str, bmask, data, icase)
		r_search_keyword_new = lib.r_search_keyword_new
		r_search_keyword_new.restype = c_void_p
		self._o = r_search_keyword_new (s, sl, b, bl, data)

	_o = AddressHolder()


class RSearchHit(Structure): #59
	_fields_ = [
		("kw", RSearchKeyword),
	]
class RFlagItem(Structure): #60
	_fields_ = [
		('name', c_char * 128),
		("namehash", c_ulonglong),
		("space", c_int),
		("size", c_ulonglong),
		("offset", c_ulonglong),
		("cmd", c_char_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	set_name, r_flag_item_set_name = register('r_flag_item_set_name','c_void_p, c_char_p',None)

class RFlag(Structure): #61
	_fields_ = [
		("space_idx", c_int),
		("flags", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)
		r_flag_new = lib.r_flag_new
		r_flag_new.restype = c_void_p
		self._o = r_flag_new ()

	_o = AddressHolder()

	list, r_flag_list = register('r_flag_list','c_void_p, c_bool',None)
	get, r_flag_get = register('r_flag_get','c_void_p, c_char_p','RFlagItem')
	get_i, r_flag_get_i = register('r_flag_get_i','c_void_p, c_ulonglong','RFlagItem')
	unset, r_flag_unset = register('r_flag_unset','c_void_p, c_char_p, RFlagItem','c_bool')
	unset_i, r_flag_unset_i = register('r_flag_unset_i','c_void_p, c_ulonglong, RFlagItem','c_bool')
	sort, r_flag_sort = register('r_flag_sort','c_void_p, c_int','c_bool')
	set, r_flag_set = register('r_flag_set','c_void_p, c_char_p, c_ulonglong, c_int, c_bool',None)
	space_list, r_flag_space_list = register('r_flag_space_list','c_void_p, c_int','c_bool')
	space_get_i, r_flag_space_get_i = register('r_flag_space_get_i','c_void_p, c_int','c_char_p')
	space_get, r_flag_space_get = register('r_flag_space_get','c_void_p, c_char_p','c_int')
	space_set, r_flag_space_set = register('r_flag_space_set','c_void_p, c_char_p',None)

class RConfig(Structure): #62
	_fields_ = [
		("lock", c_bool),
		("last_notfound", c_int),
		("n_nodes", c_int),
	]
	def __init__(self, user):
		Structure.__init__(self)
		r_config_new = lib.r_config_new
		r_config_new.restype = c_void_p
		self._o = r_config_new (user)

	_o = AddressHolder()

	eval, r_config_eval = register('r_config_eval','c_void_p, c_char_p','c_int')
	get, r_config_get = register('r_config_get','c_void_p, c_char_p','c_char_p')
	get_i, r_config_get_i = register('r_config_get_i','c_void_p, c_char_p','c_ulonglong')
	node_get, r_config_node_get = register('r_config_node_get','c_void_p, c_char_p','RConfigNode')
	node_new, r_config_node_new = register('r_config_node_new','c_char_p, c_char_p','RConfigNode')
	desc, r_config_desc = register('r_config_desc','c_void_p, c_char_p, c_char_p','c_char_p')
	swap, r_config_swap = register('r_config_swap','c_void_p, c_char_p','c_int')
	set, r_config_set = register('r_config_set','c_void_p, c_char_p, c_char_p','RConfigNode')
	set_i, r_config_set_i = register('r_config_set_i','c_void_p, c_char_p, c_ulonglong','RConfigNode')
	list, r_config_list = register('r_config_list','c_void_p, c_char_p, c_bool',None)

class RConfigNode(Structure): #63
	_fields_ = [
	]
class RBinPlugin(Structure): #66
	_fields_ = [
	]
class RBinDwarfRow(Structure): #67
	_fields_ = [
		("address", c_ulonglong),
		("file", c_char_p),
		("line", c_int),
		("column", c_int),
	]
class RBinClass(Structure): #68
	_fields_ = [
		("name", c_char_p),
		("super", c_char_p),
		("index", c_int),
		("methods", c_void_p),
		("fields", c_void_p),
		("visibility", c_bool),
	]
class RBinAddr(Structure): #70
	_fields_ = [
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RBinSection(Structure): #71
	_fields_ = [
		('name', c_char * 512),
		("size", c_ulonglong),
		("vsize", c_ulonglong),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("srwx", c_ulonglong),
	]
class RBinSymbol(Structure): #72
	_fields_ = [
		('name', c_char * 512),
		('forwarder', c_char * 512),
		('bind', c_char * 512),
		('type', c_char * 512),
		("classname", c_char_p),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("size", c_ulonglong),
		("ordinal", c_ulonglong),
	]
class RBinImport(Structure): #73
	_fields_ = [
		('name', c_char * 512),
		('bind', c_char * 512),
		('type', c_char * 512),
		("ordinal", c_ulonglong),
	]
class RBinReloc(Structure): #74
	_fields_ = [
		("type", c_ubyte),
		("additive", c_ubyte),
		("import", RBinImport),
		("addend", c_longlong),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RBinInfo(Structure): #75
	_fields_ = [
		('file', c_char * 512),
		('type', c_char * 512),
		('bclass', c_char * 512),
		('rclass', c_char * 512),
		('arch', c_char * 512),
		('machine', c_char * 512),
		('os', c_char * 512),
		('subsystem', c_char * 512),
		('rpath', c_char * 512),
		("lang", c_char_p),
		("bits", c_int),
		("has_va", c_bool),
		("has_pi", c_bool),
		("big_endian", c_bool),
		("dbg_info", c_ulonglong),
	]
class RBinObject(Structure): #69
	_fields_ = [
		("baddr", c_ulonglong),
		("size", c_int),
		("sections", c_void_p),
		("imports", c_void_p),
		("symbols", c_void_p),
		("entries", c_void_p),
		("fields", c_void_p),
		("libs", c_void_p),
		("relocs", c_void_p),
		("strings", c_void_p),
		("classes", c_void_p),
		("lines", c_void_p),
		("info", RBinInfo),
		('binsym', RBinAddr * 4),
	]
class RBinArch(Structure): #65
	_fields_ = [
		("buf", RBuffer),
		("file", c_char_p),
		("size", c_int),
		("offset", c_ulonglong),
		("o", RBinObject),
		("bin_obj", c_char_p),
		("curplugin", RBinPlugin),
	]
class RBin(Structure): #64
	_fields_ = [
		("file", c_char_p),
		("cur", RBinArch),
		("narch", c_int),
	]
	def __init__(self):
		Structure.__init__(self)
		r_bin_new = lib.r_bin_new
		r_bin_new.restype = c_void_p
		self._o = r_bin_new ()

	_o = AddressHolder()

	wr_scn_resize, r_bin_wr_scn_resize = register('r_bin_wr_scn_resize','c_void_p, c_char_p, c_ulonglong','c_ulonglong')
	wr_rpath_del, r_bin_wr_rpath_del = register('r_bin_wr_rpath_del','c_void_p','c_int')
	wr_output, r_bin_wr_output = register('r_bin_wr_output','c_void_p, c_char_p','c_int')
	load, r_bin_load = register('r_bin_load','c_void_p, c_char_p, c_bool','c_int')
	create, r_bin_create = register('r_bin_create','c_void_p, POINTER(c_ubyte), c_int, POINTER(c_ubyte), c_int','RBuffer')
	use_arch, r_bin_use_arch = register('r_bin_use_arch','c_void_p, c_char_p, c_int, c_char_p','c_int')
	select, r_bin_select = register('r_bin_select','c_void_p, c_char_p, c_int, c_char_p','c_int')
	select_idx, r_bin_select_idx = register('r_bin_select_idx','c_void_p, c_int','c_int')
	list, r_bin_list = register('r_bin_list','c_void_p','c_int')
	get_baddr, r_bin_get_baddr = register('r_bin_get_baddr','c_void_p','c_ulonglong')
	get_sym, r_bin_get_sym = register('r_bin_get_sym','c_void_p, c_int','RBinAddr')
	_get_entries, r_bin_get_entries = register('r_bin_get_entries','c_void_p','RList<RBinAddr>')
	_get_fields, r_bin_get_fields = register('r_bin_get_fields','c_void_p','RList<RBinField>')
	_get_imports, r_bin_get_imports = register('r_bin_get_imports','c_void_p','RList<RBinImport>')
	_get_sections, r_bin_get_sections = register('r_bin_get_sections','c_void_p','RList<RBinSection>')
	_get_strings, r_bin_get_strings = register('r_bin_get_strings','c_void_p','RList<RBinString>')
	_get_symbols, r_bin_get_symbols = register('r_bin_get_symbols','c_void_p','RList<RBinSymbol>')
	_get_relocs, r_bin_get_relocs = register('r_bin_get_relocs','c_void_p','RList<RBinReloc>')
	_get_libs, r_bin_get_libs = register('r_bin_get_libs','c_void_p','RList<c_char_p>')
	get_info, r_bin_get_info = register('r_bin_get_info','c_void_p','RBinInfo')
	is_big_endian, r_bin_is_big_endian = register('r_bin_is_big_endian','c_void_p','c_int')
	is_stripped, r_bin_is_stripped = register('r_bin_is_stripped','c_void_p','c_int')
	is_static, r_bin_is_static = register('r_bin_is_static','c_void_p','c_int')
	has_dbg_linenums, r_bin_has_dbg_linenums = register('r_bin_has_dbg_linenums','c_void_p','c_int')
	has_dbg_syms, r_bin_has_dbg_syms = register('r_bin_has_dbg_syms','c_void_p','c_int')
	has_dbg_relocs, r_bin_has_dbg_relocs = register('r_bin_has_dbg_relocs','c_void_p','c_int')
	meta_get_line, r_bin_meta_get_line = register('r_bin_meta_get_line','c_void_p, c_ulonglong, POINTER(c_char_p), c_int, POINTER(c_int)','c_int')
	meta_get_source_line, r_bin_meta_get_source_line = register('r_bin_meta_get_source_line','c_void_p, c_ulonglong','c_char_p')
	get_object, r_bin_get_object = register('r_bin_get_object','c_void_p','RBinObject')
	def get_entries(self):
		return rlist2array(self._get_entries(),RBinAddr)
	def get_fields(self):
		return rlist2array(self._get_fields(),RBinField)
	def get_imports(self):
		return rlist2array(self._get_imports(),RBinImport)
	def get_sections(self):
		return rlist2array(self._get_sections(),RBinSection)
	def get_strings(self):
		return rlist2array(self._get_strings(),RBinString)
	def get_symbols(self):
		return rlist2array(self._get_symbols(),RBinSymbol)
	def get_relocs(self):
		return rlist2array(self._get_relocs(),RBinReloc)
	def get_libs(self):
		return rlist2array(self._get_libs(),c_char_p)

class RBinString(Structure): #76
	_fields_ = [
		('string', c_char * 512),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("ordinal", c_ulonglong),
		("size", c_ulonglong),
	]
class RBinField(Structure): #77
	_fields_ = [
		('name', c_char * 512),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RParse(Structure): #78
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_parse_new = lib.r_parse_new
		r_parse_new.restype = c_void_p
		self._o = r_parse_new ()

	_o = AddressHolder()

	list, r_parse_list = register('r_parse_list','c_void_p','c_int')
	use, r_parse_use = register('r_parse_use','c_void_p, c_char_p','c_bool')
	filter, r_parse_filter = register('r_parse_filter','c_void_p, RFlag, POINTER(c_char_p), POINTER(c_char_p), c_int','c_bool')
	assemble, r_parse_assemble = register('r_parse_assemble','c_void_p, POINTER(c_char_p), POINTER(c_char_p)','c_bool')
	parse, r_parse_parse = register('r_parse_parse','c_void_p, c_char_p, POINTER(c_char_p)','c_bool')
	c_file, r_parse_c_file = register('r_parse_c_file','c_char_p','c_char_p')
	c_string, r_parse_c_string = register('r_parse_c_string','c_char_p','c_char_p')
	is_c_file, r_parse_is_c_file = register('r_parse_is_c_file','c_char_p','c_bool')

class RLangPlugin(Structure): #80
	_fields_ = [
		("name", c_char_p),
		("desc", c_char_p),
	]
class RLang(Structure): #79
	_fields_ = [
		("cur", RLangPlugin),
	]
	def __init__(self):
		Structure.__init__(self)
		r_lang_new = lib.r_lang_new
		r_lang_new.restype = c_void_p
		self._o = r_lang_new ()

	_o = AddressHolder()

	define, r_lang_define = register('r_lang_define','c_void_p, c_char_p, c_char_p, c_void_p','c_bool')
	add, r_lang_add = register('r_lang_add','c_void_p, RLangPlugin','c_bool')
	use, r_lang_use = register('r_lang_use','c_void_p, c_char_p','c_bool')
	undef, r_lang_undef = register('r_lang_undef','c_void_p, c_char_p',None)
	list, r_lang_list = register('r_lang_list','c_void_p','c_bool')
	set_argv, r_lang_set_argv = register('r_lang_set_argv','c_void_p, c_int, POINTER(POINTER(c_char))','c_bool')
	run, r_lang_run = register('r_lang_run','c_void_p, c_char_p, c_int','c_bool')
	run_file, r_lang_run_file = register('r_lang_run_file','c_void_p, c_char_p','c_bool')
	get_by_extension, r_lang_get_by_extension = register('r_lang_get_by_extension','c_void_p, c_char_p','RLangPlugin')
	get_by_name, r_lang_get_by_name = register('r_lang_get_by_name','c_void_p, c_char_p','RLangPlugin')
	prompt, r_lang_prompt = register('r_lang_prompt','c_void_p','c_bool')

class RSign(Structure): #81
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_sign_new = lib.r_sign_new
		r_sign_new.restype = c_void_p
		self._o = r_sign_new ()

	_o = AddressHolder()


class RPrint(Structure): #82
	_fields_ = [
		("width", c_int),
		("interrupt", c_bool),
		("limit", c_int),
		("cur_enabled", c_bool),
		("cur", c_int),
		("ocur", c_int),
		("flags", c_int),
	]
	def __init__(self):
		Structure.__init__(self)
		r_print_new = lib.r_print_new
		r_print_new.restype = c_void_p
		self._o = r_print_new ()

	_o = AddressHolder()

	hexpair, r_print_hexpair = register('r_print_hexpair','c_void_p, c_char_p, c_int','c_char_p')
	set_flags, r_print_set_flags = register('r_print_set_flags','c_void_p, c_int',None)
	hexdump, r_print_hexdump = register('r_print_hexdump','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int, c_int, c_int',None)
	hexpairs, r_print_hexpairs = register('r_print_hexpairs','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int',None)
	bytes, r_print_bytes = register('r_print_bytes','c_void_p, POINTER(c_ubyte), c_int, c_char_p',None)
	c, r_print_c = register('r_print_c','c_void_p, POINTER(c_ubyte), c_int',None)
	raw, r_print_raw = register('r_print_raw','c_void_p, POINTER(c_ubyte), c_int',None)
	cursor, r_print_cursor = register('r_print_cursor','c_void_p, c_int, c_int',None)
	set_cursor, r_print_set_cursor = register('r_print_set_cursor','c_void_p, c_int, c_int, c_int',None)
	code, r_print_code = register('r_print_code','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int, c_char',None)
	date_dos, r_print_date_dos = register('r_print_date_dos','c_void_p, POINTER(c_ubyte), c_int','c_int')
	date_w32, r_print_date_w32 = register('r_print_date_w32','c_void_p, POINTER(c_ubyte), c_int','c_int')
	date_unix, r_print_date_unix = register('r_print_date_unix','c_void_p, POINTER(c_ubyte), c_int','c_int')

class RFS(Structure): #83
	_fields_ = [
		("roots", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)
		r_fs_new = lib.r_fs_new
		r_fs_new.restype = c_void_p
		self._o = r_fs_new ()

	_o = AddressHolder()

	mount, r_fs_mount = register('r_fs_mount','c_void_p, c_char_p, c_char_p, c_ulonglong','RFSRoot')
	view, r_fs_view = register('r_fs_view','c_void_p, c_int',None)
	umount, r_fs_umount = register('r_fs_umount','c_void_p, c_char_p','c_bool')
	_root, r_fs_root = register('r_fs_root','c_void_p, c_char_p','RList<RFSRoot>')
	open, r_fs_open = register('r_fs_open','c_void_p, c_char_p','RFSFile')
	close, r_fs_close = register('r_fs_close','c_void_p, RFSFile',None)
	read, r_fs_read = register('r_fs_read','c_void_p, RFSFile, c_ulonglong, c_int','c_int')
	slurp, r_fs_slurp = register('r_fs_slurp','c_void_p, c_char_p','RFSFile')
	_dir, r_fs_dir = register('r_fs_dir','c_void_p, c_char_p','RList<RFSFile>')
	_partitions, r_fs_partitions = register('r_fs_partitions','c_void_p, c_char_p, c_ulonglong','RList<RFSPartition>')
	dir_dump, r_fs_dir_dump = register('r_fs_dir_dump','c_void_p, c_char_p, c_char_p','c_int')
	_find_name, r_fs_find_name = register('r_fs_find_name','c_void_p, c_char_p, c_char_p','RList<c_char_p>')
	_find_off, r_fs_find_off = register('r_fs_find_off','c_void_p, c_char_p, c_ulonglong','RList<c_char_p>')
	prompt, r_fs_prompt = register('r_fs_prompt','c_void_p, c_char_p','c_bool')
	partition_type, r_fs_partition_type = register('r_fs_partition_type','c_char_p, c_int','c_char_p')
	partition_type_get, r_fs_partition_type_get = register('r_fs_partition_type_get','c_int','c_char_p')
	def root(selfpath):
		return rlist2array(self._root(path),RFSRoot)
	def dir(selfpath):
		return rlist2array(self._dir(path),RFSFile)
	def partitions(selfptype, delta):
		return rlist2array(self._partitions(ptype, delta),RFSPartition)
	def find_name(selfname, glob):
		return rlist2array(self._find_name(name, glob),c_char_p)
	def find_off(selfname, off):
		return rlist2array(self._find_off(name, off),c_char_p)

class RCore(Structure): #1
	_fields_ = [
		("bin", RBin),
		("config", RConfig),
		("offset", c_ulonglong),
		("blocksize", c_uint),
		("blocksize_max", c_uint),
		("block", POINTER(c_ubyte)),
		("oobi", POINTER(c_ubyte)),
		("ffio", c_int),
		("oobi_len", c_int),
		("yank_buf", POINTER(c_ubyte)),
		("yank_len", c_int),
		("yank_off", c_ulonglong),
		("tmpseek", c_int),
		("vmode", c_bool),
		("interrupted", c_int),
		("cons", RCons),
		("kv", RPair),
		("io", RIO),
		("file", RCoreFile),
		("files", c_void_p),
		("num", RNum),
		("lib", RLib),
		("rcmd", RCmd),
		("anal", RAnal),
		("assembler", RAsm),
		("reflines", RAnalRefline),
		("reflines2", RAnalRefline),
		("parser", RParse),
		("print", RPrint),
		("lang", RLang),
		("dbg", RDebug),
		("flags", RFlag),
		("search", RSearch),
		("sign", RSign),
		("fs", RFS),
		("egg", REgg),
		("cmdqueue", c_char_p),
		("lastcmd", c_char_p),
		("cmdrepeat", c_int),
		("inc", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_core_new = lib.r_core_new
		r_core_new.restype = c_void_p
		self._o = r_core_new ()

	_o = AddressHolder()

	get_cons, r_core_get_cons = register('r_core_get_cons','c_void_p','POINTER(RCons)')
	get_config, r_core_get_config = register('r_core_get_config','c_void_p','POINTER(RConfig)')
	ncast, r_core_ncast = register('r_core_ncast','c_ulonglong','RCore')
	cast, r_core_cast = register('r_core_cast','c_void_p','RCore')
	loadlibs, r_core_loadlibs = register('r_core_loadlibs','c_void_p','c_bool')
	prompt, r_core_prompt = register('r_core_prompt','c_void_p, c_bool','c_int')
	prompt_loop, r_core_prompt_loop = register('r_core_prompt_loop','c_void_p',None)
	prompt_exec, r_core_prompt_exec = register('r_core_prompt_exec','c_void_p','c_int')
	cmd, r_core_cmd = register('r_core_cmd','c_void_p, c_char_p, c_bool','c_int')
	cmd0, r_core_cmd0 = register('r_core_cmd0','c_void_p, c_char_p','c_int')
	cmd_flush, r_core_cmd_flush = register('r_core_cmd_flush','c_void_p',None)
	cmd_init, r_core_cmd_init = register('r_core_cmd_init','c_void_p',None)
	cmd_file, r_core_cmd_file = register('r_core_cmd_file','c_void_p, c_char_p','c_bool')
	cmd_command, r_core_cmd_command = register('r_core_cmd_command','c_void_p, c_char_p','c_int')
	cmd_str, r_core_cmd_str = register('r_core_cmd_str','c_void_p, c_char_p','c_char_p')
	cmd_str_pipe, r_core_cmd_str_pipe = register('r_core_cmd_str_pipe','c_void_p, c_char_p','c_char_p')
	op_str, r_core_op_str = register('r_core_op_str','c_void_p, c_ulonglong','c_char_p')
	op_anal, r_core_op_anal = register('r_core_op_anal','c_void_p, c_ulonglong','RAnalOp')
	disassemble, r_core_disassemble = register('r_core_disassemble','c_void_p, c_ulonglong','POINTER(RAsmOp)')
	disassemble_instr, r_core_disassemble_instr = register('r_core_disassemble_instr','c_void_p, c_ulonglong, c_int','c_char_p')
	disassemble_bytes, r_core_disassemble_bytes = register('r_core_disassemble_bytes','c_void_p, c_ulonglong, c_int','c_char_p')
	search_preludes, r_core_search_preludes = register('r_core_search_preludes','c_void_p','c_int')
	search_prelude, r_core_search_prelude = register('r_core_search_prelude','c_void_p, c_ulonglong, c_ulonglong, POINTER(c_ubyte), c_int, POINTER(c_ubyte), c_int','c_int')
	anal_all, r_core_anal_all = register('r_core_anal_all','c_void_p','c_bool')
	anal_search, r_core_anal_search = register('r_core_anal_search','c_void_p, c_ulonglong, c_ulonglong, c_ulonglong','c_int')
	anal_refs, r_core_anal_refs = register('r_core_anal_refs','c_void_p, c_ulonglong, c_int',None)
	anal_bb, r_core_anal_bb = register('r_core_anal_bb','c_void_p, RAnalFunction, c_ulonglong, c_int','c_int')
	anal_bb_seek, r_core_anal_bb_seek = register('r_core_anal_bb_seek','c_void_p, c_ulonglong','c_int')
	anal_fcn, r_core_anal_fcn = register('r_core_anal_fcn','c_void_p, c_ulonglong, c_ulonglong, c_int, c_int','c_int')
	anal_fcn_list, r_core_anal_fcn_list = register('r_core_anal_fcn_list','c_void_p, c_char_p, c_bool','c_int')
	anal_graph, r_core_anal_graph = register('r_core_anal_graph','c_void_p, c_ulonglong, c_int','c_int')
	anal_ref_list, r_core_anal_ref_list = register('r_core_anal_ref_list','c_void_p, c_bool','c_int')
	project_open, r_core_project_open = register('r_core_project_open','c_void_p, c_char_p','c_int')
	project_save, r_core_project_save = register('r_core_project_save','c_void_p, c_char_p','c_int')
	project_info, r_core_project_info = register('r_core_project_info','c_void_p, c_char_p','c_char_p')
	gdiff, r_core_gdiff = register('r_core_gdiff','c_void_p, POINTER(RCore)','c_int')
	rtr_help, r_core_rtr_help = register('r_core_rtr_help','c_void_p',None)
	rtr_pushout, r_core_rtr_pushout = register('r_core_rtr_pushout','c_void_p, c_char_p',None)
	rtr_list, r_core_rtr_list = register('r_core_rtr_list','c_void_p',None)
	rtr_add, r_core_rtr_add = register('r_core_rtr_add','c_void_p, c_char_p',None)
	rtr_remove, r_core_rtr_remove = register('r_core_rtr_remove','c_void_p, c_char_p',None)
	rtr_session, r_core_rtr_session = register('r_core_rtr_session','c_void_p, c_char_p',None)
	rtr_cmd, r_core_rtr_cmd = register('r_core_rtr_cmd','c_void_p, c_char_p',None)
	read_at, r_core_read_at = register('r_core_read_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_bool')
	write_at, r_core_write_at = register('r_core_write_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_bool')
	block_read, r_core_block_read = register('r_core_block_read','c_void_p, c_bool','c_int')
	block_size, r_core_block_size = register('r_core_block_size','c_void_p, c_int','c_int')
	seek, r_core_seek = register('r_core_seek','c_void_p, c_ulonglong, c_bool','c_int')
	seek_align, r_core_seek_align = register('r_core_seek_align','c_void_p, c_ulonglong, c_int','c_int')
	yank, r_core_yank = register('r_core_yank','c_void_p, c_ulonglong, c_int','c_bool')
	yank_paste, r_core_yank_paste = register('r_core_yank_paste','c_void_p, c_ulonglong, c_int','c_bool')
	visual, r_core_visual = register('r_core_visual','c_void_p, c_char_p','c_int')
	visual_cmd, r_core_visual_cmd = register('r_core_visual_cmd','c_void_p, c_int','c_int')
	serve, r_core_serve = register('r_core_serve','c_void_p, RIODesc','c_int')
	_asm_strsearch, r_core_asm_strsearch = register('r_core_asm_strsearch','c_void_p, c_char_p, c_ulonglong, c_ulonglong','RList<RCoreAsmHit>')
	_asm_bwdisassemble, r_core_asm_bwdisassemble = register('r_core_asm_bwdisassemble','c_void_p, c_ulonglong, c_int, c_int','RList<RCoreAsmHit>')
	search_cb, r_core_search_cb = register('r_core_search_cb','c_void_p, c_ulonglong, c_ulonglong, RCoreSearchCallback','c_bool')
	file_open, r_core_file_open = register('r_core_file_open','c_void_p, c_char_p, c_int, c_ulonglong','RCoreFile')
	file_close, r_core_file_close = register('r_core_file_close','c_void_p, RCoreFile','c_bool')
	file_close_fd, r_core_file_close_fd = register('r_core_file_close_fd','c_void_p, c_int','c_bool')
	file_list, r_core_file_list = register('r_core_file_list','c_void_p','c_bool')
	seek_delta, r_core_seek_delta = register('r_core_seek_delta','c_void_p, c_longlong','c_int')
	bin_load, r_core_bin_load = register('r_core_bin_load','c_void_p, c_char_p','c_bool')
	def asm_strsearch(selfinput, _from, to):
		return rlist2array(self._asm_strsearch(input, _from, to),RCoreAsmHit)
	def asm_bwdisassemble(selfaddr, n, len):
		return rlist2array(self._asm_bwdisassemble(addr, n, len),RCoreAsmHit)

class RFSPlugin(Structure): #85
	_fields_ = [
		("name", c_char_p),
		("desc", c_char_p),
	]
class RFSRoot(Structure): #86
	_fields_ = [
		("path", c_char_p),
		("delta", c_ulonglong),
		("p", RFSPlugin),
		("ptr", c_void_p),
	]
class RFSFile(Structure): #84
	_fields_ = [
		("name", c_char_p),
		("path", c_char_p),
		("off", c_ulonglong),
		("size", c_uint),
		("data", POINTER(c_ubyte)),
		("ctx", c_void_p),
		("type", c_char),
		("time", c_ulonglong),
		("p", RFSPlugin),
		("root", RFSRoot),
		("ptr", c_void_p),
	]
class RFSPartition(Structure): #87
	_fields_ = [
		("number", c_int),
		("start", c_ulonglong),
		("length", c_ulonglong),
		("index", c_int),
		("type", c_int),
	]
class RMagic(Structure): #88
	_fields_ = [
	]
	def __init__(self, flags):
		Structure.__init__(self)
		r_magic_new = lib.r_magic_new
		r_magic_new.restype = c_void_p
		self._o = r_magic_new (flags)

	_o = AddressHolder()

	file, r_magic_file = register('r_magic_file','c_void_p, c_char_p','c_char_p')
	descriptor, r_magic_descriptor = register('r_magic_descriptor','c_void_p, c_int','c_char_p')
	buffer, r_magic_buffer = register('r_magic_buffer','c_void_p, c_void_p, c_int','c_char_p')
	load, r_magic_load = register('r_magic_load','c_void_p, c_char_p','c_int')
	check, r_magic_check = register('r_magic_check','c_void_p, c_char_p','c_int')
	compile, r_magic_compile = register('r_magic_compile','c_void_p, c_char_p','c_int')
	setflags, r_magic_setflags = register('r_magic_setflags','c_void_p, c_int',None)

RCoreSearchCallback = CFUNCTYPE (RCore, c_ulonglong, POINTER(c_ubyte), c_int)
RCmdCallback = CFUNCTYPE (RCmd, c_void_p, c_char_p)
RSearchCallback = CFUNCTYPE (RSearch, RSearchKeyword, c_void_p, c_ulonglong)
