\name{pdbaln}
\alias{pdbaln}
\title{ Sequence Alignment of PDB Files }
\description{
  Create multiple sequences alignments from a list of PDB files
  returning aligned sequence and structure records.
}
\usage{
pdbaln(files, pqr = FALSE, ...)
}
\arguments{
  \item{files}{ a character vector of PDB file names. }
  \item{pqr}{ logical, if TRUE the input structures are assumed to be in
  PQR format. }
  \item{\dots}{ extra arguments passed to \code{seqaln} function. }
}
\details{
  This wrapper function calls the underlying functions \code{read.pdb},
  \code{seq.pdb}, \code{seqaln} and \code{read.fasta.pdb} returning a
  list of class \code{"3dalign"} similar to that returned by
  \code{read.fasta.pdb}.

  As these steps are often error prone it is recomended for most cases that
  the individual underlying functions are called in sequence with checks
  made on the valadity of their respective outputs to ensure sensible
  results.
}
\value{
  Returns a list of class \code{"3dalign"} with the following five
  components:
  \item{xyz}{numeric matrix of aligned C-alpha coordinates.}
  \item{resno}{character matrix of aligned residue numbers.}
  \item{b}{numeric matrix of aligned B-factor values.}
  \item{chain}{character matrix of aligned chain identifiers.}
  \item{id}{character vector of PDB sequence/structure names.}
  \item{ali}{character matrix of aligned sequences.}
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\author{ Barry Grant }
\note{ See recommendation in details section above. }
\seealso{
  \code{\link{read.pdb}}, \code{\link{seq.pdb}}, \code{\link{seqaln}},
  \code{\link{read.fasta}},\code{\link{read.fasta.pdb}},
  \code{\link{core.find}}, \code{\link{fit.xyz}}, \code{\link{read.all}}
}
\examples{
\dontrun{
files <- get.pdb(c("4q21","5p21"), URLonly=TRUE)
pdbaln(files)
}
}
\keyword{ utilities }
