% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aka.R
\name{aka}
\alias{aka}
\alias{print.aka}
\alias{str.aka}
\title{Create an alias (also known as) for an object whose a short help page and/or original help page can be viewed with .?obj.}
\usage{
aka(
  obj,
  alias = NULL,
  comment = "",
  description = NULL,
  seealso = NULL,
  example = NULL,
  url = NULL
)

\method{print}{aka}(
  x,
  hyperlink_type = getOption("hyperlink_type", default = .hyperlink_type()),
  ...
)

\method{str}{aka}(object, ...)
}
\arguments{
\item{obj}{An R object.}

\item{alias}{The full qualified name of the alias object whose help
page should be retained as \code{pkg::name}. If \code{NULL} (by default), use \code{obj}.}

\item{comment}{A comment to place in \code{obj} (will also be printed when calling
\code{.?obj}).}

\item{description}{A description of the function for the sort man page.}

\item{seealso}{A character string of functions in the form \code{fun} or \code{pkg::fun}.}

\item{example}{A character string with code for a short example.}

\item{url}{An http or https URL pointing to the help page for the function
on the Internet.}

\item{x}{An aka object}

\item{hyperlink_type}{The type of hyperlink supported. The default value
should be ok. Use \code{"none"} to suppress hyperlink, \code{"href"} for http(s)://
link that opens a web page, or \code{"help"} in RStudio to open the corresponding
help page in the Help tab.}

\item{...}{Further arguments (not used yet)}

\item{object}{An aka object}
}
\value{
The original \code{obj} with the \code{comment} attribute set or replaced with
\verb{comment =} plus a \code{src} attribute set to \verb{alias =} and \code{description},
\code{seealso}, \code{example}, and \code{url} attributes also possibly populated. If the
object is a function, its class becomes \strong{aka} and \strong{function}.
}
\description{
When a function or object is renamed, the link to its original
help page is lost in R. Using \code{aka()} (also known as) with correct \verb{alias=}
allows to keep track of the original help page and get it with \code{.?obj}.
Moreover, one can also populate a short man page with description, seealso and example or add a short comment message that is displayed at the
same time in the R console.
}
\examples{
# Say you prefer is.true() similar to is.na() or is.null()
# but R provides isTRUE().
library(svMisc)
# Also defining a short man page
is.true <- aka(isTRUE, description = "Check if an object is TRUE.",
  seealso = c("is.false", "logical"), example = c("is.true(TRUE)", "is.true(FALSE)", "is.true(NA)"))
# This way, you still got access to the right help page for is.true()
\dontrun{
.?is.true
}
}
