% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcfcs.finegray.R
\name{smcfcs.finegray}
\alias{smcfcs.finegray}
\title{Substantive model compatible fully conditional specification imputation of
covariates for a Fine-Gray model}
\usage{
smcfcs.finegray(
  originaldata,
  smformula,
  method,
  cause = 1,
  m = 5,
  numit = 10,
  rjlimit = 5000,
  kmi_args = list(formula = ~1, bootstrap = FALSE, nboot = 10),
  ...
)
}
\arguments{
\item{originaldata}{The original data frame with missing values.}

\item{smformula}{The formula of the substantive model, given as a string. Needs to
be of the form "Surv(t, d) ~ x1 + x2", where t is a vector of competing event
times, and d is a (numeric) competing event indicator, where 0 must designate
a censored observation.}

\item{method}{A required vector of strings specifying for each variable either
that it does not need to be imputed (""), the type of regression model to be
be used to impute. Possible values are \code{"norm"} (normal linear regression),
\code{"logreg"} (logistic regression), \code{"brlogreg"} (bias reduced logistic regression),
\code{"poisson"} (Poisson regression),
\code{"podds"} (proportional odds regression for ordered categorical variables),
\code{"mlogit"} (multinomial logistic regression for unordered categorical variables),
or a custom expression which defines a passively imputed variable, e.g.
\code{"x^2"} or \code{"x1*x2"}. \code{"latnorm"} indicates the variable is a latent
normal variable which is measured with error. If this is specified for a variable,
the \code{"errorProneMatrix"} argument should also be used.}

\item{cause}{Numeric, designating the competing event of interest (default is
`cause = 1`).}

\item{m}{The number of imputed datasets to generate. The default is 5.}

\item{numit}{The number of iterations to run when generating each imputation.
In a (limited) range of simulations good performance was obtained with the
default of 10 iterations. However, particularly when the proportion of missingness
is large, more iterations may be required for convergence to stationarity.}

\item{rjlimit}{Specifies the maximum number of attempts which should be made
when using rejection sampling to draw from imputation models. If the limit is reached
when running a warning will be issued. In this case it is probably advisable to
increase the \code{rjlimit} until the warning does not appear.}

\item{kmi_args}{List, containing arguments to be passed on to \link[kmi]{kmi}.
The "formula" element is a formula where the right-hand side specifies the
covariates used for multiply imputing the potential censoring times for
individual's failing from competing events. The default is `formula = ~ 1`,
which uses marginal Kaplan-Meier estimator of the censoring distribution.}

\item{...}{Additional arguments to pass on to \link[smcfcs]{smcfcs}}
}
\value{
An object of type "smcfcs", as would usually be returned from
\link[smcfcs]{smcfcs}.
}
\description{
Multiply imputes missing covariate values using substantive model compatible
fully conditional specification for competing risks outcomes, when the
substantive model is a Fine-Gray model for the subdistribution hazard of one event.
}
\details{
In the presence of random right censoring, the function first multiply imputes
the potential censoring times for those failing from competing events using
\link[kmi]{kmi}, and thereafter uses \link[smcfcs]{smcfcs} to impute the missing
covariates. See Bonneville \emph{et al.} 2024 for further details on the methodology.

The function does not (yet) support parallel computation.
}
\examples{
\dontrun{
library(survival)
library(kmi)

imps <- smcfcs.finegray(
  originaldata = ex_finegray,
  smformula = "Surv(times, d) ~ x1 + x2",
  method = c("", "", "logreg", "norm"),
  cause = 1,
  kmi_args = list("formula" = ~ 1)
)

if (requireNamespace("mitools", quietly = TRUE)) {
  library(mitools)
  impobj <- imputationList(imps$impDatasets)
  # Important: use Surv(newtimes, newevent) ~ ... when pooling
  # (respectively: subdistribution time and indicator for cause of interest)
  models <- with(impobj, coxph(Surv(newtimes, newevent) ~ x1 + x2))
  summary(MIcombine(models))
}
}

}
\references{
Bonneville EF, Beyersmann J, Keogh RH, Bartlett JW, Morris TP,
Polverelli N, de Wreede LC, Putter H. Multiple imputation of missing covariates
when using the Fine--Gray model. 2024. Submitted.
}
\author{
Edouard F. Bonneville \email{e.f.bonneville@lumc.nl}
}
