% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXServiceProvider.R, R/SDMXServiceProvider-methods.R
\docType{class}
\name{SDMXServiceProvider}
\alias{SDMXServiceProvider}
\alias{SDMXServiceProvider,SDMXServiceProvider-method}
\alias{SDMXServiceProvider-class}
\title{Class "SDMXServiceProvider"}
\usage{
SDMXServiceProvider(agencyId, name, scale, country, builder)
}
\arguments{
\item{agencyId}{an object of class "character" giving the a provider identifier}

\item{name}{an object of class "character" giving the name of the provider}

\item{scale}{an object of class "character" giving the scale of the datasource,
either "international" or "national". Default value is "international".}

\item{country}{an object of class "character" giving the ISO 3-alpha code of
the country (if scale is "national"). Default value is \code{NA}}

\item{builder}{an object of class "SDMXRequestBuilder" that will performs the
web request building for this specific provider}
}
\value{
an object of class "SDMXServiceProvider"
}
\description{
A basic class to handle a SDMX service provider
}
\section{Slots}{

\describe{
\item{\code{agencyId}}{an object of class "character" giving the a provider identifier}

\item{\code{name}}{an object of class "character" giving the name of the provider}

\item{\code{scale}}{an object of class "character" giving the scale of the datasource,
either "international" or "national"}

\item{\code{country}}{an object of class "character" giving the ISO 3-alpha code of
the country (if scale is "national")}

\item{\code{builder}}{an object of class "SDMXRequestBuilder" that will performs the
      web request building}
}}
\examples{
#let's create a SDMXRESTRequestBuilder
  #(assuming that "My Organization" implements SDMX REST web-services)
  myBuilder <- SDMXRESTRequestBuilder(regUrl = "http://www.myorg.org/registry",
                                      repoUrl = "http://www.myorg.org/repository",
                                      compliant = TRUE)

  #create a SDMXServiceProvider
  provider <- SDMXServiceProvider(agencyId = "MYORG", name = "My Organization",
                                  builder = myBuilder)
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}

Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}

