\name{emodel.object}
\alias{emodel.object}
\title{Developer documentation: misclassification model structure object}
\description{
  A list giving information about the misclassifications assumed in a
  multi-state model fitted with the \code{ematrix} argument of
  \code{\link{msm}}.  Returned in a fitted \code{\link{msm}} model object.
  This information is converted internally to a \code{hmodel}
  object (see \code{\link{hmodel.object}}) for use in likelihood computations.
}
\value{
  \item{nstates}{Number of states (same as \code{qmodel$nstates}).}
  \item{npars}{Number of allowed misclassifications, equal to \code{sum(imatrix)}.}
  \item{imatrix}{Indicator matrix for allowed misclassifications.  This has
    \eqn{(r,s)} entry 1 if misclassification of true state \eqn{r} as
    observed state \eqn{s} is possible.
    diagonal entries are arbitrarily set to 0.}
  \item{ematrix}{Matrix of initial values for the misclassification probabilities, supplied as the \code{ematrix} argument of \code{\link{msm}}.}
  \item{inits}{Vector of these initial values, reading across rows of
    \code{qmatrix} and excluding the diagonal and disallowed transitions.}
  \item{constr}{Indicators for equality constraints on baseline misclassification
    probabilities, taken from the \code{econstraint} argument to
    \code{\link{msm}}, and mapped if necessary to the set (1,2,3,...)}
  \item{ndpars}{Number of distinct misclassification probabilities, after applying
    equality constraints.}
  \item{nipars}{Number of initial state occupancy probabilities being
    estimated.  This is zero if \code{est.initprobs=FALSE}, otherwise equal to
    the number of states.}
  \item{initprobs}{Initial state occupancy probabilities, as supplied to
    \code{\link{msm}} (initial values before estimation, if \code{est.initprobs=TRUE}.)}
  \item{est.initprobs}{Are initial state occupancy probabilities
    estimated (\code{TRUE} or \code{FALSE}), as supplied in the
    \code{est.initprobs} argument of \code{\link{msm}}.}
}
\seealso{
  \code{\link{msm.object}},\code{\link{qmodel.object}}, \code{\link{hmodel.object}}.
}