% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec2tab.R
\name{vec2tab}
\alias{vec2tab}
\title{Vector to array conversion}
\usage{
vec2tab(vec, dim)
}
\arguments{
\item{vec}{A vector}

\item{dim}{The desired array dimensions, oftentimes a vector of the number of
levels of each variable in order}
}
\value{
An array
}
\description{
Convert a vector into an array given a set of dimensions; it therefore simply
wraps \code{\link[=aperm]{aperm()}} and \code{\link[=array]{array()}}.
}
\details{
This function converts an array (or a multi-way contingency table) into a
vector, using a consistent ordering of the cells. The ordering of the cells
is lexicographical and cannot be specified by the user.
}
\examples{

data(Titanic)
Titanic
tab2vec(Titanic)
vec2tab(tab2vec(Titanic), dim(Titanic))
vec2tab(tab2vec(Titanic), dim(Titanic)) == Titanic
all(vec2tab(tab2vec(Titanic), dim(Titanic)) == Titanic)


}
\seealso{
\code{\link[=tab2vec]{tab2vec()}}, \code{\link[=aperm]{aperm()}}, \code{\link[=array]{array()}}
}
