% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_missing.R
\name{zap_missing}
\alias{zap_missing}
\title{Zap special missings to regular R missings}
\usage{
zap_missing(x)
}
\arguments{
\item{x}{A vector or data frame}
}
\description{
This is useful if you want to convert tagged missing values from SAS or
Stata, or user-defined missings from SPSS, to regular R \code{NA}.
}
\examples{
x1 <- labelled(
  c(1, 5, tagged_na("a", "b")),
  c(Unknown = tagged_na("a"), Refused = tagged_na("b"))
)
x1
zap_missing(x1)

x2 <- labelled_spss(
  c(1, 2, 1, 99),
  c(missing = 99),
  na_value = 99
)
x2
zap_missing(x2)

# You can also apply to data frames
df <- tibble::data_frame(x1, x2, y = 4:1)
df
zap_missing(df)
}
