% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{gh_next}
\alias{gh_next}
\alias{gh_prev}
\alias{gh_first}
\alias{gh_last}
\title{Get the next, previous, first or last page of results}
\usage{
gh_next(gh_response, .token = NULL, .send_headers = NULL)

gh_prev(gh_response, .token = NULL, .send_headers = NULL)

gh_first(gh_response, .token = NULL, .send_headers = NULL)

gh_last(gh_response, .token = NULL, .send_headers = NULL)
}
\arguments{
\item{gh_response}{An object returned by a \code{\link[=gh]{gh()}} call.}

\item{.token}{Authentication token. Defaults to \code{\link[=gh_token]{gh_token()}}.}

\item{.send_headers}{Named character vector of header field values
(except \code{Authorization}, which is handled via \code{.token}). This can be
used to override or augment the default \code{User-Agent} header:
\code{"https://github.com/r-lib/gh"}.}
}
\value{
Answer from the API.
}
\description{
Get the next, previous, first or last page of results
}
\details{
Note that these are not always defined. E.g. if the first
page was queried (the default), then there are no first and previous
pages defined. If there is no next page, then there is no
next page defined, etc.

If the requested page does not exist, an error is thrown.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- gh("/users")
vapply(x, "[[", character(1), "login")
x2 <- gh_next(x)
vapply(x2, "[[", character(1), "login")
\dontshow{\}) # examplesIf}
}
\seealso{
The \code{.limit} argument to \code{\link[=gh]{gh()}} supports fetching more than
one page.
}
