% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors-children.R
\docType{data}
\name{Error-Classes}
\alias{Error-Classes}
\alias{HTTPContinue}
\alias{HTTPSwitchProtocol}
\alias{HTTPProcessing}
\alias{HTTPOK}
\alias{HTTPCreated}
\alias{HTTPAccepted}
\alias{HTTPNonAuthoritativeInformation}
\alias{HTTPNoContent}
\alias{HTTPResetContent}
\alias{HTTPPartialContent}
\alias{HTTPMultiStatus}
\alias{HTTPAlreadyReported}
\alias{HTTPImUsed}
\alias{HTTPMultipleChoices}
\alias{HTTPMovedPermanently}
\alias{HTTPFound}
\alias{HTTPSeeOther}
\alias{HTTPNotModified}
\alias{HTTPUseProxy}
\alias{HTTPSwitchProxy}
\alias{HTTPTemporaryRedirect}
\alias{HTTPPermanentRedirect}
\alias{HTTPBadRequest}
\alias{HTTPUnauthorized}
\alias{HTTPPaymentRequired}
\alias{HTTPForbidden}
\alias{HTTPNotFound}
\alias{HTTPMethodNotAllowed}
\alias{HTTPNotAcceptable}
\alias{HTTPProxyAuthenticationRequired}
\alias{HTTPRequestTimeout}
\alias{HTTPConflict}
\alias{HTTPGone}
\alias{HTTPLengthRequired}
\alias{HTTPPreconditionFailed}
\alias{HTTPRequestEntityTooLarge}
\alias{HTTPRequestURITooLong}
\alias{HTTPUnsupportedMediaType}
\alias{HTTPRequestRangeNotSatisfiable}
\alias{HTTPExpectationFailed}
\alias{HTTPTeaPot}
\alias{HTTPAuthenticationTimeout}
\alias{HTTPMethodFailure}
\alias{HTTPUnprocessableEntity}
\alias{HTTPLocked}
\alias{HTTPFailedDependency}
\alias{HTTPUnorderedCollection}
\alias{HTTPUpgradeRequired}
\alias{HTTPPreconditionRequired}
\alias{HTTPTooManyRequests}
\alias{HTTPRequestHeaderFieldsTooLarge}
\alias{HTTPLoginTimeout}
\alias{HTTPNoResponse}
\alias{HTTPRetryWith}
\alias{HTTPBlockedByWindowsParentalControls}
\alias{HTTPUnavailableForLegalReasons}
\alias{HTTPRequestHeaderTooLarge}
\alias{HTTPCertError}
\alias{HTTPNoCert}
\alias{HTTPHTTPToHTTPS}
\alias{HTTPTokenExpiredInvalid}
\alias{HTTPClientClosedRequest}
\alias{HTTPInternalServerError}
\alias{HTTPNotImplemented}
\alias{HTTPBadGateway}
\alias{HTTPServiceUnavailable}
\alias{HTTPGatewayTimeout}
\alias{HTTPHTTPVersionNotSupported}
\alias{HTTPVariantAlsoNegotiates}
\alias{HTTPInsufficientStorage}
\alias{HTTPLoopDetected}
\alias{HTTPBandwidthLimitExceeded}
\alias{HTTPNotExtended}
\alias{HTTPNetworkAuthenticationRequired}
\alias{HTTPNetworkReadTimeoutError}
\alias{HTTPNetworkConnectTimeoutError}
\title{Individual error classes}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
HTTPContinue

HTTPSwitchProtocol

HTTPProcessing

HTTPOK

HTTPCreated

HTTPAccepted

HTTPNonAuthoritativeInformation

HTTPNoContent

HTTPResetContent

HTTPPartialContent

HTTPMultiStatus

HTTPAlreadyReported

HTTPImUsed

HTTPMultipleChoices

HTTPMovedPermanently

HTTPFound

HTTPSeeOther

HTTPNotModified

HTTPUseProxy

HTTPSwitchProxy

HTTPTemporaryRedirect

HTTPPermanentRedirect

HTTPBadRequest

HTTPUnauthorized

HTTPPaymentRequired

HTTPForbidden

HTTPNotFound

HTTPMethodNotAllowed

HTTPNotAcceptable

HTTPProxyAuthenticationRequired

HTTPRequestTimeout

HTTPConflict

HTTPGone

HTTPLengthRequired

HTTPPreconditionFailed

HTTPRequestEntityTooLarge

HTTPRequestURITooLong

HTTPUnsupportedMediaType

HTTPRequestRangeNotSatisfiable

HTTPExpectationFailed

HTTPTeaPot

HTTPAuthenticationTimeout

HTTPMethodFailure

HTTPUnprocessableEntity

HTTPLocked

HTTPFailedDependency

HTTPUnorderedCollection

HTTPUpgradeRequired

HTTPPreconditionRequired

HTTPTooManyRequests

HTTPRequestHeaderFieldsTooLarge

HTTPLoginTimeout

HTTPNoResponse

HTTPRetryWith

HTTPBlockedByWindowsParentalControls

HTTPUnavailableForLegalReasons

HTTPRequestHeaderTooLarge

HTTPCertError

HTTPNoCert

HTTPHTTPToHTTPS

HTTPTokenExpiredInvalid

HTTPClientClosedRequest

HTTPInternalServerError

HTTPNotImplemented

HTTPBadGateway

HTTPServiceUnavailable

HTTPGatewayTimeout

HTTPHTTPVersionNotSupported

HTTPVariantAlsoNegotiates

HTTPInsufficientStorage

HTTPLoopDetected

HTTPBandwidthLimitExceeded

HTTPNotExtended

HTTPNetworkAuthenticationRequired

HTTPNetworkReadTimeoutError

HTTPNetworkConnectTimeoutError
}
\description{
These error classes are for each HTTP error, and inherit from
the \code{\link{Error}} class in this package.
}
\details{
In addition to what's available in \code{\link{Error}},
these classes have a single variable \code{mssg} that is the very
verbose complete message describing the HTTP condition in detail.
You can include that message in your condition by using \code{do_verbose}
(see below)

\strong{Methods}

In addition to the methods documented in \code{\link{Error}}, these methods
also have:
\itemize{
  \item \code{do_verbose(response, template)} {

  Execute condition, whether it be message, warning, or error.

  \itemize{
   \item response: is any response from \pkg{crul}, \pkg{curl}, or \pkg{httr}
  Execute condition, whether it be message, warning, error, or your
  own custom function. This method uses \code{message_template_verbose},
  and uses it's default value.
   \item template: a template to use for the verbose message, see \code{\link{Error}}
  for details
  }
  }
}
}
\examples{
if (requireNamespace("crul")) {

 library("crul")
 res <- HttpClient$new("https://httpbin.org/status/414")$get()
 x <- HTTPRequestURITooLong$new()
 x
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # behavior
 x <- HTTPRequestURITooLong$new(behavior = "warning")
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 x <- HTTPRequestURITooLong$new(behavior = "message")
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # with message template
 (x <- HTTPRequestURITooLong$new(
   message_template = "{{reason}} ............ {{status}}",
   message_template_verbose = "{{reason}} .>.>.>.>.>.> {{status}}\\n {{message}}"
 ))
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }
}

}
\seealso{
\code{\link[fauxpas]{Error}}, \code{\link[fauxpas]{http}}
}
\keyword{datasets}
