% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{datatable}
\alias{datatable}
\title{Create an HTML table widget using the DataTables library}
\usage{
datatable(
  data,
  options = list(),
  class = "display",
  callback = JS("return table;"),
  rownames,
  colnames,
  container,
  caption = NULL,
  filter = c("none", "bottom", "top"),
  escape = TRUE,
  style = "default",
  width = NULL,
  height = NULL,
  elementId = NULL,
  fillContainer = getOption("DT.fillContainer", NULL),
  autoHideNavigation = getOption("DT.autoHideNavigation", NULL),
  selection = c("multiple", "single", "none"),
  extensions = list(),
  plugins = NULL,
  editable = FALSE
)
}
\arguments{
\item{data}{a data object (either a matrix or a data frame)}

\item{options}{a list of initialization options (see
\url{https://datatables.net/reference/option/}); the character options
wrapped in \code{\link[htmlwidgets]{JS}()} will be treated as literal
JavaScript code instead of normal character strings; you can also set
options globally via \code{\link{options}(DT.options = list(...))}, and
global options will be merged into this \code{options} argument if set}

\item{class}{the CSS class(es) of the table; see
\url{https://datatables.net/manual/styling/classes}}

\item{callback}{the body of a JavaScript callback function with the argument
\code{table} to be applied to the DataTables instance (i.e. \code{table})}

\item{rownames}{\code{TRUE} (show row names) or \code{FALSE} (hide row names)
or a character vector of row names; by default, the row names are displayed
in the first column of the table if exist (not \code{NULL})}

\item{colnames}{if missing, the column names of the data; otherwise it can be
an unnamed character vector of names you want to show in the table header
instead of the default data column names; alternatively, you can provide a
\emph{named} numeric or character vector of the form \code{'newName1' = i1,
'newName2' = i2} or \code{c('newName1' = 'oldName1', 'newName2' =
'oldName2', ...)}, where \code{newName} is the new name you want to show in
the table, and \code{i} or \code{oldName} is the index of the current
column name}

\item{container}{a sketch of the HTML table to be filled with data cells; by
default, it is generated from \code{htmltools::tags$table()} with a table
header consisting of the column names of the data}

\item{caption}{the table caption; a character vector or a tag object
generated from \code{htmltools::tags$caption()}}

\item{filter}{whether/where to use column filters; \code{none}: no filters;
\code{bottom/top}: put column filters at the bottom/top of the table; range
sliders are used to filter numeric/date/time columns, select lists are used
for factor columns, and text input boxes are used for character columns; if
you want more control over the styles of filters, you can provide a list to
this argument of the form \code{list(position = 'top', clear = TRUE, plain
= FALSE)}, where \code{clear} indicates whether you want the clear buttons
in the input boxes, and \code{plain} means if you want to use Bootstrap
form styles or plain text input styles for the text input boxes}

\item{escape}{whether to escape HTML entities in the table: \code{TRUE} means
to escape the whole table, and \code{FALSE} means not to escape it;
alternatively, you can specify numeric column indices or column names to
indicate which columns to escape, e.g. \code{1:5} (the first 5 columns),
\code{c(1, 3, 4)}, or \code{c(-1, -3)} (all columns except the first and
third), or \code{c('Species', 'Sepal.Length')}; since the row names take
the first column to display, you should add the numeric column indices
by one when using \code{rownames}}

\item{style}{the style name (\url{https://datatables.net/manual/styling/});
currently only \code{'default'}, \code{'bootstrap'}, and
\code{'bootstrap4'} are supported. Note that DT doesn't contain the theme
files so in order to display the style correctly, you have to link
the necessary files in the header.}

\item{width, height}{Width/Height in pixels (optional, defaults to automatic
sizing)}

\item{elementId}{An id for the widget (a random string by default).}

\item{fillContainer}{\code{TRUE} to configure the table to automatically fill
it's containing element. If the table can't fit fully into it's container
then vertical and/or horizontal scrolling of the table cells will occur.}

\item{autoHideNavigation}{\code{TRUE} to automatically hide navigational UI
(only display the table body) when the number of total records is less
than the page size. Note, it only works on the client-side processing mode
and the `pageLength` option should be provided explicitly.}

\item{selection}{the row/column selection mode (single or multiple selection
or disable selection) when a table widget is rendered in a Shiny app;
alternatively, you can use a list of the form \code{list(mode = 'multiple',
selected = c(1, 3, 8), target = 'row', selectable = c(-2, -3))} to
pre-select rows and control the selectable range; the element
\code{target} in the list can be \code{'column'} to enable column
selection, or \code{'row+column'} to make it possible to select both rows
and columns (click on the footer to select columns), or \code{'cell'} to
select cells. See details section for more info.}

\item{extensions}{a character vector of the names of the DataTables
extensions (\url{https://datatables.net/extensions/index})}

\item{plugins}{a character vector of the names of DataTables plug-ins
(\url{https://rstudio.github.io/DT/plugins.html}).  Note that only those
plugins supported by the \code{DT} package can be used here. You can see
the available plugins by calling \code{DT:::available_plugins()}}

\item{editable}{\code{FALSE} to disable the table editor, or \code{TRUE} (or
\code{"cell"}) to enable editing a single cell. Alternatively, you can set
it to \code{"row"} to be able to edit a row, or \code{"column"} to edit a
column, or \code{"all"} to edit all cells on the current page of the table.
In all modes, start editing by doubleclicking on a cell. This argument can
also be a list of the form \code{list(target = TARGET, disable =
list(columns = INDICES))}, where \code{TARGET} can be \code{cell},
\code{row}, \code{column}, or \code{all}, and \code{INDICES} is an integer
vector of column indices. Use the list form if you want to disable editing
certain columns.}
}
\description{
This function creates an HTML widget to display rectangular data (a matrix or
data frame) using the JavaScript library DataTables.
}
\details{
\code{selection}:
  \enumerate{
    \item The argument could be a scalar string, which means the selection
      \code{mode}, whose value could be one of  \code{'multiple'} (the default),
      \code{'single'} and \code{'none'} (disable selection).
    \item When a list form is provided for this argument, only parts of the
      "full" list are allowed. The default values for non-matched elements are
      \code{list(mode = 'multiple', selected = NULL, target = 'row',
      selectable = NULL)}.
    \item \code{target} must be one of \code{'row'}, \code{'column'},
      \code{'row+column'} and \code{'cell'}.
    \item \code{selected} could be \code{NULL} or "indices".
    \item \code{selectable} could be \code{NULL}, \code{TRUE}, \code{FALSE}
      or "indices", where \code{NULL} and \code{TRUE} mean all the table is
      selectable. When \code{FALSE}, it means users can't select the table
      by the cursor (but they could still be able to select the table via
      \code{\link{dataTableProxy}}, specifying \code{ignore.selectable = TRUE}).
      If "indices", they must be all positive or non-positive values. All
      positive "indices" mean only the specified ranges are selectable while all
      non-positive "indices" mean those ranges are \emph{not} selectable.
      The "indices"' format is specified below.
    \item The "indices"' format of \code{selected} and \code{selectable}:
      when \code{target} is \code{'row'} or \code{'column'}, it should be a plain
      numeric vector; when \code{target} is \code{'row+column'}, it should be a
      list, specifying \code{rows} and \code{cols} respectively, e.g.,
      \code{list(rows = 1, cols = 2)}; when \code{target} is \code{'cell'},
      it should be a 2-col \code{matrix}, where the two values of each row
      stand for the row and column index.
    \item Note that DT has its own selection implementation and doesn't
      use the Select extension because the latter doesn't support the
      server-side processing mode well. Please set this argument to
      \code{'none'} if you really want to use the Select extension.
  }
}
\note{
You are recommended to escape the table content for security reasons
  (e.g. XSS attacks) when using this function in Shiny or any other dynamic
  web applications.
}
\examples{
library(DT)

# see the package vignette for examples and the link to website
vignette('DT', package = 'DT')

# some boring edge cases for testing purposes
m = matrix(nrow = 0, ncol = 5, dimnames = list(NULL, letters[1:5]))
datatable(m)  # zero rows
datatable(as.data.frame(m))

m = matrix(1, dimnames = list(NULL, 'a'))
datatable(m)  # one row and one column
datatable(as.data.frame(m))

m = data.frame(a = 1, b = 2, c = 3)
datatable(m)
datatable(as.matrix(m))

# dates
datatable(data.frame(
  date = seq(as.Date("2015-01-01"), by = "day", length.out = 5), x = 1:5
))
datatable(data.frame(x = Sys.Date()))
datatable(data.frame(x = Sys.time()))
}
\references{
See \url{https://rstudio.github.io/DT/} for the full
  documentation.
}
