% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colAnyNAs,xgCMatrix-method}
\alias{colAnyNAs,xgCMatrix-method}
\alias{rowAnyNAs,xgCMatrix-method}
\title{Check if any elements in a row (column) of a matrix-like object is missing}
\usage{
\S4method{colAnyNAs}{xgCMatrix}(x, rows = NULL, cols = NULL, useNames = TRUE)

\S4method{rowAnyNAs}{xgCMatrix}(x, rows = NULL, cols = NULL, useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if any elements in a row (column) of a matrix-like object is missing.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowAnyNAs}} /
\code{matrixStats::\link[matrixStats]{colAnyNAs}}.
}
\examples{
  mat <- matrix(0, nrow=10, ncol=5)
  mat[sample(seq_len(5 *10), 5)] <- NA
  sp_mat <- as(mat, "dgCMatrix")
  colAnyNAs(sp_mat)

}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:anyMissing]{rowAnyNAs}()} and
\code{matrixStats::\link[matrixStats:anyMissing]{colAnyNAs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}.
\item \code{base::\link{is.na}()} and \code{base::\link{any}()}.
}
}
