% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/382-extractDrugOBFP4.R
\name{extractDrugOBFP4}
\alias{extractDrugOBFP4}
\title{Calculate the FP4 Molecular Fingerprints}
\usage{
extractDrugOBFP4(molecules, type = c("smile", "sdf"))
}
\arguments{
\item{molecules}{R character string object containing the molecules.
See the example section for details.}

\item{type}{\code{'smile'} or \code{'sdf'}.}
}
\value{
A matrix. Each row represents one molecule,
the columns represent the fingerprints.
}
\description{
Calculate the FP4 Molecular Fingerprints
}
\details{
Calculate the 512 bit FP4 fingerprints provided by OpenBabel.
}
\examples{
mol1 = 'C1CCC1CC(CN(C)(C))CC(=O)CC'  # one molecule SMILE in a vector
mol2 = c('CCC', 'CCN', 'CCN(C)(C)', 'c1ccccc1Cc1ccccc1',
         'C1CCC1CC(CN(C)(C))CC(=O)CC')  # multiple SMILEs in a vector
mol3 = readChar(system.file('compseq/DB00860.sdf', package = 'Rcpi'),
                nchars = 1e+6)  # single molecule in a sdf file
mol4 = readChar(system.file('sysdata/OptAA3d.sdf', package = 'Rcpi'),
                nchars = 1e+6)  # multiple molecules in a sdf file

\donttest{
smifp0 = extractDrugOBFP4(mol1, type = 'smile')
smifp1 = extractDrugOBFP4(mol2, type = 'smile')
sdffp0 = extractDrugOBFP4(mol3, type = 'sdf')
sdffp1 = extractDrugOBFP4(mol4, type = 'sdf')}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{extractDrugOBFP4}
