% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProcessingStep.R
\name{ProcessingStep}
\alias{ProcessingStep}
\alias{ProcessingStep-class}
\alias{characterOrFunction-class}
\alias{show,ProcessingStep-method}
\alias{executeProcessingStep}
\title{Processing step}
\usage{
ProcessingStep(FUN = character(), ARGS = list())

\S4method{show}{ProcessingStep}(object)

executeProcessingStep(object, ...)
}
\arguments{
\item{FUN}{\code{function} or \code{character} representing a function name.}

\item{ARGS}{\code{list} of arguments to be passed along to \code{FUN}.}

\item{object}{\code{ProcessingStep} object.}

\item{...}{optional additional arguments to be passed along.}
}
\value{
The \code{ProcessingStep} function returns and object of type
\code{ProcessingStep}.
}
\description{
Class containing the function and arguments to be applied in a lazy-execution
framework.

Objects of this class are created using the \code{ProcessingStep()} function. The
processing step is executed with the \code{executeProcessingStep()} function.
}
\details{
This object contains all relevant information of a data analysis processing
step, i.e. the function and all of its arguments to be applied to the data.
This object is mainly used to record possible processing steps of a
\code{Spectra} or \code{OnDiskMSnExp} object (from the \code{Spectra} and \code{MSnbase}
packages, respectively).
}
\examples{

## Create a simple processing step object
ps <- ProcessingStep(sum)

executeProcessingStep(ps, 1:10)

}
\author{
Johannes Rainer
}
