% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_compare_mbs.R
\name{plot_compare_mbs}
\alias{plot_compare_mbs}
\title{Compare two mbs mutation profiles}
\usage{
plot_compare_mbs(
  profile1,
  profile2,
  profile_names = c("profile 1", "profile 2"),
  profile_ymax = 1,
  diff_ylim = c(-0.5, 0.5)
)
}
\arguments{
\item{profile1}{First mutation profile}

\item{profile2}{Second mutation profile}

\item{profile_names}{Character vector with names of the mutations profiles
used for plotting, default = c("profile 1", "profile 2")}

\item{profile_ymax}{Maximum value of y-axis (relative contribution) for
profile plotting. This can only be used to increase the y axis.
If bars fall outside this limit, the maximum value is
automatically increased. default = 1.}

\item{diff_ylim}{Y-axis limits for profile difference plot,
default = c(-0.5, 0.5)}
}
\value{
A ggplot2 object
}
\description{
Plots two mbs mutation profiles and their difference, reports the residual
sum of squares (RSS).
}
\examples{

## Get the mbs counts
## See 'count_mbs_contexts()' for more info on how to do this.
mbs_counts <- readRDS(system.file("states/blood_mbs_counts.rds",
  package = "MutationalPatterns"
))


## You could compare regular mutation profiles with eachother.
plot_compare_mbs(
  mbs_counts[, 1],
  mbs_counts[, 2]
)

## Or change the names of the profiles
plot_compare_mbs(mbs_counts[, 1],
  mbs_counts[, 2],
  profile_names = c("Original", "Reconstructed")
)

## You can also change the y limits.
## This can be done separately for the profiles and the different facets.
plot_compare_mbs(mbs_counts[, 1],
  mbs_counts[, 2],
  profile_ymax = 0.9,
  diff_ylim = c(-0.8, 0.8)
)

## You could also compare a reconstructed profile.
## However, the example data does not contain enough MBS variants to use NMF.
## Existing signatures have also not yet been defined.
}
\seealso{
\code{\link{plot_compare_profiles}},
\code{\link{plot_compare_dbs}},
\code{\link{plot_compare_indels}}

Other MBS: 
\code{\link{count_mbs_contexts}()},
\code{\link{plot_mbs_contexts}()}
}
\concept{MBS}
