% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineParallelPValues.R
\name{combineParallelPValues}
\alias{combineParallelPValues}
\title{Combine parallel p-values}
\usage{
combineParallelPValues(
  p.values,
  method = c("simes", "holm-min", "berger", "fisher", "pearson", "wilkinson",
    "stouffer"),
  weights = NULL,
  log.p = FALSE,
  min.n = 1,
  min.prop = 0.5
)
}
\arguments{
\item{p.values}{A list of numeric vectors of the same length, containing the p-values to be combined.}

\item{method}{String specifying the method to use to combine p-values.}

\item{weights}{A numeric vector of positive weights, with one value per vector in \code{...}.
Each weight is applied to all entries of itscorresponding vector, i.e., all p-values in that vector receive the same weight.

Alternatively, a list of numeric vectors of weights with the same structure as \code{p.values}.
Each p-value is then assigned the weight in the corresponding entry of \code{weights}.

Alternatively \code{NULL}, in which case all p-values are assigned equal weight.}

\item{log.p}{Logical scalar indicating whether the p-values in \code{p.values} are log-transformed.}

\item{min.n}{Integer scalar specifying the minimum number of individual nulls to reject when testing the joint null.}

\item{min.prop}{Numeric scalar in [0, 1], specifying the minimum proportion of individual nulls to reject when testing the joint null.}
}
\value{
A list containing:
\itemize{
\item \code{p.value}, a numeric vector of length equal to the length of each vector in \code{p.values}.
This contains the Simes p-value for each group, log-transformed if \code{log.p=TRUE}.
\item \code{representative}, an integer scalar specifying the representative test in each group.
Specifically, this refers to the index of the \emph{vector} of \code{p.values} containing the representative test.
\item \code{influential}, a list of logical vectors mirroring the structure of \code{p.values}.
Entries are \code{TRUE} for any p-value that is deemed \dQuote{influential} to the final combined p-value.
}
}
\description{
Combine p-values from parallel hypothesis tests using a variety of meta-analysis methods.
Each group of p-values is defined from the corresponding entries across all vectors.
The function processes all vectors \dQuote{in parallel} - hence the name.
}
\details{
\code{min.prop} and \code{min.n} only have an effect for \code{method="wilkinson"} and \code{"holm-min"}.

\code{weights} only has an effect for \code{method="simes"}, \code{"holm-min"} and \code{"stouffer"}.
}
\examples{
p1 <- runif(10000)
p2 <- runif(10000)
p3 <- runif(10000)

fish <- combineParallelPValues(list(p1, p2, p3), method="fisher")
hist(fish$p.value)

z <- combineParallelPValues(list(p1, p2, p3), method="stouffer", weights=1:3)
hist(z$p.value)

simes <- combineParallelPValues(list(p1, p2, p3), method="simes")
hist(simes$p.value)

berger <- combineParallelPValues(list(p1, p2, p3), method="berger")
hist(berger$p.value)

}
\author{
Aaron Lun
}
