% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{plotClassTimeSeries}
\alias{plotClassTimeSeries}
\title{Plot abundances by class}
\usage{
plotClassTimeSeries(res, formula, xlab = "Time", ylab = "Abundance",
  color0 = "black", color1 = "red", include = c("1", "class",
  "time:class"), ...)
}
\arguments{
\item{res}{Output of fitTimeSeries function}

\item{formula}{Formula for ssanova. Of the form: abundance ~ ... where ... includes any pData slot value.}

\item{xlab}{X-label.}

\item{ylab}{Y-label.}

\item{color0}{Color of samples from first group.}

\item{color1}{Color of samples from second group.}

\item{include}{Parameters to include in prediction.}

\item{...}{Extra plotting arguments.}
}
\value{
Plot for abundances of each class using a spline approach on estimated null model.
}
\description{
Plot the abundance of values for each class using 
a spline approach on the estimated full model.
}
\examples{

data(mouseData)
res = fitTimeSeries(obj=mouseData,feature="Actinobacteria",
   class="status",id="mouseID",time="relativeTime",lvl='class',B=10)
plotClassTimeSeries(res,pch=21,bg=res$data$class,ylim=c(0,8))

}
\seealso{
\code{\link{fitTimeSeries}}
}
