% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFallbackREnv.R
\name{getFallbackREnv}
\alias{getFallbackREnv}
\title{Get the path to the fallback R environment}
\usage{
getFallbackREnv()
}
\value{
String containing the path to the conda environment with a fallback version of R installed.
}
\description{
Get the path to the conda environment containing an internal R installation.
This is used as a last resort fallback for \pkg{reticulate} when there are shared library version conflicts with the current R installation.
}
\details{
If the environment does not yet exist and \code{\link{useSystemDir}} is \code{FALSE}, it is created on the fly.
Otherwise, if \code{\link{useSystemDir}} is \code{TRUE}, an error is thrown;
this is because the fallback environment should have been created by \code{\link{installConda}}, unless \code{\link{noFallbackR}} is set to \code{TRUE}.
}
\examples{
# We can't actually run getFallbackEnv() here, as it 
# either relies on basilisk already being installed or
# it has a hard-coded path to the basilisk system dir.
print("dummy test to pass BiocCheck")

}
\author{
Aaron Lun
}
