/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "KernelParametersWidget.h"

#include "ParametersWidgetBase_p.h"

#include <GTLCore/Value.h>
#include <OpenShiva/Kernel.h>
#include <GTLFragment/Metadata.h>

using namespace QtShiva;

class KernelParametersWidget::KernelParametrisation : public ParametersWidgetBase::Parametrisation {
  public:
    KernelParametrisation() : m_kernel(0) {}
    virtual const GTLCore::Metadata::Group* parameters() const;
    virtual GTLCore::String name() const;
    virtual void setParameter( const GTLCore::String& _name, GTLCore::Value );
    void setKernel( OpenShiva::Kernel* _kernel );
  private:
    OpenShiva::Kernel* m_kernel;
};

const GTLCore::Metadata::Group* KernelParametersWidget::KernelParametrisation::parameters() const
{
  if( m_kernel and m_kernel->metadata() )
  {
    return m_kernel->metadata()->parameters();
  } else {
    return 0;
  }
}

GTLCore::String KernelParametersWidget::KernelParametrisation::name() const
{
  if( m_kernel )
    return m_kernel->name();
  else
    return "No kernel";
}

void KernelParametersWidget::KernelParametrisation::setParameter( const GTLCore::String& _name, GTLCore::Value _value)
{
  m_kernel->setParameter(_name, _value);
}

void KernelParametersWidget::KernelParametrisation::setKernel( OpenShiva::Kernel* _kernel )
{
  m_kernel = _kernel;
  p->regenerateWidget();
}

struct KernelParametersWidget::Private {
  KernelParametrisation* parametrisation;
};


KernelParametersWidget::KernelParametersWidget( QWidget* parent ) : ParametersWidgetBase(parent), d(new Private)
{
  d->parametrisation = new KernelParametrisation;
  setParametrisation(d->parametrisation);
}

KernelParametersWidget::~KernelParametersWidget()
{
  delete d;
}

void KernelParametersWidget::setKernel( OpenShiva::Kernel* _kernel )
{
  d->parametrisation->setKernel(_kernel);
}
