/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmneweval.h
 * \date 21/08/2025
 * \author Olivier Langella
 * \brief add any new eval contained in a double vector
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "../psmfilescanprocessandcopy.h"
#include <QJsonObject>

namespace pappso::cbor::psm
{
/**
 * @todo write docs
 */
class PsmNewEval : public PsmFileScanProcessAndCopy
{
  public:
  /**
   * Default constructor
   */
  PsmNewEval(std::size_t buffer_scan_size,
             CborStreamWriter *cbor_output_p,
             const QString &eval_name,
             const QJsonObject &parameters);

  virtual ~PsmNewEval();

  void addEvalDoubleVector(const QString &eval_key_value_name, std::vector<double> arr_values);

  protected:
  pappso::cbor::psm::CborScanMapBase *newCborScanMap() override;
  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;

  protected:
  QJsonObject m_newEvalParameters;
  QString m_evalName;
  QString m_evalKeyValueName;
  std::vector<double> m_psmEvalValues;
  
  std::vector<double>::iterator value_it;
};
} // namespace pappso::cbor::psm
