/* ----- decode/953x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_953x3_checksums[] = {
  "c78799b48c3e879236b2919c5c975fd085612c76da5b50de8283ad6fb11874dc",
  "eb934610aad64249d580d08ef6bc1a5205485544c98c25e4742b053026125d8c",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_953x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_953x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_953x3_ITEMBYTES

static void *storage_decode_953x3_x;
static unsigned char *test_decode_953x3_x;
static void *storage_decode_953x3_s;
static unsigned char *test_decode_953x3_s;
static void *storage_decode_953x3_x2;
static unsigned char *test_decode_953x3_x2;
static void *storage_decode_953x3_s2;
static unsigned char *test_decode_953x3_s2;

#define precomputed_decode_953x3_NUM 4

static const unsigned char precomputed_decode_953x3_x[precomputed_decode_953x3_NUM][crypto_decode_ITEMS] = {
  {0,1,1,2,2,2,2,1,1,1,1,-1,1,-1,1,2,-1,2,2,1,1,-1,2,-1,0,0,1,1,2,1,-1,1,2,-1,2,-1,-1,0,1,1,1,0,1,-1,0,2,2,2,2,1,0,1,1,-1,1,1,-1,0,2,-1,1,1,-1,1,1,0,-1,2,2,1,2,1,-1,1,0,2,1,1,1,0,1,2,0,-1,2,-1,2,-1,-1,0,0,1,1,1,-1,0,0,2,2,0,-1,-1,0,2,0,2,1,1,2,-1,0,-1,1,-1,1,1,0,-1,-1,0,1,0,-1,1,2,2,-1,2,1,0,0,2,0,1,-1,2,0,-1,1,1,-1,0,2,-1,1,1,-1,1,-1,1,1,2,-1,-1,1,0,-1,0,2,2,0,1,0,-1,-1,2,0,2,-1,0,-1,0,2,1,2,1,2,1,1,2,2,1,0,1,2,-1,-1,1,1,0,-1,-1,0,-1,0,-1,-1,-1,1,-1,2,0,1,-1,0,2,-1,2,2,1,-1,2,-1,2,2,1,1,2,1,-1,2,1,1,2,0,0,2,-1,-1,0,1,0,0,2,1,2,1,-1,0,0,2,0,1,0,0,2,1,1,-1,0,1,1,2,1,1,2,-1,2,-1,2,0,-1,0,-1,0,0,2,0,2,1,0,1,1,1,0,-1,0,2,0,2,1,0,2,0,2,0,1,-1,-1,1,1,0,0,-1,2,1,1,-1,-1,2,-1,0,1,-1,0,-1,0,2,-1,2,1,2,1,1,-1,1,-1,0,0,0,1,0,2,1,1,1,1,1,-1,2,1,1,2,-1,2,-1,1,2,0,2,1,2,-1,1,1,0,2,2,0,-1,2,1,1,-1,-1,1,0,-1,-1,-1,1,1,1,1,0,-1,1,2,2,1,1,0,1,2,1,1,0,2,-1,0,-1,0,2,0,0,-1,2,1,1,1,1,0,1,-1,0,0,2,0,1,0,2,-1,2,0,2,2,2,1,2,2,0,2,2,0,0,2,2,0,2,0,1,0,0,1,1,0,0,2,1,0,0,0,1,1,0,0,1,0,2,0,2,1,0,2,0,-1,0,1,2,0,0,-1,0,2,0,0,0,1,2,0,2,0,0,-1,0,1,0,-1,0,-1,1,0,-1,-1,1,-1,0,2,2,-1,2,2,0,-1,0,2,2,2,2,1,2,1,2,-1,1,-1,-1,-1,2,2,0,2,0,1,2,-1,2,2,-1,0,-1,-1,2,2,1,2,1,0,0,2,0,-1,2,2,1,1,2,0,2,0,1,1,1,0,2,1,0,0,0,-1,0,1,1,-1,1,2,0,-1,1,2,2,0,0,1,1,2,-1,2,2,1,1,0,-1,0,2,0,1,0,0,-1,-1,0,-1,-1,-1,0,-1,1,2,2,2,2,1,2,2,2,-1,2,1,0,2,1,-1,1,2,-1,2,-1,2,1,1,-1,2,-1,1,0,0,-1,-1,-1,-1,2,1,0,1,2,1,1,2,-1,2,2,2,1,0,0,-1,-1,-1,0,1,-1,1,0,1,0,0,2,0,0,-1,-1,2,-1,2,0,2,1,1,0,2,2,-1,1,1,2,1,1,2,1,-1,2,-1,1,1,1,2,2,-1,0,2,1,1,0,0,-1,0,0,-1,1,1,1,2,2,2,0,1,2,0,-1,0,0,0,1,1,1,2,2,1,0,1,2,1,1,2,-1,-1,0,1,0,0,1,0,0,-1,1,1,1,2,-1,2,1,0,2,-1,-1,2,-1,1,1,1,1,0,-1,-1,0,0,1,0,2,1,1,2,0,2,-1,2,-1,2,-1,2,0,-1,2,-1,0,1,2,-1,1,-1,2,-1,1,1,2,2,-1,1,1,0,2,1,2,0,-1,0,1,0,1,2,0,1,0,-1,1,0,1,2,2,2,1,-1,-1,-1,1,2,-1,2,-1,-1,1,2,-1,0,0,-1,2,0,0,1,-1,2,1,1,0,1,1,-1,-1,1,-1,0,2,2,0,2,0,0,0,-1,1,1,-1,-1,0,-1,2,2,2,0,1,1,0,2,1,0,2,0,1,0,2,-1,1,1,0,1,0,1,1,-1,2,1,-1,-1,2,2,-1,1,2,-1,1,-1,1,2,-1,-1,0,1,1,1,1,2,0,-1,0,0,0,0,-1,2,2,2,0,-1,2,1,2,0,1,1,1,2,2,-1,0,2,2,-1,-1,2,2,-1,0,1,1,0,-1,0,1,0,1,1,1,0,2,1,1,0,1,1,1,2,2,0,2,-1,2,0,0,2,-1,0,-1,-1,1,0,1,2,2,1,0,-1},
  {2,2,-1,1,2,1,0,1,1,0,1,2,1,0,-1,1,1,-1,-1,-1,0,0,0,1,0,0,1,-1,1,2,1,0,-1,0,2,1,1,-1,-1,2,1,2,-1,2,2,-1,0,2,-1,2,2,2,-1,2,0,1,1,1,1,1,-1,1,0,2,2,2,-1,1,1,1,1,2,2,1,1,-1,2,0,2,-1,2,-1,-1,1,0,1,0,1,-1,-1,0,0,2,0,1,-1,2,0,-1,-1,1,2,1,1,2,1,1,2,0,0,1,-1,0,0,2,1,-1,1,0,1,0,0,-1,-1,-1,0,1,0,2,2,0,0,2,0,1,1,0,0,1,0,-1,2,0,0,-1,2,-1,1,-1,-1,0,-1,1,-1,0,2,2,-1,0,2,0,2,0,-1,0,2,0,2,2,2,2,2,-1,-1,2,2,1,1,1,0,2,-1,2,0,0,-1,2,-1,0,2,0,2,0,-1,2,0,1,1,0,1,0,-1,-1,-1,0,0,2,-1,0,-1,0,1,2,1,2,2,-1,-1,2,1,2,2,1,-1,1,2,0,2,0,0,-1,-1,1,0,0,-1,1,2,2,0,-1,1,0,-1,-1,-1,0,-1,0,1,-1,-1,0,0,2,0,2,0,2,-1,2,0,2,1,-1,1,0,0,0,-1,2,-1,1,0,1,2,2,1,0,1,1,1,2,-1,0,-1,2,2,1,-1,0,-1,2,1,-1,2,2,1,2,0,2,1,-1,0,-1,-1,2,1,0,1,1,-1,0,-1,2,0,-1,1,0,-1,0,2,2,0,-1,2,-1,-1,1,-1,0,2,-1,-1,0,1,-1,1,2,0,1,1,0,1,2,2,-1,-1,2,0,-1,2,-1,0,-1,0,-1,0,2,-1,-1,2,1,2,1,2,-1,-1,0,0,1,1,0,1,2,1,0,-1,2,2,-1,0,-1,2,1,1,-1,0,0,1,0,2,-1,1,1,-1,-1,2,1,-1,-1,-1,-1,0,0,1,-1,2,-1,-1,-1,-1,0,-1,-1,-1,2,0,2,2,0,-1,2,1,2,1,0,-1,0,0,2,0,-1,1,-1,0,0,2,1,1,0,0,1,2,1,-1,2,0,0,-1,1,2,-1,0,2,-1,0,1,-1,-1,1,-1,1,-1,-1,-1,-1,2,-1,0,2,2,0,0,-1,-1,1,2,0,2,0,-1,-1,0,1,0,-1,2,-1,-1,-1,0,1,-1,0,2,-1,-1,-1,0,2,2,2,-1,-1,0,0,1,2,1,2,0,1,-1,1,-1,2,-1,0,-1,-1,1,-1,2,-1,2,-1,-1,1,1,0,1,-1,1,2,1,-1,0,-1,1,0,2,2,-1,0,0,1,1,-1,0,-1,0,0,-1,-1,-1,1,-1,1,-1,-1,-1,2,1,2,-1,0,-1,0,2,0,1,1,2,0,-1,2,-1,-1,0,0,1,2,-1,0,1,-1,0,-1,-1,2,0,0,1,1,-1,2,1,-1,1,2,0,-1,-1,1,-1,1,-1,0,0,0,-1,0,-1,1,0,1,1,2,0,2,2,2,-1,0,2,-1,0,1,2,2,1,-1,2,-1,1,0,2,2,0,2,-1,-1,2,-1,1,2,0,1,0,2,0,0,0,-1,1,2,1,1,0,1,-1,-1,-1,-1,0,1,1,2,-1,-1,-1,-1,1,-1,2,0,2,1,0,2,2,-1,2,1,2,0,2,0,0,1,2,0,0,-1,-1,1,0,2,-1,0,0,2,2,1,-1,0,1,1,-1,0,2,0,2,0,1,2,-1,1,2,-1,0,2,2,1,1,-1,2,1,2,2,-1,0,2,0,1,0,0,-1,-1,2,-1,0,1,-1,-1,0,-1,-1,0,2,2,-1,1,0,0,0,0,0,1,0,2,1,-1,1,0,-1,2,0,2,-1,2,2,2,-1,2,1,2,0,0,1,2,1,0,2,2,0,-1,-1,0,2,2,0,1,-1,1,2,1,-1,0,-1,2,0,2,-1,2,-1,2,2,0,-1,0,2,-1,2,0,0,0,0,2,0,0,1,2,-1,2,1,-1,2,-1,-1,1,0,2,0,0,-1,-1,-1,2,2,-1,2,1,1,2,-1,-1,2,1,1,2,2,2,0,2,0,1,-1,2,0,0,2,0,2,0,0,1,0,1,-1,0,0,-1,-1,0,-1,0,-1,2,0,-1,-1,-1,2,0,1,1,1,1,1,-1,2,-1,1,1,2,-1,1,0,1,0,0,1,2,1,-1,2,2,-1,0,-1,1,0,-1,-1,-1,-1,2,2,2,-1,0,0,1,2,1,1,2,1,1,-1,1,2,1,0,2,-1,1,0,1,0,-1,0,-1,1,0,2,0,-1,1,1,-1},
  {1,0,0,1,0,0,0,1,-1,2,-1,-1,1,1,2,1,2,-1,1,2,-1,-1,1,0,-1,-1,2,1,-1,2,2,1,1,1,1,2,1,1,1,-1,0,2,0,1,0,0,-1,0,0,-1,1,2,0,2,1,2,-1,1,0,1,0,0,0,1,-1,-1,2,0,2,0,-1,-1,0,-1,-1,1,0,0,2,-1,2,0,-1,1,2,2,1,1,-1,0,2,1,0,2,1,-1,-1,-1,2,1,0,-1,0,0,2,0,0,2,2,0,1,-1,2,-1,-1,-1,0,0,2,1,-1,2,1,1,1,2,0,-1,0,0,0,1,0,2,1,2,2,1,1,1,-1,1,-1,2,2,0,2,0,2,2,0,0,1,2,-1,-1,1,1,0,1,0,-1,-1,1,-1,0,0,-1,0,1,2,1,2,1,2,2,0,-1,1,0,-1,1,-1,1,-1,2,1,-1,2,1,0,0,0,1,1,1,0,1,1,-1,1,-1,0,2,1,-1,1,2,1,-1,1,2,2,0,2,-1,1,0,-1,1,2,-1,0,2,1,2,2,1,-1,-1,-1,1,0,2,-1,2,-1,0,-1,-1,2,1,-1,0,2,2,0,2,2,-1,-1,2,1,-1,2,2,0,-1,-1,-1,1,-1,2,1,2,1,2,0,1,1,2,0,2,1,-1,-1,1,2,2,0,1,0,2,0,0,0,-1,0,1,0,0,0,2,1,-1,-1,1,0,1,0,2,1,0,0,-1,-1,-1,2,1,-1,0,1,1,1,2,1,2,0,1,0,-1,-1,0,1,2,-1,1,0,2,2,0,2,2,0,1,-1,1,-1,-1,0,-1,2,0,0,2,-1,1,-1,1,-1,0,0,0,2,1,-1,0,-1,0,1,2,0,-1,2,0,-1,-1,1,2,0,-1,1,0,-1,1,2,1,2,2,-1,-1,-1,1,1,-1,2,2,0,-1,-1,-1,0,0,2,2,2,-1,2,2,-1,2,0,0,0,0,1,1,1,2,-1,1,0,-1,2,1,-1,2,2,-1,1,2,-1,2,0,-1,0,-1,0,1,1,2,0,-1,2,2,-1,2,2,0,-1,1,2,1,1,0,0,1,1,0,1,0,1,0,0,0,1,-1,2,-1,-1,0,1,-1,2,-1,2,0,-1,1,1,2,0,2,-1,1,2,-1,1,1,2,-1,2,2,-1,-1,1,-1,1,1,2,-1,0,-1,0,-1,0,1,-1,0,-1,2,0,2,2,0,-1,1,2,2,1,-1,2,2,-1,2,1,0,-1,1,-1,-1,2,1,-1,1,-1,-1,2,-1,2,1,0,1,0,0,1,-1,0,-1,2,2,2,1,1,-1,0,2,-1,0,-1,1,-1,0,0,0,2,1,2,1,1,0,0,0,2,1,0,1,-1,2,-1,-1,1,-1,-1,2,-1,2,1,1,0,0,2,1,1,2,0,-1,-1,0,2,0,-1,2,-1,1,-1,-1,0,0,0,0,1,-1,1,2,-1,0,0,1,1,-1,0,-1,2,1,1,-1,2,-1,0,1,0,1,1,-1,-1,0,2,0,0,2,0,0,1,1,1,-1,-1,-1,-1,-1,0,2,2,2,1,-1,2,2,0,1,1,-1,0,0,-1,-1,2,1,0,1,2,0,2,-1,2,2,-1,2,-1,2,1,0,1,0,2,2,0,0,2,0,0,0,0,2,2,-1,1,0,-1,0,-1,-1,0,1,1,0,0,0,-1,0,1,0,-1,0,-1,-1,-1,1,1,2,-1,2,1,0,-1,-1,-1,1,2,-1,2,0,0,0,-1,2,2,-1,0,-1,0,2,1,0,1,0,-1,-1,2,2,0,-1,1,2,1,1,0,1,-1,0,-1,2,1,1,2,2,-1,-1,0,0,2,1,1,0,1,2,-1,1,-1,1,-1,2,0,-1,-1,2,-1,2,1,0,-1,2,0,2,1,0,0,0,1,2,2,-1,0,-1,0,0,0,1,0,2,2,2,1,-1,-1,2,-1,1,0,2,-1,2,2,2,1,1,1,2,-1,0,0,0,2,2,1,1,-1,2,2,1,0,1,0,2,2,1,2,2,2,1,0,2,-1,0,2,0,0,1,2,-1,1,-1,-1,-1,-1,0,-1,0,2,2,1,2,1,1,1,0,0,2,1,-1,1,2,-1,1,-1,2,2,-1,0,1,1,1,2,-1,2,-1,1,-1,1,1,2,0,2,2,1,1,2,-1,2,1,1,2,0,1,1,1,-1,0,1,-1,-1,1,1,-1,1,1,0,-1,1,-1,2,1,2,2,0,2,2,-1,-1,-1,1,1,1,-1,2,0,1,0,-1,2,2,0,-1,2,2,-1,2,2,2,1,0,1},
  {-1,0,2,2,1,-1,0,-1,2,2,-1,0,1,0,1,1,1,1,0,2,2,1,1,0,0,1,0,-1,1,2,2,2,1,2,0,2,-1,-1,0,1,1,1,2,2,-1,-1,-1,0,2,0,2,1,2,1,1,-1,1,-1,2,0,2,1,-1,-1,1,2,-1,0,0,2,1,2,0,-1,0,-1,2,2,2,1,0,1,2,-1,0,2,-1,2,2,0,0,0,1,0,1,-1,-1,2,0,-1,2,1,2,2,0,-1,-1,2,0,2,-1,-1,-1,0,2,0,2,1,2,0,0,2,0,0,0,-1,1,-1,0,0,2,0,1,0,1,0,2,0,1,1,2,0,2,1,-1,1,-1,2,0,2,1,2,0,-1,1,-1,-1,2,2,0,2,2,0,0,1,1,-1,-1,0,0,-1,0,0,2,1,-1,1,-1,0,1,0,-1,-1,0,-1,2,1,1,1,-1,-1,2,0,0,-1,1,2,-1,-1,-1,-1,-1,0,2,1,1,2,0,1,-1,0,1,-1,1,-1,0,0,1,2,-1,1,0,0,2,0,2,2,1,1,0,2,2,2,1,0,2,2,0,1,1,0,-1,2,-1,0,1,-1,1,0,2,2,1,0,2,2,-1,1,0,0,1,1,0,-1,-1,-1,0,0,-1,2,2,1,2,2,2,2,0,-1,2,0,-1,2,1,-1,-1,0,-1,-1,-1,2,2,2,-1,2,2,1,2,2,0,2,2,0,-1,1,2,-1,0,1,1,1,2,-1,1,0,0,1,0,-1,1,-1,2,0,-1,2,0,0,0,-1,1,0,0,2,0,0,1,2,2,2,-1,0,-1,2,2,-1,-1,0,2,0,1,0,1,0,1,0,1,2,-1,-1,0,1,1,1,1,0,2,2,1,0,2,1,0,1,-1,2,0,0,0,2,0,-1,2,0,2,0,-1,2,1,2,0,2,-1,0,1,1,2,-1,-1,-1,0,0,-1,1,-1,0,2,2,0,2,2,2,2,1,0,0,2,-1,-1,-1,-1,-1,0,1,2,-1,-1,2,2,0,1,-1,1,1,-1,1,0,1,1,1,0,2,0,0,1,0,2,1,1,0,1,1,2,2,0,1,0,1,2,1,1,0,-1,0,-1,0,2,2,1,-1,2,2,-1,-1,0,0,2,0,1,2,-1,2,1,0,2,-1,-1,0,2,-1,-1,-1,-1,2,2,-1,-1,0,2,0,2,-1,-1,0,-1,1,-1,2,1,0,0,2,0,-1,2,-1,-1,0,0,2,0,-1,1,0,1,-1,-1,1,1,-1,2,0,-1,1,1,1,0,0,-1,-1,2,0,2,-1,0,0,-1,2,0,1,0,-1,0,-1,-1,-1,2,1,-1,2,2,1,1,-1,-1,0,-1,1,0,1,0,2,1,1,-1,1,1,2,-1,2,1,2,2,0,-1,2,2,1,0,2,0,1,1,0,0,1,0,2,2,1,1,2,-1,-1,-1,-1,2,0,2,2,2,0,2,-1,-1,1,1,2,1,0,1,1,-1,-1,-1,0,-1,-1,1,0,0,2,0,0,0,1,2,1,0,2,-1,0,0,1,0,2,2,2,1,1,1,2,2,-1,-1,0,1,-1,-1,0,2,-1,-1,1,2,1,2,0,0,-1,2,0,1,1,0,1,1,1,2,2,0,1,0,1,0,2,0,1,0,2,-1,0,2,1,-1,0,0,1,-1,-1,2,1,2,0,2,2,0,-1,2,2,1,0,0,0,-1,0,-1,0,1,-1,1,2,1,1,2,1,1,1,-1,2,2,1,1,0,1,0,2,2,-1,0,0,1,-1,1,1,1,-1,0,2,2,1,2,2,2,-1,0,-1,-1,-1,-1,0,0,0,0,1,1,0,1,-1,2,1,1,0,-1,0,1,-1,2,1,0,1,-1,-1,-1,1,-1,1,2,1,1,2,1,-1,0,1,0,-1,0,2,-1,-1,0,-1,-1,1,-1,-1,0,0,-1,0,1,1,-1,2,0,2,2,0,2,-1,0,0,-1,-1,-1,-1,2,-1,0,-1,1,0,-1,1,2,2,-1,2,1,-1,1,0,1,1,-1,-1,-1,2,1,-1,2,-1,2,0,2,0,-1,0,-1,1,0,2,-1,2,-1,2,0,0,1,1,1,-1,0,-1,-1,0,1,1,0,1,1,-1,-1,0,-1,0,2,-1,1,2,-1,2,2,0,-1,0,1,-1,-1,2,2,1,2,1,0,2,2,2,-1,1,0,2,2,-1,-1,0,2,2,1,0,0,-1,0,1,-1,0,-1,0,-1,0,2,-1,0,2,-1,-1,0,-1,0,1,0,-1,2,1,2,1,2,2,0,0,2,1,-1,-1,0},
} ;

static const unsigned char precomputed_decode_953x3_s[precomputed_decode_953x3_NUM][crypto_decode_STRBYTES] = {
  {233,191,42,226,188,50,165,139,51,164,38,253,155,162,52,138,198,187,216,106,30,51,148,74,125,208,173,19,162,65,134,207,214,201,161,52,138,232,96,244,25,220,68,187,235,155,131,6,17,32,39,205,203,188,46,235,53,100,237,82,103,173,164,235,204,17,117,155,26,221,118,39,104,177,194,36,209,236,138,84,182,170,172,51,222,142,246,177,130,1,170,225,107,174,77,116,177,106,82,103,115,191,223,215,119,150,214,86,90,118,219,145,23,93,121,23,25,97,32,61,31,253,187,35,240,157,243,4,239,214,241,122,167,182,21,41,30,126,233,188,70,103,65,64,248,239,207,182,56,179,50,22,192,230,58,191,5,36,102,93,48,183,246,232,186,140,250,180,22,133,250,231,81,169,111,174,67,150,133,58,219,48,170,65,217,122,51,115,76,142,140,62,218,30,153,103,152,191,128,51,56,197,37,107,10,210,119,133,66,252,105,219,217,104,166,44,60,142,56,164,122,84,241,199,158,250,244,240,164,145,169,173,169,223,92,19,152,111,232},
  {143,155,230,134,2,149,37,110,180,194,206,211,252,156,170,216,143,234,43,55,131,153,80,39,7,174,235,37,181,152,5,100,95,167,101,92,140,16,210,211,29,221,255,240,106,115,49,221,113,154,1,53,145,251,176,47,222,5,22,126,24,16,9,117,55,183,88,49,230,155,58,241,18,203,123,75,176,41,113,24,125,12,210,144,120,154,15,199,68,52,236,14,165,185,241,196,74,217,40,44,64,201,0,1,247,177,27,117,72,173,229,114,225,52,9,34,192,244,5,222,65,198,64,210,64,63,148,123,34,19,200,12,154,184,132,61,165,68,1,34,176,19,157,30,67,57,73,112,41,139,7,34,21,97,122,63,77,190,140,125,195,120,118,133,107,2,164,3,200,109,207,222,229,5,54,245,146,210,157,227,244,202,62,157,5,147,16,244,88,149,45,198,205,207,94,110,31,244,137,75,220,204,71,115,213,229,44,131,93,192,179,14,235,223,201,117,151,73,65,196,1,167,42,163,99,150,203,19,6,240,83,174,43,110,99,70,216,161,168},
  {150,149,12,186,227,96,176,188,234,42,157,69,225,237,152,149,112,7,129,53,135,175,180,45,176,81,215,39,3,181,172,30,149,237,171,200,119,95,14,154,129,20,185,251,97,136,44,91,169,41,210,226,226,55,134,211,190,128,205,4,75,223,195,242,1,178,123,122,11,126,118,69,86,11,102,91,192,146,186,103,144,99,223,39,66,92,35,82,45,145,199,129,135,225,62,160,124,64,253,60,87,169,99,44,143,115,68,122,60,31,174,165,153,149,12,201,28,122,227,232,60,136,78,68,18,247,225,203,179,33,44,194,108,150,196,175,52,33,213,174,213,38,131,48,107,173,7,29,35,84,137,83,74,172,76,166,208,117,169,0,244,203,167,20,108,222,60,179,217,215,85,143,17,164,21,25,1,58,27,224,92,241,68,155,193,135,107,18,235,67,173,57,34,7,179,113,91,249,68,101,191,48,54,191,58,213,43,111,246,254,54,93,142,0,209,187,90,139,35,79,234,140,232,189,206,122,42,9,138,134,236,247,128,202,25,31,207,111,158},
  {244,18,79,166,218,107,25,254,222,144,250,64,183,43,114,11,78,237,17,191,57,205,87,38,28,251,193,13,116,123,93,33,117,102,167,183,200,237,33,124,95,10,69,45,146,65,172,194,133,3,208,122,146,72,57,214,189,246,219,167,49,137,189,61,150,6,20,239,127,28,11,1,63,239,247,225,164,142,101,200,113,133,117,249,19,15,157,153,57,164,218,219,38,87,199,29,123,147,14,20,210,247,111,13,64,14,159,40,166,118,217,154,126,230,26,209,203,67,157,179,13,13,240,208,13,33,91,199,80,135,9,202,161,22,220,20,103,4,44,175,16,102,43,58,251,241,118,90,246,58,192,253,13,186,41,16,88,87,110,83,246,171,15,9,13,238,197,105,234,103,118,54,45,37,236,125,188,21,145,184,174,242,154,61,37,42,189,63,1,84,105,178,70,178,9,136,235,146,209,16,8,69,202,125,83,0,19,134,207,98,10,44,115,71,216,204,165,18,164,41,68,227,124,36,188,219,143,61,244,22,73,68,211,16,25,187,95,11,241},
} ;

static void test_decode_953x3_impl(long long impl)
{
  unsigned char *x = test_decode_953x3_x;
  unsigned char *s = test_decode_953x3_s;
  unsigned char *x2 = test_decode_953x3_x2;
  unsigned char *s2 = test_decode_953x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_953x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_953x3(impl);
    printf("decode_953x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x3_implementation(impl),ntruprime_dispatch_decode_953x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_953x3;
    printf("decode_953x3 selected implementation %s compiler %s\n",ntruprime_decode_953x3_implementation(),ntruprime_decode_953x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_953x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_953x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_953x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_953x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_953x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_953x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_953x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x3")) return;
  storage_decode_953x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_953x3_x = aligned(storage_decode_953x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_953x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_953x3_s = aligned(storage_decode_953x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_953x3_x2 = callocplus(maxalloc);
  test_decode_953x3_x2 = aligned(storage_decode_953x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_953x3_s2 = callocplus(maxalloc);
  test_decode_953x3_s2 = aligned(storage_decode_953x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_953x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_953x3();++impl)
      forked(test_decode_953x3_impl,impl);
    ++test_decode_953x3_x;
    ++test_decode_953x3_s;
    ++test_decode_953x3_x2;
    ++test_decode_953x3_s2;
  }
  free(storage_decode_953x3_s2);
  free(storage_decode_953x3_x2);
  free(storage_decode_953x3_s);
  free(storage_decode_953x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

