/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class ExtendedKeyUsageExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.ExtendedKeyUsage";
    public static final String NAME = "ExtendedKeyUsage";
    public static final String USAGES = "usages";
    private Vector keyUsages;

    private void encodeThis() throws IOException {
        if (this.keyUsages == null || this.keyUsages.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.keyUsages.size(); ++i) {
            derOutputStream2.putOID((ObjectIdentifier)this.keyUsages.elementAt(i));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public ExtendedKeyUsageExtension(Vector vector) throws IOException {
        this(Boolean.FALSE, vector);
    }

    public ExtendedKeyUsageExtension(Boolean bl, Vector vector) throws IOException {
        this.keyUsages = vector;
        this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
        this.critical = bl;
        this.encodeThis();
    }

    public ExtendedKeyUsageExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
        this.critical = bl;
        int n = 0;
        byte[] byArray = null;
        try {
            n = Array.getLength(object);
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = Array.getByte(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for ExtendedKeyUsageExtension.");
        }
        this.keyUsages = new Vector(1, 1);
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            ObjectIdentifier objectIdentifier = derValue2.getOID();
            this.keyUsages.addElement(objectIdentifier);
        }
    }

    public String toString() {
        if (this.keyUsages == null) {
            return "";
        }
        return super.toString() + "ExtendedKeyUsages [\n" + this.keyUsages.toString() + "]\n";
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ExtendedKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(USAGES)) {
            if (!(object instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:ExtendedKeyUsageExtension.");
        }
        this.keyUsages = (Vector)object;
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(USAGES)) {
            return this.keyUsages;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:ExtendedKeyUsageExtension.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(USAGES)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:ExtendedKeyUsageExtension.");
        }
        this.keyUsages = null;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(USAGES);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public List getExtendedKeyUsage() {
        ArrayList arrayList = new ArrayList(this.keyUsages.size());
        for (int i = 0; i < this.keyUsages.size(); ++i) {
            arrayList.add(this.keyUsages.elementAt(i).toString());
        }
        return arrayList;
    }
}

