/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.pdf.DefaultPDFObject;
import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import de.erichseifert.vectorgraphics2d.pdf.TrueTypeFont;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class Resources
extends DefaultPDFObject {
    private static final String KEY_TRANSPARENCY = "ExtGState";
    private static final String KEY_IMAGE = "XObject";
    private static final String[] VALUE_PROC_SET = new String[]{"PDF", "Text", "ImageB", "ImageC", "ImageI"};
    private static final String PREFIX_FONT = "Fnt";
    private static final String PREFIX_IMAGE = "Img";
    private static final String PREFIX_TRANSPARENCY = "Trp";
    private final List<String> procSet;
    private final Map<String, TrueTypeFont> fontsByFontId;
    private final Map<Font, String> fontIDsByFont;
    private final Map<PDFObject, String> images;
    private final Map<Double, String> transparencies;
    private final AtomicInteger currentFontId = new AtomicInteger();
    private final AtomicInteger currentImageId = new AtomicInteger();
    private final AtomicInteger currentTransparencyId = new AtomicInteger();

    public Resources() {
        super(null, null, false);
        this.procSet = new LinkedList<String>();
        this.fontsByFontId = new HashMap<String, TrueTypeFont>();
        this.fontIDsByFont = new HashMap<Font, String>();
        this.images = new HashMap<PDFObject, String>();
        this.transparencies = new HashMap<Double, String>();
        this.setProcSet(VALUE_PROC_SET);
    }

    private <T> String getResourceId(Map<T, String> map, T t, String string, AtomicInteger atomicInteger) {
        String string2 = map.get(t);
        if (string2 == null) {
            string2 = String.format("%s%d", string, atomicInteger.getAndIncrement());
            map.put(t, string2);
        }
        return string2;
    }

    public String getId(Font font) {
        font = GraphicsUtils.getPhysicalFont(font);
        String string = this.getResourceId(this.fontIDsByFont, font, PREFIX_FONT, this.currentFontId);
        String string2 = font.getPSName();
        String string3 = "WinAnsiEncoding";
        TrueTypeFont trueTypeFont = new TrueTypeFont(string3, string2);
        this.fontsByFontId.put(string, trueTypeFont);
        return string;
    }

    public String getId(PDFObject pDFObject) {
        LinkedHashMap<String, PDFObject> linkedHashMap = (LinkedHashMap<String, PDFObject>)this.dict.get(KEY_IMAGE);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<String, PDFObject>();
            this.dict.put(KEY_IMAGE, linkedHashMap);
        }
        String string = this.getResourceId(this.images, pDFObject, PREFIX_IMAGE, this.currentImageId);
        linkedHashMap.put(string, pDFObject);
        return string;
    }

    public String getId(Double d) {
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = (LinkedHashMap<String, Map<String, Object>>)this.dict.get(KEY_TRANSPARENCY);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
            this.dict.put(KEY_TRANSPARENCY, linkedHashMap);
        }
        String string = this.getResourceId(this.transparencies, d, PREFIX_TRANSPARENCY, this.currentTransparencyId);
        linkedHashMap.put(string, DataUtils.map(new String[]{"Type", "ca", "CA"}, new Object[]{KEY_TRANSPARENCY, d, d}));
        return string;
    }

    public void setProcSet(String ... stringArray) {
        this.procSet.clear();
        for (String string : stringArray) {
            this.procSet.add(string);
        }
    }

    public List<String> getProcSet() {
        return Collections.unmodifiableList(this.procSet);
    }

    public Map<String, TrueTypeFont> getFont() {
        return Collections.unmodifiableMap(this.fontsByFontId);
    }
}

