package tests::OutputFormatsTextTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::Text;
use Lire::Config::OutputFormatSpec;
use Lire::PluginManager;
use Lire::Utils qw/tempdir/;
use File::Basename qw/dirname/;
use File::Path qw/rmtree/;
use Lire::Test::Mock;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'testdir'} = dirname( __FILE__ ) ;
    $self->{'output_cfg'} =
      new Lire::Config::OutputFormatSpec( 'name' => 'output' )->instance();
    $self->{'tmpdir'} = tempdir( $self->name() . '_XXXXXX' );
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    Lire::Test::Mock->reset_factories();
    rmtree( $self->{'tmpdir'} )
      unless $self->{'keep_tmpdir'};

}

sub create_plugin {
    return new Lire::OutputFormats::Text();
}

sub properties_spec_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_txt.xml";
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_txt_init";
}

sub test_format_report {
    my $self = $_[0];

    $self->test_registration_file();
    Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::AsciiWriter',
                                        'parsefile' => '' );
    my $txt = Lire::PluginManager->get_plugin( 'output_format', 'txt' );

    my $report = "$self->{'tmpdir'}/report.txt";
    $txt->format_report( "$self->{'testdir'}/data/test-sqlite.xml",
                         $report, { 'encoding' => 'iso-8859-1' } );
    $self->assert( -f $report, "$report should exists" );
    my ($writer) = @{Lire::Test::Mock->mock_instances( 'Lire::ReportParser::AsciiWriter' )};
    my ( $pkg, %args ) = @{$writer->get_invocation( 'new' )};
    $self->assert_str_equals( 'iso-8859-1', $args{'encoding'} );
    $self->assert_num_equals( 1, $writer->invocation_count( 'parsefile' ) );
}

sub test_mime_report {
   my $self = $_[0];

   $self->test_registration_file();
   Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::AsciiWriter',
                                       'parsefile' => '' );
   my $txt = Lire::PluginManager->get_plugin( 'output_format', 'txt' );

   my $entity = $txt->mime_report( "$self->{'testdir'}/data/test-sqlite.xml",
                                   { 'encoding' => 'iso-8859-1' } );
   $self->assert_isa( 'MIME::Entity', $entity );
   $self->assert_str_equals( 'text/plain', $entity->head()->mime_type() );
   $self->assert_str_equals( "quoted-printable\n",
                             $entity->head()->get( 'content-transfer-encoding' ) );
   $self->assert_str_equals( 'iso-8859-1',
                             $entity->head()->mime_attr( 'content-type.charset' ) );
}

1;
