package latexDraw.ui.components.progressbars;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JProgressBar;

import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.util.LaTeXDrawResources;

/** 
 * Defines an abstract progress bar manager for latexdraw.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 * <br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 * <br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 02/04/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public abstract class AbstractProgressBarManager implements Runnable, ActionListener
{
	/** The thread of the parser. */
	protected transient Thread parsingThread;
	
	/** The main frame. */
	protected LaTeXDrawFrame frame;
	
	/** The file to parse. */
	protected File fileToParse;
	
	
	
	public AbstractProgressBarManager(LaTeXDrawFrame f)
	{
		if(f==null)
			throw new IllegalArgumentException();
		
		frame = f;
		frame.getStopButton().addActionListener(this);
		fileToParse = null;
	}
	
	
	
	public void actionPerformed(ActionEvent e)
	{
		Object src = e.getSource();
		
		if(src instanceof JButton && LaTeXDrawResources.LABEL_STOP.equals(((JButton)(src)).getActionCommand()))
		{
			frame.getStopButton().setVisible(false);
			frame.getProgressBar().setVisible(false);
			frame.requestFocus();
		}
	}
	
	
	
	public void resetProgressBar()
	{
		JProgressBar progressBar 	= frame.getProgressBar();
		JButton stopButton 			= frame.getStopButton();
		
		parsingThread=null;
		progressBar.setVisible(false);
		stopButton.setVisible(false);
		fileToParse = null;
	}
	
	
	public void startProgressBar()
	{
		JProgressBar progressBar 	= frame.getProgressBar();
		JButton stopButton 			= frame.getStopButton();
		
		progressBar.setMinimum(0);
		progressBar.setVisible(true);
		
		if(stopButton!=null)
			stopButton.setVisible(true);
		
		parsingThread = new Thread(this);
		parsingThread.start();
	}


	/**
	 * @return the fileToParse.
	 * @since 2.0.0
	 */
	public File getFileToParse()
	{
		return fileToParse;
	}


	/**
	 * @param fileToParse the fileToParse to set.
	 * @since 2.0.0
	 */
	public void setFileToParse(File fileToParse)
	{
		this.fileToParse = fileToParse;
	}
}
