/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2016 TIBCO Software Inc. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.engine.xml;

import java.util.UUID;

import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

import org.xml.sax.Attributes;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 */
public class JRDatasetFactory extends JRBaseFactory
{
	
	@Override
	public Object createObject(Attributes attributes)
	{
		JRXmlLoader xmlLoader = (JRXmlLoader)digester.peek(digester.getCount() - 1);
		JRDesignDataset dataset = new JRDesignDataset(xmlLoader.getJasperReportsContext(), false);
		
		dataset.setName(attributes.getValue(JRXmlConstants.ATTRIBUTE_name));
		dataset.setScriptletClass(attributes.getValue(JRXmlConstants.ATTRIBUTE_scriptletClass));
		
		dataset.setResourceBundle(attributes.getValue(JRXmlConstants.ATTRIBUTE_resourceBundle));

		WhenResourceMissingTypeEnum whenResourceMissingType = WhenResourceMissingTypeEnum.getByName(attributes.getValue(JRXmlConstants.ATTRIBUTE_whenResourceMissingType));
		if (whenResourceMissingType != null)
		{
			dataset.setWhenResourceMissingType(whenResourceMissingType);
		}
		
		String uuid = attributes.getValue(JRXmlConstants.ATTRIBUTE_uuid);
		if (uuid != null)
		{
			dataset.setUUID(UUID.fromString(uuid));
		}

		return dataset;
	}
}
