# -*- Mode: Python; 
# vi:si:et:sw=4:sts=4:ts=4
#
# Istanbul - a Desktop session recorder
# Copyright (C) 2005 Zaheer Abbas Merali (zaheerabbas at merali dot org)
# Portions Copyright (C) 2004,2005 Fluendo S.L. (www.fluendo.com)
# All rights reserved.

# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.GPL" in the source distribution for more information.

# Headers in this file shall remain intact.

import os
import gettext, locale

def get():
    return {
        'isinstalled':   True,
        'gladedir':      os.path.join('${prefix}/share', 'istanbul', 'glade'),
        'imagedir':      os.path.join('${prefix}/share', 'istanbul', 'image'),
        'pythondir':     os.path.join('/usr/local/lib', 'istanbul', 'python'),
        'localedir':     os.path.join('${prefix}/share', 'locale'),
        'domain':       'istanbul',
        'version':       '0.2.2'
    }

config_dict = get()
for key, value in config_dict.items():
    dictionary = locals()
    dictionary[key] = value

gettext.bindtextdomain(domain, localedir)
gettext.textdomain(domain)
locale.bindtextdomain(domain, localedir)
locale.textdomain(domain)
