{- This module was generated from data in the Kate syntax
   highlighting file cmake.xml, version 1.22, by Alexander Neundorf (neundorf@kde.org) -}

module Text.Highlighting.Kate.Syntax.Cmake
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Modelines
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "CMake"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "CMakeLists.txt;*.cmake;"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("CMake","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("CMake","Normal Text") -> return ()
      ("CMake","Detect More Builtin Variables") -> return ()
      ("CMake","Detect Builtin Variables") -> return ()
      ("CMake","VarSubst") -> (popContext) >> pEndLine
      ("CMake","Detect Variables") -> return ()
      ("CMake","DetectSimpleGEEnd") -> (popContext >> popContext) >> pEndLine
      ("CMake","Generator Expression") -> (popContext) >> pEndLine
      ("CMake","Detect Generator Expressions") -> return ()
      ("CMake","Command Args") -> return ()
      ("CMake","Macro Args") -> return ()
      ("CMake","Comment") -> (popContext) >> pEndLine
      ("CMake","String") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_commands = Set.fromList $ words $ "add_custom_command add_custom_target add_definitions add_dependencies add_executable add_library add_subdirectory add_test aux_source_directory break build_command build_name cmake_minimum_required cmake_policy configure_file create_test_sourcelist define_property else elseif enable_language enable_testing endforeach endfunction endif endmacro endwhile exec_program execute_process export export_library_dependencies file find_file find_library find_package find_path find_program fltk_wrap_ui foreach function get_cmake_property get_directory_property get_filename_component get_property get_source_file_property get_target_property get_test_property if include include_directories include_external_msproject include_regular_expression install install_files install_programs install_targets link_directories link_libraries list load_cache load_command macro make_directory mark_as_advanced math message option output_required_files project qt_wrap_cpp qt_wrap_ui remove remove_definitions return separate_arguments set set_directory_properties set_property set_source_files_properties set_target_properties set_tests_properties site_name source_group string subdir_depends subdirs target_compile_definitions target_include_directories target_link_libraries try_compile try_run unset use_mangled_mesa utility_source variable_requires variable_watch while write_file"
list_itkvtk'5fcommands = Set.fromList $ words $ "itk_wrap_tcl vtk_make_instantiator vtk_wrap_java vtk_wrap_python vtk_wrap_tcl"
list_special'5fargs = Set.fromList $ words $ "AFTER ALL ALPHABET AND APPEND APPEND_STRING ARCHIVE ARGS ASCII AUTHOR_WARNING BEFORE BRIEF_DOCS BUNDLE CACHE CACHED_VARIABLE CLEAR CMAKE_FIND_ROOT_PATH_BOTH CMAKE_FLAGS CODE COMMAND COMMAND_NAME COMMENT COMPARE COMPILE_DEFINITIONS COMPILE_OUTPUT_VARIABLE COMPILE_RESULT_VAR COMPONENT COMPONENTS CONFIG CONFIGS CONFIGURATION CONFIGURATIONS CONFIGURE COPY COPYONLY COPY_FILE CRLF DEFINED DEFINITION DEPENDS DESTINATION DIRECTORY DIRECTORY_PERMISSIONS DOC DOS DOWNLOAD ENV EQUAL ERROR_FILE ERROR_QUIET ERROR_STRIP_TRAILING_WHITESPACE ERROR_VARIABLE ESCAPE_QUOTES EXACT EXCLUDE EXCLUDE_FROM_ALL EXISTS EXPECTED_HASH EXPECTED_MD5 EXPORT EXPR EXTRA_INCLUDE FATAL_ERROR FILE FILES FILES_MATCHING FILE_PERMISSIONS FIND FOLLOW_SYMLINKS FORCE FRAMEWORK FULL_DOCS FUNCTION GET GLOB GLOBAL GLOB_RECURSE GREATER GROUP_EXECUTE GROUP_READ GUID HEX HINTS IMPLICIT_DEPENDS IMPORTED IN INACTIVITY_TIMEOUT INCLUDE_INTERNALS INHERITED INPUT_FILE INSERT INSTALL INTERFACE IS_ABSOLUTE IS_DIRECTORY IS_NEWER_THAN IS_SYMLINK ITEMS LENGTH LENGTH_MAXIMUM LENGTH_MINIMUM LESS LF LIBRARY LIMIT LIMIT_COUNT LIMIT_INPUT LIMIT_OUTPUT LINK_INTERFACE_LIBRARIES LINK_LIBRARIES LINK_PRIVATE LINK_PUBLIC LISTS LOG MACOSX_BUNDLE MAIN_DEPENDENCY MAKE_DIRECTORY MATCH MATCHALL MATCHES MD5 MODULE NAME NAMELINK_ONLY NAMELINK_SKIP NAMES NAMESPACE NAMES_PER_DIR NEW NEWLINE_CONSUME NEWLINE_STYLE NOT NOTEQUAL NO_CMAKE_BUILDS_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_FIND_ROOT_PATH NO_CMAKE_PACKAGE_REGISTRY NO_CMAKE_PATH NO_CMAKE_SYSTEM_PACKAGE_REGISTRY NO_CMAKE_SYSTEM_PATH NO_DEFAULT_PATH NO_HEX_CONVERSION NO_MODULE NO_POLICY_SCOPE NO_SOURCE_PERMISSIONS NO_SYSTEM_ENVIRONMENT_PATH OBJECT OFFSET OLD ONLY_CMAKE_FIND_ROOT_PATH OPTIONAL OPTIONAL_COMPONENTS OR OUTPUT OUTPUT_DIRECTORY OUTPUT_FILE OUTPUT_QUIET OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE OWNER_EXECUTE OWNER_READ OWNER_WRITE PACKAGE PARENT_SCOPE PATHS PATH_SUFFIXES PATH_TO_MESA PATTERN PERMISSIONS PLATFORM POLICY POP POST_BUILD PREORDER PRE_BUILD PRE_LINK PRIVATE PRIVATE_HEADER PROGRAM PROGRAMS PROGRAM_ARGS PROJECT_NAME PROPERTIES PROPERTY PUBLIC PUBLIC_HEADER PUSH QUIET RANDOM RANDOM_SEED RANGE READ READ_WITH_PREFIX REGEX REGULAR_EXPRESSION RELATIVE RELATIVE_PATH REMOVE REMOVE_AT REMOVE_DUPLICATES REMOVE_ITEM REMOVE_RECURSE RENAME REPLACE REQUIRED REQUIRED_VARIABLE1 REQUIRED_VARIABLE2 RESOURCE RESULT_VAR RESULT_VARIABLE RETURN_VALUE REVERSE RUNTIME RUNTIME_DIRECTORY RUN_OUTPUT_VARIABLE RUN_RESULT_VAR SCRIPT SEND_ERROR SET SHA1 SHA224 SHA256 SHA384 SHA512 SHARED SHOW_PROGRESS SORT SOURCE SOURCES STATIC STATUS STREQUAL STRGREATER STRINGS STRIP STRLESS SUBSTRING SYSTEM TARGET TARGETS TEST TEST_VARIABLE TIMEOUT TIMESTAMP TLS_CAINFO TLS_VERIFY TOLOWER TOUPPER TO_CMAKE_PATH TO_NATIVE_PATH TYPE UNIX UNIX_COMMAND UNKNOWN UPLOAD USE_SOURCE_PERMISSIONS UTC VALUE VARIABLE VERBATIM VERSION VERSION_EQUAL VERSION_GREATER VERSION_LESS WARNING WIN32 WINDOWS_COMMAND WORKING_DIRECTORY WRITE"
list_extra'5fspecial'5fargs = Set.fromList $ words $ "PATH NAME EXT NAME_WE ABSOLUTE REALPATH FILEPATH STRING BOOL INTERNAL"
list_properties = Set.fromList $ words $ "ABSTRACT ADDITIONAL_MAKE_CLEAN_FILES ADVANCED ALLOW_DUPLICATE_CUSTOM_TARGETS ARCHIVE_OUTPUT_DIRECTORY ARCHIVE_OUTPUT_NAME ATTACHED_FILES ATTACHED_FILES_ON_FAIL AUTOMOC AUTOMOC_MOC_OPTIONS BUILD_WITH_INSTALL_RPATH BUNDLE BUNDLE_EXTENSION CACHE_VARIABLES CLEAN_NO_CUSTOM COMPATIBLE_INTERFACE_BOOL COMPATIBLE_INTERFACE_STRING COMPILE_DEFINITIONS COMPILE_FLAGS COST DEBUG_CONFIGURATIONS DEBUG_POSTFIX DEFINE_SYMBOL DEFINITIONS DEPENDS DISABLED_FEATURES ENABLED_FEATURES ENABLED_LANGUAGES ENABLE_EXPORTS ENVIRONMENT EXCLUDE_FROM_ALL EXCLUDE_FROM_DEFAULT_BUILD EXTERNAL_OBJECT EchoString FAIL_REGULAR_EXPRESSION FIND_LIBRARY_USE_LIB64_PATHS FIND_LIBRARY_USE_OPENBSD_VERSIONING FOLDER FRAMEWORK Fortran_FORMAT Fortran_MODULE_DIRECTORY GENERATED GENERATOR_FILE_NAME GLOBAL_DEPENDS_DEBUG_MODE GLOBAL_DEPENDS_NO_CYCLES GNUtoMS HAS_CXX HEADER_FILE_ONLY HELPSTRING IMPLICIT_DEPENDS_INCLUDE_TRANSFORM IMPORTED IMPORTED_CONFIGURATIONS IMPORTED_IMPLIB IMPORTED_LINK_DEPENDENT_LIBRARIES IMPORTED_LINK_INTERFACE_LANGUAGES IMPORTED_LINK_INTERFACE_LIBRARIES IMPORTED_LINK_INTERFACE_MULTIPLICITY IMPORTED_LOCATION IMPORTED_NO_SONAME IMPORTED_SONAME IMPORT_PREFIX IMPORT_SUFFIX INCLUDE_DIRECTORIES INCLUDE_REGULAR_EXPRESSION INSTALL_NAME_DIR INSTALL_RPATH INSTALL_RPATH_USE_LINK_PATH INTERFACE_COMPILE_DEFINITIONS INTERFACE_INCLUDE_DIRECTORIES INTERFACE_POSITION_INDEPENDENT_CODE INTERPROCEDURAL_OPTIMIZATION IN_TRY_COMPILE KEEP_EXTENSION LABELS LANGUAGE LIBRARY_OUTPUT_DIRECTORY LIBRARY_OUTPUT_NAME LINKER_LANGUAGE LINK_DEPENDS LINK_DEPENDS_NO_SHARED LINK_DIRECTORIES LINK_FLAGS LINK_INTERFACE_LIBRARIES LINK_INTERFACE_MULTIPLICITY LINK_LIBRARIES LINK_SEARCH_END_STATIC LINK_SEARCH_START_STATIC LISTFILE_STACK LOCATION MACOSX_BUNDLE MACOSX_BUNDLE_INFO_PLIST MACOSX_FRAMEWORK_INFO_PLIST MACOSX_PACKAGE_LOCATION MACROS MEASUREMENT MODIFIED NO_SONAME OBJECT_DEPENDS OBJECT_OUTPUTS OSX_ARCHITECTURES OUTPUT_NAME PACKAGES_FOUND PACKAGES_NOT_FOUND PARENT_DIRECTORY PASS_REGULAR_EXPRESSION PDB_NAME PDB_OUTPUT_DIRECTORY POSITION_INDEPENDENT_CODE POST_INSTALL_SCRIPT PREDEFINED_TARGETS_FOLDER PREFIX PRE_INSTALL_SCRIPT PRIVATE_HEADER PROCESSORS PROJECT_LABEL PUBLIC_HEADER REPORT_UNDEFINED_PROPERTIES REQUIRED_FILES RESOURCE RESOURCE_LOCK RULE_LAUNCH_COMPILE RULE_LAUNCH_CUSTOM RULE_LAUNCH_LINK RULE_MESSAGES RUNTIME_OUTPUT_DIRECTORY RUNTIME_OUTPUT_NAME RUN_SERIAL SKIP_BUILD_RPATH SOURCES SOVERSION STATIC_LIBRARY_FLAGS STRINGS SUFFIX SYMBOLIC TARGET_ARCHIVES_MAY_BE_SHARED_LIBS TARGET_SUPPORTS_SHARED_LIBS TEST_INCLUDE_FILE TIMEOUT TYPE USE_FOLDERS VALUE VARIABLES VERSION VS_DOTNET_REFERENCES VS_GLOBAL_KEYWORD VS_GLOBAL_PROJECT_TYPES VS_KEYWORD VS_SCC_AUXPATH VS_SCC_LOCALPATH VS_SCC_PROJECTNAME VS_SCC_PROVIDER VS_WINRT_EXTENSIONS VS_WINRT_REFERENCES WILL_FAIL WIN32_EXECUTABLE WORKING_DIRECTORY WRAP_EXCLUDE __CMAKE_DELETE_CACHE_CHANGE_VARS_"
list_extra'5fproperties = Set.fromList $ words $ "COMMANDS DEFINITION"
list_cmake'5fvars = Set.fromList $ words $ "APPLE BORLAND BUILD_SHARED_LIBS CMAKE_ABSOLUTE_DESTINATION_FILES CMAKE_AR CMAKE_ARCHIVE_OUTPUT_DIRECTORY CMAKE_ARGC CMAKE_ARGV0 CMAKE_AUTOMOC CMAKE_AUTOMOC_MOC_OPTIONS CMAKE_AUTOMOC_RELAXED_MODE CMAKE_BACKWARDS_COMPATIBILITY CMAKE_BINARY_DIR CMAKE_BUILD_TOOL CMAKE_BUILD_TYPE CMAKE_BUILD_WITH_INSTALL_RPATH CMAKE_CACHEFILE_DIR CMAKE_CACHE_MAJOR_VERSION CMAKE_CACHE_MINOR_VERSION CMAKE_CACHE_PATCH_VERSION CMAKE_CFG_INTDIR CMAKE_CL_64 CMAKE_COLOR_MAKEFILE CMAKE_COMMAND CMAKE_COMPILER_2005 CMAKE_CONFIGURATION_TYPES CMAKE_CROSSCOMPILING CMAKE_CTEST_COMMAND CMAKE_CURRENT_BINARY_DIR CMAKE_CURRENT_LIST_DIR CMAKE_CURRENT_LIST_FILE CMAKE_CURRENT_LIST_LINE CMAKE_CURRENT_SOURCE_DIR CMAKE_DEBUG_POSTFIX CMAKE_DEBUG_TARGET_PROPERTIES CMAKE_DL_LIBS CMAKE_EDIT_COMMAND CMAKE_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION CMAKE_EXECUTABLE_SUFFIX CMAKE_EXE_LINKER_FLAGS CMAKE_EXTRA_GENERATOR CMAKE_EXTRA_SHARED_LIBRARY_SUFFIXES CMAKE_FIND_LIBRARY_PREFIXES CMAKE_FIND_LIBRARY_SUFFIXES CMAKE_FIND_PACKAGE_WARN_NO_MODULE CMAKE_Fortran_FORMAT CMAKE_Fortran_MODDIR_DEFAULT CMAKE_Fortran_MODDIR_FLAG CMAKE_Fortran_MODOUT_FLAG CMAKE_Fortran_MODULE_DIRECTORY CMAKE_GENERATOR CMAKE_GENERATOR_TOOLSET CMAKE_GNUtoMS CMAKE_HOME_DIRECTORY CMAKE_HOST_APPLE CMAKE_HOST_SYSTEM CMAKE_HOST_SYSTEM_NAME CMAKE_HOST_SYSTEM_PROCESSOR CMAKE_HOST_SYSTEM_VERSION CMAKE_HOST_UNIX CMAKE_HOST_WIN32 CMAKE_IGNORE_PATH CMAKE_IMPORT_LIBRARY_PREFIX CMAKE_IMPORT_LIBRARY_SUFFIX CMAKE_INCLUDE_CURRENT_DIR CMAKE_INCLUDE_CURRENT_DIR_IN_INTERFACE CMAKE_INCLUDE_PATH CMAKE_INSTALL_DEFAULT_COMPONENT_NAME CMAKE_INSTALL_NAME_DIR CMAKE_INSTALL_PREFIX CMAKE_INSTALL_RPATH CMAKE_INSTALL_RPATH_USE_LINK_PATH CMAKE_INTERNAL_PLATFORM_ABI CMAKE_LIBRARY_ARCHITECTURE CMAKE_LIBRARY_ARCHITECTURE_REGEX CMAKE_LIBRARY_OUTPUT_DIRECTORY CMAKE_LIBRARY_PATH CMAKE_LIBRARY_PATH_FLAG CMAKE_LINK_DEF_FILE_FLAG CMAKE_LINK_DEPENDS_NO_SHARED CMAKE_LINK_INTERFACE_LIBRARIES CMAKE_LINK_LIBRARY_FILE_FLAG CMAKE_LINK_LIBRARY_FLAG CMAKE_LINK_LIBRARY_SUFFIX CMAKE_MACOSX_BUNDLE CMAKE_MAJOR_VERSION CMAKE_MAKE_PROGRAM CMAKE_MFC_FLAG CMAKE_MINOR_VERSION CMAKE_MODULE_PATH CMAKE_NOT_USING_CONFIG_FLAGS CMAKE_NO_BUILTIN_CHRPATH CMAKE_OBJECT_PATH_MAX CMAKE_PARENT_LIST_FILE CMAKE_PATCH_VERSION CMAKE_PDB_OUTPUT_DIRECTORY CMAKE_POSITION_INDEPENDENT_CODE CMAKE_PREFIX_PATH CMAKE_PROGRAM_PATH CMAKE_PROJECT_NAME CMAKE_RANLIB CMAKE_ROOT CMAKE_RUNTIME_OUTPUT_DIRECTORY CMAKE_SCRIPT_MODE_FILE CMAKE_SHARED_LIBRARY_PREFIX CMAKE_SHARED_LIBRARY_SUFFIX CMAKE_SHARED_MODULE_PREFIX CMAKE_SHARED_MODULE_SUFFIX CMAKE_SIZEOF_VOID_P CMAKE_SKIP_BUILD_RPATH CMAKE_SKIP_INSTALL_ALL_DEPENDENCY CMAKE_SKIP_INSTALL_RPATH CMAKE_SKIP_RPATH CMAKE_SOURCE_DIR CMAKE_STANDARD_LIBRARIES CMAKE_STATIC_LIBRARY_PREFIX CMAKE_STATIC_LIBRARY_SUFFIX CMAKE_SYSTEM CMAKE_SYSTEM_IGNORE_PATH CMAKE_SYSTEM_INCLUDE_PATH CMAKE_SYSTEM_LIBRARY_PATH CMAKE_SYSTEM_NAME CMAKE_SYSTEM_PREFIX_PATH CMAKE_SYSTEM_PROCESSOR CMAKE_SYSTEM_PROGRAM_PATH CMAKE_SYSTEM_VERSION CMAKE_TRY_COMPILE_CONFIGURATION CMAKE_TWEAK_VERSION CMAKE_USER_MAKE_RULES_OVERRIDE CMAKE_USE_RELATIVE_PATHS CMAKE_VERBOSE_MAKEFILE CMAKE_VERSION CMAKE_VS_PLATFORM_TOOLSET CMAKE_WARN_ON_ABSOLUTE_INSTALL_DESTINATION CMAKE_WIN32_EXECUTABLE CMAKE_XCODE_PLATFORM_TOOLSET CYGWIN EXECUTABLE_OUTPUT_PATH LIBRARY_OUTPUT_PATH MSVC MSVC10 MSVC11 MSVC60 MSVC70 MSVC71 MSVC80 MSVC90 MSVC_IDE MSVC_VERSION PROJECT_BINARY_DIR PROJECT_NAME PROJECT_SOURCE_DIR UNIX WIN32 XCODE_VERSION"
list_simple'5fgenerator'5fexpr = Set.fromList $ words $ "CONFIGURATION ANGLE-R COMMA SEMICOLON INSTALL_PREFIX"
list_generator'5fexpr = Set.fromList $ words $ "0 1 CONFIG BOOL STREQUAL TARGET_NAME INSTALL_INTERFACE BUILD_INTERFACE TARGET_FILE TARGET_LINKER_FILE TARGET_SONAME_FILE TARGET_DIR TARGET_LINKER_DIR TARGET_SONAME_DIR TARGET_PROPERTY TARGET_POLICY AND OR NOT"

regex_'5cbif'5cb = compileRegex "\\bif\\b"
regex_'5cbelse'5cb = compileRegex "\\belse\\b"
regex_'5cbelseif'5cb = compileRegex "\\belseif\\b"
regex_'5cbendif'5cb = compileRegex "\\bendif\\b"
regex_'5cbmacro'5cb = compileRegex "\\bmacro\\b"
regex_'5cbendmacro'5cb = compileRegex "\\bendmacro\\b"
regex_'5cbforeach'5cb = compileRegex "\\bforeach\\b"
regex_'5cbendforeach'5cb = compileRegex "\\bendforeach\\b"
regex_'5cbwhile'5cb = compileRegex "\\bwhile\\b"
regex_'5cbendwhile'5cb = compileRegex "\\bendwhile\\b"
regex_'23'5cs'2aBEGIN'2e'2a'24 = compileRegex "#\\s*BEGIN.*$"
regex_'23'5cs'2aEND'2e'2a'24 = compileRegex "#\\s*END.*$"
regex_'5cw'2b'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "\\w+\\s*(?=\\()"
regex_'5cbCMAKE'5fCOMPILER'5fIS'5fGNU'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb = compileRegex "\\bCMAKE_COMPILER_IS_GNU[A-Za-z_][A-Za-z_0-9]*\\b"
regex_'5cbCMAKE'5fDISABLE'5fFIND'5fPACKAGE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb = compileRegex "\\bCMAKE_DISABLE_FIND_PACKAGE_[A-Za-z_][A-Za-z_0-9]*\\b"
regex_'5cbCMAKE'5fEXE'5fLINKER'5fFLAGS'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb = compileRegex "\\bCMAKE_EXE_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b"
regex_'5cbCMAKE'5fPOLICY'5fDEFAULT'5fCMP'5b0'2d9'5d'2b'5cb = compileRegex "\\bCMAKE_POLICY_DEFAULT_CMP[0-9]+\\b"
regex_'5cbCMAKE'5fUSER'5fMAKE'5fRULES'5fOVERRIDE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb = compileRegex "\\bCMAKE_USER_MAKE_RULES_OVERRIDE_[A-Za-z_][A-Za-z_0-9]*\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fAPPEND'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_APPEND\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fCREATE'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_CREATE\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fFINISH'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_FINISH\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fABI'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ABI\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fID'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ID\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fLOADED'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_LOADED\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fVERSION'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_VERSION\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILE'5fOBJECT'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILE_OBJECT\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSHARED'5fLIBRARY'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_LIBRARY\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSHARED'5fMODULE'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_MODULE\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSTATIC'5fLIBRARY'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_STATIC_LIBRARY\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fDEBUG'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_DEBUG\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fMINSIZEREL'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_MINSIZEREL\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fRELEASE'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELEASE\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fRELWITHDEBINFO'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELWITHDEBINFO\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIGNORE'5fEXTENSIONS'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IGNORE_EXTENSIONS\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fINCLUDE'5fDIRECTORIES'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_INCLUDE_DIRECTORIES\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fDIRECTORIES'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_DIRECTORIES\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fFRAMEWORK'5fDIRECTORIES'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fLIBRARIES'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_LIBRARIES\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLIBRARY'5fARCHITECTURE'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LIBRARY_ARCHITECTURE\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINKER'5fPREFERENCE'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINKER'5fPREFERENCE'5fPROPAGATES'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE_PROPAGATES\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINK'5fEXECUTABLE_'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINK_EXECUTABLE \\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fOUTPUT'5fEXTENSION'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_OUTPUT_EXTENSION\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fPLATFORM'5fID'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_PLATFORM_ID\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fPOSTFIX'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_POSTFIX\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fSIZEOF'5fDATA'5fPTR'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIZEOF_DATA_PTR\\b"
regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fSOURCE'5fFILE'5fEXTENSIONS'5cb = compileRegex "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SOURCE_FILE_EXTENSIONS\\b"
regex_'5c'24ENV'5c'7b'5cs'2a'5b'5cw'2d'5d'2b'5cs'2a'5c'7d = compileRegex "\\$ENV\\{\\s*[\\w-]+\\s*\\}"
regex_'5cbCMP'5b0'2d9'5d'2b'5cb = compileRegex "\\bCMP[0-9]+\\b"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'22'28'3f'3d'5b_'29'3b'5d'7c'24'29 = compileRegex "\"(?=[ );]|$)"
regex_'5c'5c'5b'22'24n'5c'5c'5d = compileRegex "\\\\[\"$n\\\\]"

parseRules ("CMake","Normal Text") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cbif'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbelse'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbelseif'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbendif'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbmacro'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbendmacro'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbforeach'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbendforeach'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbwhile'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pRegExpr regex_'5cbendwhile'5cb >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_commands >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_itkvtk'5fcommands >>= withAttribute FunctionTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aBEGIN'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aEND'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("CMake","Comment"))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   ((pRegExpr regex_'5cw'2b'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute FunctionTok) >>~ pushContext ("CMake","Macro Args"))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Detect More Builtin Variables") =
  (((pRegExpr regex_'5cbCMAKE'5fCOMPILER'5fIS'5fGNU'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5fDISABLE'5fFIND'5fPACKAGE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5fEXE'5fLINKER'5fFLAGS'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5fPOLICY'5fDEFAULT'5fCMP'5b0'2d9'5d'2b'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5fUSER'5fMAKE'5fRULES'5fOVERRIDE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fAPPEND'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fCREATE'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fARCHIVE'5fFINISH'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fABI'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fID'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fLOADED'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILER'5fVERSION'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCOMPILE'5fOBJECT'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSHARED'5fLIBRARY'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSHARED'5fMODULE'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fCREATE'5fSTATIC'5fLIBRARY'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fDEBUG'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fMINSIZEREL'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fRELEASE'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fFLAGS'5fRELWITHDEBINFO'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIGNORE'5fEXTENSIONS'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fINCLUDE'5fDIRECTORIES'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fDIRECTORIES'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fFRAMEWORK'5fDIRECTORIES'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fIMPLICIT'5fLINK'5fLIBRARIES'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLIBRARY'5fARCHITECTURE'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINKER'5fPREFERENCE'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINKER'5fPREFERENCE'5fPROPAGATES'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fLINK'5fEXECUTABLE_'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fOUTPUT'5fEXTENSION'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fPLATFORM'5fID'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fPOSTFIX'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fSIZEOF'5fDATA'5fPTR'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cbCMAKE'5f'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz'5f0'2d9'5d'2a'5fSOURCE'5fFILE'5fEXTENSIONS'5cb >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Detect More Builtin Variables")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Detect Builtin Variables") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_cmake'5fvars >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CMake","Detect More Builtin Variables")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Detect Builtin Variables")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","VarSubst") =
  (((parseRules ("CMake","Detect Builtin Variables")))
   <|>
   ((pDetectIdentifier >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","VarSubst")) >> pDefault >>= withAttribute DecValTok))

parseRules ("CMake","Detect Variables") =
  (((pRegExpr regex_'5c'24ENV'5c'7b'5cs'2a'5b'5cw'2d'5d'2b'5cs'2a'5c'7d >>= withAttribute FloatTok))
   <|>
   ((pDetect2Chars False '$' '{' >>= withAttribute DecValTok) >>~ pushContext ("CMake","VarSubst"))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Detect Variables")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","DetectSimpleGEEnd") =
  (((pDetectChar False '>' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","DetectSimpleGEEnd")) >> pDefault >>= withAttribute OtherTok))

parseRules ("CMake","Generator Expression") =
  (((parseRules ("CMake","Detect Generator Expressions")))
   <|>
   ((pDetectChar False '>' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_simple'5fgenerator'5fexpr >>= withAttribute KeywordTok) >>~ pushContext ("CMake","DetectSimpleGEEnd"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_generator'5fexpr >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Generator Expression")) >> pDefault >>= withAttribute OtherTok))

parseRules ("CMake","Detect Generator Expressions") =
  (((pDetect2Chars False '$' '<' >>= withAttribute OtherTok) >>~ pushContext ("CMake","Generator Expression"))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Detect Generator Expressions")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Command Args") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special'5fargs >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extra'5fspecial'5fargs >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cbCMP'5b0'2d9'5d'2b'5cb >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_properties >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extra'5fproperties >>= withAttribute OtherTok))
   <|>
   ((parseRules ("CMake","Detect Builtin Variables")))
   <|>
   ((parseRules ("CMake","Macro Args")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Command Args")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Macro Args") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "\\\"" >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("CMake","String"))
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("CMake","Detect Builtin Variables")))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   ((parseRules ("CMake","Detect Generator Expressions")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Macro Args")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("CMake","String") =
  (((pRegExpr regex_'22'28'3f'3d'5b_'29'3b'5d'7c'24'29 >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'22'24n'5c'5c'5d >>= withAttribute CharTok))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   ((parseRules ("CMake","Detect Generator Expressions")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing
parseRules ("Modelines", _) = Text.Highlighting.Kate.Syntax.Modelines.parseExpression Nothing

parseRules x = parseRules ("CMake","Normal Text") <|> fail ("Unknown context" ++ show x)
