{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
{-# OPTIONS_HADDOCK hide #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  Language.Haskell.Exts.Annotated.Parser
-- Copyright   :  (c) Niklas Broberg 2004-2009,
--                Original (c) Simon Marlow, Sven Panne 1997-2000
-- License     :  BSD-style (see the file LICENSE.txt)
--
-- Maintainer  :  Niklas Broberg, d00nibro@chalmers.se
-- Stability   :  stable
-- Portability :  portable
--
--
-----------------------------------------------------------------------------
module Language.Haskell.Exts.InternalParser (
              mparseModule,
              mparseExp,
              mparsePat,
              mparseDecl,
              mparseType,
              mparseStmt,
              mparseImportDecl,
              ngparseModulePragmas,
              ngparseModuleHeadAndImports,
              ngparsePragmasAndModuleHead,
              ngparsePragmasAndModuleName
              ) where
import Language.Haskell.Exts.Syntax hiding ( Type(..), Exp(..), Asst(..), XAttr(..), FieldUpdate(..) )
import Language.Haskell.Exts.Syntax ( Type, Exp, Asst )
import Language.Haskell.Exts.ParseMonad
import Language.Haskell.Exts.InternalLexer
import Language.Haskell.Exts.ParseUtils
import Language.Haskell.Exts.Fixity
import Language.Haskell.Exts.SrcLoc
import Language.Haskell.Exts.Extension

import Control.Monad ( liftM, (<=<), when )
import Control.Applicative ( (<$>) )
import Data.Maybe
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn14 :: ([Module L]) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> ([Module L])
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: ([[ModulePragma L] -> [S] -> L -> Module L]) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> ([[ModulePragma L] -> [S] -> L -> Module L])
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (Module L) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (Module L)
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (PExp L) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (PExp L)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (([ModulePragma L],[S],L)) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],L))
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (([ModulePragma L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],Maybe L))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (ModulePragma L) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (ModulePragma L)
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([ModulePragma L] -> [S] -> L -> Module L) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([ModulePragma L] -> [S] -> L -> Module L)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Maybe (ModuleHead L)) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (Maybe (ModuleHead L))
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Maybe (WarningText L)) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> (Maybe (WarningText L))
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (([ImportDecl L],[Decl L],[S],L)) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S],L))
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (([ImportDecl L],[Decl L],[S])) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S]))
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([S]) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> ([S])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([S]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([S])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (Maybe (ExportSpecList L)) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (Maybe (ExportSpecList L))
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (ExportSpecList L) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (ExportSpecList L)
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([S]) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([S])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (([ExportSpec L],[S])) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (([ExportSpec L],[S]))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (ExportSpec L) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (ExportSpec L)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (([Either S (CName L)],[S])) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> (([Either S (CName L)],[S]))
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Either S (CName L)) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (Either S (CName L))
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (QName L) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (QName L)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (([ImportDecl L],[S])) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (([ImportDecl L],[S]))
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (ImportDecl L) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> (ImportDecl L)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ((Maybe String,[S])) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> ((Maybe String,[S]))
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: ((Maybe (ModuleName L),[S],Maybe L)) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> ((Maybe (ModuleName L),[S],Maybe L))
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (Maybe (ImportSpecList L)) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> (Maybe (ImportSpecList L))
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (ImportSpecList L) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (ImportSpecList L)
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ((Bool, Maybe L,[S])) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> ((Bool, Maybe L,[S]))
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (([ImportSpec L],[S])) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> (([ImportSpec L],[S]))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (ImportSpec L) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (ImportSpec L)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (([CName L],[S])) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> (([CName L],[S]))
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (CName L) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> (CName L)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Decl L) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (Decl L)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ((Maybe Int, [S])) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> ((Maybe Int, [S]))
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (Assoc L) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (Assoc L)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (([Op L],[S],L)) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (([Op L],[S],L))
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (Maybe (InjectivityInfo L)) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (Maybe (InjectivityInfo L))
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (InjectivityInfo L) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (InjectivityInfo L)
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([Name L]) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> ([Name L])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Decl L) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> (Decl L)
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Maybe (ResultSig L)) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (Maybe (ResultSig L))
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (Maybe (ResultSig L)) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> (Maybe (ResultSig L))
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: ((Maybe (ResultSig L), Maybe (InjectivityInfo L))) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> ((Maybe (ResultSig L), Maybe (InjectivityInfo L)))
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ((Maybe (ResultSig L), Maybe (S, Type L), Maybe (InjectivityInfo L))) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> ((Maybe (ResultSig L), Maybe (S, Type L), Maybe (InjectivityInfo L)))
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (Decl L) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (Decl L)
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ([(Maybe String, L)]) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> ([(Maybe String, L)])
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ((Maybe String, L)) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> ((Maybe String, L))
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Maybe (Overlap L)) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (Maybe (Overlap L))
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (Maybe ([TypeEqn L], S)) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (Maybe ([TypeEqn L], S))
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (TypeEqn L) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (TypeEqn L)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (DataOrNew L) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (DataOrNew L)
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (Decl L) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (Decl L)
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (Binds L) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (Binds L)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (Decl L) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (Decl L)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Decl L) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> (Decl L)
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (Decl L) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (Decl L)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (Type L) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> (Type L)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (Maybe (BooleanFormula L)) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> (Maybe (BooleanFormula L))
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Binds L) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> (Binds L)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (([Name L],[S],L)) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> (([Name L],[S],L))
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (CallConv L) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (CallConv L)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Maybe (Safety L)) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> (Maybe (Safety L))
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: ((Maybe String, Name L, Type L, [S])) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> ((Maybe String, Name L, Type L, [S]))
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: ([Rule L]) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> ([Rule L])
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Rule L) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> (Rule L)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Maybe (Activation L)) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> (Maybe (Activation L))
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: ((Maybe [RuleVar L],[S])) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> ((Maybe [RuleVar L],[S]))
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: ([RuleVar L]) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> ([RuleVar L])
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (RuleVar L) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (RuleVar L)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (([([Name L],String)],[S])) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> (([([Name L],String)],[S]))
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: ((([Name L], String),[S])) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> ((([Name L], String),[S]))
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: (Name L) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> (Name L)
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (Annotation L) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> (Annotation L)
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (Type L) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> (Type L)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (PType L) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> (PType L)
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (Type L) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> (Type L)
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (PType L) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> (PType L)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (Type L) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> (Type L)
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (Type L) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> (Type L)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (PType L) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> (PType L)
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (PType L) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> (PType L)
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Promoted L) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> (Promoted L)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: ((Maybe (L -> BangType L,S), Maybe (Unpackedness L))) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> ((Maybe (L -> BangType L,S), Maybe (Unpackedness L)))
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: ((L -> BangType L, S)) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> ((L -> BangType L, S))
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (Unpackedness L) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> (Unpackedness L)
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (QName L) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> (QName L)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (QName L) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> (QName L)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (QName L) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> (QName L)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (Type L) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> (Type L)
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (PType L) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> (PType L)
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: (PContext L) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> (PContext L)
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (([TyVarBind L],Maybe L)) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> (([TyVarBind L],Maybe L))
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (TyVarBind L) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> (TyVarBind L)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (([Name L],Maybe L)) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> (([Name L],Maybe L))
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: (([Name L],L)) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> (([Name L],L))
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: (([FunDep L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> (([FunDep L],[S],Maybe L))
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: (([FunDep L],[S],L)) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> (([FunDep L],[S],L))
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: (FunDep L) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> (FunDep L)
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: (([GadtDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> (([GadtDecl L],[S],Maybe L))
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: ([GadtDecl L]) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> ([GadtDecl L])
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: (([QualConDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],Maybe L))
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: (([QualConDecl L],[S],L)) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],L))
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: (QualConDecl L) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> (QualConDecl L)
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: ((Maybe [TyVarBind L], [S], Maybe L)) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe L))
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: (ConDecl L) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> (ConDecl L)
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: ((Name L, [Type L], L)) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> ((Name L, [Type L], L))
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: (([FieldDecl L],[S])) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> (([FieldDecl L],[S]))
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (FieldDecl L) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> (FieldDecl L)
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (Maybe (Deriving L)) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> (Maybe (Deriving L))
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: (([InstRule L],[S])) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> (([InstRule L],[S]))
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: (InstHead L) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> (InstHead L)
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: (Kind L) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> (Kind L)
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (Kind L) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> (Kind L)
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (Kind L) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> (Kind L)
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (Kind L) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> (Kind L)
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (Kind L) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> (Kind L)
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (([Kind L], [S])) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> (([Kind L], [S]))
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: ((Maybe (Kind L), [S])) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> ((Maybe (Kind L), [S]))
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: ((Maybe [ClassDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> ((Maybe [ClassDecl L],[S],Maybe L))
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: ([S]) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> ([S])
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: ((Maybe [InstDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> ((Maybe [InstDecl L],[S],Maybe L))
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (InstDecl L) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: (InstDecl L) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: (Decl L) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> (Decl L)
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: ((Maybe (Binds L),[S])) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> ((Maybe (Binds L),[S]))
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: ((Maybe (Type L, S))) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> ((Maybe (Type L, S)))
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: (Rhs L) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> (Rhs L)
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: (Exp L) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> (Exp L)
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyIn171 :: (PExp L) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> (PExp L)
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
happyIn172 :: (PExp L) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> (PExp L)
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
happyIn173 :: (PExp L) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> (PExp L)
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
happyIn174 :: (PExp L) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> (PExp L)
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
happyIn175 :: (PExp L) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> (PExp L)
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
happyIn176 :: ([S]) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> ([S])
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
happyIn177 :: ([S]) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> ([S])
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
happyIn178 :: (PExp L) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> (PExp L)
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
happyIn179 :: (PExp L) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> (PExp L)
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
happyIn180 :: (PExp L) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> (PExp L)
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
happyIn181 :: ([Pat L]) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> ([Pat L])
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
happyIn182 :: (Pat L) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> (Pat L)
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
happyIn183 :: (PExp L) -> (HappyAbsSyn )
happyIn183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn183 #-}
happyOut183 :: (HappyAbsSyn ) -> (PExp L)
happyOut183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut183 #-}
happyIn184 :: (PExp L) -> (HappyAbsSyn )
happyIn184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn184 #-}
happyOut184 :: (HappyAbsSyn ) -> (PExp L)
happyOut184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut184 #-}
happyIn185 :: (PExp L) -> (HappyAbsSyn )
happyIn185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn185 #-}
happyOut185 :: (HappyAbsSyn ) -> (PExp L)
happyOut185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut185 #-}
happyIn186 :: ([S]) -> (HappyAbsSyn )
happyIn186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn186 #-}
happyOut186 :: (HappyAbsSyn ) -> ([S])
happyOut186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut186 #-}
happyIn187 :: (PExp L) -> (HappyAbsSyn )
happyIn187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn187 #-}
happyOut187 :: (HappyAbsSyn ) -> (PExp L)
happyOut187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut187 #-}
happyIn188 :: (([Maybe (PExp L)],[S])) -> (HappyAbsSyn )
happyIn188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn188 #-}
happyOut188 :: (HappyAbsSyn ) -> (([Maybe (PExp L)],[S]))
happyOut188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut188 #-}
happyIn189 :: (([Maybe (PExp L)],[S])) -> (HappyAbsSyn )
happyIn189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn189 #-}
happyOut189 :: (HappyAbsSyn ) -> (([Maybe (PExp L)],[S]))
happyOut189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut189 #-}
happyIn190 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn190 #-}
happyOut190 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut190 #-}
happyIn191 :: (PExp L) -> (HappyAbsSyn )
happyIn191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn191 #-}
happyOut191 :: (HappyAbsSyn ) -> (PExp L)
happyOut191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut191 #-}
happyIn192 :: (PExp L) -> (HappyAbsSyn )
happyIn192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn192 #-}
happyOut192 :: (HappyAbsSyn ) -> (PExp L)
happyOut192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut192 #-}
happyIn193 :: ([PExp L]) -> (HappyAbsSyn )
happyIn193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn193 #-}
happyOut193 :: (HappyAbsSyn ) -> ([PExp L])
happyOut193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut193 #-}
happyIn194 :: (PExp L) -> (HappyAbsSyn )
happyIn194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn194 #-}
happyOut194 :: (HappyAbsSyn ) -> (PExp L)
happyOut194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut194 #-}
happyIn195 :: (XName L) -> (HappyAbsSyn )
happyIn195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn195 #-}
happyOut195 :: (HappyAbsSyn ) -> (XName L)
happyOut195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut195 #-}
happyIn196 :: (Loc String) -> (HappyAbsSyn )
happyIn196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn196 #-}
happyOut196 :: (HappyAbsSyn ) -> (Loc String)
happyOut196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut196 #-}
happyIn197 :: (Loc String) -> (HappyAbsSyn )
happyIn197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn197 #-}
happyOut197 :: (HappyAbsSyn ) -> (Loc String)
happyOut197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut197 #-}
happyIn198 :: ([ParseXAttr L]) -> (HappyAbsSyn )
happyIn198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn198 #-}
happyOut198 :: (HappyAbsSyn ) -> ([ParseXAttr L])
happyOut198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut198 #-}
happyIn199 :: (ParseXAttr L) -> (HappyAbsSyn )
happyIn199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn199 #-}
happyOut199 :: (HappyAbsSyn ) -> (ParseXAttr L)
happyOut199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut199 #-}
happyIn200 :: (Maybe (PExp L)) -> (HappyAbsSyn )
happyIn200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn200 #-}
happyOut200 :: (HappyAbsSyn ) -> (Maybe (PExp L))
happyOut200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut200 #-}
happyIn201 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn201 #-}
happyOut201 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut201 #-}
happyIn202 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn202 #-}
happyOut202 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut202 #-}
happyIn203 :: (([[QualStmt L]],[S])) -> (HappyAbsSyn )
happyIn203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn203 #-}
happyOut203 :: (HappyAbsSyn ) -> (([[QualStmt L]],[S]))
happyOut203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut203 #-}
happyIn204 :: (([QualStmt L],[S])) -> (HappyAbsSyn )
happyIn204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn204 #-}
happyOut204 :: (HappyAbsSyn ) -> (([QualStmt L],[S]))
happyOut204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut204 #-}
happyIn205 :: (QualStmt L) -> (HappyAbsSyn )
happyIn205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn205 #-}
happyOut205 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut205 #-}
happyIn206 :: (QualStmt L) -> (HappyAbsSyn )
happyIn206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn206 #-}
happyOut206 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut206 #-}
happyIn207 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn207 #-}
happyOut207 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut207 #-}
happyIn208 :: (Stmt L) -> (HappyAbsSyn )
happyIn208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn208 #-}
happyOut208 :: (HappyAbsSyn ) -> (Stmt L)
happyOut208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut208 #-}
happyIn209 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn209 #-}
happyOut209 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut209 #-}
happyIn210 :: (([Alt L],L,[S])) -> (HappyAbsSyn )
happyIn210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn210 #-}
happyOut210 :: (HappyAbsSyn ) -> (([Alt L],L,[S]))
happyOut210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut210 #-}
happyIn211 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn211 #-}
happyOut211 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut211 #-}
happyIn212 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn212 #-}
happyOut212 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut212 #-}
happyIn213 :: (Alt L) -> (HappyAbsSyn )
happyIn213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn213 #-}
happyOut213 :: (HappyAbsSyn ) -> (Alt L)
happyOut213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut213 #-}
happyIn214 :: (Rhs L) -> (HappyAbsSyn )
happyIn214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn214 #-}
happyOut214 :: (HappyAbsSyn ) -> (Rhs L)
happyOut214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut214 #-}
happyIn215 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn215 #-}
happyOut215 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut215 #-}
happyIn216 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn216 #-}
happyOut216 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut216 #-}
happyIn217 :: (Pat L) -> (HappyAbsSyn )
happyIn217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn217 #-}
happyOut217 :: (HappyAbsSyn ) -> (Pat L)
happyOut217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut217 #-}
happyIn218 :: (([GuardedRhs L], L, [S])) -> (HappyAbsSyn )
happyIn218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn218 #-}
happyOut218 :: (HappyAbsSyn ) -> (([GuardedRhs L], L, [S]))
happyOut218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut218 #-}
happyIn219 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn219 #-}
happyOut219 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut219 #-}
happyIn220 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn220 #-}
happyOut220 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut220 #-}
happyIn221 :: (([Stmt L],L,[S])) -> (HappyAbsSyn )
happyIn221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn221 #-}
happyOut221 :: (HappyAbsSyn ) -> (([Stmt L],L,[S]))
happyOut221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut221 #-}
happyIn222 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn222 #-}
happyOut222 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut222 #-}
happyIn223 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn223 #-}
happyOut223 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut223 #-}
happyIn224 :: (Stmt L) -> (HappyAbsSyn )
happyIn224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn224 #-}
happyOut224 :: (HappyAbsSyn ) -> (Stmt L)
happyOut224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut224 #-}
happyIn225 :: (([PFieldUpdate L],[S])) -> (HappyAbsSyn )
happyIn225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn225 #-}
happyOut225 :: (HappyAbsSyn ) -> (([PFieldUpdate L],[S]))
happyOut225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut225 #-}
happyIn226 :: (PFieldUpdate L) -> (HappyAbsSyn )
happyIn226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn226 #-}
happyOut226 :: (HappyAbsSyn ) -> (PFieldUpdate L)
happyOut226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut226 #-}
happyIn227 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn227 #-}
happyOut227 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut227 #-}
happyIn228 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn228 #-}
happyOut228 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut228 #-}
happyIn229 :: (IPBind L) -> (HappyAbsSyn )
happyIn229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn229 #-}
happyOut229 :: (HappyAbsSyn ) -> (IPBind L)
happyOut229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut229 #-}
happyIn230 :: (PExp L) -> (HappyAbsSyn )
happyIn230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn230 #-}
happyOut230 :: (HappyAbsSyn ) -> (PExp L)
happyOut230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut230 #-}
happyIn231 :: (Name L) -> (HappyAbsSyn )
happyIn231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn231 #-}
happyOut231 :: (HappyAbsSyn ) -> (Name L)
happyOut231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut231 #-}
happyIn232 :: (Name L) -> (HappyAbsSyn )
happyIn232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn232 #-}
happyOut232 :: (HappyAbsSyn ) -> (Name L)
happyOut232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut232 #-}
happyIn233 :: (QName L) -> (HappyAbsSyn )
happyIn233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn233 #-}
happyOut233 :: (HappyAbsSyn ) -> (QName L)
happyOut233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut233 #-}
happyIn234 :: (IPName L) -> (HappyAbsSyn )
happyIn234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn234 #-}
happyOut234 :: (HappyAbsSyn ) -> (IPName L)
happyOut234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut234 #-}
happyIn235 :: (Name L) -> (HappyAbsSyn )
happyIn235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn235 #-}
happyOut235 :: (HappyAbsSyn ) -> (Name L)
happyOut235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut235 #-}
happyIn236 :: (QName L) -> (HappyAbsSyn )
happyIn236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn236 #-}
happyOut236 :: (HappyAbsSyn ) -> (QName L)
happyOut236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut236 #-}
happyIn237 :: (Name L) -> (HappyAbsSyn )
happyIn237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn237 #-}
happyOut237 :: (HappyAbsSyn ) -> (Name L)
happyOut237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut237 #-}
happyIn238 :: (QName L) -> (HappyAbsSyn )
happyIn238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn238 #-}
happyOut238 :: (HappyAbsSyn ) -> (QName L)
happyOut238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut238 #-}
happyIn239 :: (QName L) -> (HappyAbsSyn )
happyIn239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn239 #-}
happyOut239 :: (HappyAbsSyn ) -> (QName L)
happyOut239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut239 #-}
happyIn240 :: (Name L) -> (HappyAbsSyn )
happyIn240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn240 #-}
happyOut240 :: (HappyAbsSyn ) -> (Name L)
happyOut240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut240 #-}
happyIn241 :: (QName L) -> (HappyAbsSyn )
happyIn241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn241 #-}
happyOut241 :: (HappyAbsSyn ) -> (QName L)
happyOut241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut241 #-}
happyIn242 :: (Op L) -> (HappyAbsSyn )
happyIn242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn242 #-}
happyOut242 :: (HappyAbsSyn ) -> (Op L)
happyOut242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut242 #-}
happyIn243 :: (QOp L) -> (HappyAbsSyn )
happyIn243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn243 #-}
happyOut243 :: (HappyAbsSyn ) -> (QOp L)
happyOut243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut243 #-}
happyIn244 :: (QOp L) -> (HappyAbsSyn )
happyIn244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn244 #-}
happyOut244 :: (HappyAbsSyn ) -> (QOp L)
happyOut244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut244 #-}
happyIn245 :: (QName L) -> (HappyAbsSyn )
happyIn245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn245 #-}
happyOut245 :: (HappyAbsSyn ) -> (QName L)
happyOut245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut245 #-}
happyIn246 :: (PExp L) -> (HappyAbsSyn )
happyIn246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn246 #-}
happyOut246 :: (HappyAbsSyn ) -> (PExp L)
happyOut246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut246 #-}
happyIn247 :: (QName L) -> (HappyAbsSyn )
happyIn247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn247 #-}
happyOut247 :: (HappyAbsSyn ) -> (QName L)
happyOut247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut247 #-}
happyIn248 :: (Name L) -> (HappyAbsSyn )
happyIn248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn248 #-}
happyOut248 :: (HappyAbsSyn ) -> (Name L)
happyOut248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut248 #-}
happyIn249 :: (Name L) -> (HappyAbsSyn )
happyIn249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn249 #-}
happyOut249 :: (HappyAbsSyn ) -> (Name L)
happyOut249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut249 #-}
happyIn250 :: (IPName L) -> (HappyAbsSyn )
happyIn250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn250 #-}
happyOut250 :: (HappyAbsSyn ) -> (IPName L)
happyOut250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut250 #-}
happyIn251 :: (QName L) -> (HappyAbsSyn )
happyIn251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn251 #-}
happyOut251 :: (HappyAbsSyn ) -> (QName L)
happyOut251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut251 #-}
happyIn252 :: (Name L) -> (HappyAbsSyn )
happyIn252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn252 #-}
happyOut252 :: (HappyAbsSyn ) -> (Name L)
happyOut252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut252 #-}
happyIn253 :: (QName L) -> (HappyAbsSyn )
happyIn253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn253 #-}
happyOut253 :: (HappyAbsSyn ) -> (QName L)
happyOut253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut253 #-}
happyIn254 :: (Name L) -> (HappyAbsSyn )
happyIn254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn254 #-}
happyOut254 :: (HappyAbsSyn ) -> (Name L)
happyOut254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut254 #-}
happyIn255 :: (QName L) -> (HappyAbsSyn )
happyIn255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn255 #-}
happyOut255 :: (HappyAbsSyn ) -> (QName L)
happyOut255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut255 #-}
happyIn256 :: (QName L) -> (HappyAbsSyn )
happyIn256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn256 #-}
happyOut256 :: (HappyAbsSyn ) -> (QName L)
happyOut256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut256 #-}
happyIn257 :: (Name L) -> (HappyAbsSyn )
happyIn257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn257 #-}
happyOut257 :: (HappyAbsSyn ) -> (Name L)
happyOut257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut257 #-}
happyIn258 :: (Name L) -> (HappyAbsSyn )
happyIn258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn258 #-}
happyOut258 :: (HappyAbsSyn ) -> (Name L)
happyOut258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut258 #-}
happyIn259 :: (QName L) -> (HappyAbsSyn )
happyIn259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn259 #-}
happyOut259 :: (HappyAbsSyn ) -> (QName L)
happyOut259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut259 #-}
happyIn260 :: (Literal L) -> (HappyAbsSyn )
happyIn260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn260 #-}
happyOut260 :: (HappyAbsSyn ) -> (Literal L)
happyOut260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut260 #-}
happyIn261 :: (S) -> (HappyAbsSyn )
happyIn261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn261 #-}
happyOut261 :: (HappyAbsSyn ) -> (S)
happyOut261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut261 #-}
happyIn262 :: (S) -> (HappyAbsSyn )
happyIn262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn262 #-}
happyOut262 :: (HappyAbsSyn ) -> (S)
happyOut262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut262 #-}
happyIn263 :: (Decl L) -> (HappyAbsSyn )
happyIn263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn263 #-}
happyOut263 :: (HappyAbsSyn ) -> (Decl L)
happyOut263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut263 #-}
happyIn264 :: (Decl L) -> (HappyAbsSyn )
happyIn264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn264 #-}
happyOut264 :: (HappyAbsSyn ) -> (Decl L)
happyOut264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut264 #-}
happyIn265 :: (Pat L) -> (HappyAbsSyn )
happyIn265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn265 #-}
happyOut265 :: (HappyAbsSyn ) -> (Pat L)
happyOut265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut265 #-}
happyIn266 :: ([Pat L]) -> (HappyAbsSyn )
happyIn266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn266 #-}
happyOut266 :: (HappyAbsSyn ) -> ([Pat L])
happyOut266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut266 #-}
happyIn267 :: (([S], [Name L])) -> (HappyAbsSyn )
happyIn267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn267 #-}
happyOut267 :: (HappyAbsSyn ) -> (([S], [Name L]))
happyOut267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut267 #-}
happyIn268 :: (PatternSynDirection L) -> (HappyAbsSyn )
happyIn268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn268 #-}
happyOut268 :: (HappyAbsSyn ) -> (PatternSynDirection L)
happyOut268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut268 #-}
happyIn269 :: (Decl L) -> (HappyAbsSyn )
happyIn269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn269 #-}
happyOut269 :: (HappyAbsSyn ) -> (Decl L)
happyOut269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut269 #-}
happyIn270 :: ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L )) -> (HappyAbsSyn )
happyIn270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn270 #-}
happyOut270 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L ))
happyOut270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut270 #-}
happyIn271 :: (ModuleName L) -> (HappyAbsSyn )
happyIn271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn271 #-}
happyOut271 :: (HappyAbsSyn ) -> (ModuleName L)
happyOut271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut271 #-}
happyIn272 :: (Name L) -> (HappyAbsSyn )
happyIn272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn272 #-}
happyOut272 :: (HappyAbsSyn ) -> (Name L)
happyOut272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut272 #-}
happyIn273 :: (QName L) -> (HappyAbsSyn )
happyIn273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn273 #-}
happyOut273 :: (HappyAbsSyn ) -> (QName L)
happyOut273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut273 #-}
happyIn274 :: (Name L) -> (HappyAbsSyn )
happyIn274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn274 #-}
happyOut274 :: (HappyAbsSyn ) -> (Name L)
happyOut274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut274 #-}
happyIn275 :: (Name L) -> (HappyAbsSyn )
happyIn275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn275 #-}
happyOut275 :: (HappyAbsSyn ) -> (Name L)
happyOut275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut275 #-}
happyIn276 :: (QName L) -> (HappyAbsSyn )
happyIn276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn276 #-}
happyOut276 :: (HappyAbsSyn ) -> (QName L)
happyOut276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut276 #-}
happyIn277 :: (Name L) -> (HappyAbsSyn )
happyIn277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn277 #-}
happyOut277 :: (HappyAbsSyn ) -> (Name L)
happyOut277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut277 #-}
happyIn278 :: (([ImportDecl L],[S],L)) -> (HappyAbsSyn )
happyIn278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn278 #-}
happyOut278 :: (HappyAbsSyn ) -> (([ImportDecl L],[S],L))
happyOut278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut278 #-}
happyIn279 :: ((([ModulePragma L], [S], L), Maybe (ModuleName L))) -> (HappyAbsSyn )
happyIn279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn279 #-}
happyOut279 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleName L)))
happyOut279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut279 #-}
happyIn280 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L))) -> (HappyAbsSyn )
happyIn280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn280 #-}
happyOut280 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L)))
happyOut280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut280 #-}
happyIn281 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L))) -> (HappyAbsSyn )
happyIn281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn281 #-}
happyOut281 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L)))
happyOut281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut281 #-}
happyInTok :: (Loc Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Loc Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x0e\x27\x8f\x26\xad\x09\x39\x1a\x16\x23\x5b\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x09\x7c\x05\x4f\x09\xbb\x09\x45\x09\xb3\x09\x3a\x09\xb0\x09\xb0\x09\x22\x09\x21\x09\x00\x00\x76\x09\x00\x00\x00\x00\x38\x06\x00\x00\x00\x00\x00\x00\x06\x2b\x00\x00\x80\x09\x00\x00\x00\x00\x6d\x09\x0f\x09\x00\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x1f\x00\x1f\x12\x20\x9b\x20\x00\x00\x20\x2a\x79\x1c\x06\x2b\x06\x2b\x06\x2b\x0e\x27\x00\x00\x0e\x27\x0e\x27\x0e\x27\x39\x1a\x00\x00\x60\x2d\xbe\x30\x00\x00\x40\x30\x0e\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\x7d\x09\x00\x00\x00\x00\x00\x00\x10\x26\x7c\x09\x7b\x09\x93\x2a\x7b\x09\x00\x00\x00\x00\x85\x09\x84\x09\x83\x09\x00\x00\x00\x00\x69\x13\x00\x00\x00\x00\x79\x1c\x00\x00\x69\x03\x00\x00\x00\x00\x00\x09\x00\x00\x39\x1a\x68\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x13\x89\x14\xc9\x16\x59\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\x31\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x08\xfb\x08\xf9\x08\x00\x00\x00\x00\x00\x00\xf9\x08\x70\x09\xf8\x08\x00\x00\xf8\x08\x44\x00\x00\x00\x00\x00\x6b\x09\x40\x30\x10\x09\x3e\x07\x00\x00\x1d\x09\x00\x00\x00\x00\x64\x09\x00\x00\xa9\x0d\x58\x00\x00\x00\x00\x00\x1d\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x14\x69\x16\x00\x00\x5d\x09\x55\x09\xc9\x13\x53\x09\x00\x00\x52\x09\x4e\x09\x00\x00\x58\x03\x47\x03\x00\x00\x00\x00\xe1\x02\x58\x09\xe3\x02\x54\x09\x4b\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x09\x00\x00\x48\x09\x00\x00\x79\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x79\x1c\x00\x00\x00\x00\x79\x1c\x00\x00\x00\x00\xed\x30\x39\x1a\x00\x00\x00\x00\x41\x09\xc7\x08\xc6\x08\x00\x00\x1a\x21\x1a\x21\x29\x09\x00\x00\x06\x2b\x00\x00\xdf\x08\x26\x09\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x08\x99\x02\xf6\x08\x00\x00\x1a\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x2c\x46\x03\x20\x09\x00\x00\x00\x00\x2c\x0e\xcb\x0e\xfc\x08\xf7\x08\x52\x0d\xf3\x08\x1c\x09\x12\x09\x59\x01\x00\x00\x06\x2b\x00\x00\x00\x00\x00\x00\xad\x29\x00\x00\x17\x09\xfe\x08\x06\x03\x06\x09\x08\x09\x00\x00\x00\x00\x0e\x27\x00\x00\x00\x00\x00\x00\xf0\x27\x00\x00\x09\x01\x07\x09\xff\x08\x00\x00\x77\x1e\x39\x03\x00\x00\xcd\x04\xee\x1d\x44\x02\x0e\x09\x0d\x09\x0c\x09\x0b\x09\x09\x09\x00\x00\x06\x2b\x06\x2b\x06\x2b\x0e\x27\x42\x2d\x00\x00\x00\x00\x00\x00\x0e\x27\x00\x00\xf0\x27\x39\x1a\x0e\x27\x0e\x27\x0e\x27\x0e\x27\xca\x08\x8a\x08\x37\x00\x00\x00\x3e\x07\x58\x00\x00\x00\x00\x00\x00\x00\xf5\x2c\x00\x00\xa4\x08\x00\x00\x06\x2b\x89\x08\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\x06\x2b\x0a\x09\xec\x08\x77\x00\x34\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x08\xe3\x08\x00\x00\x00\x00\xe7\x08\xd8\x08\xd0\x08\xa6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x1d\x00\x00\x00\x00\x43\x02\x00\x00\x00\x00\x0e\x27\x91\x25\xdc\x1c\x00\x00\x00\x00\xee\x02\x00\x00\x9b\x20\x00\x00\x9b\x20\x0e\x27\x97\x22\xd3\x08\x00\x00\x00\x00\x9b\x20\x0e\x27\x97\x22\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\x0e\x27\x00\x00\x12\x25\x00\x00\x00\x00\x0e\x27\x00\x00\x00\x00\x00\x00\xe4\x08\x58\x00\x00\x00\x00\x00\x00\x00\x09\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x27\x00\x00\x00\x00\x00\x00\x06\x2b\x1b\x01\x39\x1a\x87\x08\xd7\x08\x7b\x08\x00\x00\x00\x00\x00\x00\x54\x05\x00\x00\xc9\x19\x19\x2f\xcd\x08\xcd\x08\xfc\xff\xcd\x08\xdb\x08\xfe\x2e\xfe\x2e\xf5\x2c\xe1\x2f\xcb\x08\x00\x00\x40\x30\xba\x28\x00\x00\x9e\x08\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\xbd\x08\xcc\x02\xba\x08\x58\x00\x5a\x08\x00\x00\x0e\x27\x00\x00\x0e\x27\xb9\x08\xb8\x08\x1a\x21\x58\x00\x0e\x27\x0e\x27\xaa\x08\x00\x00\xac\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x2c\x00\x00\x00\x00\x69\x19\x69\x19\x00\x00\x00\x00\x00\x00\x00\x00\x10\x03\x00\x00\x23\x02\x00\x00\x00\x00\x00\x00\x7c\x31\x69\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\x10\xb3\x08\xb2\x08\x58\x00\x58\x00\xb0\x06\x80\x08\x00\x00\x00\x00\xba\x28\x84\x08\xb4\x08\xb7\x08\xb5\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x27\x00\x00\x00\x00\x97\x08\x56\x08\x3a\x0e\x9a\x08\x9a\x08\x00\x00\x88\x08\x00\x00\x00\x00\x8d\x08\x00\x00\x94\x08\x00\x00\x89\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x2b\x75\x2c\x00\x00\x00\x00\x93\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x21\x00\x00\x00\x00\x00\x00\x0e\x27\x00\x00\x00\x00\x00\x00\x00\x00\x12\x25\x00\x00\x00\x00\x1b\x00\x55\x08\x00\x00\x6f\x08\x00\x00\xf4\x06\x6d\x06\x69\x06\x68\x06\x62\x06\x3b\x06\x3a\x06\x02\x06\xe6\x05\xd0\x05\xca\x05\xb4\x05\x96\x05\x74\x05\x6b\x05\x27\x05\x17\x05\x09\x05\xfd\x04\xec\x04\xba\x04\x00\x00\x0d\x08\x00\x00\x6b\x08\x73\x08\x00\x00\x0c\x2c\x00\x08\x2a\x00\x00\x00\x83\x08\x71\x08\x22\x00\x20\x00\x00\x00\x70\x08\xb3\x2e\x47\x00\xb3\x2e\x69\x19\xb3\x2e\xb3\x2e\x95\x2e\xcb\x04\x60\x03\x81\x08\x57\x08\x59\x1b\x79\x1c\xed\x02\x69\x19\xf4\x07\xf3\x07\xea\x07\x54\x05\x69\x19\x69\x19\x52\x08\x70\x06\x70\x06\x78\x04\x78\x04\x79\x2e\x69\x19\x07\x07\x69\x19\xcb\x0e\x61\x08\x37\x08\x34\x06\x00\x00\x00\x00\x4c\x00\x00\x00\x4e\x08\x5d\x08\x00\x00\x00\x00\x18\x22\x5b\x08\x58\x00\x4b\x08\x51\x08\x00\x00\x00\x00\x00\x00\x93\x24\x00\x00\xec\x02\x00\x00\x00\x00\x4a\x08\x00\x00\x85\x02\x00\x00\x00\x00\x00\x00\xe6\x02\x00\x00\x00\x00\x47\x08\x00\x00\x00\x00\x00\x00\xf3\x01\x00\x00\x0e\x27\xe6\x2d\x00\x00\x00\x00\x00\x00\x62\x08\x00\x00\x1d\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x16\x00\x68\x08\x06\x2b\x00\x00\x4d\x08\x4c\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\x99\x21\x0e\x27\x02\x08\xf1\xff\x99\x21\x00\x00\x00\x00\x00\x00\x00\x00\x37\x04\xf2\x07\x0e\x27\x14\x24\x00\x00\x3c\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x2f\x00\x00\x00\x00\xfb\x06\xf9\x07\xe0\x07\xf2\x2b\xf0\x07\x1c\x04\xe4\x02\x00\x00\xd3\x07\x23\x08\x00\x00\x0e\x27\x14\x24\xd0\x07\x43\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x2b\xcc\x07\x00\x00\x1f\x08\x2c\x08\x00\x00\x0b\x08\x00\x00\x69\x19\x00\x00\x00\x00\x00\x00\xbb\x07\x00\x00\x94\x01\x07\x08\x00\x00\xe8\x06\x69\x19\x95\x23\x95\x23\x0f\x30\x0f\x30\x00\x00\x0f\x30\x09\x19\xa6\x07\xa5\x07\x9a\x07\x04\x08\x0c\x08\x1e\x08\xfe\x07\xba\x07\x11\x08\x00\x00\x4a\x2e\x00\x00\x4a\x2e\x00\x00\x00\x00\x00\x00\x08\x08\xab\x2f\xab\x2f\x00\x00\x00\x00\x00\x00\x06\x2b\x00\x00\x00\x00\x48\x01\xcc\x02\xff\x07\x00\x00\xe3\x07\xec\x07\xe7\x07\xee\x07\x00\x00\x00\x00\xf2\x2b\x00\x00\xf2\x2b\x00\x00\x00\x00\x0e\x27\x0b\x07\xe6\x07\x39\x29\x70\x11\xe6\x07\x70\x07\x63\x07\x78\x07\x00\x00\x7d\x27\x00\x00\xa8\x06\x00\x00\x00\x00\xdf\x07\xcb\x07\x00\x00\x00\x00\xd5\x07\x94\x01\x00\x00\xfd\x06\xbe\x2c\xce\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x07\x00\x00\xd1\x07\x00\x00\x00\x00\xf2\x2b\x00\x00\xdd\x07\x81\x07\x00\x00\x0e\x27\x00\x00\x99\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x27\x7d\x2f\xa9\x18\xc7\x07\x00\x00\xa9\x18\x00\x00\x00\x00\x00\x00\x00\x00\x59\x1b\x00\x00\x00\x00\xc3\x07\xc0\x07\x00\x00\x00\x00\x66\x07\x00\x00\x00\x00\xb2\x07\xf2\x2b\x37\x31\xa9\x18\x45\x00\x00\x00\xb8\x07\x00\x00\x00\x00\x00\x00\xf2\x2b\x08\x31\xb6\x07\x00\x00\x00\x00\xb7\x07\x00\x00\xa8\x07\x00\x00\x25\x05\xc9\x01\xa4\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x07\xad\x00\x00\x00\x00\x00\x00\x00\x62\x2f\xa9\x18\xa3\x07\x00\x00\x19\x1c\x00\x00\x00\x00\x69\x07\xb1\x07\x00\x00\xa7\x01\x64\x07\x4f\x07\xa0\x07\x9c\x07\x34\x06\x00\x00\x00\x00\x4e\x07\x91\x07\x00\x00\x0e\x27\x95\x23\x9e\x07\x00\x00\x0e\x27\x0e\x27\x0e\x27\x00\x00\x94\x07\x00\x00\x5c\x07\x47\x07\xcf\x03\xf7\x00\x00\x00\x00\x00\x05\x00\xfd\x06\x00\x00\x00\x00\x39\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x07\x00\x00\x00\x00\x00\x00\xa9\x15\x00\x00\x00\x00\x00\x00\xd3\x30\x56\x01\x49\x18\x19\x1c\x00\x00\x00\x00\x89\x07\x88\x07\x03\x13\x1a\x07\x00\x00\x00\x00\xc9\x01\x0e\x27\x00\x00\x00\x00\x85\x07\x79\x07\xb9\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x07\x00\x00\x7c\x31\x00\x00\x74\x07\x00\x00\x0f\x30\xcb\x2d\x00\x00\x59\x1b\x04\x07\x6c\x07\x00\x00\x00\x00\xf8\x06\x60\x07\x47\x2f\x00\x00\x0f\x30\x5a\x07\x38\x07\x00\x00\x0e\x27\x58\x07\x5f\x07\x67\x07\x00\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x2c\x65\x07\xac\x27\x00\x00\xba\x03\x40\x30\x00\x00\x00\x00\x47\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x2b\x6f\x07\x00\x00\x40\x30\x0e\x27\x52\x07\x00\x00\x00\x00\x00\x00\xe9\x17\x00\x00\x00\x00\x89\x17\x00\x00\x00\x00\x00\x00\x4b\x07\x00\x00\x5e\x07\xeb\x10\x5b\x07\x58\x00\x7c\x31\x00\x00\x00\x00\x5c\x0f\x59\x07\x58\x00\x00\x00\xb9\x1b\x00\x00\x00\x00\x00\x00\x5d\x07\xad\x2d\xf9\x1a\x00\x00\xb9\x1b\x6b\x07\x00\x00\x13\x02\x44\x07\x58\x00\x4c\x07\x45\x07\x00\x00\x00\x00\x0e\x27\x00\x00\x00\x00\x00\x00\x48\x07\x00\x00\x0b\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x07\x00\x00\xb9\x1b\xc8\x02\x62\x02\x00\x00\x00\x00\x3f\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x06\x7a\x12\x49\x15\x67\x31\x00\x00\x00\x00\x29\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb9\x1b\x00\x00\x29\x17\x29\x17\x4c\x31\x66\x10\x2f\x07\x58\x00\x00\x00\x00\x00\x29\x17\x00\x00\x0a\x07\x89\x06\x00\x00\x00\x00\x7b\x2d\x01\x07\x00\x00\x00\x00\x0e\x27\x00\x00\x32\x07\x00\x00\x00\x00\x4c\x31\x00\x00\xca\x03\x00\x00\x1e\x07\x5e\x00\x1d\x07\xf5\x11\x2b\x07\xbb\x06\xa6\x06\x99\x1a\x29\x17\x00\x00\xf3\x05\x99\x1a\x00\x00\xe1\x0f\x2b\x07\x00\x00\x30\x2e\x29\x17\xe9\x14\x04\x01\x2b\x07\x26\x07\x06\x07\x00\x00\x00\x00\x00\x00\x00\x07\xe2\x2e\x86\x02\x00\x00\x00\x00\x8f\x2c\xef\x06\x3a\x28\x00\x00\x00\x00\x00\x00\x30\x2e\x00\x00\x00\x00\x00\x00\xd0\x06\x29\x17\x00\x00\x4c\x06\x00\x00\xf2\x2b\x29\x17\x92\x06\x65\x06\x00\x00\x29\x17\x00\x00\x29\x17\x29\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x77\x06\x00\x00\xb4\x06\x00\x00\x00\x00\xf2\x2b\x74\x30\x00\x00\x00\x00\x66\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\xbd\x06\x00\x00\x00\x00\x16\x2e\x8b\x06\x88\x06\x00\x00\x00\x00\x00\x00\x00\x00\x29\x17\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x02\x00\x56\x38\x08\x3d\x0b\x00\x5c\x09\x9b\x34\x80\x06\x03\x00\xfd\xff\xff\xff\xfe\xff\x01\x00\x9b\x03\xbf\x06\x00\x00\x00\x00\xa5\x06\x00\x00\x91\x06\x00\x00\x00\x00\x00\x00\x74\x06\x00\x00\x00\x00\x00\x00\x00\x00\x48\x08\x00\x00\x00\x00\x00\x00\xe9\x44\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x38\x41\x39\x21\x39\xc7\x38\x00\x00\x36\x31\xe9\x01\xd2\x44\xa6\x0c\x8c\x44\xf1\x3c\x00\x00\x03\x38\xec\x37\xe9\x41\x19\x09\x9d\x05\xf7\x06\x9a\x01\x00\x00\x4b\x05\x2c\x41\xb3\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x41\x7d\xff\x00\x00\x00\x00\x00\x00\xb2\x34\xf9\xff\x7c\xff\x5e\x42\x73\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x0c\x00\x00\x00\x00\x5c\x0c\x00\x00\x06\x06\x00\x00\x00\x00\x00\x00\x00\x00\x72\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x05\xd2\x06\x86\x06\x0e\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x99\x37\xe4\x03\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x05\x00\x00\x00\x00\x00\x00\xaa\x05\xa6\x05\x00\x00\x00\x00\xf2\xff\x00\x00\x00\x00\x00\x00\x79\x03\x00\x00\x00\x00\x08\x00\xd1\x04\xae\x06\x45\x05\x00\x00\x00\x00\x0a\x00\x04\x00\x00\x00\x00\x00\x79\x00\x44\x05\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x06\x47\x09\x00\x00\x00\x00\x00\x00\x31\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x0c\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x0b\x00\x00\x00\x00\x31\x0a\x00\x00\x00\x00\x21\x02\x5d\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x34\xde\x33\x00\x00\x00\x00\x75\x44\x00\x00\x00\x00\x78\x05\x00\x00\x13\x00\x10\x00\x00\x00\x00\x00\x15\x02\x00\x00\x5f\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x61\x05\x00\x00\x00\x00\x00\x00\x35\x07\x69\x01\x00\x00\x00\x00\xf5\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2f\x44\x00\x00\x00\x00\x00\x00\x47\x42\x00\x00\x71\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x41\x00\x00\x00\x00\x00\x00\x70\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x3b\x82\x02\x00\x00\x00\x00\xac\x3a\x2f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x0c\x18\x44\xd2\x43\x82\x37\xef\x04\x00\x00\x00\x00\x00\x00\xb6\x33\x00\x00\x40\x03\x04\x09\xc2\x40\xab\x40\x58\x40\x41\x40\xfa\x05\x00\x00\x6d\x01\x00\x00\xfa\x04\xe7\x04\x9f\x06\x99\x06\xc3\x02\x7f\x03\x00\x00\x7e\x03\x00\x00\xbb\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x02\x75\x43\x07\x05\x8f\x06\xf5\x04\x00\x00\x43\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x06\x00\x00\x6f\x06\x00\x00\xbb\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x3a\x00\x00\x00\x00\xf3\x02\x00\x00\x00\x00\x9e\x3c\x87\x3c\x33\x3a\x00\x00\x00\x00\x29\x01\x00\x00\x14\x3a\x00\x00\xba\x39\xee\x3f\xa0\x31\x00\x00\x00\x00\x00\x00\x9b\x39\xd7\x3f\x4d\x31\x00\x00\x19\x00\x0c\x00\x00\x00\x84\x3f\x6d\x3f\x00\x00\x8b\x33\x00\x00\x00\x00\xb6\x33\x00\x00\x00\x00\x00\x00\x88\x05\xcf\x04\x45\x06\x00\x00\x00\x00\x1a\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x06\x00\x00\x00\x00\x00\x00\x5e\x43\x00\x00\x06\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x05\x00\x00\x71\x09\x64\x02\x41\x05\x3a\x05\x2a\x05\x1d\x05\xf0\x05\x52\x02\xc7\x01\xf8\x02\x1a\x00\x00\x00\x00\x00\x80\x05\xbb\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x3c\x5e\xff\x42\x01\x00\x00\x7b\x04\x00\x00\x00\x00\x1a\x3f\x00\x00\x03\x3f\x00\x00\x7d\x04\x67\x33\x64\x04\xb0\x3e\x99\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x19\x00\x00\x00\x00\xc7\x0a\xb2\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x6f\x0a\x10\x06\xbe\x05\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x02\x00\x00\x00\x00\x4a\x04\x46\x04\x20\x05\x00\x00\x76\x04\x00\x00\xa4\x42\x1e\x05\x52\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x05\x00\x00\x81\x03\x8b\x05\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x04\x00\x00\x00\x00\x00\x00\x00\x00\x52\x0c\x2c\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x33\x00\x00\x00\x00\x00\x00\x46\x3e\x00\x00\x00\x00\x00\x00\x81\x05\xec\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x04\x1d\x03\x00\x00\x13\x03\x5b\x0a\x83\x02\x55\x01\xd3\x01\x77\x04\x00\x00\x05\x04\x00\x00\xf2\x0b\x8a\x05\xa9\xff\x1c\x0a\x00\x00\x00\x00\x00\x00\xd9\x04\x24\x04\x07\x0a\x52\x04\x75\x04\x68\x04\xb0\x04\x72\x04\xf6\x00\xef\x08\xe8\x01\xb1\x08\x82\x01\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xff\x00\x00\x00\x00\x60\x3b\x00\x00\xee\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2f\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x02\x00\x00\x2f\x3e\xb6\x04\x00\x00\x00\x00\x00\x00\x85\x04\x00\x00\x40\x05\x2f\x05\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x03\x18\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x05\xf1\x04\x92\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\x3d\xf3\x31\xc5\x3d\x00\x00\x00\x00\x46\x32\x00\x00\x00\x00\xce\x04\x00\x00\x3b\x04\x00\x00\x18\x37\x48\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x03\x00\x00\x00\x00\x6e\x01\xf8\x03\xfe\x03\xb5\x12\x65\x04\x00\x00\x00\x00\x00\x00\xd4\x03\xcc\x03\x00\x00\xc5\x36\x99\x32\xcb\x03\x12\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\xc9\x03\xcb\x02\x16\x04\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x09\x00\x00\x00\x00\x00\x00\xb0\x03\xfd\x03\x2c\x06\x00\x00\x00\x00\xed\x03\x9c\x08\x1d\x3c\xca\x3b\xbc\x03\xd1\x01\x00\x00\x98\x01\xc4\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x03\x9f\x03\x00\x00\x8c\x01\x00\x00\xc9\x02\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x00\x51\x00\x00\x00\x31\x03\x00\x00\x01\x43\x00\x00\x00\x00\x00\x00\x1f\x03\x3c\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x17\x00\x00\x7b\x12\x00\x00\x00\x00\xae\x36\x9d\x01\x00\x00\x00\x42\x36\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xff\x00\x00\x00\x00\x1a\x03\x00\x00\x00\x00\xc1\x03\x00\x00\x00\x00\x00\x00\xab\x03\x00\x00\xbb\x02\x65\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x36\x00\x00\xef\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x41\x07\x00\xb8\x04\x00\x00\x00\x00\x88\x04\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x06\x00\x00\x28\x03\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x02\x00\x00\x00\x00\x59\x04\x64\x12\xec\x00\x59\x08\x48\x03\x00\x00\x91\x02\x00\x00\x00\x00\x00\x00\x69\x0c\xbb\x00\x00\x00\x00\x00\x00\x00\x7d\x02\x00\x00\x00\x00\x00\x00\xdc\x00\x57\x03\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xed\xff\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x01\x44\x08\x00\x00\x00\x00\x9f\x0c\x01\x03\x00\x00\xc2\x02\x35\x02\x00\x00\x92\xff\x9e\x02\x9f\x02\x00\x00\x00\x00\xbc\x02\x00\x00\x00\x00\x48\x02\x33\x02\x00\x00\x44\x36\xb3\x3b\x00\x00\x00\x00\xf1\x35\xda\x35\x87\x35\x00\x00\x00\x00\x00\x00\xb5\x02\x98\x02\x00\x00\xae\x01\x00\x00\x00\x00\xf7\x03\x9b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x01\x00\x00\x00\x00\x00\x00\x3e\x06\x40\x00\x17\x00\x00\x00\xa5\xff\x85\xff\xdc\x0a\xc7\x0c\x00\x00\x00\x00\x00\x00\x00\x00\xce\x05\xf3\x03\x00\x00\x00\x00\x44\x03\x70\x35\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x05\x3c\x00\x1c\x00\x7a\x00\x00\x00\xb7\x03\x00\x00\x32\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x01\x00\x00\x74\x00\x00\x00\x1a\x01\x00\x00\x5f\x00\xa5\xff\x00\x00\xcd\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\xff\x00\x00\x52\x01\x00\x00\x00\x00\x00\x00\x72\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x53\x01\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x23\x00\x00\x00\x51\x02\x19\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x03\x00\x00\x00\x00\x09\x04\x1d\x35\x00\x00\x00\x00\x00\x00\x00\x00\x48\x04\x00\x00\x00\x00\xaf\x09\x00\x00\x64\x00\x49\x00\x00\x00\x00\x00\xd4\xff\xbf\x04\x00\x00\xff\x00\x96\x00\x00\x00\x00\x00\xf0\x01\x00\x00\xfa\x00\x00\x00\x56\x04\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x01\xdc\x0a\x00\x00\x9d\x0a\x16\x01\x00\x00\x15\x01\x00\x00\xf2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x03\x00\x00\x00\x00\x00\x00\xdc\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x03\x00\x00\x00\x00\x02\x01\x37\x05\xc0\x0b\x00\x00\x00\x00\x00\x00\x06\x08\x00\x00\x00\x00\x8a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x02\x00\x00\x90\x03\x2e\x03\xe3\xff\xda\x02\x00\x00\xed\x00\x00\x00\x00\x00\xf1\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x5b\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x00\x00\x00\x1b\x05\x00\x00\x28\x01\x26\x01\xb1\x0b\xec\x03\x00\x00\x9d\x07\x9c\x0b\x00\x00\x6c\x02\x00\x00\x00\x00\xc4\xff\xdc\x07\xae\x07\xa7\xff\x00\x00\x00\x00\x78\x01\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x01\x6b\xff\x00\x00\x00\x00\xc9\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x0b\x01\x00\x00\x00\x00\x00\x00\x50\x01\x99\x07\x00\x00\x50\x00\x00\x00\x2b\x06\x46\x07\xb3\x00\x3b\x00\x00\x00\x31\x07\x00\x00\xd9\x03\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\xff\x00\x00\x2f\x02\x00\x00\x00\x00\x82\x04\x9e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\xff\x00\x00\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x06\x00\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x2f\xfd\x00\x00\x00\x00\x2f\xfd\x00\x00\x00\x00\x00\x00\x2f\xfd\x2f\xfd\x2f\xfd\x2f\xfd\x00\x00\x00\x00\xea\xff\x0a\xfd\x00\x00\xe2\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x00\x00\xbc\xff\x92\xfd\x6c\xfe\x6a\xfe\x64\xfe\x63\xfe\x61\xfe\x5f\xfe\x59\xfe\x4f\xfe\x4a\xfe\x41\xfe\x3e\xfe\x2a\xfe\x00\x00\x00\x00\x3a\xfe\x3b\xfe\x3d\xfe\x82\xfd\x3c\xfe\x7d\xfd\x54\xfd\x63\xfd\x7b\xfd\x78\xfd\x4a\xfd\x39\xfe\x61\xfd\x64\xfd\x62\xfd\x4c\xfd\x4b\xfd\x48\xfd\x49\xfd\x39\xfd\x37\xfd\x38\xfd\x36\xfd\x35\xfd\x34\xfd\x33\xfd\x32\xfd\x31\xfd\x30\xfd\x00\x00\x00\x00\x00\x00\xb3\xfd\x2e\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x2f\xfd\x00\x00\x00\x00\x1e\xfe\x00\x00\x00\x00\x09\xfe\x5d\xfd\x53\xfd\x52\xfd\x50\xfd\x51\xfd\x5c\xfd\x5b\xfd\x5a\xfd\x59\xfd\x58\xfd\x57\xfd\x56\xfd\x55\xfd\x60\xfd\x00\x00\x2f\xfd\x4e\xfd\x4f\xfd\x5e\xfd\x2f\xfd\x2f\xfd\x2f\xfd\x00\x00\x2f\xfd\x5f\xfd\x4d\xfd\x00\x00\x00\x00\x00\x00\x05\xff\xd4\xfe\x0b\xff\x01\xff\xf3\xfe\x00\x00\xe9\xfe\xe8\xfe\x00\xff\xe2\xfe\x00\x00\xd7\xfe\x00\x00\x00\x00\x15\xfd\xdb\xfe\xff\xfe\x16\xfd\xeb\xfe\xea\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xf5\xfe\xe5\xfe\xe6\xfe\xf6\xfe\x00\x00\x00\x00\xf4\xfe\x14\xfd\x13\xfd\x12\xfd\xce\xfe\x00\x00\x00\x00\x00\x00\xd6\xff\xd6\xff\xa2\xfd\x00\x00\x2f\xfd\x00\x00\x6c\xfe\x00\x00\xe2\xff\xf1\xff\xef\xff\x2f\xfd\x00\x00\xe2\xff\x00\x00\x3a\xff\x00\x00\xd6\xff\xd6\xff\x00\x00\xd7\xff\xd9\xff\x00\x00\xe3\xfe\xe4\xfe\x00\x00\x17\xfd\xed\xfe\x65\xfd\x47\xfd\xec\xfe\x45\xfd\x46\xfd\x00\x00\x00\x00\x66\xfd\x00\x00\x00\x00\x0b\xff\xd4\xfe\xd1\xfe\x00\x00\x00\x00\xdf\xfe\x00\x00\x00\x00\xdd\xfe\x1c\xfe\xd1\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x44\xfd\x40\xfd\x43\xfd\x3e\xfd\x3a\xfd\xe1\xfe\x3c\xfd\x00\x00\x3f\xfd\xe6\xfe\x3b\xfd\x00\x00\xd5\xfe\xe7\xfe\xfe\xfe\x02\xff\x00\x00\xd8\xfe\x6e\xfd\x00\x00\x10\xfd\x0f\xfd\x00\x00\x00\x00\xd3\xfe\x0e\xfd\x00\x00\x00\x00\x00\x00\x91\xfd\x97\xfd\x97\xfd\x00\x00\x47\xfe\x00\x00\x50\xfe\x94\xfd\x57\xfe\x5b\xfe\xd6\xff\xd6\xff\x51\xfe\x00\x00\x55\xfe\x00\x00\xd0\xfd\x04\xfe\x00\xfe\x03\xfe\x02\xfe\x01\xfe\xfc\xfd\xfb\xfd\xfa\xfd\xf9\xfd\xf7\xfd\xf8\xfd\xf6\xfd\xf5\xfd\xf4\xfd\xf3\xfd\xf2\xfd\xf1\xfd\xf0\xfd\xef\xfd\xee\xfd\xed\xfd\xec\xfd\xfe\xfd\xfd\xfd\xeb\xfd\xea\xfd\xe9\xfd\xe8\xfd\xe7\xfd\xe6\xfd\xe5\xfd\xe4\xfd\xe3\xfd\xe2\xfd\xe1\xfd\xe0\xfd\xdf\xfd\xde\xfd\xdd\xfd\xdc\xfd\xdb\xfd\xda\xfd\xd9\xfd\xd8\xfd\xd7\xfd\xd6\xfd\xd5\xfd\xff\xfd\xd4\xfd\xd3\xfd\xd2\xfd\x1f\xfe\x20\xfe\x00\x00\x00\x00\x00\x00\x22\xfe\x21\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x63\xfe\x00\x00\x00\x00\x11\xfe\x00\x00\xa1\xfd\x52\xfe\x43\xfe\x42\xfe\x03\xff\x00\x00\x48\xfe\x2f\xfd\x1b\xfe\xb2\xfd\xb1\xfd\x00\x00\x68\xfd\x67\xfd\x00\x00\x72\xfd\x42\xfd\x41\xfd\x00\x00\x3d\xfd\xcc\xfd\x00\x00\xcb\xfd\x86\xfd\x00\x00\x00\x00\x84\xfd\x1b\xfe\x00\x00\x00\x00\x00\x00\x6e\xfd\x00\x00\x42\xfd\x41\xfd\x87\xfd\x3f\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x4b\xfe\x6a\xfd\x69\xfd\x69\xfe\x74\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\xff\x00\x00\x07\xfd\x09\xfd\x00\x00\x00\x00\xd6\xff\xd6\xff\xd6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xff\x11\xff\x81\xfd\x7a\xfd\x00\x00\x00\x00\x00\x00\xd6\xff\x00\x00\x00\x00\xea\xff\xec\xff\x2d\xfd\x2e\xfd\x0b\xfd\x1a\xfd\x19\xfd\xd6\xff\x08\xfd\xd6\xff\xbd\xff\xb8\xff\xbb\xff\x65\xfe\x66\xfe\x67\xfe\x68\xfe\x6b\xfe\x00\x00\x00\x00\x62\xfe\x60\xfe\x00\x00\x8f\xfd\x8c\xfd\x00\x00\x40\xfe\x8e\xfd\x93\xfd\x44\xfe\x45\xfe\x7c\xfd\x77\xfd\x2d\xfe\x00\x00\x37\xfe\x38\xfe\x00\x00\x85\xfd\x1d\xfe\x00\x00\x00\x00\x00\x00\x34\xfe\x33\xfe\x00\x00\x83\xfd\x00\x00\x30\xfe\x00\x00\xca\xfd\x00\x00\x00\x00\x1a\xfe\x2f\xfe\x00\x00\x00\x00\x00\x00\x53\xfe\xd6\xff\xd6\xff\x49\xfe\x00\x00\x00\x00\x2c\xfe\x00\x00\x28\xfe\x27\xfe\x00\x00\x26\xfe\x25\xfe\x55\xff\x9f\xff\x00\x00\xd6\xff\x91\xff\x90\xff\x00\x00\x7c\xff\x56\xff\x4f\xff\x4e\xff\x54\xff\x83\xff\x63\xfe\x53\xff\x2c\xfd\x52\xff\x00\x00\x00\x00\x00\x00\x5f\xff\x00\x00\x00\x00\x9d\xff\x9c\xff\x9b\xff\x68\xff\x5e\xff\x00\x00\x00\x00\x21\xff\x21\xff\x21\xff\x21\xff\x23\xff\x15\xff\x15\xff\x00\x00\x41\xff\x00\x00\x23\xfe\x00\x00\xcd\xfd\x0c\xfe\x00\x00\x06\xfe\x0a\xfe\x56\xfe\x08\xfe\x00\x00\x2f\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x58\xfe\x00\x00\x46\xfe\x00\x00\x00\x00\x95\xfd\x97\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x08\xff\x00\x00\x09\xff\x0a\xff\x06\xff\xe0\xfe\xd9\xfe\xda\xfe\xde\xfe\xfd\xfe\xf9\xfe\x00\x00\xdc\xfe\xfc\xfe\x00\x00\x00\x00\xf0\xfe\xfb\xfe\xfa\xfe\xf7\xfe\x00\x00\xf1\xfe\x00\x00\xee\xfe\xcf\xfe\xcd\xfe\x00\x00\x00\x00\xd6\xff\xd6\xff\xbf\xff\xdb\xff\xd8\xff\xde\xff\x59\xff\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xff\x00\x00\xd0\xfd\xe4\xff\xcd\xfd\x00\x00\xd4\xff\x00\x00\x00\x00\x38\xff\x50\xff\x39\xff\x51\xff\xd6\xff\x57\xff\x72\xfe\xd6\xff\x89\xfd\x3d\xfe\x00\x00\xd7\xff\xda\xff\xdd\xff\xd6\xfe\x00\x00\xef\xfe\xf2\xfe\xd2\xfe\xd0\xfe\x00\x00\xa6\xfe\xa5\xfe\xa3\xfe\x9f\xfe\x9e\xfe\x9d\xfe\x00\x00\x00\x00\xa1\xfe\x11\xfd\x00\x00\x4d\xfe\x4e\xfe\x9a\xfd\x98\xfd\x99\xfd\x97\xfd\x9b\xfd\x5a\xfe\x5d\xfe\x00\x00\x9f\xfd\xa0\xfd\x9c\xfd\xd6\xff\x00\x00\x54\xfe\x11\xfe\x00\x00\x00\x00\xce\xfd\x00\x00\xd1\xfd\x00\x00\x61\xfd\x48\xfd\x5d\xfd\x53\xfd\x52\xfd\x50\xfd\x51\xfd\x5c\xfd\x5b\xfd\x5a\xfd\x59\xfd\x58\xfd\x57\xfd\x56\xfd\x55\xfd\x60\xfd\x4e\xfd\x4f\xfd\x5e\xfd\x5f\xfd\x05\xfe\x00\x00\x42\xff\x40\xff\x3e\xff\x3b\xff\x00\x00\x00\x00\x00\x00\x16\xff\x00\x00\x13\xff\x00\x00\x00\x00\x24\xff\x21\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\xff\x5b\xff\x00\x00\xc8\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\xfe\x00\x00\xd7\xff\x93\xff\x00\x00\x00\x00\x9e\xff\xb5\xfd\x00\x00\xb7\xfd\x00\x00\x2f\xfd\x12\xfe\x5e\xfe\x00\x00\x00\x00\x00\x00\xae\xfd\xc2\xfd\xc0\xfd\xbf\xfd\xbe\xfd\x00\x00\xb0\xfd\x1b\xfe\xc4\xfd\x71\xfd\xc6\xfd\xc8\xfd\x1b\xfe\xc5\xfd\x31\xfe\x32\xfe\x00\x00\x13\xfe\x19\xfe\x0f\xfe\x10\xfe\x35\xfe\x36\xfe\x00\x00\x16\xfe\x00\x00\x00\x00\x3f\xfe\x6d\xfd\x73\xfd\xb6\xff\xb9\xff\x00\x00\x00\x00\xeb\xff\xe8\xff\xe5\xff\x00\x00\x00\x00\x00\x00\x0e\xff\x00\x00\x00\x00\xe7\xff\x0d\xff\x80\xfd\x79\xfd\x0f\xff\xe6\xff\xe9\xff\xd6\xff\xd6\xff\x00\x00\xb7\xff\x90\xfd\x8d\xfd\x18\xfe\x17\xfe\x15\xfe\x14\xfe\xc9\xfd\x00\x00\x00\x00\xbd\xfd\x00\x00\x00\x00\xac\xfd\xad\xfd\xd6\xff\xa9\xfd\x00\x00\xb4\xfd\x00\x00\x00\x00\x2b\xfe\xa0\xff\x6c\xfd\x6b\xfd\x99\xff\x70\xfd\x76\xfd\x00\x00\x24\xfe\x92\xff\x97\xfe\xac\xfe\xc1\xfe\x00\x00\xb5\xfe\x4d\xff\x00\x00\x36\xff\x74\xfe\x70\xfe\x6e\xfe\x00\x00\x00\x00\x74\xfe\x29\xff\x35\xff\x34\xff\x33\xff\x32\xff\x31\xff\x30\xff\x2f\xff\x2e\xff\x00\x00\x93\xfe\xca\xfe\x7b\xff\x00\x00\x5c\xff\x07\xff\x5d\xff\x00\x00\x6a\xff\x6b\xff\x69\xff\x83\xfe\x6f\xff\x00\x00\x00\x00\x0c\xff\x79\xff\x00\x00\x00\x00\x00\x00\x00\x00\x25\xfd\x28\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\xff\x25\xff\x80\xff\x17\xff\x7f\xff\x00\x00\x14\xff\x7e\xff\x7d\xff\x00\x00\x00\x00\x00\x00\x46\xff\x09\xfe\x0d\xfe\x00\x00\x0b\xfe\x07\xfe\x00\x00\x9e\xfd\x57\xfe\x96\xfd\x00\x00\x00\x00\x00\x00\xa6\xfe\x9c\xfe\xa2\xfe\x00\x00\xf8\xfe\x00\x00\xc0\xff\xdc\xff\x00\x00\xd7\xff\x8b\xfd\x00\x00\xd7\xff\x5a\xff\x00\x00\x00\x00\x00\x00\xd5\xff\xd0\xff\xf0\xff\x00\x00\x09\xfe\xed\xff\x00\x00\xd0\xff\xce\xff\xcd\xff\xcb\xff\x00\x00\xd1\xff\x00\x00\x00\x00\x00\x00\xe3\xff\xe1\xff\xe0\xff\x58\xff\x8a\xfd\x00\x00\x88\xfd\x00\x00\xa4\xfe\xa0\xfe\x00\x00\x9a\xfe\x00\x00\x00\x00\x9d\xfd\x00\x00\xcf\xfd\x55\xfe\x3f\xff\x3d\xff\x3c\xff\x12\xff\x18\xff\x26\xff\x00\x00\x00\x00\x00\x00\x00\x00\x20\xff\x00\x00\x47\xff\x4a\xff\x4b\xff\x1b\xfd\x00\x00\x1f\xfd\xce\xfe\x23\xfd\x00\x00\x24\xfd\x27\xfd\x2a\xfd\x2b\xfd\x8f\xff\x98\xff\x00\x00\x00\x00\x00\x00\x70\xff\x86\xff\x2f\xfd\x85\xff\x84\xff\x8a\xff\x00\x00\x00\x00\xc7\xfe\xc5\xfe\x87\xff\x2f\xfd\x81\xff\x00\x00\x7f\xfd\x00\x00\x00\x00\x00\x00\x2d\xff\x2c\xff\x2b\xff\x2a\xff\x76\xfe\x2f\xfd\x00\x00\x71\xfe\x6f\xfe\x77\xfe\x00\x00\x00\x00\xbb\xfe\xb9\xfe\x00\x00\xce\xfe\x96\xfe\xac\xfe\x2f\xfd\x8c\xff\x00\x00\xac\xfe\xc1\xfe\x00\x00\x00\x00\x00\x00\xb8\xfd\xb6\xfd\x74\xfe\xa6\xfd\xa4\xfd\x00\x00\xd7\xff\xab\xfd\xc1\xfd\x00\x00\x00\x00\x00\x00\xaf\xfd\xc3\xfd\xc7\xfd\xb4\xff\xd7\xff\x00\x00\x00\x00\x0c\xfd\x0d\xfd\xb2\xff\x00\x00\xbc\xfd\xba\xfd\xbb\xfd\xaa\xfd\xa7\xfd\xa5\xfd\xa8\xfd\x9a\xff\x6f\xfd\x75\xfd\xac\xfe\x89\xff\xab\xfe\xa7\xfe\x00\x00\xd6\xff\xd6\xff\x8b\xff\x00\x00\x00\x00\xb0\xfe\x00\x00\xb7\xfe\xb4\xfe\x00\x00\xdb\xfe\x00\x00\xb5\xfe\x4c\xff\x37\xff\x00\x00\x00\x00\x75\xfe\x82\xff\x00\x00\x00\x00\x00\x00\xd6\xff\xd6\xff\xca\xfe\xcb\xfe\xca\xfe\x7a\xff\xd6\xff\xd6\xff\x6e\xff\x6d\xff\x6c\xff\x8d\xff\x77\xff\x78\xff\x67\xff\x97\xff\x00\x00\x29\xfd\x2f\xfd\x26\xfd\x00\x00\x00\x00\x1c\xfd\x00\x00\x00\x00\x45\xff\x43\xff\x1f\xff\x00\x00\x00\x00\x1c\xff\x1a\xff\x00\x00\x00\x00\x00\x00\xa3\xfd\x00\x00\x00\x00\x99\xfe\x00\x00\xcc\xfe\xc7\xff\x00\x00\xcc\xff\xc2\xff\xc1\xff\xc8\xff\x00\x00\x00\x00\xd1\xff\xd2\xff\x00\x00\x00\x00\xcf\xff\xd3\xff\x00\x00\xc5\xff\xc3\xff\xa2\xff\xa1\xff\xca\xff\xc4\xff\x9b\xfe\x00\x00\x00\x00\x5c\xfe\x00\x00\x00\x00\x00\x00\x1b\xff\x1d\xff\x48\xff\x00\x00\x49\xff\x1d\xfd\x00\x00\x22\xfd\xd6\xff\xd6\xff\x00\x00\x8e\xff\x2f\xfd\x81\xfe\x00\x00\x00\x00\x00\x00\xc4\xfe\xc6\xfe\x91\xfe\x00\x00\x00\x00\x27\xff\x00\x00\x7e\xfd\x6d\xfe\xba\xfe\x00\x00\x00\x00\xb0\xfe\xb8\xfe\x00\x00\x00\x00\xb6\xfe\x00\x00\x00\x00\x00\x00\xa8\xfe\x00\x00\xaa\xfe\x88\xff\x00\x00\xb5\xff\xbe\xff\xb3\xff\x00\x00\xaf\xff\xd0\xff\xb9\xfd\xa9\xfe\xc2\xfe\xc3\xfe\xd6\xff\xbe\xfe\x00\x00\xb3\xfe\x04\xff\x00\x00\x00\x00\xae\xfe\xb2\xfe\xda\xfe\x28\xff\x94\xfe\x95\xfe\x8e\xfe\xd6\xff\x8f\xfe\x8d\xfe\x8b\xfe\x00\x00\x00\x00\xc9\xfe\x84\xfe\x85\xfe\x00\x00\x7b\xfe\x7c\xfe\xd6\xff\x7f\xfe\x7d\xfe\x7e\xfe\x5f\xff\x00\x00\x66\xff\x00\x00\x00\x00\x00\x00\x59\xff\x00\x00\x00\x00\x1e\xfd\x44\xff\x00\x00\x22\xff\x00\x00\x00\x00\x98\xfe\xc9\xff\x00\x00\x00\x00\xee\xff\xc6\xff\x00\x00\x0e\xfe\x00\x00\x20\xfd\x21\xfd\x96\xff\x94\xff\x00\x00\x61\xff\x00\x00\x00\x00\x00\x00\xd7\xff\x82\xfe\x97\xfe\x73\xff\x00\x00\x00\x00\x8c\xfe\x00\x00\x00\x00\x8a\xfe\xd7\xff\x92\xfe\xb1\xfe\x00\x00\x00\x00\x00\x00\xd7\xff\xc0\xfe\x00\x00\xd0\xff\xac\xff\xab\xff\x18\xfd\xa8\xff\x00\x00\x00\x00\xa9\xff\xaa\xff\x00\x00\x00\x00\xd1\xff\xb0\xff\xbf\xfe\xbd\xfe\x00\x00\xad\xfe\xaf\xfe\x90\xfe\x7b\xff\x00\x00\x86\xfe\x76\xff\x88\xfe\x00\x00\x00\x00\xac\xfe\xc1\xfe\x80\xfe\x00\x00\x64\xff\x62\xff\x00\x00\x65\xff\x95\xff\x19\xff\x4c\xfe\x60\xff\x63\xff\x7a\xfe\xac\xfe\x79\xfe\x98\xff\x72\xff\x87\xfe\x00\x00\x00\x00\x4d\xff\x89\xfe\x00\x00\xad\xff\xb1\xff\x00\x00\xa3\xff\xa6\xff\x00\x00\xa7\xff\xa5\xff\x00\x00\x00\x00\x00\x00\x75\xff\x71\xff\x78\xfe\x74\xff\x00\x00\xa4\xff\xbc\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x04\x00\x04\x00\x04\x00\x02\x00\x04\x00\x04\x00\x04\x00\x24\x00\x11\x00\x12\x00\x13\x00\x38\x00\x6f\x00\x2b\x00\x4b\x00\x67\x00\x0d\x00\x0e\x00\x0b\x00\x6f\x00\x83\x00\x0b\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x1f\x00\x17\x00\x0d\x00\x0e\x00\x78\x00\x0d\x00\x0e\x00\xc4\x00\x11\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x1b\x00\x0d\x00\x0e\x00\x53\x00\x54\x00\x40\x00\x0d\x00\x0e\x00\x40\x00\x1b\x00\x40\x00\x21\x00\x22\x00\xc4\x00\x13\x00\x4a\x00\x1b\x00\x40\x00\x4a\x00\x1b\x00\x4a\x00\x1b\x00\x23\x00\x0d\x00\x0e\x00\x3d\x00\xcf\x00\x4a\x00\x80\x00\x1b\x00\x01\x00\x3d\x00\xdd\x00\x0d\x00\x0e\x00\xcf\x00\xcf\x00\x0d\x00\x0e\x00\x1b\x00\x2a\x00\x60\x00\x1b\x00\x1c\x00\x0d\x00\xf7\x00\x0d\x00\x0e\x00\x00\x00\xee\x00\x53\x00\x54\x00\x14\x00\x15\x00\x00\x00\x81\x00\x46\x00\x47\x00\x48\x00\x49\x00\x0a\x00\x22\x00\x0c\x00\xe2\x00\xf7\x00\x24\x00\xf7\x00\x50\x00\x24\x00\x7c\x00\x72\x00\x23\x00\x6b\x00\x0d\x00\x0e\x00\xf7\x00\xf7\x00\xf0\x00\x1e\x00\x4e\x00\x31\x00\x1b\x00\x4e\x00\x16\x00\x1e\x00\x06\x00\x2f\x00\xed\x00\xee\x00\x31\x00\x28\x00\x1d\x00\x15\x00\xde\x00\x3d\x00\x3b\x00\xea\x00\x23\x00\x6d\x00\x3c\x00\x48\x00\x76\x00\x4a\x00\xea\x00\x17\x00\x18\x00\x1b\x00\x24\x00\xed\x00\xee\x00\xed\x00\xee\x00\x47\x00\x48\x00\x49\x00\x8e\x00\x8f\x00\x90\x00\x25\x00\xdb\x00\x27\x00\x3d\x00\x04\x01\x05\x01\x6d\x00\x2c\x00\x2d\x00\x2e\x00\x8c\x00\x04\x01\x05\x01\x95\x00\x33\x00\xe9\x00\xea\x00\xeb\x00\x75\x00\x18\x00\x28\x00\x92\x00\x3b\x00\x95\x00\x76\x00\x95\x00\x3f\x00\x75\x00\x41\x00\x42\x00\x43\x00\xd9\x00\x25\x00\x95\x00\x27\x00\xdd\x00\xea\x00\xeb\x00\x92\x00\x2c\x00\x2d\x00\x2e\x00\x8c\x00\x95\x00\x18\x00\xf7\x00\x33\x00\xea\x00\xea\x00\xeb\x00\x23\x00\xc5\x00\xee\x00\xdb\x00\x3b\x00\x23\x00\xde\x00\x2a\x00\x3f\x00\xd5\x00\x41\x00\x42\x00\x43\x00\xcd\x00\xc5\x00\xd5\x00\xcd\x00\xe9\x00\xea\x00\xeb\x00\xf7\x00\xed\x00\xee\x00\xf7\x00\x05\x01\xf7\x00\x70\x00\xd9\x00\x23\x00\x24\x00\x74\x00\xdd\x00\xf7\x00\xea\x00\xeb\x00\xd9\x00\xf7\x00\xf7\x00\xf7\x00\x00\x00\xf7\x00\xf7\x00\xf7\x00\x03\x01\xea\x00\xeb\x00\xdb\x00\xf7\x00\xee\x00\xde\x00\xf7\x00\xda\x00\xea\x00\xeb\x00\xda\x00\x09\x01\x0b\x01\x0a\x01\x06\x00\x07\x00\xe9\x00\xea\x00\xeb\x00\x96\x00\xed\x00\xee\x00\x1b\x00\xea\x00\x02\x01\x1e\x00\xea\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\x17\x00\xd9\x00\xa4\x00\xa5\x00\xa6\x00\xdd\x00\xd9\x00\xa9\x00\xaa\x00\xab\x00\xdd\x00\x03\x01\x47\x00\x48\x00\x49\x00\xd9\x00\xb2\x00\x23\x00\xea\x00\xeb\x00\x96\x00\x27\x00\xee\x00\xea\x00\xeb\x00\x81\x00\x2c\x00\xee\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xea\x00\xeb\x00\xa4\x00\xa5\x00\xa6\x00\xdb\x00\x4b\x00\xa9\x00\xaa\x00\xab\x00\x02\x01\x48\x00\x49\x00\xd9\x00\xea\x00\xeb\x00\xb2\x00\xdd\x00\xea\x00\xe9\x00\xea\x00\xeb\x00\xd8\x00\xed\x00\xee\x00\xdb\x00\xdc\x00\x4b\x00\xde\x00\x32\x00\xea\x00\xeb\x00\x6f\x00\xfd\x00\xee\x00\xea\x00\x18\x00\x0a\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x05\x01\xdf\x00\x23\x00\x23\x00\xe2\x00\x52\x00\xe4\x00\xf6\x00\x6f\x00\xd8\x00\xf9\x00\xfa\x00\xdb\x00\xdc\x00\x2e\x00\xde\x00\xff\x00\x05\x01\xf0\x00\x25\x00\x23\x00\xf3\x00\xf4\x00\x2f\x00\xea\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x6d\x00\x11\x00\x7f\x00\x80\x00\x77\x00\x78\x00\x25\x00\xf6\x00\x27\x00\x8f\x00\xf9\x00\xfa\x00\x3b\x00\x2c\x00\x2d\x00\x2e\x00\xff\x00\x4b\x00\x04\x01\x05\x01\x33\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x79\x00\xd9\x00\xf8\x00\x3b\x00\xea\x00\xdd\x00\x25\x00\x3f\x00\x27\x00\x41\x00\x42\x00\x43\x00\x06\x00\x07\x00\x09\x00\x2e\x00\x0b\x00\x8a\x00\xea\x00\xeb\x00\x33\x00\xda\x00\xee\x00\xac\x00\xd9\x00\x26\x00\xaf\x00\x28\x00\x3b\x00\x17\x00\x04\x01\x05\x01\x3f\x00\xea\x00\x41\x00\x42\x00\x43\x00\xea\x00\x33\x00\x34\x00\x35\x00\xea\x00\xeb\x00\x26\x00\x7f\x00\x80\x00\x09\x00\x0a\x00\xdb\x00\x09\x00\xf3\x00\xf4\x00\xac\x00\xea\x00\xd9\x00\xaf\x00\x33\x00\x34\x00\x35\x00\x04\x01\x05\x01\xde\x00\xe9\x00\xea\x00\xeb\x00\x56\x00\x57\x00\x58\x00\xf8\x00\xdb\x00\x79\x00\xea\x00\xeb\x00\xf8\x00\xea\x00\x26\x00\xed\x00\xee\x00\x26\x00\x04\x01\x05\x01\xf8\x00\xde\x00\xe9\x00\xea\x00\xeb\x00\xf8\x00\x8a\x00\x33\x00\x34\x00\x35\x00\x33\x00\x34\x00\x35\x00\x96\x00\x66\x00\x67\x00\xed\x00\xee\x00\xee\x00\x04\x01\x05\x01\x9e\x00\x9f\x00\xa0\x00\xa1\x00\x18\x00\xca\x00\xa4\x00\xa5\x00\xa6\x00\xce\x00\xf7\x00\xa9\x00\xaa\x00\xab\x00\x25\x00\x23\x00\x27\x00\x96\x00\x06\x00\x07\x00\xb2\x00\x55\x00\x56\x00\x57\x00\x58\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xd9\x00\x37\x00\xa4\x00\xa5\x00\xa6\x00\xdb\x00\x17\x00\xa9\x00\xaa\x00\xab\x00\x1b\x00\x3f\x00\xdb\x00\x41\x00\x42\x00\x43\x00\xb2\x00\xea\x00\xeb\x00\xe9\x00\xea\x00\xeb\x00\xe7\x00\x18\x00\xea\x00\xeb\x00\xe9\x00\xea\x00\xeb\x00\xd8\x00\xef\x00\xf0\x00\xdb\x00\xdc\x00\x23\x00\xde\x00\x5f\x00\x81\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x29\x00\x2a\x00\xd8\x00\x18\x00\x18\x00\xdb\x00\xdc\x00\xf6\x00\xde\x00\x79\x00\xf9\x00\xfa\x00\xf7\x00\xd9\x00\x23\x00\x23\x00\xff\x00\xdd\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x25\x00\x8a\x00\x27\x00\xd7\x00\x08\x01\xea\x00\xeb\x00\xf6\x00\xdc\x00\xee\x00\xf9\x00\xfa\x00\x8d\x00\x8e\x00\x1d\x00\x90\x00\xff\x00\xea\x00\xeb\x00\xea\x00\x23\x00\x96\x00\xed\x00\xee\x00\xec\x00\x3e\x00\x3f\x00\x06\x00\x41\x00\x42\x00\x43\x00\xa0\x00\x25\x00\xa3\x00\x27\x00\xa4\x00\xfd\x00\xa6\x00\x0d\x00\x0e\x00\xa9\x00\xaa\x00\xab\x00\x01\x01\x17\x00\x04\x01\x05\x01\xd9\x00\xb2\x00\xb2\x00\xb4\x00\xdd\x00\xd9\x00\xf8\x00\x55\x00\x56\x00\x57\x00\x58\x00\x3f\x00\x27\x00\x41\x00\x42\x00\x43\x00\x18\x00\xea\x00\xeb\x00\x2e\x00\x1b\x00\xee\x00\xea\x00\xeb\x00\xa3\x00\x5a\x00\x5b\x00\xea\x00\xeb\x00\xea\x00\xeb\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xb2\x00\xd8\x00\xb4\x00\x07\x00\xdb\x00\xdc\x00\xfc\x00\xde\x00\xfc\x00\x0d\x00\x0e\x00\x1d\x00\xea\x00\x06\x00\x07\x00\xed\x00\xee\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x97\x00\x47\x00\x48\x00\x96\x00\x4a\x00\x4b\x00\x17\x00\xf6\x00\x1b\x00\x4f\x00\xf9\x00\xfa\x00\x23\x00\xa0\x00\x04\x01\x05\x01\xff\x00\xa4\x00\x29\x00\xa6\x00\x06\x00\x07\x00\xa9\x00\xaa\x00\xab\x00\x2c\x00\x18\x00\x8e\x00\x18\x00\x90\x00\xca\x00\xb2\x00\x25\x00\x1a\x00\x27\x00\x96\x00\xb2\x00\x17\x00\xb4\x00\x23\x00\x23\x00\x1a\x00\x23\x00\x29\x00\xea\x00\xa0\x00\x29\x00\xed\x00\xee\x00\xa4\x00\x23\x00\xa6\x00\x27\x00\x75\x00\xa9\x00\xaa\x00\xab\x00\x3e\x00\x3f\x00\x2e\x00\x41\x00\x42\x00\x43\x00\xb2\x00\x81\x00\x57\x00\x58\x00\xd6\x00\xd7\x00\xd8\x00\x04\x01\x05\x01\xdb\x00\xdc\x00\x23\x00\xde\x00\xd9\x00\xf7\x00\x27\x00\xac\x00\xdd\x00\x20\x00\xaf\x00\x2c\x00\x23\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x70\x00\xea\x00\xeb\x00\x73\x00\x74\x00\xee\x00\xdd\x00\xf6\x00\x81\x00\xd8\x00\xf9\x00\xfa\x00\xdb\x00\xdc\x00\xea\x00\xde\x00\xff\x00\xed\x00\xee\x00\xea\x00\xeb\x00\x58\x00\x59\x00\xee\x00\x1a\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x25\x00\x23\x00\x27\x00\xdb\x00\xfb\x00\x1a\x00\x1a\x00\xf6\x00\x04\x01\x05\x01\xf9\x00\xfa\x00\x39\x00\x3a\x00\x23\x00\x23\x00\xff\x00\xe9\x00\xea\x00\xeb\x00\x6e\x00\x96\x00\xac\x00\x1a\x00\xae\x00\xf7\x00\x3f\x00\xac\x00\x41\x00\x42\x00\x43\x00\xa0\x00\x23\x00\x03\x00\x35\x00\xa4\x00\x01\x00\xa6\x00\x08\x00\x09\x00\xa9\x00\xaa\x00\xab\x00\x08\x00\x09\x00\xf7\x00\x5b\x00\x2a\x00\x5d\x00\xb2\x00\x2d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x6e\x00\x69\x00\x6a\x00\x6b\x00\x31\x00\xdf\x00\x01\x00\x34\x00\xe2\x00\xac\x00\xe4\x00\xae\x00\xd9\x00\x08\x00\x09\x00\xfe\x00\xdd\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\xf0\x00\x0d\x00\x0e\x00\xf3\x00\xf4\x00\xe7\x00\xd8\x00\xea\x00\xeb\x00\xdb\x00\xdc\x00\xee\x00\xde\x00\xef\x00\xf0\x00\xf1\x00\x01\x01\xf3\x00\xf4\x00\xf5\x00\x0d\x00\x0e\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x39\x00\x3a\x00\xf0\x00\x96\x00\xb3\x00\xf3\x00\xf4\x00\xf6\x00\xd9\x00\x11\x00\xf9\x00\xfa\x00\xdd\x00\xa0\x00\x58\x00\x59\x00\xff\x00\xa4\x00\xac\x00\xa6\x00\xae\x00\xa2\x00\xa9\x00\xaa\x00\xab\x00\xea\x00\xeb\x00\xb3\x00\x1b\x00\xee\x00\x1d\x00\xb2\x00\xca\x00\x1b\x00\x5b\x00\x1d\x00\x5d\x00\xdb\x00\x50\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xdb\x00\x69\x00\x6a\x00\x6b\x00\xe9\x00\xea\x00\xeb\x00\x52\x00\xde\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xe9\x00\xea\x00\xeb\x00\x4f\x00\xdc\x00\xe9\x00\xea\x00\xeb\x00\xd8\x00\xed\x00\xee\x00\xdb\x00\xdc\x00\x3a\x00\xde\x00\x1e\x00\x1f\x00\x20\x00\xea\x00\x98\x00\xec\x00\xed\x00\xee\x00\x30\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x03\x01\x3a\x00\x70\x00\x71\x00\xe9\x00\xea\x00\xeb\x00\xf6\x00\xed\x00\xee\x00\xf9\x00\xfa\x00\x34\x00\x04\x01\x05\x01\x5b\x00\xff\x00\x5d\x00\xf3\x00\xf4\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x91\x00\x69\x00\x6a\x00\x6b\x00\x2f\x00\x2a\x00\x5b\x00\x2c\x00\x5d\x00\xf3\x00\xf4\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x8b\x00\x69\x00\x6a\x00\x6b\x00\xd9\x00\xe9\x00\xea\x00\xeb\x00\xdd\x00\xed\x00\xee\x00\x4d\x00\x3c\x00\xe0\x00\x97\x00\x2c\x00\xe3\x00\x2e\x00\xe5\x00\x9b\x00\xe7\x00\xea\x00\xeb\x00\x97\x00\xdc\x00\xee\x00\x7b\x00\x7c\x00\xef\x00\xf0\x00\xf1\x00\x75\x00\xf3\x00\xf4\x00\xf5\x00\xea\x00\xeb\x00\x81\x00\xea\x00\xee\x00\xec\x00\xed\x00\xee\x00\x5b\x00\x5c\x00\x5d\x00\x29\x00\x2a\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x44\x00\x45\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xe7\x00\x01\x01\x04\x01\x05\x01\x53\x00\x54\x00\x55\x00\x56\x00\xef\x00\xf0\x00\xf1\x00\xee\x00\xf3\x00\xf4\x00\xf5\x00\x1c\x00\x2a\x00\x5b\x00\x2c\x00\x5d\x00\xea\x00\xeb\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x5a\x00\x5b\x00\x6a\x00\x6b\x00\x4c\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xb5\x00\xb6\x00\xb7\x00\x4c\x00\xde\x00\xea\x00\x72\x00\xec\x00\xed\x00\xee\x00\xdc\x00\x87\x00\x88\x00\xe7\x00\x44\x00\x45\x00\xb5\x00\xb6\x00\xb7\x00\xed\x00\xee\x00\xef\x00\xf0\x00\x0a\x00\xea\x00\x0c\x00\xec\x00\xed\x00\xee\x00\x0d\x00\x0e\x00\x04\x01\x05\x01\x7a\x00\x7b\x00\x7c\x00\x28\x00\x5b\x00\x2a\x00\x5d\x00\xf8\x00\x03\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x04\x01\x05\x01\x6a\x00\x6b\x00\xf1\x00\xf0\x00\xf3\x00\xf4\x00\xf5\x00\x2c\x00\x3b\x00\x2e\x00\x44\x00\x45\x00\x0d\x00\x0e\x00\xdc\x00\x42\x00\x43\x00\xc8\x00\xc9\x00\xca\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x99\x00\x9a\x00\x9b\x00\xea\x00\x36\x00\xec\x00\xed\x00\xee\x00\x5b\x00\x28\x00\x5d\x00\x2a\x00\x51\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xde\x00\x03\x00\x6a\x00\x6b\x00\xdc\x00\x28\x00\x01\x00\x2a\x00\x04\x01\x05\x01\x0a\x00\xe9\x00\xea\x00\xeb\x00\xb8\x00\xed\x00\xee\x00\x28\x00\xea\x00\x2a\x00\xec\x00\xed\x00\xee\x00\x06\x00\x07\x00\x0d\x00\x0e\x00\x0a\x00\x17\x00\x0c\x00\xf8\x00\x28\x00\xea\x00\x2a\x00\xf8\x00\xed\x00\xee\x00\x03\x01\x17\x00\x18\x00\x17\x00\x99\x00\x9a\x00\x9b\x00\x04\x01\x05\x01\xd1\x00\x28\x00\x1f\x00\x2a\x00\x93\x00\x94\x00\x95\x00\x96\x00\x3b\x00\x17\x00\x18\x00\x28\x00\x04\x01\x05\x01\xf8\x00\x42\x00\x43\x00\xa0\x00\xde\x00\x0f\x00\x10\x00\xa4\x00\xdc\x00\xa6\x00\xef\x00\xf0\x00\xa9\x00\xaa\x00\xab\x00\xe9\x00\xea\x00\xeb\x00\x51\x00\xed\x00\xee\x00\xb2\x00\xea\x00\xf8\x00\xec\x00\xed\x00\xee\x00\x52\x00\x41\x00\x42\x00\x43\x00\x51\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x03\x01\xb5\x00\xb6\x00\xb7\x00\xd3\x00\xd4\x00\x51\x00\x04\x01\x05\x01\x0d\x00\x0e\x00\x6b\x00\xdb\x00\x51\x00\x28\x00\xdc\x00\x2a\x00\x36\x00\xd8\x00\x0d\x00\x0e\x00\xdb\x00\xdc\x00\x28\x00\xde\x00\x2a\x00\xe9\x00\xea\x00\xeb\x00\xea\x00\x7e\x00\xec\x00\xed\x00\xee\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x26\x00\x94\x00\x95\x00\x96\x00\x0c\x00\x0d\x00\x0e\x00\xf6\x00\x0c\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\xa0\x00\x04\x01\x05\x01\x28\x00\xa4\x00\x2a\x00\xa6\x00\xd3\x00\xd4\x00\xa9\x00\xaa\x00\xab\x00\xf8\x00\x5a\x00\x5b\x00\xdb\x00\x0d\x00\x0e\x00\xb2\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1b\x00\xa0\x00\xe9\x00\xea\x00\xeb\x00\xa4\x00\x28\x00\xa6\x00\x2a\x00\xf8\x00\xa9\x00\xaa\x00\xab\x00\xee\x00\x5a\x00\x5b\x00\x92\x00\x93\x00\x94\x00\xb2\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x28\x00\xd8\x00\x2a\x00\xee\x00\xdb\x00\xdc\x00\x28\x00\xde\x00\x2a\x00\x01\x01\x09\x00\x0a\x00\x0b\x00\x0c\x00\xb5\x00\xb6\x00\xb7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x8e\x00\x8f\x00\x90\x00\xac\x00\x28\x00\xd8\x00\x2a\x00\xf6\x00\xdb\x00\xdc\x00\x1a\x00\xde\x00\x23\x00\xb8\x00\x25\x00\x26\x00\xa2\x00\x28\x00\x29\x00\x0d\x00\x0e\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x33\x00\x34\x00\x35\x00\x5b\x00\x28\x00\x5d\x00\x2a\x00\xf6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xb6\x00\xb7\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xf8\x00\x09\x00\x0a\x00\x4f\x00\x50\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x5b\x00\x01\x01\x5d\x00\x05\x00\x06\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x0e\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\xea\x00\x25\x00\x26\x00\xed\x00\xee\x00\x25\x00\x26\x00\x6e\x00\x28\x00\x29\x00\x28\x00\x28\x00\x2a\x00\x2a\x00\xb3\x00\x33\x00\x34\x00\x35\x00\x64\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x04\x01\x05\x01\xea\x00\x29\x00\x2a\x00\xed\x00\xee\x00\x5b\x00\xac\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x0e\x00\x6a\x00\x6b\x00\x28\x00\x6d\x00\x2a\x00\x19\x00\x04\x01\x05\x01\x28\x00\x28\x00\x2a\x00\x2a\x00\xf7\x00\x28\x00\xac\x00\x2a\x00\x18\x00\x5b\x00\x09\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x0e\x00\x6a\x00\x6b\x00\xdc\x00\x6d\x00\x0d\x00\x0e\x00\x09\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x2c\x00\xe7\x00\x08\x00\x09\x00\xea\x00\x2e\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\x82\x00\xf3\x00\xf4\x00\xf5\x00\x05\x00\x06\x00\xdc\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x29\x00\x2a\x00\xe7\x00\x04\x01\x05\x01\xea\x00\x18\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\x65\x00\xf3\x00\xf4\x00\xf5\x00\x2c\x00\x5b\x00\x7d\x00\x5d\x00\x29\x00\x2a\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x04\x01\x05\x01\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x4c\x00\x4d\x00\x5b\x00\x65\x00\x5d\x00\x29\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x06\x00\x07\x00\xe7\x00\x6b\x00\x18\x00\xea\x00\xde\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\x04\x00\x05\x00\x29\x00\x2a\x00\xe7\x00\xe9\x00\xea\x00\xeb\x00\x17\x00\xed\x00\xee\x00\xdc\x00\xef\x00\xf0\x00\xf1\x00\x95\x00\xf3\x00\xf4\x00\xf5\x00\x04\x01\x05\x01\x29\x00\x2a\x00\x06\x00\x07\x00\xea\x00\x23\x00\xec\x00\xed\x00\xee\x00\x5b\x00\x03\x01\x5d\x00\x29\x00\x2a\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x8a\x00\x8b\x00\x6a\x00\x6b\x00\x18\x00\x6d\x00\x4c\x00\x4d\x00\x04\x01\x05\x01\x06\x00\x07\x00\x1b\x00\x2a\x00\x2a\x00\x5b\x00\x18\x00\x5d\x00\x1d\x00\x4c\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x4c\x00\x69\x00\x6a\x00\x6b\x00\x68\x00\x1c\x00\x29\x00\x18\x00\x5b\x00\x17\x00\x5d\x00\x1d\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x98\x00\x69\x00\x6a\x00\x6b\x00\x23\x00\xea\x00\x06\x00\xec\x00\xed\x00\xee\x00\x18\x00\x1d\x00\xdc\x00\x1d\x00\x2e\x00\x1c\x00\x29\x00\x0d\x00\x18\x00\xac\x00\x18\x00\x28\x00\x49\x00\x23\x00\x69\x00\x2a\x00\xea\x00\x26\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x95\x00\x5d\x00\x23\x00\x1c\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x95\x00\x69\x00\x6a\x00\x6b\x00\x18\x00\x7d\x00\x04\x01\x05\x01\x5b\x00\x29\x00\x5d\x00\x1c\x00\x1c\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xdc\x00\x69\x00\x6a\x00\x6b\x00\x65\x00\xe0\x00\x6d\x00\x7c\x00\xe3\x00\x23\x00\xe5\x00\x1b\x00\xe7\x00\x5f\x00\xea\x00\x2c\x00\xec\x00\xed\x00\xee\x00\x25\x00\xef\x00\xf0\x00\xf1\x00\x25\x00\xf3\x00\xf4\x00\xf5\x00\x65\x00\xdc\x00\x7d\x00\x7d\x00\x1c\x00\x65\x00\x2c\x00\x1c\x00\x29\x00\xdb\x00\x1c\x00\x1c\x00\xde\x00\x04\x01\x05\x01\xea\x00\x23\x00\xec\x00\xed\x00\xee\x00\x1d\x00\x2c\x00\xdc\x00\xe9\x00\xea\x00\xeb\x00\x7d\x00\xed\x00\xee\x00\x23\x00\x20\x00\x67\x00\x18\x00\x0d\x00\x2a\x00\x17\x00\xea\x00\x23\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x7d\x00\x5d\x00\x18\x00\x95\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1b\x00\x69\x00\x6a\x00\x6b\x00\x95\x00\x18\x00\x04\x01\x05\x01\x5b\x00\x23\x00\x5d\x00\x20\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x33\x00\x69\x00\x6a\x00\x6b\x00\x1b\x00\xea\x00\xe7\x00\xec\x00\xed\x00\xee\x00\x18\x00\x10\x00\xdc\x00\x69\x00\xef\x00\xf0\x00\xf1\x00\x29\x00\xf3\x00\xf4\x00\xf5\x00\x0d\x00\x20\x00\x29\x00\x23\x00\x95\x00\xea\x00\x2a\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x7d\x00\x5d\x00\x95\x00\x95\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x18\x00\x69\x00\x6a\x00\x6b\x00\x29\x00\x7d\x00\x04\x01\x05\x01\x5b\x00\x7d\x00\x5d\x00\x2c\x00\x7d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x69\x00\x69\x00\x6a\x00\x6b\x00\x7d\x00\x65\x00\x23\x00\x6e\x00\x5b\x00\x60\x00\x5d\x00\x18\x00\x18\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x06\x00\x69\x00\x6a\x00\x6b\x00\x10\x00\x2c\x00\x23\x00\xdc\x00\x2c\x00\x2c\x00\x1d\x00\x1c\x00\x43\x00\x2d\x00\x1b\x00\xe0\x00\x2c\x00\x95\x00\xe3\x00\x2a\x00\xe5\x00\xea\x00\xe7\x00\xec\x00\xed\x00\xee\x00\x95\x00\x95\x00\xdc\x00\x0a\x00\xef\x00\xf0\x00\xf1\x00\x1f\x00\xf3\x00\xf4\x00\xf5\x00\x10\x00\x23\x00\x95\x00\x23\x00\x2c\x00\xea\x00\x2a\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x0d\x00\x5d\x00\x95\x00\x4e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x18\x00\x69\x00\x6a\x00\x6b\x00\x23\x00\x29\x00\x04\x01\x05\x01\x5b\x00\x1b\x00\x5d\x00\x61\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x2a\x00\x69\x00\x6a\x00\x6b\x00\x10\x00\xea\x00\x10\x00\xec\x00\xed\x00\xee\x00\x17\x00\x48\x00\xdc\x00\x4e\x00\x1d\x00\x1d\x00\x25\x00\x28\x00\x1b\x00\x7a\x00\xe0\x00\x1d\x00\x1d\x00\xe3\x00\x1c\x00\xe5\x00\xea\x00\xe7\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xdc\x00\x18\x00\xef\x00\xf0\x00\xf1\x00\x49\x00\xf3\x00\xf4\x00\xf5\x00\x10\x00\x1f\x00\x72\x00\x17\x00\x68\x00\xea\x00\x0d\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x25\x00\x5d\x00\x2a\x00\x23\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1d\x00\x69\x00\x6a\x00\x6b\x00\x25\x00\x7e\x00\x04\x01\x05\x01\x5b\x00\x25\x00\x5d\x00\x23\x00\x06\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x75\x00\x69\x00\x6a\x00\x6b\x00\x53\x00\x95\x00\x95\x00\xdc\x00\x18\x00\x23\x00\x18\x00\x18\x00\x18\x00\x18\x00\x20\x00\xe0\x00\x23\x00\x22\x00\xe3\x00\x2e\x00\xe5\x00\xea\x00\xe7\x00\xec\x00\xed\x00\xee\x00\x1c\x00\x18\x00\xdc\x00\x43\x00\xef\x00\xf0\x00\xf1\x00\x43\x00\xf3\x00\xf4\x00\xf5\x00\x2c\x00\x43\x00\x20\x00\x1b\x00\x28\x00\xea\x00\x4e\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x77\x00\x5d\x00\x6e\x00\x0d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x2e\x00\x69\x00\x6a\x00\x6b\x00\x95\x00\x95\x00\x04\x01\x05\x01\x5b\x00\x18\x00\x5d\x00\x18\x00\x18\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x18\x00\x69\x00\x6a\x00\x6b\x00\x18\x00\x23\x00\x20\x00\x20\x00\x5b\x00\x18\x00\x5d\x00\x22\x00\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1d\x00\x69\x00\x6a\x00\x6b\x00\x75\x00\xea\x00\x1c\x00\xec\x00\xed\x00\xee\x00\x6e\x00\x1c\x00\xdc\x00\x96\x00\x96\x00\x95\x00\x29\x00\x95\x00\x10\x00\x10\x00\x10\x00\x96\x00\x1c\x00\x1c\x00\x1c\x00\x2d\x00\xea\x00\x1c\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\x2d\x00\x5d\x00\x96\x00\x85\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x75\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x6d\x00\x04\x01\x05\x01\x5b\x00\x96\x00\x5d\x00\x75\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x75\x00\x69\x00\x6a\x00\x6b\x00\x6d\x00\x1c\x00\xff\xff\xdc\x00\x5b\x00\xff\xff\x75\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\x6a\x00\x6b\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xdc\x00\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\x00\x01\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\x00\x01\x6a\x00\x6b\x00\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xdc\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xdc\x00\xff\xff\xff\xff\x5e\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\x6a\x00\x6b\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xff\xff\x04\x01\x05\x01\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xea\x00\xff\xff\xff\xff\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\x6a\x00\x6b\x00\xed\x00\xee\x00\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xff\xff\x04\x01\x05\x01\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xdc\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\x04\x01\x05\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\x04\x01\x05\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x5b\x00\xdc\x00\xff\xff\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\x5b\x00\xdc\x00\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x04\x01\x05\x01\xdc\x00\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xff\xff\xea\x00\xdc\x00\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x04\x01\x05\x01\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x04\x01\x05\x01\xff\xff\xea\x00\xff\xff\xff\xff\xed\x00\xee\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\x04\x01\x05\x01\xff\xff\xff\xff\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x04\x01\x05\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xff\xff\xff\xff\xff\xff\x04\x01\x05\x01\xea\x00\xff\xff\xec\x00\xed\x00\xee\x00\x5e\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xea\x00\xff\xff\x6b\x00\xed\x00\xee\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x04\x01\x05\x01\xe3\x00\xff\xff\xff\xff\xff\xff\xe7\x00\xff\xff\xff\xff\xea\x00\x7d\x00\x7e\x00\xed\x00\xee\x00\xef\x00\xf0\x00\x04\x01\x05\x01\xff\xff\x5e\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\x04\x01\x05\x01\x06\x01\x07\x01\xe7\x00\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\x7d\x00\x7e\x00\xea\x00\xde\x00\xff\xff\xed\x00\xee\x00\xff\xff\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xe9\x00\xea\x00\xeb\x00\x03\x01\xed\x00\xee\x00\xb2\x00\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\x04\x01\x05\x01\xff\xff\xff\xff\xff\xff\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03\x01\xff\xff\xff\xff\xff\xff\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xde\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\x33\x00\x34\x00\x35\x00\xff\xff\xea\x00\xff\xff\x03\x01\xed\x00\xee\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x04\x01\x05\x01\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xea\x00\xff\xff\xff\xff\xed\x00\xee\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x04\x01\x05\x01\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x90\x00\x91\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x26\x00\x19\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x91\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\x91\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xde\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xe9\x00\xea\x00\xeb\x00\x03\x01\xed\x00\xee\x00\x01\x00\xff\xff\x69\x00\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\x03\x01\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x8c\x00\x8d\x00\x28\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03\x01\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x6b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\x2e\x00\xff\xff\xff\xff\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\x6b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\x1a\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x1c\x00\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\x68\x00\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x03\x01\x06\x00\x07\x00\xff\xff\x69\x00\x0a\x00\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xde\x00\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03\x01\xff\xff\x68\x00\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x72\x00\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x7e\x00\x7f\x00\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\x1f\x00\xde\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9\x00\xea\x00\xeb\x00\xff\xff\xed\x00\xee\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\x03\x01\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x6b\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\x1a\x00\x7e\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\x8c\x00\x8d\x00\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\x1a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\x1a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\x7a\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\x7a\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x1c\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x73\x00\x74\x00\x06\x00\x07\x00\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x23\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\x23\x00\xff\xff\x25\x00\x26\x00\xff\xff\x28\x00\x29\x00\x2a\x00\x23\x00\x2c\x00\x25\x00\x26\x00\xff\xff\x28\x00\x29\x00\x17\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x75\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x75\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\xff\xff\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x18\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\x1f\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\x35\x00\x01\x00\xff\xff\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\x52\x00\xff\xff\x06\x00\x07\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x6b\x00\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x17\x00\xff\xff\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x18\x00\xff\xff\x1f\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x2e\x00\xff\xff\x35\x00\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\x06\x00\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x17\x00\x18\x00\xff\xff\x7e\x00\x7f\x00\xff\xff\x01\x00\x68\x00\x69\x00\xff\xff\x6b\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x7f\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x1d\x00\x6b\x00\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x27\x00\x75\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x01\x00\xff\xff\x03\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x7e\x00\x7f\x00\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x1d\x00\x6b\x00\x01\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x17\x00\x68\x00\x69\x00\xff\xff\x6b\x00\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x17\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\xff\xff\xff\xff\x06\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x17\x00\xff\xff\x7e\x00\xff\xff\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\x06\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x1c\x00\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\xff\xff\xff\xff\x06\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x7e\x00\x7f\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x68\x00\x69\x00\xff\xff\x6b\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x7f\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\x7e\x00\x7f\x00\xff\xff\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\x06\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x06\x00\xff\xff\x08\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x7e\x00\x7f\x00\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x6b\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x17\x00\xff\xff\x2e\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\x26\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\x17\x00\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x6b\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x6b\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x6b\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x6b\x00\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xd8\x00\xc2\x00\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xbf\x00\xc0\x00\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbf\x00\xc0\x00\xff\xff\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xc2\x00\xff\xff\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xcb\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xb2\x00\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xf6\x00\xff\xff\xd0\x00\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xcb\x00\xff\xff\xa9\x00\xaa\x00\xab\x00\xd0\x00\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc1\x00\xc2\x00\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xcb\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xf6\x00\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xb2\x00\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xb2\x00\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xf6\x00\xff\xff\xd0\x00\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xd0\x00\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xc2\x00\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xf6\x00\xf7\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xff\xff\xff\xff\xff\xff\xb1\x00\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbc\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbb\x00\xbc\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xe1\x00\xff\xff\xe3\x00\xff\xff\xff\xff\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xf4\x00\xf5\x00\xf6\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc6\x00\xc7\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xc7\x00\xff\xff\xb2\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb0\x00\xff\xff\xb2\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb1\x00\xb2\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb0\x00\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xff\xff\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xff\xff\xf6\x00\xa4\x00\xa5\x00\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa4\x00\xff\xff\xa6\x00\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xb5\x00\xb6\x00\xb7\x00\xff\xff\xb9\x00\xba\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xb5\x00\xb6\x00\xb7\x00\xff\xff\xb9\x00\xba\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x00\xaa\x00\xab\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xd8\x00\xff\xff\xff\xff\xdb\x00\xdc\x00\xff\xff\xde\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x12\x00\x0e\x00\x10\x00\xa4\x00\x0c\x00\xa5\x00\x14\x00\x3c\x05\x8d\x03\x8e\x03\x8f\x03\xc8\x04\x36\x05\xe0\x04\xad\x04\x49\x03\xb1\x00\x3b\x02\x43\x02\x31\x02\x16\x04\x9c\x00\xb1\x00\x3b\x02\xb1\x00\xce\x02\xa6\x02\xae\xff\xb1\x00\x0a\x02\x07\x05\xb1\x00\x0a\x02\x78\x02\xf9\x04\xb1\x00\x96\x04\xb1\x00\xce\x02\x3a\x02\xb1\x00\x87\x04\x74\x04\x4d\x04\xac\x00\xb1\x00\x81\x04\xac\x00\x3a\x02\xac\x00\xfa\x04\xfb\x04\xca\x01\x64\x04\x2a\x04\x3a\x02\xac\x00\x18\x03\x5f\x03\xad\x00\x61\x03\xd0\x01\xb1\x00\x81\x04\x3c\x02\xef\x00\xf6\x00\x0b\x05\x61\x03\x39\x04\x3e\x02\x01\x05\xb1\x00\x87\x04\xf5\x00\xfb\x00\xb1\x00\x96\x04\x3a\x02\x3a\x05\xfd\x03\x2f\xfd\x9a\x01\x5b\x03\xcb\x01\xb1\x00\xcc\x04\x93\x01\x89\x01\x4c\x04\x4d\x04\x66\x04\x67\x04\x93\x01\x39\x05\x95\x02\x96\x02\x97\x02\x98\x02\xbd\x00\x2c\x05\xbe\x00\x93\x04\xcb\x01\x3a\x04\xf0\x00\x6f\x03\x68\x04\xfe\x03\xa8\x02\x1b\x03\xa3\x04\xb1\x00\xcc\x04\xf0\x00\xf0\x00\x20\x03\x94\x01\x2b\x04\x5c\x03\x1a\x05\xd3\x03\x5a\x04\x94\x01\x38\x00\x69\x01\x17\x04\x30\x00\x26\x05\xc1\x00\x36\x05\xda\x04\xaa\x04\xcd\x04\x1c\x03\x85\x00\xf5\x04\x17\x00\x6a\x01\xaa\x00\x97\x04\xab\x00\x85\x00\x36\x02\x37\x02\x3a\x02\x68\x04\x2f\x00\x30\x00\x86\x00\x30\x00\xa9\x03\x97\x02\x98\x02\x7f\x01\x80\x01\x81\x01\xd7\x01\x2c\x03\xd8\x01\xce\x04\x32\x02\x88\x00\x2f\xfd\x38\x02\xda\x01\xdb\x01\x88\x04\x32\x02\x88\x00\x03\x03\xdc\x01\x2b\x00\x2c\x00\x2d\x00\x22\x05\x7c\x03\x1c\x03\x82\x04\xdd\x01\x60\x03\x98\x04\x62\x03\xde\x01\xac\x00\xdf\x01\xe0\x01\xe1\x01\x69\x04\xd7\x01\x65\x03\xd8\x01\x6a\x04\x2c\x00\x4e\x04\x83\x04\x7d\x03\xda\x01\xdb\x01\x89\x04\xf5\x02\x34\x05\xc9\x04\xdc\x01\x85\x00\x2c\x00\x88\x01\x1b\x03\xcf\x02\x89\x01\x90\x03\xdd\x01\x35\x05\xb7\x00\x2a\x04\xde\x01\x3d\x02\xdf\x01\xe0\x01\xe1\x01\x0b\x02\xd0\x02\x3f\x02\x0c\x02\x2b\x00\x2c\x00\x2d\x00\xae\x00\x2f\x00\x30\x00\xae\x00\xe1\x04\xae\x00\xce\x03\xfc\x04\x2e\x05\x2f\x05\x86\x04\xfd\x04\xae\x00\x2c\x00\x4e\x04\x99\x02\x0d\x00\x0d\x00\x0d\x00\x93\x01\x0d\x00\x0d\x00\x0d\x00\x91\x03\x2c\x00\x88\x01\x90\x03\x9d\x00\x89\x01\xb7\x00\x9d\x00\xd4\x03\x2c\x00\x88\x01\xd4\x03\x0f\x00\x13\x00\x11\x00\x38\x00\x39\x00\x2b\x00\x2c\x00\x2d\x00\xe2\x01\x2f\x00\x30\x00\x3a\x02\xd5\x03\xfe\x04\x94\x01\xd5\x03\xe3\x01\x1a\x00\xe4\x01\x1c\x00\x5a\x04\xfc\x04\x1d\x00\x1e\x00\x1f\x00\xfd\x04\x69\x04\x20\x00\x21\x00\x22\x00\x6a\x04\x91\x03\x66\x03\x97\x02\x98\x02\x99\x02\x23\x00\xc2\x01\x2c\x00\x88\x01\xe2\x01\xc3\x01\x89\x01\x2c\x00\x88\x01\x23\x05\xc4\x01\x89\x01\xe3\x01\x1a\x00\xe4\x01\x1c\x00\x2c\x00\x88\x01\x1d\x00\x1e\x00\x1f\x00\x5b\x04\x2b\x03\x20\x00\x21\x00\x22\x00\xfe\x04\xaa\x03\x98\x02\x69\x04\x2c\x00\xbc\x03\x23\x00\x6a\x04\x85\x00\x2b\x00\x2c\x00\x2d\x00\x26\x00\x5c\x04\x30\x00\x27\x00\x28\x00\xad\x04\x29\x00\x11\x05\x2c\x00\x88\x01\x3b\x04\x7b\x04\x89\x01\x85\x00\xd7\x04\xbd\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x1c\x05\x1d\x03\xd8\x04\x1b\x03\x1e\x03\xbb\x02\x1f\x03\x31\x00\x31\x02\x26\x00\xe5\x01\xe6\x01\x27\x00\x28\x00\xa7\x03\x29\x00\xe7\x01\x7e\x04\x20\x03\x95\x04\xd0\x01\x21\x03\xd3\x00\x2a\x05\x85\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xbc\x02\x04\x05\x2b\x05\xaf\x04\xa8\x04\xa9\x04\xd7\x01\x31\x00\xd8\x01\xef\x04\xe5\x01\xe6\x01\xd1\x01\xd9\x01\xda\x01\xdb\x01\xe7\x01\xad\x04\xbc\x04\x88\x00\xdc\x01\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x14\x05\x69\x04\x18\x05\xdd\x01\x85\x00\x6a\x04\xd7\x01\xde\x01\xd8\x01\xdf\x01\xe0\x01\xe1\x01\x38\x00\x39\x00\xd6\x00\x24\x03\xd7\x00\x15\x05\x2c\x00\x88\x01\xdc\x01\x2d\x04\x89\x01\xba\x01\x99\x02\xd9\x00\x0b\x03\xc1\x00\xdd\x01\x19\x04\x32\x04\x88\x00\xde\x01\x85\x00\xdf\x01\xe0\x01\xe1\x01\xd5\x03\xdb\x00\x57\x01\xdd\x00\x2c\x00\x88\x01\xd9\x00\xae\x04\xaf\x04\xd6\x00\xbd\x00\x2c\x03\xd6\x00\xfb\x02\xd3\x00\xba\x01\x85\x00\x99\x02\xdf\x02\xdb\x00\x57\x01\xdd\x00\x58\x02\x88\x00\x58\x04\x2b\x00\x2c\x00\x2d\x00\xad\x03\x9e\x02\x9f\x02\xde\x04\x2c\x03\xee\x03\x2c\x00\x88\x01\xa6\x04\x85\x00\xd9\x00\x2f\x00\x30\x00\xd9\x00\x32\x02\x88\x00\xb3\x04\xaa\x04\x2b\x00\x2c\x00\x2d\x00\xbd\x04\xef\x03\xdb\x00\x57\x01\xdd\x00\xdb\x00\x57\x01\xdd\x00\xe2\x01\x33\x01\x80\x00\x2f\x00\x30\x00\xf1\x03\x32\x02\x88\x00\xe3\x01\x1a\x00\xe4\x01\x1c\x00\x0b\x03\x75\x02\x1d\x00\x1e\x00\x1f\x00\x76\x02\x7c\x04\x20\x00\x21\x00\x22\x00\xd7\x01\xcd\x00\xd8\x01\xe2\x01\x38\x00\x39\x00\x23\x00\x9c\x02\x9d\x02\x9e\x02\x9f\x02\xe3\x01\x1a\x00\xe4\x01\x1c\x00\x02\x05\x7f\x04\x1d\x00\x1e\x00\x1f\x00\x2c\x03\x5a\x04\x20\x00\x21\x00\x22\x00\x3a\x02\xb5\x04\x56\x03\xdf\x01\xe0\x01\xe1\x01\x23\x00\x2c\x00\x88\x01\x2b\x00\x2c\x00\x2d\x00\xfe\x01\x5a\x02\x2c\x00\x73\x04\x2b\x00\x2c\x00\x2d\x00\x26\x00\xb9\x00\xba\x00\x27\x00\x28\x00\x28\x02\x29\x00\x46\x01\x9c\x04\x47\x01\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x38\x05\x3e\x04\x26\x00\xe8\x02\xb5\x01\x27\x00\x28\x00\x31\x00\x29\x00\x26\x03\xe5\x01\xe6\x01\x97\x01\x86\x01\xcd\x00\xcd\x00\xe7\x01\x87\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xd7\x01\x27\x03\xd8\x01\x9b\x03\x98\x01\x2c\x00\x88\x01\x31\x00\x9c\x03\x89\x01\xe5\x01\xe6\x01\xb6\x04\xb7\x04\xf4\x04\xb8\x04\xe7\x01\x2c\x00\xbc\x03\x85\x00\xf5\x04\xe2\x01\x86\x00\x30\x00\x2e\x00\x4d\x02\x4e\x02\x38\x00\xdf\x01\xe0\x01\xe1\x01\x4f\x02\xd7\x01\x51\x04\xd8\x01\x1d\x00\xbd\x03\x1f\x00\xe7\x04\xe8\x04\x20\x00\x21\x00\x22\x00\x9e\x04\xae\x02\x34\x01\x88\x00\x86\x01\x04\x02\x23\x00\x05\x02\x87\x01\x27\x04\x06\x04\xa0\x02\x9d\x02\x9e\x02\x9f\x02\xb5\x04\x0e\x03\xdf\x01\xe0\x01\xe1\x01\x7c\x03\x2c\x00\x88\x01\xba\x01\x07\x02\x89\x01\x2c\x00\x88\x01\x03\x02\xe6\x04\x4c\x03\x2c\x00\x52\x03\x2c\x00\x52\x03\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x04\x02\x26\x00\x05\x02\x8d\x01\x27\x00\x28\x00\xbe\x03\x29\x00\x53\x03\xb1\x00\x8e\x01\x08\x04\x85\x00\x38\x00\x39\x00\x86\x00\x30\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x10\x04\x08\x02\x58\x00\xe2\x01\x59\x00\x5a\x00\x5a\x04\x31\x00\x3a\x02\x09\x02\xe5\x01\xe6\x01\xe4\x03\x4f\x02\x87\x00\x88\x00\xe7\x01\x1d\x00\xf6\x04\x1f\x00\x38\x00\x39\x00\x20\x00\x21\x00\x22\x00\x78\x02\x24\x02\x0c\x05\x22\x02\xb8\x04\x0f\x04\x23\x00\xd7\x01\x0d\x03\xd8\x01\xe2\x01\x04\x02\x4b\x03\x05\x02\xb8\x01\xe4\x03\xe1\x02\xcd\x00\x25\x02\x85\x00\x4f\x02\xe5\x03\xa3\x01\x30\x00\x1d\x00\xcd\x00\x1f\x00\x10\x03\x14\x04\x20\x00\x21\x00\x22\x00\x4d\x02\x4e\x02\xba\x01\xdf\x01\xe0\x01\xe1\x01\x23\x00\x15\x04\xac\x03\x9f\x02\x50\x02\x51\x02\x26\x00\x1a\x02\x88\x00\x27\x00\x52\x02\xc8\x01\x29\x00\x86\x01\x19\x04\xc9\x01\xba\x01\x87\x01\x5b\x02\xbb\x01\xca\x01\x28\x02\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xce\x03\x2c\x00\x88\x01\xcf\x03\xd0\x03\x89\x01\xaa\x02\x31\x00\x1b\x04\x26\x00\xe5\x01\xe6\x01\x27\x00\x28\x00\x85\x00\x29\x00\xe7\x01\x86\x00\x30\x00\x2c\x00\xab\x02\x84\x01\x9b\x02\x89\x01\xbd\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xd7\x01\xcd\x00\xd8\x01\x57\x03\xac\x02\xcc\x00\x26\x02\x31\x00\x87\x00\x88\x00\xe5\x01\xe6\x01\xe2\x04\xe3\x04\xcd\x00\xb8\x01\xe7\x01\x2b\x00\x2c\x00\x2d\x00\x1c\x04\xe2\x01\xb2\x01\x27\x02\x09\x03\x2f\x04\x9a\x03\xcf\x00\xdf\x01\xe0\x01\xe1\x01\x4f\x02\x28\x02\xa6\x00\x37\x04\x1d\x00\x83\x01\x1f\x00\xa7\x00\xa8\x00\x20\x00\x21\x00\x22\x00\x82\x01\xa8\x00\x35\x04\x77\x00\x50\x03\x78\x00\x23\x00\x51\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x44\x04\xe4\x04\x82\x00\x83\x00\x91\x00\x1d\x03\x81\x01\x92\x00\x1e\x03\xb2\x01\x11\x04\xe6\x02\x86\x01\x82\x01\xa8\x00\x40\x04\x87\x01\x55\x04\x5f\x02\x60\x02\x61\x02\xd5\x04\x20\x03\xf1\x04\xf2\x04\x21\x03\xd3\x00\xd0\x00\x26\x00\x2c\x00\x88\x01\x27\x00\x28\x00\x89\x01\x29\x00\xb9\x00\xba\x00\xd1\x00\x5d\x04\xd2\x00\xd3\x00\xd4\x00\xf7\x04\xf8\x04\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xe5\x04\xe3\x04\xfa\x02\xe2\x01\x62\x04\xfb\x02\xd3\x00\x31\x00\x86\x01\x5f\x04\xe5\x01\xe6\x01\x87\x01\x4f\x02\x84\x01\x85\x01\xe7\x01\x1d\x00\xb2\x01\x1f\x00\xb3\x01\xa4\x03\x20\x00\x21\x00\x22\x00\x2c\x00\x88\x01\xa8\x03\x1a\x05\x89\x01\x1c\x05\x23\x00\xa5\x03\x3a\x02\x77\x00\x08\x04\x78\x00\x59\x03\xae\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x5c\x03\xe4\x04\x82\x00\x83\x00\x2b\x00\x2c\x00\x2d\x00\xaf\x03\xb7\x00\x08\x02\x58\x00\x64\x04\x59\x00\x5a\x00\x2b\x00\x2c\x00\x2d\x00\x09\x02\x84\x00\x62\x02\x2c\x00\x2d\x00\x26\x00\x2f\x00\x30\x00\x27\x00\x28\x00\x20\x05\x29\x00\x9f\x04\xa0\x04\xa1\x04\x85\x00\xbd\x02\x2e\x00\x86\x00\x30\x00\xc3\x03\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x63\x02\x0f\x05\x84\x04\x85\x04\xa2\x01\x2c\x00\x2d\x00\x31\x00\xa3\x01\x30\x00\xe5\x01\xe6\x01\xc7\x03\x87\x00\x88\x00\x77\x00\xe7\x01\x78\x00\xfb\x02\xd3\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xc8\x03\xe4\x04\x82\x00\x83\x00\xcc\x03\x73\xfe\x77\x00\x73\xfe\x78\x00\x2c\x04\xd3\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xd1\x03\xe4\x04\x82\x00\x83\x00\x86\x01\xc4\x01\x2c\x00\x2d\x00\x87\x01\xa3\x01\x30\x00\xd8\x03\x40\x03\x6d\x01\xdd\x03\x78\x02\x6e\x01\xf9\x03\x81\x03\xe1\x03\xe4\x00\x2c\x00\x88\x01\xe2\x03\x84\x00\x89\x01\x8e\x04\xe7\x03\xb9\x00\xba\x00\x70\x01\xea\x03\xd2\x00\xd3\x00\xd4\x00\x2c\x00\xf0\x03\xec\x03\x85\x00\xf1\x03\x2e\x00\x86\x00\x30\x00\x77\x00\x41\x03\x42\x03\x3d\x04\x3e\x04\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xd0\x04\x48\x04\xc5\x00\x83\x00\x43\x03\xc7\x00\xfe\x01\x02\x04\x87\x00\x88\x00\xda\x03\xdb\x03\xdc\x03\xdd\x03\xb9\x00\xba\x00\x63\x01\x01\x03\xd2\x00\xd3\x00\xd4\x00\x05\x03\x31\x03\x77\x00\x32\x03\x78\x00\x2c\x00\xbf\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xb2\x04\x4c\x03\x49\x04\x83\x00\x33\x03\x84\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xd3\x04\x00\x01\x01\x01\x3c\x03\xb7\x00\x85\x00\x3d\x03\x2e\x00\x86\x00\x30\x00\x84\x00\x78\x03\x61\x02\xb8\x00\x47\x04\x48\x04\xd8\x04\x00\x01\x01\x01\x2f\x00\x30\x00\xb9\x00\xba\x00\xbd\x00\x85\x00\xbe\x00\x2e\x00\x86\x00\x30\x00\xf9\x03\xfa\x03\x87\x00\x88\x00\xe5\x03\xe6\x03\xe7\x03\xd2\xfd\x77\x00\xd2\xfd\x78\x00\x13\x03\xbb\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x87\x00\x88\x00\x49\x04\x83\x00\x63\x01\xfa\x02\xd2\x00\xd3\x00\xd4\x00\xb9\x01\xbf\x04\xba\x01\x4b\x04\x48\x04\x03\x04\x04\x04\x84\x00\xc0\x04\xc1\x04\xf5\x03\xf6\x03\xf7\x03\x37\x05\x5e\x02\x5f\x02\x60\x02\x61\x02\x2d\x03\x2e\x03\x2f\x03\x85\x00\x44\x03\x2e\x00\x86\x00\x30\x00\x77\x00\xe4\xfd\x78\x00\xe4\xfd\x5d\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xb7\x00\x89\x03\x49\x04\x83\x00\x84\x00\xe6\xfd\x33\x00\xe6\xfd\x87\x00\x88\x00\x46\x02\x62\x02\x2c\x00\x2d\x00\x44\x02\x2f\x00\x30\x00\xe7\xfd\x85\x00\xe7\xfd\x2e\x00\x86\x00\x30\x00\x38\x00\x39\x00\x03\x04\x05\x04\xbd\x00\xd8\x03\xbe\x00\x49\x02\xee\xfd\x85\x00\xee\xfd\x4a\x02\x86\x00\x30\x00\x63\x02\x03\x03\x37\x02\xbf\x00\x32\x03\x2e\x03\x2f\x03\x87\x00\x88\x00\x6d\x02\xef\xfd\xc0\x00\xef\xfd\xc2\x04\xc3\x04\xc4\x04\xc5\x04\xbf\x04\x04\x03\x37\x02\xc1\x00\x87\x00\x88\x00\x6b\x02\xc0\x04\xc1\x04\x4f\x02\xb7\x00\x86\x03\x87\x03\x1d\x00\x84\x00\x1f\x00\x51\x03\xba\x00\x20\x00\x21\x00\x22\x00\x62\x02\x2c\x00\x2d\x00\xa4\x02\x2f\x00\x30\x00\x23\x00\x85\x00\x73\x02\x2e\x00\x86\x00\x30\x00\x5b\x00\xed\x04\xe0\x01\xe1\x01\xa6\x02\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x63\x02\x42\x02\x00\x01\x01\x01\x07\x03\xa7\x01\xa8\x02\x87\x00\x88\x00\xb1\x00\x70\x03\x6d\x00\xa8\x01\xa9\x02\xf0\xfd\x84\x00\xf0\xfd\xb2\x02\x26\x00\x7f\x03\x80\x03\x27\x00\x28\x00\xf1\xfd\x29\x00\xf1\xfd\x2b\x00\x2c\x00\x2d\x00\x85\x00\x73\x00\x2e\x00\x86\x00\x30\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc5\x02\x16\x05\xc4\x04\xc5\x04\xb0\x00\xb1\x00\xb2\x00\x31\x00\xb3\x00\xb1\x00\xb2\x00\x82\x03\x83\x03\x4f\x02\x87\x00\x88\x00\xf2\xfd\x1d\x00\xf2\xfd\x1f\x00\xa6\x01\xa7\x01\x20\x00\x21\x00\x22\x00\xc4\x02\x8a\x04\x4c\x03\xa8\x01\x54\x02\x55\x02\x23\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xef\x02\xee\x04\x2b\x00\x2c\x00\x2d\x00\x1d\x00\xf3\xfd\x1f\x00\xf3\xfd\x91\x01\x20\x00\x21\x00\x22\x00\xf5\x02\x4b\x03\x4c\x03\xb4\x02\xb5\x02\xb6\x02\x23\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xf4\xfd\x26\x00\xf4\xfd\xf8\x02\x27\x00\x28\x00\xf5\xfd\x29\x00\xf5\xfd\x94\x01\xd6\x00\xbd\x00\xd7\x00\xbe\x00\xff\x00\x00\x01\x01\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x7f\x01\x80\x01\x81\x01\xca\x00\xf6\xfd\x26\x00\xf6\xfd\x31\x00\x27\x00\x28\x00\x9b\x01\x29\x00\xbf\x02\x01\x02\x72\x01\xd9\x00\x0d\x02\xc1\x00\x0f\x05\xb1\x00\x56\x02\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xdb\x00\x57\x01\xdd\x00\x77\x00\xf8\xfd\x78\x00\xf8\xfd\x31\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x94\x02\x01\x01\xcd\x00\x83\x00\xce\x00\xc7\x00\x35\x02\xd6\x00\xbd\x00\xa1\x02\xa2\x02\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x77\x00\x40\x02\x78\x00\xf3\x02\x7d\x01\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xc2\x02\xc3\x02\xcd\x00\x83\x00\xce\x00\xc7\x00\x85\x00\x23\x03\xd9\x00\x86\x00\x30\x00\x72\x01\xd9\x00\xb6\x00\xc1\x00\x73\x01\xf7\xfd\xf9\xfd\xf7\xfd\xf9\xfd\xfd\x00\xdb\x00\x57\x01\xdd\x00\xdf\x00\xdb\x00\x57\x01\xdd\x00\x74\x01\x75\x01\x76\x01\x77\x01\x87\x00\x88\x00\x85\x00\x28\x05\x29\x05\x86\x00\x30\x00\x77\x00\xcf\x00\x78\x00\xb1\x00\xf1\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xb1\x00\xf2\x02\xc5\x00\x83\x00\xfa\xfd\x2f\x02\xfa\xfd\x77\x01\x87\x00\x88\x00\xfb\xfd\x02\xfe\xfb\xfd\x02\xfe\x3b\x01\x03\xfe\xcf\x00\x03\xfe\x15\x00\x77\x00\x79\x01\x78\x00\xb1\x00\xf6\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xb1\x00\x8f\x01\xc5\x00\x83\x00\x84\x00\x99\x04\xb1\x00\x90\x01\x7a\x01\x25\x05\x5e\x02\x5f\x02\x60\x02\x61\x02\x40\x04\x8f\x04\x41\x02\xa8\x00\x85\x00\x3c\x05\x2e\x00\x86\x00\x30\x00\xb9\x00\xba\x00\xd1\x00\x9a\x04\xd2\x00\xd3\x00\xd4\x00\x7c\x01\x7d\x01\x84\x00\x35\x03\x36\x03\x37\x03\x38\x03\x39\x03\x3a\x03\x3b\x03\x3c\x03\x13\x05\x14\x05\xd0\x00\x87\x00\x88\x00\x85\x00\x33\x05\x2e\x00\x86\x00\x30\x00\xb9\x00\xba\x00\xd1\x00\xee\x03\xd2\x00\xd3\x00\xd4\x00\x40\x04\x77\x00\xec\x03\xc4\x00\x29\x03\x2a\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x87\x00\x88\x00\xc5\x00\x83\x00\xc6\x00\xc7\x00\x8c\x03\x8d\x03\x77\x00\xee\x03\x45\x04\xce\x03\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x96\x01\x97\x01\xfe\x01\x46\x04\x2e\x05\x85\x00\xb7\x00\x2e\x00\x86\x00\x30\x00\xb9\x00\xba\x00\x36\x00\x37\x00\xc5\x03\xc6\x03\xd0\x00\x62\x02\x2c\x00\x2d\x00\x04\x05\x2f\x00\x30\x00\x84\x00\xb9\x00\xba\x00\xd1\x00\xdc\x04\xd2\x00\xd3\x00\xd4\x00\x87\x00\x88\x00\x29\x03\x2a\x03\x96\x01\x97\x01\x85\x00\x06\x05\x2e\x00\x86\x00\x30\x00\x77\x00\x63\x02\x78\x00\x29\x03\x2a\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x48\x02\x49\x02\xc5\x00\x83\x00\x07\x05\xc9\x00\x6b\x03\x6c\x03\x87\x00\x88\x00\x96\x01\x97\x01\x3a\x02\x18\x05\x1b\x05\x77\x00\x1e\x05\x78\x00\xe0\x04\xda\x04\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xdd\x04\x3d\x05\x82\x00\x83\x00\xf1\x04\x77\xfd\xf7\x04\xa6\x04\x77\x00\xa4\x04\x78\x00\xa8\x04\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xbd\x02\x1f\x05\x82\x00\x83\x00\x28\x02\x85\x00\x38\x00\x2e\x00\x86\x00\x30\x00\xb2\x04\xb5\x04\x84\x00\xbf\x04\xcc\x04\xcb\x04\xd2\x04\xd5\x04\x66\x04\xca\x00\x6e\x04\x70\x04\x72\x04\x6f\x04\xe9\x03\x73\x04\x85\x00\x76\x04\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x77\x04\x78\x00\x78\x04\x7e\x04\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x79\x04\x21\x05\x82\x00\x83\x00\x8d\x04\x81\x04\x87\x00\x88\x00\x77\x00\x8c\x04\x78\x00\x78\xfd\x91\x04\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x84\x00\x24\x05\x82\x00\x83\x00\xee\x03\x6d\x01\x17\x00\x9e\x04\x6e\x01\x13\x03\xd4\x01\x3a\x02\xe4\x00\x0a\x04\x85\x00\x78\x02\x2e\x00\x86\x00\x30\x00\x13\x04\xb9\x00\xba\x00\x70\x01\x14\x04\xd2\x00\xd3\x00\xd4\x00\xee\x03\x84\x00\xdf\x03\xec\x03\x1b\x04\xee\x03\x26\x04\xb0\x00\x2f\x04\x38\x01\x31\x04\x37\x04\x39\x01\x87\x00\x88\x00\x85\x00\x32\x04\x2e\x00\x86\x00\x30\x00\x43\x04\x40\x04\x84\x00\x2b\x00\x2c\x00\x2d\x00\x42\x04\x2f\x00\x30\x00\x44\x04\x4b\x04\x54\x04\x58\x04\x55\x04\x7f\x03\x5f\x04\x85\x00\x61\x04\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x98\x03\x78\x00\x62\x04\x99\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x3a\x02\x29\x05\x82\x00\x83\x00\x9a\x03\xa1\x03\x87\x00\x88\x00\x77\x00\xa2\x03\x78\x00\xa3\x03\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xa4\x03\x08\x05\x82\x00\x83\x00\x0f\x02\x85\x00\xfe\x01\x2e\x00\x86\x00\x30\x00\xac\x03\xa4\x02\x84\x00\xb1\x03\xb9\x00\xba\x00\x63\x01\xb2\x03\xd2\x00\xd3\x00\xd4\x00\xb3\x03\xb4\x03\xb5\x03\xd4\xfe\xb6\x03\x85\x00\xc7\x03\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\xca\x03\x78\x00\xb7\x03\xb8\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xcc\x03\x0a\x05\x82\x00\x83\x00\xce\x03\xd3\x03\x87\x00\x88\x00\x77\x00\xdf\x03\x78\x00\x32\x03\xdf\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xe9\x03\xdd\x04\x82\x00\x83\x00\xec\x03\xee\x03\xf3\x03\x10\x02\x77\x00\xff\x03\x78\x00\xff\x02\x00\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x38\x00\xe9\x04\x82\x00\x83\x00\x07\x03\xb9\x01\x13\x03\x84\x00\x0f\x03\x0f\x03\x15\x03\xb0\x00\x24\x03\x1a\x03\x3a\x02\x6d\x01\x3f\x03\x46\x03\x6e\x01\x4f\x03\x81\x03\x85\x00\xe4\x00\x2e\x00\x86\x00\x30\x00\x47\x03\x48\x03\x84\x00\xbd\x00\xb9\x00\xba\x00\x70\x01\xa6\x02\xd2\x00\xd3\x00\xd4\x00\x64\x03\x63\x03\x66\x03\x68\x03\x69\x03\x85\x00\x6d\x03\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x74\x03\x78\x00\x6a\x03\x6e\x03\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x7b\x03\x26\x04\x82\x00\x83\x00\xd0\xfe\x7c\x03\x87\x00\x88\x00\x77\x00\x3a\x02\x78\x00\x4b\x01\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x7f\x03\x3a\x04\x82\x00\x83\x00\x85\x03\x85\x00\x86\x03\x2e\x00\x86\x00\x30\x00\x89\x03\xaa\x00\x84\x00\x46\x02\x4c\x02\x4d\x02\x68\x02\x69\x02\x6f\x02\x73\x02\x6d\x01\x70\x02\x75\x02\x6e\x01\xcd\x01\xd4\x01\x85\x00\xe4\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x84\x00\xb1\x01\xb9\x00\xba\x00\x70\x01\x7c\x02\xd2\x00\xd3\x00\xd4\x00\xa4\x02\xa6\x02\xb7\x02\xb8\x02\xb9\x02\x85\x00\xc7\x02\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\xdb\x02\x78\x00\xeb\x02\xec\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xed\x02\xc2\x03\x82\x00\x83\x00\xee\x02\xf1\x02\x87\x00\x88\x00\x77\x00\xef\x02\x78\x00\xf8\x02\x38\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xac\x00\x25\x03\x82\x00\x83\x00\x9d\x01\xfd\x02\x9b\x01\x84\x00\x43\xfd\xc0\x01\x40\xfd\xb0\x01\xb1\x01\xb2\x01\xc1\x01\x6d\x01\xc0\x01\xc7\x01\x6e\x01\xba\x01\x6f\x01\x85\x00\xe4\x00\x2e\x00\x86\x00\x30\x00\xcd\x01\xd3\x01\x84\x00\xd4\x01\xb9\x00\xba\x00\x70\x01\xd6\x01\xd2\x00\xd3\x00\xd4\x00\xd2\x01\xd7\x01\xc9\x00\x0f\x02\x01\x02\x85\x00\x03\x02\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x0a\x02\x78\x00\x10\x02\x19\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x12\x02\x2a\x03\x82\x00\x83\x00\x17\x02\x18\x02\x87\x00\x88\x00\x77\x00\x3d\xfd\x78\x00\x1f\x02\x20\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x21\x02\xa1\x01\x82\x00\x83\x00\x23\x02\x29\x02\x2a\x02\x2b\x02\x77\x00\x2d\x02\x78\x00\x2c\x02\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x3b\x02\x3c\x01\x82\x00\x83\x00\xac\x00\x85\x00\x9f\x00\x2e\x00\x86\x00\x30\x00\x10\x02\xb0\x00\x84\x00\xff\xff\xff\xff\xb5\x00\xde\x00\xb6\x00\xed\x00\xee\x00\xef\x00\xff\xff\xf2\x00\xb0\x00\xf2\x00\x6b\x01\x85\x00\x6c\x01\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\xa2\xfd\x78\x00\xff\xff\x79\x01\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xac\x00\xff\xff\xc5\x00\x83\x00\xff\xff\x2d\x02\x87\x00\x88\x00\x77\x00\xff\xff\x78\x00\xac\x00\xff\xff\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x7c\x01\x81\x00\x82\x00\x83\x00\x17\x00\x9f\x00\x00\x00\x84\x00\xae\x02\x00\x00\xac\x00\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\xb8\x03\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x00\x00\xb9\x03\x00\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\xb8\x03\x00\x00\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x00\x00\xb9\x03\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\xca\x03\x83\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x3f\x03\x83\x00\x00\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x48\x03\x83\x00\x00\x00\x00\x00\x00\x00\x84\x00\x1b\x02\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\xcf\x04\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x00\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\xba\x03\x58\x03\x83\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x84\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x57\x02\x83\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x84\x00\x00\x00\x00\x00\xab\x04\x00\x00\xac\x04\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\x5b\x02\x83\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x5c\x02\x83\x00\x00\x00\x00\x00\x87\x00\x88\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\xb9\x02\x83\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\xc0\x02\x83\x00\x00\x00\x85\x00\x00\x00\x00\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\x19\x02\x83\x00\x86\x00\x30\x00\x87\x00\x88\x00\x77\x00\x00\x00\x78\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\xde\x00\x83\x00\x00\x00\x00\x00\x87\x00\x88\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x84\x00\x77\x00\x00\x00\x0d\x05\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x87\x00\x88\x00\x77\x00\x00\x00\x10\x05\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x77\x00\x00\x00\xea\x04\x87\x00\x88\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x77\x00\x00\x00\x79\x04\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x00\x00\x1c\x02\x84\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x77\x00\x84\x00\x4d\x03\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x77\x00\x00\x00\xc2\x00\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x87\x00\x88\x00\x84\x00\x1d\x02\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\xe2\x00\x00\x00\x85\x00\x84\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x00\x88\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x00\x00\xe0\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x87\x00\x88\x00\x00\x00\x85\x00\x00\x00\x00\x00\x86\x00\x30\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x75\x03\x76\x03\x5f\x02\x60\x02\x61\x02\x00\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x34\x04\x5e\x02\x5f\x02\x60\x02\x61\x02\x00\x00\x00\x00\x00\x00\x00\x00\x87\x00\x88\x00\x85\x00\x00\x00\x2e\x00\x86\x00\x30\x00\x1d\x04\x00\x00\x1e\x04\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\x85\x00\x00\x00\x1f\x04\x86\x00\x30\x00\x55\x04\x5f\x02\x60\x02\x61\x02\x56\x04\x87\x00\x88\x00\xe3\x00\x00\x00\x00\x00\x00\x00\xe4\x00\x00\x00\x00\x00\x85\x00\x20\x04\x21\x04\x86\x00\x30\x00\xb9\x00\xba\x00\x87\x00\x88\x00\x00\x00\x1d\x04\x00\x00\x91\x04\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x00\x88\x00\xe5\x00\xe6\x00\xfe\x01\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x92\x04\x21\x04\x85\x00\xb7\x00\x00\x00\x86\x00\x30\x00\x00\x00\x44\x01\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x62\x02\x2c\x00\x2d\x00\x63\x02\x2f\x00\x30\x00\x23\x00\x00\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x00\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x02\x00\x00\x00\x00\x00\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x72\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x22\x04\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\xdb\x00\x57\x01\xdd\x00\x00\x00\x85\x00\x00\x00\x63\x02\x23\x04\x30\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x00\x88\x00\x22\x04\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x85\x00\x00\x00\x00\x00\x23\x04\x30\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x3a\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x87\x00\x88\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\xeb\x01\xec\x01\xed\x01\xee\x01\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x17\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\xf2\x01\xa2\x00\x70\x00\x00\x00\xf3\x01\x00\x00\x71\x00\x00\x00\x00\x00\xf4\x01\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\xfa\x01\x75\x00\x76\x00\x77\x00\xfb\x01\xfc\x01\xd6\x00\xbd\x00\xd7\x00\xbe\x00\xfd\x01\xfe\x01\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xd9\x00\x45\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\xdb\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\xeb\x01\xec\x01\xed\x01\xee\x01\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x17\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\xf2\x01\xa2\x00\x70\x00\x00\x00\xf3\x01\x00\x00\x71\x00\x00\x00\x00\x00\xf4\x01\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\xfa\x01\x75\x00\x76\x00\x77\x00\xfb\x01\xfc\x01\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x01\xfe\x01\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\xeb\x01\xec\x01\xed\x01\xee\x01\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\xf2\x01\xa2\x00\x70\x00\x00\x00\xf3\x01\x00\x00\x71\x00\x00\x00\x00\x00\xf4\x01\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\xfa\x01\x75\x00\x76\x00\x77\x00\xfb\x01\xfc\x01\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x01\xfe\x01\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x3a\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\xba\x04\xbb\x04\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x04\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\xba\x04\xbb\x04\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x04\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x3a\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x3a\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\xc7\x04\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\xf3\x01\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x04\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\xef\x01\xf0\x01\xf1\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\xc7\x04\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\xf3\x01\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x04\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x3c\x04\x5e\x02\x5f\x02\x60\x02\x61\x02\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\xf6\x01\xf7\x01\xf8\x01\xf9\x01\x9e\x03\x5e\x02\x5f\x02\x60\x02\x61\x02\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\xfe\x01\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\xd8\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\xcd\x00\x90\x00\x00\x00\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x00\x00\x00\x00\x00\x91\x00\x00\x00\xdb\x00\xdc\x00\xdd\x00\xe9\x03\x5e\x02\x5f\x02\x60\x02\x61\x02\x00\x00\x00\x00\x93\x00\x94\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\xb7\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x63\x02\x2f\x00\x30\x00\x33\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x38\x00\x39\x00\x00\x00\xe8\x00\xbd\x00\x00\x00\xbe\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x02\x00\x00\x8c\x00\x73\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\xe9\x00\x9b\x00\x9c\x00\xc1\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x91\x00\xeb\x00\xec\x00\x92\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x02\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\xe8\x00\xbd\x00\x6d\x00\xbe\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\xe9\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\xea\x00\x00\x00\x00\x00\x91\x00\x00\x00\xec\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\xbd\x00\x6d\x00\xbe\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x31\x02\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\xcd\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x0a\x05\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\xec\x04\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\xed\x04\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x9c\x04\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x2f\x02\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\xc9\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x9f\x03\x5f\x02\x60\x02\x61\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xbc\x03\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x63\x02\x38\x00\x39\x00\x00\x00\x9a\x00\x04\xff\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x04\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\xeb\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xbc\x03\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x74\x03\x5e\x02\x5f\x02\x60\x02\x61\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x5d\x02\x5e\x02\x5f\x02\x60\x02\x61\x02\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x02\x00\x00\xb0\x02\x00\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\xb1\x02\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x73\x00\xb2\x02\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x8e\x00\xb7\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x02\x2c\x00\x2d\x00\x00\x00\x2f\x00\x30\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x63\x02\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x9a\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x04\xff\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x04\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x04\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x8e\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x9c\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x6d\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\xe3\x02\x73\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xb8\x01\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x9b\x00\x9c\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xea\x02\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xb8\x01\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xb7\x01\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xb8\x01\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\xbf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xb8\x01\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x5e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xcd\x00\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x67\x01\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\xcd\x00\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x68\x01\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x5b\x01\x47\x00\x00\x00\x00\x00\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x77\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x56\x01\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x15\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\xd7\x02\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x3a\x02\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\xd7\x02\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x12\x03\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\xfb\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x00\x70\x00\x00\x00\x00\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\xa2\x00\x70\x00\x38\x00\x39\x00\x00\x00\x71\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x03\x75\x00\x76\x00\x77\x00\x00\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x00\x00\x00\x00\x94\x03\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\xbf\x02\x00\x00\x72\x01\xd9\x00\x00\x00\xc1\x00\xc0\x02\x72\xfe\xbf\x02\x72\xfe\x72\x01\xd9\x00\x00\x00\xc1\x00\xc0\x02\x93\x03\xdb\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x57\x01\xdd\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x95\x03\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x96\x03\x00\x00\x00\x00\x73\x00\x74\x00\x97\x03\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x03\x8b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x96\x03\x00\x00\x00\x00\x73\x00\x74\x00\x97\x03\x00\x00\x94\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x8b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x00\x00\x00\x00\x73\x00\x74\x00\x01\x05\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x00\x00\x00\x00\x73\x00\x74\x00\x01\x05\x81\x02\x34\x00\x35\x00\x36\x00\x37\x00\x82\x02\x39\x00\x05\x01\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x01\x83\x02\x84\x02\x85\x02\x86\x02\x87\x02\x88\x02\x89\x02\x8a\x02\x8b\x02\x8c\x02\x8d\x02\x8e\x02\x8f\x02\x90\x02\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x91\x02\x92\x02\x1f\x01\x93\x02\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x94\x02\x74\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x01\x00\x00\x4a\x00\x4b\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x56\x00\x57\x00\x00\x00\x58\x00\x00\x00\x59\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\xbd\x00\x00\x00\xbe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x65\x02\x78\x03\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\x00\x00\x66\x02\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x02\x00\x00\x00\x00\x00\x00\x67\x02\x33\x00\x00\x00\x00\x00\x66\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd7\x03\x00\x00\x00\x00\x7a\x03\x00\x00\x00\x00\x00\x00\xd8\x03\x00\x00\x00\x00\x67\x02\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x35\x00\x5b\x00\x00\x00\x38\x00\x39\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x65\x02\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x6d\x00\x00\x00\x66\x02\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x9b\x02\x00\x00\x00\x00\x00\x00\x67\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd6\x00\xbd\x00\xd7\x00\xbe\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x65\x02\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\xd8\x00\x00\x00\x66\x02\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcd\x00\x00\x00\x00\x00\xd9\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x31\x05\xda\x00\x00\x00\x67\x02\x00\x00\x00\x00\xdb\x00\x57\x01\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xaa\x01\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x38\x00\x6d\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x8b\x01\x6c\x04\x00\x00\x73\x00\x74\x00\x00\x00\x33\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x73\x00\x74\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x35\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x73\x00\x74\x00\xaa\x01\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\xab\x01\x6d\x00\x33\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x00\x00\xac\x01\x8c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x01\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x3b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x6d\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x33\x00\x00\x00\x35\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x73\x00\x74\x00\x00\x00\x00\x00\xaa\x01\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\xb1\x04\x6d\x00\x33\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x34\x02\x6b\x00\x6c\x00\x00\x00\x6d\x00\x33\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\xaa\x01\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xac\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x38\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x73\x00\x74\x00\x8b\x01\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\xaa\x01\x00\x00\x73\x00\x00\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x38\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x35\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xaa\x01\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x55\x03\x6b\x00\x6c\x00\x33\x00\x6d\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\xaa\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x73\x00\x74\x00\x29\x04\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x33\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x38\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x73\x00\x74\x00\x8b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x02\x73\x00\x74\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x50\x04\x00\x00\x73\x00\x74\x00\x00\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x29\x04\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x04\x00\x00\x00\x00\x73\x00\x74\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x9b\x02\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x38\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x02\x00\x00\x00\x00\x73\x00\x74\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x03\x01\x00\x00\x00\x00\x73\x00\x74\x00\x04\x01\x00\x00\x05\x01\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x6b\x00\x6c\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x02\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x33\x00\x36\x01\x00\x00\x37\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x01\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x02\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x73\x00\x38\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x6d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x34\x02\x00\x00\x34\x04\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x6d\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x35\x02\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x33\x00\x34\x02\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xcb\xfe\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x6d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x6d\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x00\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\x6d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x6d\x00\x00\x00\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\x00\x00\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\xcb\xfe\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x97\x00\x98\x00\x99\x00\xcb\xfe\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x00\x00\x48\x01\x49\x01\xf3\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\xcb\xfe\x00\x00\x6d\x00\x23\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x02\xd2\x02\xd3\x02\xd4\x02\x26\x00\xd5\x02\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x02\xd2\x02\xd3\x02\xd4\x02\x00\x00\xd5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\xd3\x02\xd4\x02\x00\x00\xd5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfb\x03\xd4\x02\x00\x00\xd5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x03\xc9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x03\xc9\x02\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xca\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x23\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x31\x00\x00\x00\x72\x03\x00\x00\x13\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x24\x00\x00\x00\x20\x00\x21\x00\x22\x00\x6c\x02\x00\x00\x13\x02\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x02\xc9\x02\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xca\x02\xa4\x01\x00\x00\x00\x00\xa5\x01\x1e\x00\x1f\x00\x31\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x23\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x23\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x31\x00\x00\x00\x12\x02\x00\x00\x13\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xc7\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x02\x00\x00\x13\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\xf3\x03\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xf7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\xa4\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x31\x00\xf9\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xd2\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x8d\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x0a\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x0b\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x0c\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x0e\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x52\x04\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x9d\x03\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xe0\x03\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xf4\x03\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x10\x03\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xac\x01\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xc1\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x3f\x01\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x40\x01\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xa2\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x5e\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x5f\x01\x60\x01\x00\x00\x00\x00\x00\x00\x61\x01\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\x62\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x63\x01\x52\x01\xd2\x00\x64\x01\x65\x01\x31\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x4c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x57\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x01\x59\x01\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x5b\x01\x5c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\xd8\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xde\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xe1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xe8\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xb5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x4b\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xbd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x4f\x01\x00\x00\x50\x01\x00\x00\x00\x00\x51\x01\xe4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xb9\x00\xba\x00\x00\x00\x52\x01\x00\x00\x53\x01\x54\x01\x31\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x03\x16\x03\x00\x00\x00\x00\x00\x00\x17\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x04\x00\x00\x23\x00\x00\x00\x17\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\xc0\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x79\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x02\x00\x00\x23\x00\x00\x00\xc1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xe4\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x02\x23\x00\x00\x00\xe3\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x41\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x01\x00\x00\x23\x00\x00\x00\x9f\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x1e\x05\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x70\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\xff\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x01\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x08\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x71\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x69\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x6a\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x70\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x71\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\xcc\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xcd\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\xd7\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xdc\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x9d\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x9e\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x9f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xa0\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\xfc\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xfe\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x50\x04\x1a\x00\x3e\x01\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\xc5\x01\x1a\x00\x3e\x01\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x3d\x01\x1a\x00\x3e\x01\x1c\x00\x00\x00\x31\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x01\x00\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xcd\x01\xf3\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x00\xf3\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x7c\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x7d\x02\x00\x01\x01\x01\x00\x00\x7e\x02\x8a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x7d\x02\x00\x01\x01\x01\x00\x00\x7e\x02\x7f\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xa7\x03\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xbc\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xfd\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xae\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x10\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x45\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (11, 760) [
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518),
	(519 , happyReduce_519),
	(520 , happyReduce_520),
	(521 , happyReduce_521),
	(522 , happyReduce_522),
	(523 , happyReduce_523),
	(524 , happyReduce_524),
	(525 , happyReduce_525),
	(526 , happyReduce_526),
	(527 , happyReduce_527),
	(528 , happyReduce_528),
	(529 , happyReduce_529),
	(530 , happyReduce_530),
	(531 , happyReduce_531),
	(532 , happyReduce_532),
	(533 , happyReduce_533),
	(534 , happyReduce_534),
	(535 , happyReduce_535),
	(536 , happyReduce_536),
	(537 , happyReduce_537),
	(538 , happyReduce_538),
	(539 , happyReduce_539),
	(540 , happyReduce_540),
	(541 , happyReduce_541),
	(542 , happyReduce_542),
	(543 , happyReduce_543),
	(544 , happyReduce_544),
	(545 , happyReduce_545),
	(546 , happyReduce_546),
	(547 , happyReduce_547),
	(548 , happyReduce_548),
	(549 , happyReduce_549),
	(550 , happyReduce_550),
	(551 , happyReduce_551),
	(552 , happyReduce_552),
	(553 , happyReduce_553),
	(554 , happyReduce_554),
	(555 , happyReduce_555),
	(556 , happyReduce_556),
	(557 , happyReduce_557),
	(558 , happyReduce_558),
	(559 , happyReduce_559),
	(560 , happyReduce_560),
	(561 , happyReduce_561),
	(562 , happyReduce_562),
	(563 , happyReduce_563),
	(564 , happyReduce_564),
	(565 , happyReduce_565),
	(566 , happyReduce_566),
	(567 , happyReduce_567),
	(568 , happyReduce_568),
	(569 , happyReduce_569),
	(570 , happyReduce_570),
	(571 , happyReduce_571),
	(572 , happyReduce_572),
	(573 , happyReduce_573),
	(574 , happyReduce_574),
	(575 , happyReduce_575),
	(576 , happyReduce_576),
	(577 , happyReduce_577),
	(578 , happyReduce_578),
	(579 , happyReduce_579),
	(580 , happyReduce_580),
	(581 , happyReduce_581),
	(582 , happyReduce_582),
	(583 , happyReduce_583),
	(584 , happyReduce_584),
	(585 , happyReduce_585),
	(586 , happyReduce_586),
	(587 , happyReduce_587),
	(588 , happyReduce_588),
	(589 , happyReduce_589),
	(590 , happyReduce_590),
	(591 , happyReduce_591),
	(592 , happyReduce_592),
	(593 , happyReduce_593),
	(594 , happyReduce_594),
	(595 , happyReduce_595),
	(596 , happyReduce_596),
	(597 , happyReduce_597),
	(598 , happyReduce_598),
	(599 , happyReduce_599),
	(600 , happyReduce_600),
	(601 , happyReduce_601),
	(602 , happyReduce_602),
	(603 , happyReduce_603),
	(604 , happyReduce_604),
	(605 , happyReduce_605),
	(606 , happyReduce_606),
	(607 , happyReduce_607),
	(608 , happyReduce_608),
	(609 , happyReduce_609),
	(610 , happyReduce_610),
	(611 , happyReduce_611),
	(612 , happyReduce_612),
	(613 , happyReduce_613),
	(614 , happyReduce_614),
	(615 , happyReduce_615),
	(616 , happyReduce_616),
	(617 , happyReduce_617),
	(618 , happyReduce_618),
	(619 , happyReduce_619),
	(620 , happyReduce_620),
	(621 , happyReduce_621),
	(622 , happyReduce_622),
	(623 , happyReduce_623),
	(624 , happyReduce_624),
	(625 , happyReduce_625),
	(626 , happyReduce_626),
	(627 , happyReduce_627),
	(628 , happyReduce_628),
	(629 , happyReduce_629),
	(630 , happyReduce_630),
	(631 , happyReduce_631),
	(632 , happyReduce_632),
	(633 , happyReduce_633),
	(634 , happyReduce_634),
	(635 , happyReduce_635),
	(636 , happyReduce_636),
	(637 , happyReduce_637),
	(638 , happyReduce_638),
	(639 , happyReduce_639),
	(640 , happyReduce_640),
	(641 , happyReduce_641),
	(642 , happyReduce_642),
	(643 , happyReduce_643),
	(644 , happyReduce_644),
	(645 , happyReduce_645),
	(646 , happyReduce_646),
	(647 , happyReduce_647),
	(648 , happyReduce_648),
	(649 , happyReduce_649),
	(650 , happyReduce_650),
	(651 , happyReduce_651),
	(652 , happyReduce_652),
	(653 , happyReduce_653),
	(654 , happyReduce_654),
	(655 , happyReduce_655),
	(656 , happyReduce_656),
	(657 , happyReduce_657),
	(658 , happyReduce_658),
	(659 , happyReduce_659),
	(660 , happyReduce_660),
	(661 , happyReduce_661),
	(662 , happyReduce_662),
	(663 , happyReduce_663),
	(664 , happyReduce_664),
	(665 , happyReduce_665),
	(666 , happyReduce_666),
	(667 , happyReduce_667),
	(668 , happyReduce_668),
	(669 , happyReduce_669),
	(670 , happyReduce_670),
	(671 , happyReduce_671),
	(672 , happyReduce_672),
	(673 , happyReduce_673),
	(674 , happyReduce_674),
	(675 , happyReduce_675),
	(676 , happyReduce_676),
	(677 , happyReduce_677),
	(678 , happyReduce_678),
	(679 , happyReduce_679),
	(680 , happyReduce_680),
	(681 , happyReduce_681),
	(682 , happyReduce_682),
	(683 , happyReduce_683),
	(684 , happyReduce_684),
	(685 , happyReduce_685),
	(686 , happyReduce_686),
	(687 , happyReduce_687),
	(688 , happyReduce_688),
	(689 , happyReduce_689),
	(690 , happyReduce_690),
	(691 , happyReduce_691),
	(692 , happyReduce_692),
	(693 , happyReduce_693),
	(694 , happyReduce_694),
	(695 , happyReduce_695),
	(696 , happyReduce_696),
	(697 , happyReduce_697),
	(698 , happyReduce_698),
	(699 , happyReduce_699),
	(700 , happyReduce_700),
	(701 , happyReduce_701),
	(702 , happyReduce_702),
	(703 , happyReduce_703),
	(704 , happyReduce_704),
	(705 , happyReduce_705),
	(706 , happyReduce_706),
	(707 , happyReduce_707),
	(708 , happyReduce_708),
	(709 , happyReduce_709),
	(710 , happyReduce_710),
	(711 , happyReduce_711),
	(712 , happyReduce_712),
	(713 , happyReduce_713),
	(714 , happyReduce_714),
	(715 , happyReduce_715),
	(716 , happyReduce_716),
	(717 , happyReduce_717),
	(718 , happyReduce_718),
	(719 , happyReduce_719),
	(720 , happyReduce_720),
	(721 , happyReduce_721),
	(722 , happyReduce_722),
	(723 , happyReduce_723),
	(724 , happyReduce_724),
	(725 , happyReduce_725),
	(726 , happyReduce_726),
	(727 , happyReduce_727),
	(728 , happyReduce_728),
	(729 , happyReduce_729),
	(730 , happyReduce_730),
	(731 , happyReduce_731),
	(732 , happyReduce_732),
	(733 , happyReduce_733),
	(734 , happyReduce_734),
	(735 , happyReduce_735),
	(736 , happyReduce_736),
	(737 , happyReduce_737),
	(738 , happyReduce_738),
	(739 , happyReduce_739),
	(740 , happyReduce_740),
	(741 , happyReduce_741),
	(742 , happyReduce_742),
	(743 , happyReduce_743),
	(744 , happyReduce_744),
	(745 , happyReduce_745),
	(746 , happyReduce_746),
	(747 , happyReduce_747),
	(748 , happyReduce_748),
	(749 , happyReduce_749),
	(750 , happyReduce_750),
	(751 , happyReduce_751),
	(752 , happyReduce_752),
	(753 , happyReduce_753),
	(754 , happyReduce_754),
	(755 , happyReduce_755),
	(756 , happyReduce_756),
	(757 , happyReduce_757),
	(758 , happyReduce_758),
	(759 , happyReduce_759),
	(760 , happyReduce_760)
	]

happy_n_terms = 151 :: Int
happy_n_nonterms = 268 :: Int

happyReduce_11 = happySpecReduce_2  0# happyReduction_11
happyReduction_11 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn14
		 (let (os,ss,l) = happy_var_1 in map (\x -> x os ss l) happy_var_2
	)}}

happyReduce_12 = happySpecReduce_2  1# happyReduction_12
happyReduction_12 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_13 = happySpecReduce_1  1# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn15
		 ([happy_var_1]
	)}

happyReduce_14 = happyMonadReduce 2# 2# happyReduction_14
happyReduction_14 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	( checkPageModule happy_var_2 happy_var_1)}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_15 = happyMonadReduce 5# 2# happyReduction_15
happyReduction_15 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 XCodeTagOpen) -> 
	case happyOut22 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCodeTagClose) -> 
	case happyOut17 happy_x_5 of { happy_var_5 -> 
	( let (os,ss,l) = happy_var_1 in checkHybridModule happy_var_5 (happy_var_3 os ss l) happy_var_2 happy_var_4)}}}}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_16 = happySpecReduce_2  2# happyReduction_16
happyReduction_16 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (let (os,ss,l) = happy_var_1 in happy_var_2 os ss l
	)}}

happyReduce_17 = happyMonadReduce 9# 3# happyReduction_17
happyReduction_17 (happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOut198 happy_x_3 of { happy_var_3 -> 
	case happyOut200 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut193 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 XCloseTagOpen) -> 
	case happyOut195 happy_x_8 of { happy_var_8 -> 
	case happyOutTok happy_x_9 of { (Loc happy_var_9 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_8;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3; };
                                                                       return $ XTag (happy_var_1 <^^> happy_var_9 <** [happy_var_1,happy_var_5,happy_var_7,happy_var_9]) n as happy_var_4 cn })}}}}}}}}}
	) (\r -> happyReturn (happyIn17 r))

happyReduce_18 = happyReduce 5# 3# happyReduction_18
happyReduction_18 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOut198 happy_x_3 of { happy_var_3 -> 
	case happyOut200 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn17
		 (XETag (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_19 = happySpecReduce_3  4# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn18
		 (let (os,ss,ml) = happy_var_2 in (os,happy_var_1:ss++[happy_var_3],happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_20 = happySpecReduce_3  5# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn19
		 (let (os,ss,ml) = happy_var_3;
                                                             ss' = reverse happy_var_2 ++ ss;
                                                             l'  = case happy_var_2 of
                                                                    [] -> ann happy_var_1
                                                                    _  -> ann happy_var_1 <++> nIS (last happy_var_2);
                                                         in (happy_var_1 : os, ss', Just $ l'  <+?> ml)
	)}}}

happyReduce_21 = happySpecReduce_0  5# happyReduction_21
happyReduction_21  =  happyIn19
		 (([],[],Nothing)
	)

happyReduce_22 = happyReduce 4# 6# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LANGUAGE) -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn20
		 (LanguagePragma (happy_var_1 <^^> happy_var_4 <** (happy_var_1:snd happy_var_2 ++ reverse happy_var_3 ++ [happy_var_4])) (fst happy_var_2)
	) `HappyStk` happyRest}}}}

happyReduce_23 = happySpecReduce_3  6# happyReduction_23
happyReduction_23 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (let Loc l (OPTIONS (mc, s)) = happy_var_1
                                                      in OptionsPragma (l <^^> happy_var_3 <** (l:reverse happy_var_2 ++ [happy_var_3])) (readTool mc) s
	)}}}

happyReduce_24 = happySpecReduce_3  6# happyReduction_24
happyReduction_24 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (AnnModulePragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_25 = happySpecReduce_3  7# happyReduction_25
happyReduction_25 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut252 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 ((fst happy_var_1 ++ [happy_var_3], snd happy_var_1 ++ [happy_var_2])
	)}}}

happyReduce_26 = happySpecReduce_2  7# happyReduction_26
happyReduction_26 happy_x_2
	happy_x_1
	 =  case happyOut252 happy_x_2 of { happy_var_2 -> 
	happyIn21
		 (([happy_var_2],[])
	)}

happyReduce_27 = happySpecReduce_2  8# happyReduction_27
happyReduction_27 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (let (is,ds,ss1,inf) = happy_var_2
                 in \os ss l -> Module (l <++> inf <** (ss ++ ss1)) happy_var_1 os is ds
	)}}

happyReduce_28 = happyReduce 5# 9# happyReduction_28
happyReduction_28 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut271 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	case happyOut29 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 KW_Where) -> 
	happyIn23
		 (Just $ ModuleHead (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_29 = happySpecReduce_0  9# happyReduction_29
happyReduction_29  =  happyIn23
		 (Nothing
	)

happyReduce_30 = happySpecReduce_3  10# happyReduction_30
happyReduction_30 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ DeprText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_31 = happySpecReduce_3  10# happyReduction_31
happyReduction_31 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ WarnText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_32 = happySpecReduce_0  10# happyReduction_32
happyReduction_32  =  happyIn24
		 (Nothing
	)

happyReduce_33 = happySpecReduce_3  11# happyReduction_33
happyReduction_33 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_34 = happyReduce 4# 11# happyReduction_34
happyReduction_34 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_35 = happyReduce 4# 12# happyReduction_35
happyReduction_35 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut58 happy_x_4 of { happy_var_4 -> 
	happyIn26
		 ((reverse (fst happy_var_2), fst happy_var_4, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3 ++ snd happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_36 = happySpecReduce_2  12# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn26
		 (([], fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2)
	)}}

happyReduce_37 = happySpecReduce_3  12# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 ((reverse (fst happy_var_2), [], reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_38 = happySpecReduce_1  12# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (([], [], reverse happy_var_1)
	)}

happyReduce_39 = happySpecReduce_2  13# happyReduction_39
happyReduction_39 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn27
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_40 = happySpecReduce_1  14# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_41 = happySpecReduce_0  14# happyReduction_41
happyReduction_41  =  happyIn28
		 ([]
	)

happyReduce_42 = happySpecReduce_1  15# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn29
		 (Just happy_var_1
	)}

happyReduce_43 = happySpecReduce_0  15# happyReduction_43
happyReduction_43  =  happyIn29
		 (Nothing
	)

happyReduce_44 = happyReduce 4# 16# happyReduction_44
happyReduction_44 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut32 happy_x_2 of { happy_var_2 -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse (snd happy_var_2) ++ happy_var_3 ++ [happy_var_4])) (reverse (fst happy_var_2))
	) `HappyStk` happyRest}}}}

happyReduce_45 = happySpecReduce_3  16# happyReduction_45
happyReduction_45 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_3 <** (happy_var_1:happy_var_2++[happy_var_3])) []
	)}}}

happyReduce_46 = happySpecReduce_1  17# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn31
		 ([happy_var_1]
	)}

happyReduce_47 = happySpecReduce_0  17# happyReduction_47
happyReduction_47  =  happyIn31
		 ([  ]
	)

happyReduce_48 = happySpecReduce_3  18# happyReduction_48
happyReduction_48 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_49 = happySpecReduce_1  18# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (([happy_var_1],[])
	)}

happyReduce_50 = happySpecReduce_1  19# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOut233 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EVar (ann happy_var_1) happy_var_1
	)}

happyReduce_51 = happyMonadReduce 2# 19# happyReduction_51
happyReduction_51 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (EAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_52 = happySpecReduce_1  19# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOut273 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_53 = happySpecReduce_3  19# happyReduction_53
happyReduction_53 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut273 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn33
		 (EThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    (NoWildcard noSrcSpan) happy_var_1 []
	)}}}

happyReduce_54 = happyMonadReduce 4# 19# happyReduction_54
happyReduction_54 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut273 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	( mkEThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse $ fst happy_var_3))}}}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_55 = happySpecReduce_2  19# happyReduction_55
happyReduction_55 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut271 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (EModuleContents (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_56 = happyMonadReduce 2# 19# happyReduction_56
happyReduction_56 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut236 happy_x_2 of { happy_var_2 -> 
	(  do { checkEnabled PatternSynonyms;
                                                      return $ EAbs (nIS happy_var_1 <++> (ann happy_var_2) <** [happy_var_1])
                                                                 (PatternNamespace (nIS happy_var_1)) happy_var_2 })}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_57 = happySpecReduce_3  20# happyReduction_57
happyReduction_57 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	happyIn34
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_58 = happySpecReduce_1  20# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (([happy_var_1],[])
	)}

happyReduce_59 = happySpecReduce_1  21# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DotDot) -> 
	happyIn35
		 (Left happy_var_1
	)}

happyReduce_60 = happySpecReduce_1  21# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (Right happy_var_1
	)}

happyReduce_61 = happySpecReduce_1  22# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOut233 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 (happy_var_1
	)}

happyReduce_62 = happySpecReduce_1  22# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 (happy_var_1
	)}

happyReduce_63 = happySpecReduce_3  23# happyReduction_63
happyReduction_63 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_64 = happySpecReduce_1  23# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (([happy_var_1],[])
	)}

happyReduce_65 = happyReduce 8# 24# happyReduction_65
happyReduction_65 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Import) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut40 happy_x_3 of { happy_var_3 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	case happyOut42 happy_x_5 of { happy_var_5 -> 
	case happyOut271 happy_x_6 of { happy_var_6 -> 
	case happyOut43 happy_x_7 of { happy_var_7 -> 
	case happyOut44 happy_x_8 of { happy_var_8 -> 
	happyIn38
		 (let { (mmn,ss,ml) = happy_var_7 ;
                                      l = nIS happy_var_1 <++> ann happy_var_6 <+?> ml <+?> (fmap ann) happy_var_8 <** (happy_var_1:snd happy_var_2 ++ snd happy_var_3 ++ snd happy_var_4 ++ snd happy_var_5 ++ ss)}
                                 in ImportDecl l happy_var_6 (fst happy_var_4) (fst happy_var_2) (fst happy_var_3) (fst happy_var_5) mmn happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_66 = happySpecReduce_2  25# happyReduction_66
happyReduction_66 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SOURCE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn39
		 ((True,[happy_var_1,happy_var_2])
	)}}

happyReduce_67 = happySpecReduce_0  25# happyReduction_67
happyReduction_67  =  happyIn39
		 ((False,[])
	)

happyReduce_68 = happyMonadReduce 1# 26# happyReduction_68
happyReduction_68 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	( do { checkEnabledOneOf [Safe, SafeImports, Trustworthy] ;
                                                 return (True, [happy_var_1]) })}
	) (\r -> happyReturn (happyIn40 r))

happyReduce_69 = happySpecReduce_0  26# happyReduction_69
happyReduction_69  =  happyIn40
		 ((False, [])
	)

happyReduce_70 = happySpecReduce_1  27# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn41
		 ((True,[happy_var_1])
	)}

happyReduce_71 = happySpecReduce_0  27# happyReduction_71
happyReduction_71  =  happyIn41
		 ((False, [])
	)

happyReduce_72 = happyMonadReduce 1# 28# happyReduction_72
happyReduction_72 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( do { checkEnabled PackageImports ;
                                                      let { Loc l (StringTok (s,_)) = happy_var_1 } ;
                                                      return $ (Just s,[l]) })}
	) (\r -> happyReturn (happyIn42 r))

happyReduce_73 = happySpecReduce_0  28# happyReduction_73
happyReduction_73  =  happyIn42
		 ((Nothing,[])
	)

happyReduce_74 = happySpecReduce_2  29# happyReduction_74
happyReduction_74 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	case happyOut271 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 ((Just happy_var_2,[happy_var_1],Just (nIS happy_var_1 <++> ann happy_var_2))
	)}}

happyReduce_75 = happySpecReduce_0  29# happyReduction_75
happyReduction_75  =  happyIn43
		 ((Nothing,[],Nothing)
	)

happyReduce_76 = happySpecReduce_1  30# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 (Just happy_var_1
	)}

happyReduce_77 = happySpecReduce_0  30# happyReduction_77
happyReduction_77  =  happyIn44
		 (Nothing
	)

happyReduce_78 = happyReduce 5# 31# happyReduction_78
happyReduction_78 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn45
		 (let {(b,ml,s) = happy_var_1 ;
                                                      l = (ml <?+> (happy_var_2 <^^> happy_var_5)) <** (s ++ happy_var_2:reverse (snd happy_var_3) ++ happy_var_4 ++ [happy_var_5])}
                                                 in ImportSpecList l b (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}}

happyReduce_79 = happyReduce 4# 31# happyReduction_79
happyReduction_79 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn45
		 (let {(b,ml,s) = happy_var_1 ; l = (ml <?+> (happy_var_2 <^^> happy_var_4)) <** (s ++ happy_var_2:happy_var_3 ++ [happy_var_4])}
                                                 in ImportSpecList l b []
	) `HappyStk` happyRest}}}}

happyReduce_80 = happySpecReduce_1  32# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn46
		 ((True,Just (nIS happy_var_1),[happy_var_1])
	)}

happyReduce_81 = happySpecReduce_0  32# happyReduction_81
happyReduction_81  =  happyIn46
		 ((False,Nothing,[])
	)

happyReduce_82 = happySpecReduce_3  33# happyReduction_82
happyReduction_82 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_83 = happySpecReduce_1  33# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (([happy_var_1],[])
	)}

happyReduce_84 = happySpecReduce_1  34# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (IVar (ann happy_var_1) happy_var_1
	)}

happyReduce_85 = happyMonadReduce 2# 34# happyReduction_85
happyReduction_85 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut231 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn48 r))

happyReduce_86 = happyMonadReduce 2# 34# happyReduction_86
happyReduction_86 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut235 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled PatternSynonyms;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (PatternNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn48 r))

happyReduce_87 = happySpecReduce_1  34# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOut272 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (IAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_88 = happyReduce 4# 34# happyReduction_88
happyReduction_88 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DotDot) -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn48
		 (IThingAll  (ann happy_var_1 <++> nIS happy_var_4 <** [happy_var_2,happy_var_3,happy_var_4]) happy_var_1
	) `HappyStk` happyRest}}}}

happyReduce_89 = happySpecReduce_3  34# happyReduction_89
happyReduction_89 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn48
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    happy_var_1 []
	)}}}

happyReduce_90 = happyReduce 4# 34# happyReduction_90
happyReduction_90 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut49 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn48
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_91 = happySpecReduce_3  35# happyReduction_91
happyReduction_91 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_92 = happySpecReduce_1  35# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (([happy_var_1],[])
	)}

happyReduce_93 = happySpecReduce_1  36# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (VarName (ann happy_var_1) happy_var_1
	)}

happyReduce_94 = happySpecReduce_1  36# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (ConName (ann happy_var_1) happy_var_1
	)}

happyReduce_95 = happySpecReduce_3  37# happyReduction_95
happyReduction_95 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn51
		 (let (ops,ss,l) = happy_var_3
                                                 in InfixDecl (ann happy_var_1 <++> l <** (snd happy_var_2 ++ reverse ss)) happy_var_1 (fst happy_var_2) (reverse ops)
	)}}}

happyReduce_96 = happySpecReduce_0  38# happyReduction_96
happyReduction_96  =  happyIn52
		 ((Nothing, [])
	)

happyReduce_97 = happyMonadReduce 1# 38# happyReduction_97
happyReduction_97 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let Loc l (IntTok (i,_)) = happy_var_1 in checkPrec i >>= \i -> return (Just i, [l]))}
	) (\r -> happyReturn (happyIn52 r))

happyReduce_98 = happySpecReduce_1  39# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Infix) -> 
	happyIn53
		 (AssocNone  $ nIS happy_var_1
	)}

happyReduce_99 = happySpecReduce_1  39# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixL) -> 
	happyIn53
		 (AssocLeft  $ nIS happy_var_1
	)}

happyReduce_100 = happySpecReduce_1  39# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixR) -> 
	happyIn53
		 (AssocRight $ nIS happy_var_1
	)}

happyReduce_101 = happySpecReduce_3  40# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut242 happy_x_3 of { happy_var_3 -> 
	happyIn54
		 (let (ops,ss,l) = happy_var_1 in (happy_var_3 : ops, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_102 = happySpecReduce_1  40# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOut242 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_103 = happySpecReduce_0  41# happyReduction_103
happyReduction_103  =  happyIn55
		 (Nothing
	)

happyReduce_104 = happySpecReduce_1  41# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (Just happy_var_1
	)}

happyReduce_105 = happyReduce 4# 42# happyReduction_105
happyReduction_105 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut275 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut57 happy_x_4 of { happy_var_4 -> 
	happyIn56
		 (InjectivityInfo (nIS happy_var_1 <++> ann (last happy_var_4) <** [happy_var_1,happy_var_3]) happy_var_2 (reverse happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_106 = happySpecReduce_2  43# happyReduction_106
happyReduction_106 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut275 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_107 = happySpecReduce_1  43# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut275 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 ([happy_var_1]
	)}

happyReduce_108 = happyMonadReduce 2# 44# happyReduction_108
happyReduction_108 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	( checkRevDecls (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1 ++ reverse happy_var_2))}}
	) (\r -> happyReturn (happyIn58 r))

happyReduce_109 = happySpecReduce_3  45# happyReduction_109
happyReduction_109 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut60 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_110 = happySpecReduce_1  45# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 (([happy_var_1],[])
	)}

happyReduce_111 = happyMonadReduce 1# 46# happyReduction_111
happyReduction_111 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut65 happy_x_1 of { happy_var_1 -> 
	( checkEnabled RoleAnnotations >> return happy_var_1)}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_112 = happyMonadReduce 4# 46# happyReduction_112
happyReduction_112 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut105 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	( do { dh <- checkSimpleType happy_var_2;
                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]};
                       return (TypeDecl l dh happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_113 = happyMonadReduce 6# 46# happyReduction_113
happyReduction_113 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut62 happy_x_4 of { happy_var_4 -> 
	case happyOut55 happy_x_5 of { happy_var_5 -> 
	case happyOut69 happy_x_6 of { happy_var_6 -> 
	( do { dh <- checkSimpleType happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <** [happy_var_1,happy_var_2]};
                       case happy_var_6 of {
                         Nothing    -> return (TypeFamDecl l dh happy_var_4 happy_var_5);
                         Just (x,a) -> return (ClosedTypeFamDecl (l <** [a]) dh happy_var_4 happy_var_5 x); }})}}}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_114 = happyMonadReduce 5# 46# happyReduction_114
happyReduction_114 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut104 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Equals) -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       checkEnabled TypeFamilies ;
                       let {l = nIS happy_var_1 <++> ann happy_var_5 <** [happy_var_1,happy_var_2,happy_var_4]};
                       return (TypeInsDecl l happy_var_3 happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_115 = happyMonadReduce 4# 46# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	case happyOut143 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (qds,ss,minf) = happy_var_3;
                             l = happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann happy_var_4 <** ss};
                       checkDataOrNew happy_var_1 qds;
                       return (DataDecl l happy_var_1 cs dh (reverse qds) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_116 = happyMonadReduce 5# 46# happyReduction_116
happyReduction_116 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut152 happy_x_3 of { happy_var_3 -> 
	case happyOut131 happy_x_4 of { happy_var_4 -> 
	case happyOut143 happy_x_5 of { happy_var_5 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (gs,ss,minf) = happy_var_4;
                             l = ann happy_var_1 <+?> minf <+?> fmap ann happy_var_5 <** (snd happy_var_3 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       case (gs, fst happy_var_3) of
                        ([], Nothing) -> return (DataDecl l happy_var_1 cs dh [] happy_var_5)
                        _ -> checkEnabled GADTs >> return (GDataDecl l happy_var_1 cs dh (fst happy_var_3) (reverse gs) happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_117 = happyMonadReduce 4# 46# happyReduction_117
happyReduction_117 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) happy_var_4 <** [happy_var_1,happy_var_2]};
                       return (DataFamDecl l cs dh happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_118 = happyMonadReduce 5# 46# happyReduction_118
happyReduction_118 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	case happyOut135 happy_x_4 of { happy_var_4 -> 
	case happyOut143 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let { (qds,ss,minf) = happy_var_4 ;
                             l = happy_var_1 <> happy_var_3 <+?> minf <+?> fmap ann happy_var_5 <** happy_var_2:ss };
                       checkDataOrNew happy_var_1 qds;
                       return (DataInsDecl l happy_var_1 happy_var_3 (reverse qds) happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_119 = happyMonadReduce 6# 46# happyReduction_119
happyReduction_119 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	case happyOut152 happy_x_4 of { happy_var_4 -> 
	case happyOut131 happy_x_5 of { happy_var_5 -> 
	case happyOut143 happy_x_6 of { happy_var_6 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let {(gs,ss,minf) = happy_var_5;
                            l = ann happy_var_1 <+?> minf <+?> fmap ann happy_var_6 <** (happy_var_2:snd happy_var_4 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       return (GDataInsDecl l happy_var_1 happy_var_3 (fst happy_var_4) (reverse gs) happy_var_6) })}}}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_120 = happyMonadReduce 4# 46# happyReduction_120
happyReduction_120 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut128 happy_x_3 of { happy_var_3 -> 
	case happyOut153 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkClassHeader happy_var_2;
                       let {(fds,ss1,minf1) = happy_var_3;(mcs,ss2,minf2) = happy_var_4} ;
                       let { l = nIS happy_var_1 <++> ann happy_var_2 <+?> minf1 <+?> minf2 <** (happy_var_1:ss1 ++ ss2)} ;
                       return (ClassDecl l cs dh fds mcs) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_121 = happyMonadReduce 4# 46# happyReduction_121
happyReduction_121 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Instance) -> 
	case happyOut68 happy_x_2 of { happy_var_2 -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOut159 happy_x_4 of { happy_var_4 -> 
	( do { ih <- checkInstHeader happy_var_3;
                       let {(mis,ss,minf) = happy_var_4};
                       return (InstDecl (nIS happy_var_1 <++> ann happy_var_3 <+?> minf <** (happy_var_1:ss)) happy_var_2 ih mis) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_122 = happyMonadReduce 4# 46# happyReduction_122
happyReduction_122 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	case happyOut120 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled StandaloneDeriving ;
                       ih <- checkInstHeader happy_var_4;
                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2]};
                       return (DerivDecl l happy_var_3 ih) })}}}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_123 = happyReduce 4# 46# happyReduction_123
happyReduction_123 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut74 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn60
		 (DefaultDecl (happy_var_1 <^^> happy_var_4 <** (happy_var_1:happy_var_2 : snd happy_var_3 ++ [happy_var_4])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_124 = happyMonadReduce 1# 46# happyReduction_124
happyReduction_124 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut172 happy_x_1 of { happy_var_1 -> 
	( do
              checkToplevel happy_var_1
              checkExpr happy_var_1 >>= \e -> return (SpliceDecl (ann e) e))}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_125 = happyReduce 5# 46# happyReduction_125
happyReduction_125 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Import) -> 
	case happyOut90 happy_x_3 of { happy_var_3 -> 
	case happyOut91 happy_x_4 of { happy_var_4 -> 
	case happyOut92 happy_x_5 of { happy_var_5 -> 
	happyIn60
		 (let (s,n,t,ss) = happy_var_5 in ForImp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3 happy_var_4 s n t
	) `HappyStk` happyRest}}}}}

happyReduce_126 = happyReduce 4# 46# happyReduction_126
happyReduction_126 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Export) -> 
	case happyOut90 happy_x_3 of { happy_var_3 -> 
	case happyOut92 happy_x_4 of { happy_var_4 -> 
	happyIn60
		 (let (s,n,t,ss) = happy_var_4 in ForExp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3    s n t
	) `HappyStk` happyRest}}}}

happyReduce_127 = happySpecReduce_3  46# happyReduction_127
happyReduction_127 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RULES) -> 
	case happyOut93 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (RulePragmaDecl (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) $ reverse happy_var_2
	)}}}

happyReduce_128 = happySpecReduce_3  46# happyReduction_128
happyReduction_128 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOut99 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (DeprPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_129 = happySpecReduce_3  46# happyReduction_129
happyReduction_129 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOut99 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (WarnPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_130 = happySpecReduce_3  46# happyReduction_130
happyReduction_130 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (AnnPragma      (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_131 = happySpecReduce_1  46# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (happy_var_1
	)}

happyReduce_132 = happySpecReduce_0  47# happyReduction_132
happyReduction_132  =  happyIn61
		 (Nothing
	)

happyReduce_133 = happySpecReduce_2  47# happyReduction_133
happyReduction_133 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn61
		 ((Just $ KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_134 = happySpecReduce_0  48# happyReduction_134
happyReduction_134  =  happyIn62
		 (Nothing
	)

happyReduce_135 = happySpecReduce_2  48# happyReduction_135
happyReduction_135 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 ((Just $ KindSig  (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_136 = happySpecReduce_2  48# happyReduction_136
happyReduction_136 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut125 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 ((Just $ TyVarSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_137 = happySpecReduce_0  49# happyReduction_137
happyReduction_137  =  happyIn63
		 ((Nothing, Nothing)
	)

happyReduce_138 = happySpecReduce_2  49# happyReduction_138
happyReduction_138 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn63
		 ((Just (KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Nothing)
	)}}

happyReduce_139 = happySpecReduce_3  49# happyReduction_139
happyReduction_139 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut125 happy_x_2 of { happy_var_2 -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	happyIn63
		 ((Just (TyVarSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Just happy_var_3)
	)}}}

happyReduce_140 = happySpecReduce_0  50# happyReduction_140
happyReduction_140  =  happyIn64
		 ((Nothing, Nothing, Nothing)
	)

happyReduce_141 = happySpecReduce_2  50# happyReduction_141
happyReduction_141 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn64
		 ((Just (KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Nothing, Nothing)
	)}}

happyReduce_142 = happySpecReduce_3  50# happyReduction_142
happyReduction_142 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	happyIn64
		 ((Nothing, Just (happy_var_1, happy_var_2), happy_var_3)
	)}}}

happyReduce_143 = happyMonadReduce 4# 51# happyReduction_143
happyReduction_143 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Role) -> 
	case happyOut117 happy_x_3 of { happy_var_3 -> 
	case happyOut66 happy_x_4 of { happy_var_4 -> 
	( mkRoleAnnotDecl happy_var_1 happy_var_2 happy_var_3 (reverse happy_var_4))}}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_144 = happySpecReduce_0  52# happyReduction_144
happyReduction_144  =  happyIn66
		 ([]
	)

happyReduce_145 = happySpecReduce_2  52# happyReduction_145
happyReduction_145 happy_x_2
	happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut67 happy_x_2 of { happy_var_2 -> 
	happyIn66
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_146 = happySpecReduce_1  53# happyReduction_146
happyReduction_146 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (let (VarId v) = unLoc happy_var_1 in (Just v, nIS $ loc happy_var_1)
	)}

happyReduce_147 = happySpecReduce_1  53# happyReduction_147
happyReduction_147 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn67
		 ((Nothing, nIS happy_var_1)
	)}

happyReduce_148 = happySpecReduce_2  54# happyReduction_148
happyReduction_148 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAP) -> 
	happyIn68
		 (Just (Overlap (nIS happy_var_1))
	)}

happyReduce_149 = happySpecReduce_2  54# happyReduction_149
happyReduction_149 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 INCOHERENT) -> 
	happyIn68
		 (Just (Incoherent (nIS happy_var_1))
	)}

happyReduce_150 = happySpecReduce_2  54# happyReduction_150
happyReduction_150 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 NO_OVERLAP) -> 
	happyIn68
		 (Just (NoOverlap (nIS happy_var_1))
	)}

happyReduce_151 = happySpecReduce_0  54# happyReduction_151
happyReduction_151  =  happyIn68
		 (Nothing
	)

happyReduce_152 = happySpecReduce_0  55# happyReduction_152
happyReduction_152  =  happyIn69
		 (Nothing
	)

happyReduce_153 = happySpecReduce_2  55# happyReduction_153
happyReduction_153 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (Just (happy_var_2, happy_var_1)
	)}}

happyReduce_154 = happySpecReduce_3  56# happyReduction_154
happyReduction_154 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (happy_var_2
	)}

happyReduce_155 = happySpecReduce_3  56# happyReduction_155
happyReduction_155 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (happy_var_2
	)}

happyReduce_156 = happySpecReduce_3  57# happyReduction_156
happyReduction_156 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (happy_var_1 ++ [happy_var_3]
	)}}

happyReduce_157 = happySpecReduce_2  57# happyReduction_157
happyReduction_157 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (happy_var_1
	)}

happyReduce_158 = happySpecReduce_1  57# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 ([happy_var_1]
	)}

happyReduce_159 = happyMonadReduce 3# 58# happyReduction_159
happyReduction_159 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut119 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled TypeFamilies ;
                        return (TypeEqn (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3) })}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_160 = happySpecReduce_1  59# happyReduction_160
happyReduction_160 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn73
		 (DataType $ nIS happy_var_1
	)}

happyReduce_161 = happySpecReduce_1  59# happyReduction_161
happyReduction_161 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_NewType) -> 
	happyIn73
		 (NewType  $ nIS happy_var_1
	)}

happyReduce_162 = happyMonadReduce 1# 60# happyReduction_162
happyReduction_162 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut122 happy_x_1 of { happy_var_1 -> 
	( do { ts <- mapM checkType (fst happy_var_1);
                                              return $ (reverse ts, reverse (snd happy_var_1)) })}
	) (\r -> happyReturn (happyIn74 r))

happyReduce_163 = happySpecReduce_1  60# happyReduction_163
happyReduction_163 happy_x_1
	 =  case happyOut106 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (([happy_var_1],[])
	)}

happyReduce_164 = happySpecReduce_0  60# happyReduction_164
happyReduction_164  =  happyIn74
		 (([],[])
	)

happyReduce_165 = happyMonadReduce 3# 61# happyReduction_165
happyReduction_165 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut76 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevDecls (fst happy_var_2) >>= \ds -> return (ds, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn75 r))

happyReduce_166 = happySpecReduce_1  61# happyReduction_166
happyReduction_166 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (([],reverse happy_var_1)
	)}

happyReduce_167 = happySpecReduce_3  62# happyReduction_167
happyReduction_167 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_168 = happySpecReduce_1  62# happyReduction_168
happyReduction_168 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 (([happy_var_1],[])
	)}

happyReduce_169 = happySpecReduce_1  63# happyReduction_169
happyReduction_169 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_170 = happySpecReduce_1  63# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_171 = happySpecReduce_1  63# happyReduction_171
happyReduction_171 happy_x_1
	 =  case happyOut164 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_172 = happySpecReduce_1  63# happyReduction_172
happyReduction_172 happy_x_1
	 =  case happyOut263 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_173 = happySpecReduce_1  63# happyReduction_173
happyReduction_173 happy_x_1
	 =  case happyOut269 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_174 = happySpecReduce_3  64# happyReduction_174
happyReduction_174 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn78
		 (BDecls (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_175 = happySpecReduce_3  64# happyReduction_175
happyReduction_175 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (let l' = if null (fst happy_var_2) then nIS happy_var_3 else (ann . last $ fst happy_var_2)
                                         in BDecls (nIS happy_var_1 <++> l' <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_176 = happySpecReduce_1  65# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_177 = happySpecReduce_1  65# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_178 = happyMonadReduce 3# 66# happyReduction_178
happyReduction_178 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               return $ TypeSig (happy_var_1 <> happy_var_3 <** [happy_var_2]) [v] happy_var_3 })}}}
	) (\r -> happyReturn (happyIn80 r))

happyReduce_179 = happyMonadReduce 5# 66# happyReduction_179
happyReduction_179 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               let {(vs,ss,_) = happy_var_3 ; l = happy_var_1 <> happy_var_5 <** (happy_var_2 : reverse ss ++ [happy_var_4]) } ;
                                                               return $ TypeSig l (v : reverse vs) happy_var_5 })}}}}}
	) (\r -> happyReturn (happyIn80 r))

happyReduce_180 = happyReduce 4# 67# happyReduction_180
happyReduction_180 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut233 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn81
		 (let Loc l (INLINE s) = happy_var_1 in InlineSig (l <^^> happy_var_4 <** [l,happy_var_4]) s happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_181 = happyReduce 4# 67# happyReduction_181
happyReduction_181 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 INLINE_CONLIKE) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut233 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn81
		 (InlineConlikeSig (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_4]) happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_182 = happyReduce 6# 67# happyReduction_182
happyReduction_182 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut233 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut82 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn81
		 (SpecSig (happy_var_1 <^^> happy_var_6 <** (happy_var_1: happy_var_4 : snd happy_var_5 ++ [happy_var_6])) happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_183 = happyReduce 6# 67# happyReduction_183
happyReduction_183 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut233 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut82 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn81
		 (let Loc l (SPECIALISE_INLINE s) = happy_var_1
               in SpecInlineSig (l <^^> happy_var_6 <** (l:happy_var_4:snd happy_var_5++[happy_var_6])) s happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_184 = happyMonadReduce 4# 67# happyReduction_184
happyReduction_184 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	( do { ih <- checkInstHeader happy_var_3;
                                                               let {l = happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,happy_var_4]};
                                                               return $ InstSig l ih })}}}}
	) (\r -> happyReturn (happyIn81 r))

happyReduce_185 = happySpecReduce_3  67# happyReduction_185
happyReduction_185 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 MINIMAL) -> 
	case happyOut84 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn81
		 (MinimalPragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_186 = happySpecReduce_1  68# happyReduction_186
happyReduction_186 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 (([happy_var_1],[])
	)}

happyReduce_187 = happySpecReduce_3  68# happyReduction_187
happyReduction_187 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut82 happy_x_3 of { happy_var_3 -> 
	happyIn82
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_188 = happyMonadReduce 1# 69# happyReduction_188
happyReduction_188 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut120 happy_x_1 of { happy_var_1 -> 
	( checkType $ mkTyForall (ann happy_var_1) Nothing Nothing happy_var_1)}
	) (\r -> happyReturn (happyIn83 r))

happyReduce_189 = happySpecReduce_1  70# happyReduction_189
happyReduction_189 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (Just happy_var_1
	)}

happyReduce_190 = happySpecReduce_0  70# happyReduction_190
happyReduction_190  =  happyIn84
		 (Nothing
	)

happyReduce_191 = happySpecReduce_1  71# happyReduction_191
happyReduction_191 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn85
		 (happy_var_1
	)}

happyReduce_192 = happySpecReduce_3  71# happyReduction_192
happyReduction_192 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut85 happy_x_3 of { happy_var_3 -> 
	happyIn85
		 (OrFormula (ann happy_var_1 <++>  ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_193 = happySpecReduce_1  72# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	happyIn86
		 (happy_var_1
	)}

happyReduce_194 = happySpecReduce_3  72# happyReduction_194
happyReduction_194 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (AndFormula (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_195 = happySpecReduce_3  73# happyReduction_195
happyReduction_195 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn87
		 (ParenFormula (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_196 = happySpecReduce_1  73# happyReduction_196
happyReduction_196 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn87
		 (VarFormula (ann happy_var_1) happy_var_1
	)}

happyReduce_197 = happySpecReduce_1  74# happyReduction_197
happyReduction_197 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 (happy_var_1
	)}

happyReduce_198 = happySpecReduce_3  74# happyReduction_198
happyReduction_198 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut227 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn88
		 (IPBinds (happy_var_1 <^^> happy_var_3 <** snd happy_var_2) (fst happy_var_2)
	)}}}

happyReduce_199 = happySpecReduce_3  74# happyReduction_199
happyReduction_199 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut227 happy_x_2 of { happy_var_2 -> 
	happyIn88
		 (let l' =  ann . last $ fst happy_var_2
                                         in IPBinds (nIS happy_var_1 <++> l' <** snd happy_var_2) (fst happy_var_2)
	)}}

happyReduce_200 = happySpecReduce_3  75# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut231 happy_x_3 of { happy_var_3 -> 
	happyIn89
		 (let (ns,ss,l) = happy_var_1 in (happy_var_3 : ns, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_201 = happyMonadReduce 1# 75# happyReduction_201
happyReduction_201 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return ([n],[],ann n) })}
	) (\r -> happyReturn (happyIn89 r))

happyReduce_202 = happySpecReduce_1  76# happyReduction_202
happyReduction_202 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn90
		 (StdCall    (nIS happy_var_1)
	)}

happyReduce_203 = happySpecReduce_1  76# happyReduction_203
happyReduction_203 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn90
		 (CCall      (nIS happy_var_1)
	)}

happyReduce_204 = happySpecReduce_1  76# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn90
		 (CPlusPlus  (nIS happy_var_1)
	)}

happyReduce_205 = happySpecReduce_1  76# happyReduction_205
happyReduction_205 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn90
		 (DotNet     (nIS happy_var_1)
	)}

happyReduce_206 = happySpecReduce_1  76# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn90
		 (Jvm        (nIS happy_var_1)
	)}

happyReduce_207 = happySpecReduce_1  76# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn90
		 (Js         (nIS happy_var_1)
	)}

happyReduce_208 = happySpecReduce_1  76# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn90
		 (JavaScript (nIS happy_var_1)
	)}

happyReduce_209 = happySpecReduce_1  76# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn90
		 (CApi       (nIS happy_var_1)
	)}

happyReduce_210 = happySpecReduce_1  77# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn91
		 (Just $ PlaySafe  (nIS happy_var_1) False
	)}

happyReduce_211 = happySpecReduce_1  77# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn91
		 (Just $ PlayRisky (nIS happy_var_1)
	)}

happyReduce_212 = happySpecReduce_1  77# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn91
		 (Just $ PlaySafe  (nIS happy_var_1) True
	)}

happyReduce_213 = happySpecReduce_1  77# happyReduction_213
happyReduction_213 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn91
		 (Just $ PlayInterruptible (nIS happy_var_1)
	)}

happyReduce_214 = happySpecReduce_0  77# happyReduction_214
happyReduction_214  =  happyIn91
		 (Nothing
	)

happyReduce_215 = happyReduce 4# 78# happyReduction_215
happyReduction_215 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut232 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut104 happy_x_4 of { happy_var_4 -> 
	happyIn92
		 (let Loc l (StringTok (s,_)) = happy_var_1 in (Just s, happy_var_2, happy_var_4, [l,happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_216 = happySpecReduce_3  78# happyReduction_216
happyReduction_216 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut232 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut104 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 ((Nothing, happy_var_1, happy_var_3, [happy_var_2])
	)}}}

happyReduce_217 = happySpecReduce_3  79# happyReduction_217
happyReduction_217 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_3 of { happy_var_3 -> 
	happyIn93
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_218 = happySpecReduce_2  79# happyReduction_218
happyReduction_218 happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (happy_var_1
	)}

happyReduce_219 = happySpecReduce_1  79# happyReduction_219
happyReduction_219 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 ([happy_var_1]
	)}

happyReduce_220 = happySpecReduce_0  79# happyReduction_220
happyReduction_220  =  happyIn93
		 ([]
	)

happyReduce_221 = happyMonadReduce 6# 80# happyReduction_221
happyReduction_221 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut96 happy_x_3 of { happy_var_3 -> 
	case happyOut172 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 Equals) -> 
	case happyOut170 happy_x_6 of { happy_var_6 -> 
	( do { let {Loc l (StringTok (s,_)) = happy_var_1};
                                                                  e <- checkRuleExpr happy_var_4;
                                                                  return $ Rule (nIS l <++> ann happy_var_6 <** l:snd happy_var_3 ++ [happy_var_5]) s happy_var_2 (fst happy_var_3) e happy_var_6 })}}}}}}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_222 = happySpecReduce_0  81# happyReduction_222
happyReduction_222  =  happyIn95
		 (Nothing
	)

happyReduce_223 = happySpecReduce_3  81# happyReduction_223
happyReduction_223 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn95
		 (let Loc l (IntTok (i,_)) = happy_var_2 in Just $ ActiveFrom  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3])    (fromInteger i)
	)}}}

happyReduce_224 = happyReduce 4# 81# happyReduction_224
happyReduction_224 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Tilde) -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	happyIn95
		 (let Loc l (IntTok (i,_)) = happy_var_3 in Just $ ActiveUntil (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,l,happy_var_4]) (fromInteger i)
	) `HappyStk` happyRest}}}}

happyReduce_225 = happySpecReduce_0  82# happyReduction_225
happyReduction_225  =  happyIn96
		 ((Nothing,[])
	)

happyReduce_226 = happySpecReduce_3  82# happyReduction_226
happyReduction_226 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	happyIn96
		 ((Just happy_var_2,[happy_var_1,happy_var_3])
	)}}}

happyReduce_227 = happySpecReduce_1  83# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn97
		 ([happy_var_1]
	)}

happyReduce_228 = happySpecReduce_2  83# happyReduction_228
happyReduction_228 happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	happyIn97
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_229 = happySpecReduce_1  84# happyReduction_229
happyReduction_229 happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 (RuleVar (ann happy_var_1) happy_var_1
	)}

happyReduce_230 = happyReduce 5# 84# happyReduction_230
happyReduction_230 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut249 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn98
		 (TypedRuleVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_231 = happySpecReduce_3  85# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	happyIn99
		 ((fst happy_var_3 : fst happy_var_1, snd happy_var_1 ++ (happy_var_2:snd happy_var_3))
	)}}}

happyReduce_232 = happySpecReduce_2  85# happyReduction_232
happyReduction_232 happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn99
		 ((fst happy_var_1, snd happy_var_1 ++ [happy_var_2])
	)}}

happyReduce_233 = happySpecReduce_1  85# happyReduction_233
happyReduction_233 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (([fst happy_var_1],snd happy_var_1)
	)}

happyReduce_234 = happySpecReduce_0  85# happyReduction_234
happyReduction_234  =  happyIn99
		 (([],[])
	)

happyReduce_235 = happySpecReduce_2  86# happyReduction_235
happyReduction_235 happy_x_2
	happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn100
		 (let Loc l (StringTok (s,_)) = happy_var_2 in ((fst happy_var_1,s),snd happy_var_1 ++ [l])
	)}}

happyReduce_236 = happySpecReduce_1  87# happyReduction_236
happyReduction_236 happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	happyIn101
		 (([happy_var_1],[])
	)}

happyReduce_237 = happySpecReduce_3  87# happyReduction_237
happyReduction_237 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut101 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_238 = happySpecReduce_1  88# happyReduction_238
happyReduction_238 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (happy_var_1
	)}

happyReduce_239 = happySpecReduce_1  88# happyReduction_239
happyReduction_239 happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (happy_var_1
	)}

happyReduce_240 = happyMonadReduce 3# 89# happyReduction_240
happyReduction_240 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut252 happy_x_2 of { happy_var_2 -> 
	case happyOut183 happy_x_3 of { happy_var_3 -> 
	( checkExpr happy_var_3 >>= \e -> return (TypeAnn   (nIS happy_var_1 <++> ann e <** [happy_var_1]) happy_var_2 e))}}}
	) (\r -> happyReturn (happyIn103 r))

happyReduce_241 = happyMonadReduce 2# 89# happyReduction_241
happyReduction_241 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (ModuleAnn (nIS happy_var_1 <++> ann e <** [happy_var_1])    e))}}
	) (\r -> happyReturn (happyIn103 r))

happyReduce_242 = happyMonadReduce 2# 89# happyReduction_242
happyReduction_242 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (Ann (happy_var_1 <> e) happy_var_1 e))}}
	) (\r -> happyReturn (happyIn103 r))

happyReduce_243 = happyMonadReduce 1# 90# happyReduction_243
happyReduction_243 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut105 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn104 r))

happyReduce_244 = happySpecReduce_1  91# happyReduction_244
happyReduction_244 happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	happyIn105
		 (splitTilde happy_var_1
	)}

happyReduce_245 = happySpecReduce_3  91# happyReduction_245
happyReduction_245 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut118 happy_x_2 of { happy_var_2 -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_246 = happySpecReduce_3  91# happyReduction_246
happyReduction_246 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut276 happy_x_2 of { happy_var_2 -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_247 = happySpecReduce_3  91# happyReduction_247
happyReduction_247 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyFun (happy_var_1 <> happy_var_3 <** [happy_var_2]) (splitTilde happy_var_1) happy_var_3
	)}}}

happyReduce_248 = happyMonadReduce 1# 92# happyReduction_248
happyReduction_248 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut107 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn106 r))

happyReduce_249 = happySpecReduce_3  93# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn107
		 (let l = (happy_var_1 <> happy_var_3 <** [happy_var_2]) in TyPred l $ IParam l happy_var_1 happy_var_3
	)}}}

happyReduce_250 = happySpecReduce_1  93# happyReduction_250
happyReduction_250 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn107
		 (happy_var_1
	)}

happyReduce_251 = happyMonadReduce 1# 94# happyReduction_251
happyReduction_251 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut110 happy_x_1 of { happy_var_1 -> 
	( checkType (splitTilde happy_var_1))}
	) (\r -> happyReturn (happyIn108 r))

happyReduce_252 = happyMonadReduce 1# 95# happyReduction_252
happyReduction_252 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut111 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_253 = happySpecReduce_2  96# happyReduction_253
happyReduction_253 happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	happyIn110
		 (TyApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_254 = happySpecReduce_1  96# happyReduction_254
happyReduction_254 happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	happyIn110
		 (happy_var_1
	)}

happyReduce_255 = happySpecReduce_1  97# happyReduction_255
happyReduction_255 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (TyCon   (ann happy_var_1) happy_var_1
	)}

happyReduce_256 = happyMonadReduce 1# 97# happyReduction_256
happyReduction_256 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut274 happy_x_1 of { happy_var_1 -> 
	( checkTyVar happy_var_1)}
	) (\r -> happyReturn (happyIn111 r))

happyReduce_257 = happySpecReduce_2  97# happyReduction_257
happyReduction_257 happy_x_2
	happy_x_1
	 =  case happyOut113 happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	happyIn111
		 (let (mstrict, mupack) = happy_var_1
                                        in bangType mstrict mupack happy_var_2
	)}}

happyReduce_258 = happySpecReduce_3  97# happyReduction_258
happyReduction_258 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Boxed   (reverse (fst happy_var_2))
	)}}}

happyReduce_259 = happySpecReduce_3  97# happyReduction_259
happyReduction_259 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn111
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Unboxed (reverse (fst happy_var_2))
	)}}}

happyReduce_260 = happySpecReduce_3  97# happyReduction_260
happyReduction_260 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn111
		 (TyList  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_261 = happySpecReduce_3  97# happyReduction_261
happyReduction_261 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn111
		 (TyParArray  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_262 = happySpecReduce_3  97# happyReduction_262
happyReduction_262 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (TyParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_263 = happyReduce 5# 97# happyReduction_263
happyReduction_263 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut146 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn111
		 (TyKind  (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_264 = happySpecReduce_3  97# happyReduction_264
happyReduction_264 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in TySplice l $ ParenSplice l happy_var_2
	)}}}

happyReduce_265 = happySpecReduce_1  97# happyReduction_265
happyReduction_265 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (let Loc l (THIdEscape s) = happy_var_1 in TySplice (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_266 = happySpecReduce_1  97# happyReduction_266
happyReduction_266 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn111
		 (TyWildCard (nIS happy_var_1) Nothing
	)}

happyReduce_267 = happySpecReduce_1  97# happyReduction_267
happyReduction_267 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (let Loc l (THQuasiQuote (n,q)) = happy_var_1 in TyQuasiQuote (nIS l) n q
	)}

happyReduce_268 = happyMonadReduce 1# 97# happyReduction_268
happyReduction_268 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut112 happy_x_1 of { happy_var_1 -> 
	( checkEnabled DataKinds >> return (TyPromoted (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn111 r))

happyReduce_269 = happyMonadReduce 4# 98# happyReduction_269
happyReduction_269 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) True . reverse <$> mapM checkType (fst happy_var_3))}}}
	) (\r -> happyReturn (happyIn112 r))

happyReduce_270 = happySpecReduce_3  98# happyReduction_270
happyReduction_270 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn112
		 (PromotedList   (happy_var_1 <^^> happy_var_3 <** [happy_var_1, happy_var_3]) True  []
	)}}

happyReduce_271 = happyMonadReduce 3# 98# happyReduction_271
happyReduction_271 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse(happy_var_3:snd happy_var_2))) False . reverse <$> mapM checkType (fst happy_var_2))}}}
	) (\r -> happyReturn (happyIn112 r))

happyReduce_272 = happyMonadReduce 4# 98# happyReduction_272
happyReduction_272 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	( PromotedTuple (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) . reverse <$> mapM checkType (fst happy_var_3))}}}
	) (\r -> happyReturn (happyIn112 r))

happyReduce_273 = happySpecReduce_3  98# happyReduction_273
happyReduction_273 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn112
		 (PromotedUnit  (happy_var_1 <^^> happy_var_3 )
	)}}

happyReduce_274 = happySpecReduce_2  98# happyReduction_274
happyReduction_274 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut245 happy_x_2 of { happy_var_2 -> 
	happyIn112
		 (PromotedCon ((noInfoSpan happy_var_1 <++> ann happy_var_2) <** [happy_var_1]) True  happy_var_2
	)}}

happyReduce_275 = happySpecReduce_2  98# happyReduction_275
happyReduction_275 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut273 happy_x_2 of { happy_var_2 -> 
	happyIn112
		 (PromotedCon ((noInfoSpan happy_var_1 <++> ann happy_var_2) <** [happy_var_1]) True  happy_var_2
	)}}

happyReduce_276 = happySpecReduce_1  98# happyReduction_276
happyReduction_276 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (let Loc l (IntTok  (i,raw)) = happy_var_1 in PromotedInteger (nIS l) i raw
	)}

happyReduce_277 = happySpecReduce_1  98# happyReduction_277
happyReduction_277 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (let Loc l (StringTok (s,raw)) = happy_var_1 in PromotedString (nIS l) s raw
	)}

happyReduce_278 = happySpecReduce_1  99# happyReduction_278
happyReduction_278 happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 ((Just happy_var_1, Nothing)
	)}

happyReduce_279 = happySpecReduce_1  99# happyReduction_279
happyReduction_279 happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 ((Nothing, Just happy_var_1)
	)}

happyReduce_280 = happySpecReduce_2  99# happyReduction_280
happyReduction_280 happy_x_2
	happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	case happyOut114 happy_x_2 of { happy_var_2 -> 
	happyIn113
		 ((Just happy_var_2, Just happy_var_1)
	)}}

happyReduce_281 = happySpecReduce_1  100# happyReduction_281
happyReduction_281 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	happyIn114
		 ((BangedTy, happy_var_1)
	)}

happyReduce_282 = happySpecReduce_1  100# happyReduction_282
happyReduction_282 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Tilde) -> 
	happyIn114
		 ((LazyTy, happy_var_1)
	)}

happyReduce_283 = happySpecReduce_2  101# happyReduction_283
happyReduction_283 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 UNPACK) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn115
		 ((Unpack ((nIS happy_var_1 <++> nIS happy_var_2) <** [happy_var_1,happy_var_2]))
	)}}

happyReduce_284 = happySpecReduce_2  101# happyReduction_284
happyReduction_284 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 NOUNPACK) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn115
		 ((NoUnpack ((nIS happy_var_1 <++> nIS happy_var_2) <** [happy_var_1,happy_var_2]))
	)}}

happyReduce_285 = happySpecReduce_1  102# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	happyIn116
		 (happy_var_1
	)}

happyReduce_286 = happySpecReduce_2  102# happyReduction_286
happyReduction_286 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn116
		 (unit_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_287 = happySpecReduce_3  102# happyReduction_287
happyReduction_287 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn116
		 (fun_tycon_name               (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_2,happy_var_3])
	)}}}

happyReduce_288 = happySpecReduce_2  102# happyReduction_288
happyReduction_288 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightSquare) -> 
	happyIn116
		 (list_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_289 = happySpecReduce_3  102# happyReduction_289
happyReduction_289 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn116
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Boxed (length happy_var_2)
	)}}}

happyReduce_290 = happySpecReduce_2  102# happyReduction_290
happyReduction_290 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn116
		 (unboxed_singleton_tycon_name (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_291 = happySpecReduce_3  102# happyReduction_291
happyReduction_291 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn116
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Unboxed (length happy_var_2)
	)}}}

happyReduce_292 = happySpecReduce_1  103# happyReduction_292
happyReduction_292 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn117
		 (happy_var_1
	)}

happyReduce_293 = happySpecReduce_3  103# happyReduction_293
happyReduction_293 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut245 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn117
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_294 = happySpecReduce_3  103# happyReduction_294
happyReduction_294 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut255 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn117
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_295 = happySpecReduce_1  104# happyReduction_295
happyReduction_295 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn118
		 (happy_var_1
	)}

happyReduce_296 = happyMonadReduce 1# 105# happyReduction_296
happyReduction_296 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut120 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn119 r))

happyReduce_297 = happyReduce 4# 106# happyReduction_297
happyReduction_297 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	case happyOut120 happy_x_4 of { happy_var_4 -> 
	happyIn120
		 (mkTyForall (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (Just (reverse (fst happy_var_2))) Nothing happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_298 = happySpecReduce_2  106# happyReduction_298
happyReduction_298 happy_x_2
	happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	happyIn120
		 (mkTyForall (happy_var_1 <> happy_var_2) Nothing (Just happy_var_1) happy_var_2
	)}}

happyReduce_299 = happySpecReduce_1  106# happyReduction_299
happyReduction_299 happy_x_1
	 =  case happyOut107 happy_x_1 of { happy_var_1 -> 
	happyIn120
		 (happy_var_1
	)}

happyReduce_300 = happyMonadReduce 2# 107# happyReduction_300
happyReduction_300 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleArrow) -> 
	( checkPContext $ (amap (\l -> l <++> nIS happy_var_2 <** (srcInfoPoints l ++ [happy_var_2]))) (splitTilde happy_var_1))}}
	) (\r -> happyReturn (happyIn121 r))

happyReduce_301 = happySpecReduce_3  108# happyReduction_301
happyReduction_301 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn122
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_302 = happySpecReduce_1  109# happyReduction_302
happyReduction_302 happy_x_1
	 =  case happyOut120 happy_x_1 of { happy_var_1 -> 
	happyIn123
		 (([happy_var_1],[])
	)}

happyReduce_303 = happySpecReduce_3  109# happyReduction_303
happyReduction_303 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn123
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_304 = happySpecReduce_2  110# happyReduction_304
happyReduction_304 happy_x_2
	happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	case happyOut125 happy_x_2 of { happy_var_2 -> 
	happyIn124
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_305 = happySpecReduce_0  110# happyReduction_305
happyReduction_305  =  happyIn124
		 (([],Nothing)
	)

happyReduce_306 = happySpecReduce_1  111# happyReduction_306
happyReduction_306 happy_x_1
	 =  case happyOut274 happy_x_1 of { happy_var_1 -> 
	happyIn125
		 (UnkindedVar (ann happy_var_1) happy_var_1
	)}

happyReduce_307 = happyReduce 5# 111# happyReduction_307
happyReduction_307 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut146 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn125
		 (KindedVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_308 = happySpecReduce_2  112# happyReduction_308
happyReduction_308 happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	happyIn126
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_309 = happySpecReduce_0  112# happyReduction_309
happyReduction_309  =  happyIn126
		 (([], Nothing)
	)

happyReduce_310 = happySpecReduce_2  113# happyReduction_310
happyReduction_310 happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_1 of { happy_var_1 -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	happyIn127
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <?+> ann happy_var_2)
	)}}

happyReduce_311 = happySpecReduce_0  114# happyReduction_311
happyReduction_311  =  happyIn128
		 (([],[], Nothing)
	)

happyReduce_312 = happyMonadReduce 2# 114# happyReduction_312
happyReduction_312 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut129 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled FunctionalDependencies ;
                                              let {(fds,ss,l) = happy_var_2} ;
                                              return (reverse fds, happy_var_1 : reverse ss, Just (nIS happy_var_1 <++> l)) })}}
	) (\r -> happyReturn (happyIn128 r))

happyReduce_313 = happySpecReduce_3  115# happyReduction_313
happyReduction_313 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut130 happy_x_3 of { happy_var_3 -> 
	happyIn129
		 (let (fds,ss,l) = happy_var_1 in (happy_var_3 : fds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_314 = happySpecReduce_1  115# happyReduction_314
happyReduction_314 happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_315 = happySpecReduce_3  116# happyReduction_315
happyReduction_315 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	happyIn130
		 (FunDep (snd happy_var_1 <?+> nIS happy_var_2 <++> snd happy_var_3 <** [happy_var_2]) (reverse (fst happy_var_1)) (reverse (fst happy_var_3))
	)}}}

happyReduce_316 = happyMonadReduce 4# 117# happyReduction_316
happyReduction_316 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut132 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}}
	) (\r -> happyReturn (happyIn131 r))

happyReduce_317 = happyMonadReduce 4# 117# happyReduction_317
happyReduction_317 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut132 happy_x_3 of { happy_var_3 -> 
	case happyOut262 happy_x_4 of { happy_var_4 -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}}
	) (\r -> happyReturn (happyIn131 r))

happyReduce_318 = happyMonadReduce 0# 117# happyReduction_318
happyReduction_318 (happyRest) tk
	 = happyThen (( checkEnabled EmptyDataDecls >> return ([],[],Nothing))
	) (\r -> happyReturn (happyIn131 r))

happyReduce_319 = happySpecReduce_3  118# happyReduction_319
happyReduction_319 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut133 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn132
		 ((fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_320 = happySpecReduce_3  119# happyReduction_320
happyReduction_320 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut133 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut134 happy_x_3 of { happy_var_3 -> 
	happyIn133
		 ((happy_var_3 ++ fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_321 = happySpecReduce_1  119# happyReduction_321
happyReduction_321 happy_x_1
	 =  case happyOut134 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 ((happy_var_1,[])
	)}

happyReduce_322 = happyMonadReduce 3# 120# happyReduction_322
happyReduction_322 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut236 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { c <- checkUnQual happy_var_1;
                                               return [GadtDecl (happy_var_1 <> happy_var_3 <** [happy_var_2]) c Nothing happy_var_3] })}}}
	) (\r -> happyReturn (happyIn134 r))

happyReduce_323 = happyMonadReduce 7# 120# happyReduction_323
happyReduction_323 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut236 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftCurly) -> 
	case happyOut141 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightCurly) -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 RightArrow) -> 
	case happyOut119 happy_x_7 of { happy_var_7 -> 
	( do { c <- checkUnQual happy_var_1;
                                              return [GadtDecl (happy_var_1 <> happy_var_7 <** [happy_var_2,happy_var_3,happy_var_5,happy_var_6] ++ snd happy_var_4) c (Just (reverse $ fst happy_var_4)) happy_var_7] })}}}}}}}
	) (\r -> happyReturn (happyIn134 r))

happyReduce_324 = happySpecReduce_2  121# happyReduction_324
happyReduction_324 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut136 happy_x_2 of { happy_var_2 -> 
	happyIn135
		 (let (ds,ss,l) = happy_var_2 in (ds, happy_var_1 : reverse ss, Just $ nIS happy_var_1 <++> l)
	)}}

happyReduce_325 = happySpecReduce_3  122# happyReduction_325
happyReduction_325 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut137 happy_x_3 of { happy_var_3 -> 
	happyIn136
		 (let (ds,ss,l) = happy_var_1 in (happy_var_3 : ds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_326 = happySpecReduce_1  122# happyReduction_326
happyReduction_326 happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	happyIn136
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_327 = happyMonadReduce 3# 123# happyReduction_327
happyReduction_327 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut138 happy_x_1 of { happy_var_1 -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	case happyOut139 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled ExistentialQuantification ;
                                               ctxt <- checkContext (Just happy_var_2) ;
                                               let {(mtvs,ss,ml) = happy_var_1} ;
                                               return $ QualConDecl (ml <?+> ann happy_var_3 <** ss) mtvs ctxt happy_var_3 })}}}
	) (\r -> happyReturn (happyIn137 r))

happyReduce_328 = happySpecReduce_2  123# happyReduction_328
happyReduction_328 happy_x_2
	happy_x_1
	 =  case happyOut138 happy_x_1 of { happy_var_1 -> 
	case happyOut139 happy_x_2 of { happy_var_2 -> 
	happyIn137
		 (let (mtvs, ss, ml) = happy_var_1 in QualConDecl (ml <?+> ann happy_var_2 <** ss) mtvs Nothing happy_var_2
	)}}

happyReduce_329 = happyMonadReduce 3# 124# happyReduction_329
happyReduction_329 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	( checkEnabled ExistentialQuantification >> return (Just (fst happy_var_2), [happy_var_1,happy_var_3], Just $ happy_var_1 <^^> happy_var_3))}}}
	) (\r -> happyReturn (happyIn138 r))

happyReduce_330 = happySpecReduce_0  124# happyReduction_330
happyReduction_330  =  happyIn138
		 ((Nothing, [], Nothing)
	)

happyReduce_331 = happySpecReduce_1  125# happyReduction_331
happyReduction_331 happy_x_1
	 =  case happyOut140 happy_x_1 of { happy_var_1 -> 
	happyIn139
		 (let (n,ts,l) = happy_var_1 in ConDecl l n ts
	)}

happyReduce_332 = happySpecReduce_3  125# happyReduction_332
happyReduction_332 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	case happyOut240 happy_x_2 of { happy_var_2 -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	happyIn139
		 (InfixConDecl (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_333 = happyMonadReduce 3# 125# happyReduction_333
happyReduction_333 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut236 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1; return $ RecDecl (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]) c [] })}}}
	) (\r -> happyReturn (happyIn139 r))

happyReduce_334 = happyMonadReduce 4# 125# happyReduction_334
happyReduction_334 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut236 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut141 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1;
                                              return $ RecDecl (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) c (reverse (fst happy_var_3)) })}}}}
	) (\r -> happyReturn (happyIn139 r))

happyReduce_335 = happyMonadReduce 1# 126# happyReduction_335
happyReduction_335 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut110 happy_x_1 of { happy_var_1 -> 
	( do { (c,ts) <- splitTyConApp happy_var_1;
                                              return (c, ts, ann happy_var_1) })}
	) (\r -> happyReturn (happyIn140 r))

happyReduce_336 = happySpecReduce_3  127# happyReduction_336
happyReduction_336 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut141 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut142 happy_x_3 of { happy_var_3 -> 
	happyIn141
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_337 = happySpecReduce_1  127# happyReduction_337
happyReduction_337 happy_x_1
	 =  case happyOut142 happy_x_1 of { happy_var_1 -> 
	happyIn141
		 (([happy_var_1],[])
	)}

happyReduce_338 = happySpecReduce_3  128# happyReduction_338
happyReduction_338 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	happyIn142
		 (let (ns,ss,l) = happy_var_1 in FieldDecl (l <++> ann happy_var_3 <** (reverse ss ++ [happy_var_2])) (reverse ns) happy_var_3
	)}}}

happyReduce_339 = happySpecReduce_0  129# happyReduction_339
happyReduction_339  =  happyIn143
		 (Nothing
	)

happyReduce_340 = happySpecReduce_2  129# happyReduction_340
happyReduction_340 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut145 happy_x_2 of { happy_var_2 -> 
	happyIn143
		 (let l = nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1] in Just $ Deriving l [IRule (ann happy_var_2) Nothing Nothing happy_var_2]
	)}}

happyReduce_341 = happySpecReduce_3  129# happyReduction_341
happyReduction_341 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn143
		 (Just $ Deriving (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_2,happy_var_3]) []
	)}}}

happyReduce_342 = happyReduce 4# 129# happyReduction_342
happyReduction_342 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut144 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn143
		 (-- Distinguish deriving (Show) from deriving Show (#189)
                                        case fst happy_var_3 of
                                          [ts] -> Just $ Deriving (happy_var_1 <^^> happy_var_4 <** [happy_var_1]) [IParen (happy_var_2 <^^> happy_var_4 <** [happy_var_2,happy_var_4]) ts]
                                          tss  -> Just $ Deriving (happy_var_1 <^^> happy_var_4 <** happy_var_1:happy_var_2: reverse (snd happy_var_3) ++ [happy_var_4]) (reverse tss)
	) `HappyStk` happyRest}}}}

happyReduce_343 = happyMonadReduce 1# 130# happyReduction_343
happyReduction_343 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut123 happy_x_1 of { happy_var_1 -> 
	( checkDeriving (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1))}
	) (\r -> happyReturn (happyIn144 r))

happyReduce_344 = happySpecReduce_1  131# happyReduction_344
happyReduction_344 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn145
		 (IHCon (ann happy_var_1) happy_var_1
	)}

happyReduce_345 = happyMonadReduce 1# 132# happyReduction_345
happyReduction_345 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut147 happy_x_1 of { happy_var_1 -> 
	( checkEnabled KindSignatures >> return happy_var_1)}
	) (\r -> happyReturn (happyIn146 r))

happyReduce_346 = happySpecReduce_1  133# happyReduction_346
happyReduction_346 happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	happyIn147
		 (happy_var_1
	)}

happyReduce_347 = happySpecReduce_3  133# happyReduction_347
happyReduction_347 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut147 happy_x_3 of { happy_var_3 -> 
	happyIn147
		 (KindFn (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_348 = happySpecReduce_1  134# happyReduction_348
happyReduction_348 happy_x_1
	 =  case happyOut149 happy_x_1 of { happy_var_1 -> 
	happyIn148
		 (happy_var_1
	)}

happyReduce_349 = happySpecReduce_2  134# happyReduction_349
happyReduction_349 happy_x_2
	happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn148
		 (KindApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_350 = happySpecReduce_1  135# happyReduction_350
happyReduction_350 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Star) -> 
	happyIn149
		 (KindStar  (nIS happy_var_1)
	)}

happyReduce_351 = happySpecReduce_3  135# happyReduction_351
happyReduction_351 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut147 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn149
		 (KindParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_352 = happyMonadReduce 1# 135# happyReduction_352
happyReduction_352 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut150 happy_x_1 of { happy_var_1 -> 
	( checkKind happy_var_1 >> return happy_var_1)}
	) (\r -> happyReturn (happyIn149 r))

happyReduce_353 = happyMonadReduce 1# 135# happyReduction_353
happyReduction_353 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut247 happy_x_1 of { happy_var_1 -> 
	( checkEnabled PolyKinds >> return (KindVar (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn149 r))

happyReduce_354 = happySpecReduce_1  136# happyReduction_354
happyReduction_354 happy_x_1
	 =  case happyOut273 happy_x_1 of { happy_var_1 -> 
	happyIn150
		 (KindVar (ann happy_var_1) happy_var_1
	)}

happyReduce_355 = happySpecReduce_2  136# happyReduction_355
happyReduction_355 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn150
		 (let l = happy_var_1 <^^> happy_var_2 in KindVar l (unit_tycon_name l)
	)}}

happyReduce_356 = happyReduce 5# 136# happyReduction_356
happyReduction_356 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Comma) -> 
	case happyOut151 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn150
		 (KindTuple (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3:reverse (happy_var_5:snd happy_var_4))) (happy_var_2:reverse (fst happy_var_4))
	) `HappyStk` happyRest}}}}}

happyReduce_357 = happySpecReduce_3  136# happyReduction_357
happyReduction_357 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn150
		 (KindList  ((happy_var_1 <^^> happy_var_3) <** [happy_var_1, happy_var_3]) happy_var_2
	)}}}

happyReduce_358 = happySpecReduce_1  137# happyReduction_358
happyReduction_358 happy_x_1
	 =  case happyOut147 happy_x_1 of { happy_var_1 -> 
	happyIn151
		 (([happy_var_1], [])
	)}

happyReduce_359 = happySpecReduce_3  137# happyReduction_359
happyReduction_359 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut147 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut151 happy_x_3 of { happy_var_3 -> 
	happyIn151
		 ((happy_var_1 : (fst happy_var_3), happy_var_2 : (snd happy_var_3))
	)}}}

happyReduce_360 = happySpecReduce_0  138# happyReduction_360
happyReduction_360  =  happyIn152
		 ((Nothing,[])
	)

happyReduce_361 = happySpecReduce_2  138# happyReduction_361
happyReduction_361 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn152
		 ((Just happy_var_2,[happy_var_1])
	)}}

happyReduce_362 = happyMonadReduce 4# 139# happyReduction_362
happyReduction_362 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut154 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkClassBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn153 r))

happyReduce_363 = happyMonadReduce 4# 139# happyReduction_363
happyReduction_363 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut154 happy_x_3 of { happy_var_3 -> 
	case happyOut262 happy_x_4 of { happy_var_4 -> 
	( do { vs <- checkClassBody (fst happy_var_3);
                                              let { l' = if null (fst happy_var_3) then nIS happy_var_4 else (ann . last $ fst happy_var_3) };
                                              return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (nIS happy_var_1 <++> l')) })}}}}
	) (\r -> happyReturn (happyIn153 r))

happyReduce_364 = happySpecReduce_0  139# happyReduction_364
happyReduction_364  =  happyIn153
		 ((Nothing,[],Nothing)
	)

happyReduce_365 = happyMonadReduce 3# 140# happyReduction_365
happyReduction_365 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut155 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevClsDecls (fst happy_var_2) >>= \cs -> return (cs, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn154 r))

happyReduce_366 = happySpecReduce_1  140# happyReduction_366
happyReduction_366 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn154
		 (([],reverse happy_var_1)
	)}

happyReduce_367 = happySpecReduce_3  141# happyReduction_367
happyReduction_367 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut156 happy_x_3 of { happy_var_3 -> 
	happyIn155
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_368 = happySpecReduce_1  141# happyReduction_368
happyReduction_368 happy_x_1
	 =  case happyOut156 happy_x_1 of { happy_var_1 -> 
	happyIn155
		 (([happy_var_1],[])
	)}

happyReduce_369 = happySpecReduce_1  142# happyReduction_369
happyReduction_369 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn156
		 (ClsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_370 = happyMonadReduce 1# 142# happyReduction_370
happyReduction_370 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut158 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)}
	) (\r -> happyReturn (happyIn156 r))

happyReduce_371 = happyMonadReduce 2# 142# happyReduction_371
happyReduction_371 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	( checkEnabled DefaultSignatures >> checkDefSigDef happy_var_2 >>= \(n,t,l) -> return (ClsDefSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1,l]) n t))}}
	) (\r -> happyReturn (happyIn156 r))

happyReduce_372 = happySpecReduce_0  143# happyReduction_372
happyReduction_372  =  happyIn157
		 ([]
	)

happyReduce_373 = happySpecReduce_1  143# happyReduction_373
happyReduction_373 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn157
		 ([happy_var_1]
	)}

happyReduce_374 = happyMonadReduce 4# 144# happyReduction_374
happyReduction_374 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_3;
                    return (ClsDataFam (nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) happy_var_4 <** [happy_var_1]) cs dh happy_var_4) })}}}
	) (\r -> happyReturn (happyIn158 r))

happyReduce_375 = happyMonadReduce 3# 144# happyReduction_375
happyReduction_375 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	( mkAssocType happy_var_1 happy_var_2 happy_var_3)}}}
	) (\r -> happyReturn (happyIn158 r))

happyReduce_376 = happyMonadReduce 4# 144# happyReduction_376
happyReduction_376 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut63 happy_x_4 of { happy_var_4 -> 
	( do { dh <- checkSimpleType happy_var_3;
                    return (ClsTyFam  (nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) (fst happy_var_4)
                                                          <+?> (fmap ann) (snd happy_var_4)
                                                          <** [happy_var_1]) dh (fst happy_var_4) (snd happy_var_4)) })}}}
	) (\r -> happyReturn (happyIn158 r))

happyReduce_377 = happySpecReduce_3  144# happyReduction_377
happyReduction_377 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (ClsTyDef (nIS happy_var_1 <++> ann happy_var_3 <** [happy_var_1,happy_var_2]) happy_var_3
	)}}}

happyReduce_378 = happyMonadReduce 4# 145# happyReduction_378
happyReduction_378 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut160 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn159 r))

happyReduce_379 = happyMonadReduce 4# 145# happyReduction_379
happyReduction_379 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut160 happy_x_3 of { happy_var_3 -> 
	case happyOut262 happy_x_4 of { happy_var_4 -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn159 r))

happyReduce_380 = happySpecReduce_0  145# happyReduction_380
happyReduction_380  =  happyIn159
		 ((Nothing, [], Nothing)
	)

happyReduce_381 = happyMonadReduce 3# 146# happyReduction_381
happyReduction_381 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut161 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevInstDecls (fst happy_var_2) >>= \is -> return (is, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn160 r))

happyReduce_382 = happySpecReduce_1  146# happyReduction_382
happyReduction_382 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (([],reverse happy_var_1)
	)}

happyReduce_383 = happySpecReduce_3  147# happyReduction_383
happyReduction_383 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut162 happy_x_3 of { happy_var_3 -> 
	happyIn161
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_384 = happySpecReduce_1  147# happyReduction_384
happyReduction_384 happy_x_1
	 =  case happyOut162 happy_x_1 of { happy_var_1 -> 
	happyIn161
		 (([happy_var_1],[])
	)}

happyReduce_385 = happySpecReduce_1  148# happyReduction_385
happyReduction_385 happy_x_1
	 =  case happyOut164 happy_x_1 of { happy_var_1 -> 
	happyIn162
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_386 = happyMonadReduce 1# 148# happyReduction_386
happyReduction_386 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut163 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_387 = happySpecReduce_1  148# happyReduction_387
happyReduction_387 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn162
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_388 = happyMonadReduce 1# 148# happyReduction_388
happyReduction_388 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut80 happy_x_1 of { happy_var_1 -> 
	( checkEnabled InstanceSigs >> return (InsDecl (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_389 = happyMonadReduce 4# 149# happyReduction_389
happyReduction_389 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut104 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       return (InsType (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn163 r))

happyReduce_390 = happyMonadReduce 4# 149# happyReduction_390
happyReduction_390 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	case happyOut143 happy_x_4 of { happy_var_4 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let {(ds,ss,minf) = happy_var_3};
                       checkDataOrNew happy_var_1 ds;
                       return (InsData (happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann happy_var_4 <** ss ) happy_var_1 happy_var_2 (reverse ds) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn163 r))

happyReduce_391 = happyMonadReduce 5# 149# happyReduction_391
happyReduction_391 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut152 happy_x_3 of { happy_var_3 -> 
	case happyOut131 happy_x_4 of { happy_var_4 -> 
	case happyOut143 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let { (gs,ss,minf) = happy_var_4 } ;
                       checkDataOrNewG happy_var_1 gs;
                       return $ InsGData (ann happy_var_1 <+?> minf <+?> fmap ann happy_var_5 <** (snd happy_var_3 ++ ss)) happy_var_1 happy_var_2 (fst happy_var_3) (reverse gs) happy_var_5 })}}}}}
	) (\r -> happyReturn (happyIn163 r))

happyReduce_392 = happyMonadReduce 4# 150# happyReduction_392
happyReduction_392 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOut166 happy_x_2 of { happy_var_2 -> 
	case happyOut167 happy_x_3 of { happy_var_3 -> 
	case happyOut165 happy_x_4 of { happy_var_4 -> 
	( checkValDef ((happy_var_1 <> happy_var_3 <+?> (fmap ann) (fst happy_var_4)) <** (snd happy_var_4)) happy_var_1 happy_var_2 happy_var_3 (fst happy_var_4))}}}}
	) (\r -> happyReturn (happyIn164 r))

happyReduce_393 = happyMonadReduce 4# 150# happyReduction_393
happyReduction_393 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	case happyOut167 happy_x_3 of { happy_var_3 -> 
	case happyOut165 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled BangPatterns ;
                                              let { l = nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1] };
                                              p <- checkPattern (BangPat l happy_var_2);
                                              return $ PatBind (p <> happy_var_3 <+?> (fmap ann) (fst happy_var_4) <** snd happy_var_4)
                                                          p happy_var_3 (fst happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn164 r))

happyReduce_394 = happySpecReduce_2  151# happyReduction_394
happyReduction_394 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn165
		 ((Just happy_var_2, [happy_var_1])
	)}}

happyReduce_395 = happySpecReduce_0  151# happyReduction_395
happyReduction_395  =  happyIn165
		 ((Nothing, [])
	)

happyReduce_396 = happyMonadReduce 2# 152# happyReduction_396
happyReduction_396 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	( checkEnabled ScopedTypeVariables >> return (Just (happy_var_2, happy_var_1)))}}
	) (\r -> happyReturn (happyIn166 r))

happyReduce_397 = happySpecReduce_0  152# happyReduction_397
happyReduction_397  =  happyIn166
		 (Nothing
	)

happyReduce_398 = happySpecReduce_2  153# happyReduction_398
happyReduction_398 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn167
		 (UnGuardedRhs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_399 = happySpecReduce_1  153# happyReduction_399
happyReduction_399 happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	happyIn167
		 (GuardedRhss (snd happy_var_1) (reverse $ fst happy_var_1)
	)}

happyReduce_400 = happySpecReduce_2  154# happyReduction_400
happyReduction_400 happy_x_2
	happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	happyIn168
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <++> ann happy_var_2)
	)}}

happyReduce_401 = happySpecReduce_1  154# happyReduction_401
happyReduction_401 happy_x_1
	 =  case happyOut169 happy_x_1 of { happy_var_1 -> 
	happyIn168
		 (([happy_var_1],ann happy_var_1)
	)}

happyReduce_402 = happyMonadReduce 4# 155# happyReduction_402
happyReduction_402 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut207 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	( do { checkPatternGuards (fst happy_var_2);
                                       return $ GuardedRhs (nIS happy_var_1 <++> ann happy_var_4 <** (happy_var_1:snd happy_var_2 ++ [happy_var_3])) (reverse (fst happy_var_2)) happy_var_4 })}}}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_403 = happyMonadReduce 1# 156# happyReduction_403
happyReduction_403 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut171 happy_x_1 of { happy_var_1 -> 
	( checkExpr happy_var_1)}
	) (\r -> happyReturn (happyIn170 r))

happyReduce_404 = happySpecReduce_3  157# happyReduction_404
happyReduction_404 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (ExpTypeSig      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_405 = happySpecReduce_1  157# happyReduction_405
happyReduction_405 happy_x_1
	 =  case happyOut172 happy_x_1 of { happy_var_1 -> 
	happyIn171
		 (happy_var_1
	)}

happyReduce_406 = happySpecReduce_2  157# happyReduction_406
happyReduction_406 happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	happyIn171
		 (PostOp          (happy_var_1 <> happy_var_2)          happy_var_1 happy_var_2
	)}}

happyReduce_407 = happySpecReduce_3  157# happyReduction_407
happyReduction_407 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrowTail) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (LeftArrApp      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_408 = happySpecReduce_3  157# happyReduction_408
happyReduction_408 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrowTail) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (RightArrApp     (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_409 = happySpecReduce_3  157# happyReduction_409
happyReduction_409 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftDblArrowTail) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (LeftArrHighApp  (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_410 = happySpecReduce_3  157# happyReduction_410
happyReduction_410 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightDblArrowTail) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (RightArrHighApp (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_411 = happySpecReduce_1  158# happyReduction_411
happyReduction_411 happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (happy_var_1
	)}

happyReduce_412 = happySpecReduce_1  158# happyReduction_412
happyReduction_412 happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (happy_var_1
	)}

happyReduce_413 = happySpecReduce_3  159# happyReduction_413
happyReduction_413 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn173
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_414 = happySpecReduce_1  159# happyReduction_414
happyReduction_414 happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	happyIn173
		 (happy_var_1
	)}

happyReduce_415 = happySpecReduce_3  160# happyReduction_415
happyReduction_415 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	case happyOut178 happy_x_3 of { happy_var_3 -> 
	happyIn174
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_416 = happySpecReduce_1  160# happyReduction_416
happyReduction_416 happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	happyIn174
		 (happy_var_1
	)}

happyReduce_417 = happyReduce 4# 161# happyReduction_417
happyReduction_417 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOut181 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut171 happy_x_4 of { happy_var_4 -> 
	happyIn175
		 (Lambda (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_418 = happyReduce 4# 161# happyReduction_418
happyReduction_418 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_In) -> 
	case happyOut171 happy_x_4 of { happy_var_4 -> 
	happyIn175
		 (Let    (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_419 = happyReduce 8# 161# happyReduction_419
happyReduction_419 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut171 happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 KW_Then) -> 
	case happyOut171 happy_x_5 of { happy_var_5 -> 
	case happyOut176 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 KW_Else) -> 
	case happyOut171 happy_x_8 of { happy_var_8 -> 
	happyIn175
		 (If     (nIS happy_var_1 <++> ann happy_var_8 <** (happy_var_1:happy_var_3 ++ happy_var_4:happy_var_6 ++ [happy_var_7])) happy_var_2 happy_var_5 happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_420 = happyMonadReduce 2# 161# happyReduction_420
happyReduction_420 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut218 happy_x_2 of { happy_var_2 -> 
	( checkEnabled MultiWayIf >>
                                           let (alts, inf, ss) = happy_var_2
                                           in return (MultiIf (nIS happy_var_1 <++> inf <** (happy_var_1:ss)) alts))}}
	) (\r -> happyReturn (happyIn175 r))

happyReduce_421 = happyReduce 4# 161# happyReduction_421
happyReduction_421 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Proc) -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut171 happy_x_4 of { happy_var_4 -> 
	happyIn175
		 (Proc   (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_422 = happySpecReduce_1  161# happyReduction_422
happyReduction_422 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn175
		 (happy_var_1
	)}

happyReduce_423 = happyMonadReduce 1# 162# happyReduction_423
happyReduction_423 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	( checkEnabled DoAndIfThenElse >> return [happy_var_1])}
	) (\r -> happyReturn (happyIn176 r))

happyReduce_424 = happySpecReduce_0  162# happyReduction_424
happyReduction_424  =  happyIn176
		 ([]
	)

happyReduce_425 = happySpecReduce_1  163# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	happyIn177
		 ([happy_var_1]
	)}

happyReduce_426 = happySpecReduce_0  163# happyReduction_426
happyReduction_426  =  happyIn177
		 ([]
	)

happyReduce_427 = happyReduce 4# 164# happyReduction_427
happyReduction_427 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Case) -> 
	case happyOut171 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Of) -> 
	case happyOut210 happy_x_4 of { happy_var_4 -> 
	happyIn178
		 (let (als, inf, ss) = happy_var_4 in Case (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_3:ss)) happy_var_2 als
	) `HappyStk` happyRest}}}}

happyReduce_428 = happyMonadReduce 3# 164# happyReduction_428
happyReduction_428 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Case) -> 
	case happyOut210 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled LambdaCase ;
                                              let { (als, inf, ss) = happy_var_3 } ;
                                              return (LCase (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_2:ss)) als) })}}}
	) (\r -> happyReturn (happyIn178 r))

happyReduce_429 = happySpecReduce_2  164# happyReduction_429
happyReduction_429 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn178
		 (NegApp (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_430 = happySpecReduce_2  164# happyReduction_430
happyReduction_430 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Do) -> 
	case happyOut221 happy_x_2 of { happy_var_2 -> 
	happyIn178
		 (let (sts, inf, ss) = happy_var_2 in Do   (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_431 = happySpecReduce_2  164# happyReduction_431
happyReduction_431 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_MDo) -> 
	case happyOut221 happy_x_2 of { happy_var_2 -> 
	happyIn178
		 (let (sts, inf, ss) = happy_var_2 in MDo  (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_432 = happySpecReduce_1  164# happyReduction_432
happyReduction_432 happy_x_1
	 =  case happyOut180 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (happy_var_1
	)}

happyReduce_433 = happyReduce 4# 165# happyReduction_433
happyReduction_433 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 CORE) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut171 happy_x_4 of { happy_var_4 -> 
	happyIn179
		 (let Loc l (StringTok (s,_)) = happy_var_2 in CorePragma (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_434 = happyReduce 4# 165# happyReduction_434
happyReduction_434 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SCC) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut171 happy_x_4 of { happy_var_4 -> 
	happyIn179
		 (let Loc l (StringTok (s,_)) = happy_var_2 in SCCPragma  (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_435 = happyReduce 11# 165# happyReduction_435
happyReduction_435 (happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 GENERATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Colon) -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 Minus) -> 
	case happyOutTok happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 Colon) -> 
	case happyOutTok happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 PragmaEnd) -> 
	case happyOut171 happy_x_11 of { happy_var_11 -> 
	happyIn179
		 (let { Loc l0 (StringTok (s,_)) = happy_var_2;
                                                  Loc l1 (IntTok (i1,_))   = happy_var_3;
                                                  Loc l2 (IntTok (i2,_))   = happy_var_5;
                                                  Loc l3 (IntTok (i3,_))   = happy_var_7;
                                                  Loc l4 (IntTok (i4,_))   = happy_var_9}
                                             in GenPragma (nIS happy_var_1 <++> ann happy_var_11 <** [happy_var_1,l0,l1,happy_var_4,l2,happy_var_6,l3,happy_var_8,l4,happy_var_10])
                                                      s (fromInteger i1, fromInteger i2)
                                                        (fromInteger i3, fromInteger i4) happy_var_11
	) `HappyStk` happyRest}}}}}}}}}}}

happyReduce_436 = happySpecReduce_2  166# happyReduction_436
happyReduction_436 happy_x_2
	happy_x_1
	 =  case happyOut180 happy_x_1 of { happy_var_1 -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	happyIn180
		 (App (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_437 = happySpecReduce_1  166# happyReduction_437
happyReduction_437 happy_x_1
	 =  case happyOut183 happy_x_1 of { happy_var_1 -> 
	happyIn180
		 (happy_var_1
	)}

happyReduce_438 = happySpecReduce_2  167# happyReduction_438
happyReduction_438 happy_x_2
	happy_x_1
	 =  case happyOut181 happy_x_1 of { happy_var_1 -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	happyIn181
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_439 = happySpecReduce_1  167# happyReduction_439
happyReduction_439 happy_x_1
	 =  case happyOut182 happy_x_1 of { happy_var_1 -> 
	happyIn181
		 ([happy_var_1]
	)}

happyReduce_440 = happyMonadReduce 1# 168# happyReduction_440
happyReduction_440 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut183 happy_x_1 of { happy_var_1 -> 
	( checkPattern happy_var_1)}
	) (\r -> happyReturn (happyIn182 r))

happyReduce_441 = happyMonadReduce 2# 168# happyReduction_441
happyReduction_441 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	( checkPattern (BangPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2))}}
	) (\r -> happyReturn (happyIn182 r))

happyReduce_442 = happyMonadReduce 3# 169# happyReduction_442
happyReduction_442 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 At) -> 
	case happyOut183 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (AsPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}}
	) (\r -> happyReturn (happyIn183 r))

happyReduce_443 = happyMonadReduce 3# 169# happyReduction_443
happyReduction_443 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RPCAt) -> 
	case happyOut183 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (CAsRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}}
	) (\r -> happyReturn (happyIn183 r))

happyReduce_444 = happySpecReduce_2  169# happyReduction_444
happyReduction_444 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Tilde) -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	happyIn183
		 (IrrPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_445 = happySpecReduce_2  169# happyReduction_445
happyReduction_445 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 TApp) -> 
	case happyOut109 happy_x_2 of { happy_var_2 -> 
	happyIn183
		 (TypeApp (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_446 = happySpecReduce_1  169# happyReduction_446
happyReduction_446 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (happy_var_1
	)}

happyReduce_447 = happyMonadReduce 3# 170# happyReduction_447
happyReduction_447 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]))) $ mkRecConstrOrUpdate happy_var_1 [])}}}
	) (\r -> happyReturn (happyIn184 r))

happyReduce_448 = happyMonadReduce 4# 170# happyReduction_448
happyReduction_448 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut225 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4]))))
                                              $ mkRecConstrOrUpdate happy_var_1 (fst happy_var_3))}}}}
	) (\r -> happyReturn (happyIn184 r))

happyReduce_449 = happySpecReduce_1  170# happyReduction_449
happyReduction_449 happy_x_1
	 =  case happyOut185 happy_x_1 of { happy_var_1 -> 
	happyIn184
		 (happy_var_1
	)}

happyReduce_450 = happySpecReduce_1  171# happyReduction_450
happyReduction_450 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (IPVar (ann happy_var_1) happy_var_1
	)}

happyReduce_451 = happySpecReduce_1  171# happyReduction_451
happyReduction_451 happy_x_1
	 =  case happyOut246 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (happy_var_1
	)}

happyReduce_452 = happySpecReduce_1  171# happyReduction_452
happyReduction_452 happy_x_1
	 =  case happyOut233 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (Var (ann happy_var_1) happy_var_1
	)}

happyReduce_453 = happySpecReduce_1  171# happyReduction_453
happyReduction_453 happy_x_1
	 =  case happyOut230 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (happy_var_1
	)}

happyReduce_454 = happySpecReduce_1  171# happyReduction_454
happyReduction_454 happy_x_1
	 =  case happyOut260 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (Lit (ann happy_var_1) happy_var_1
	)}

happyReduce_455 = happySpecReduce_3  171# happyReduction_455
happyReduction_455 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn185
		 (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_456 = happySpecReduce_3  171# happyReduction_456
happyReduction_456 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOut188 happy_x_3 of { happy_var_3 -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_3) <** happy_var_1:reverse (snd happy_var_3)) Boxed (Just happy_var_2 : fst happy_var_3)
	)}}}

happyReduce_457 = happyReduce 4# 171# happyReduction_457
happyReduction_457 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> happy_var_4 <** happy_var_1:reverse (happy_var_4:happy_var_2)) Boxed
                                                      (replicate (length happy_var_2) Nothing ++ [Just happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_458 = happyReduce 4# 171# happyReduction_458
happyReduction_458 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	case happyOut188 happy_x_4 of { happy_var_4 -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_4) <** happy_var_1:reverse (snd happy_var_4 ++ happy_var_2)) Boxed
                                                      (replicate (length happy_var_2) Nothing ++ Just happy_var_3 : fst happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_459 = happySpecReduce_3  171# happyReduction_459
happyReduction_459 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOut189 happy_x_3 of { happy_var_3 -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_3) <** happy_var_1:reverse (snd happy_var_3)) Unboxed (Just happy_var_2 : fst happy_var_3)
	)}}}

happyReduce_460 = happySpecReduce_3  171# happyReduction_460
happyReduction_460 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) Unboxed [Just happy_var_2]
	)}}}

happyReduce_461 = happyReduce 4# 171# happyReduction_461
happyReduction_461 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightHashParen) -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> happy_var_4 <** happy_var_1:reverse (happy_var_4:happy_var_2)) Unboxed
                                                      (replicate (length happy_var_2) Nothing ++ [Just happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_462 = happyReduce 4# 171# happyReduction_462
happyReduction_462 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	case happyOut189 happy_x_4 of { happy_var_4 -> 
	happyIn185
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_4) <** happy_var_1:reverse (snd happy_var_4 ++ happy_var_2)) Unboxed
                                                      (replicate (length happy_var_2) Nothing ++ Just happy_var_3 : fst happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_463 = happySpecReduce_3  171# happyReduction_463
happyReduction_463 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut201 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn185
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_464 = happySpecReduce_3  171# happyReduction_464
happyReduction_464 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn185
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_465 = happySpecReduce_1  171# happyReduction_465
happyReduction_465 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn185
		 (WildCard (nIS happy_var_1)
	)}

happyReduce_466 = happyMonadReduce 3# 171# happyReduction_466
happyReduction_466 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut191 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	( checkEnabled RegularPatterns >> return (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2))}}}
	) (\r -> happyReturn (happyIn185 r))

happyReduce_467 = happySpecReduce_3  171# happyReduction_467
happyReduction_467 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut190 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RPGuardClose) -> 
	happyIn185
		 (SeqRP (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (snd happy_var_2) ++ [happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_468 = happyReduce 5# 171# happyReduction_468
happyReduction_468 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut171 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Bar) -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RPGuardClose) -> 
	happyIn185
		 (GuardRP (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3 : snd happy_var_4 ++ [happy_var_5])) happy_var_2 $ (reverse $ fst happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_469 = happySpecReduce_1  171# happyReduction_469
happyReduction_469 happy_x_1
	 =  case happyOut192 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (happy_var_1
	)}

happyReduce_470 = happySpecReduce_1  171# happyReduction_470
happyReduction_470 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (let Loc l (THIdEscape s) = happy_var_1 in SpliceExp (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_471 = happySpecReduce_3  171# happyReduction_471
happyReduction_471 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn185
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in SpliceExp l $ ParenSplice l happy_var_2
	)}}}

happyReduce_472 = happySpecReduce_3  171# happyReduction_472
happyReduction_472 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THExpQuote) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn185
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in BracketExp l $ ExpBracket l happy_var_2
	)}}}

happyReduce_473 = happyMonadReduce 3# 171# happyReduction_473
happyReduction_473 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THPatQuote) -> 
	case happyOut172 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	( do { p <- checkPattern happy_var_2;
                                              let {l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) };
                                              return $ BracketExp l $ PatBracket l p })}}}
	) (\r -> happyReturn (happyIn185 r))

happyReduce_474 = happySpecReduce_3  171# happyReduction_474
happyReduction_474 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTypQuote) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn185
		 (let l = happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3] in BracketExp l $ TypeBracket l happy_var_2
	)}}}

happyReduce_475 = happyReduce 5# 171# happyReduction_475
happyReduction_475 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 THDecQuote) -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOut262 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 THCloseQuote) -> 
	happyIn185
		 (let l = happy_var_1 <^^> happy_var_5 <** (happy_var_1:snd happy_var_3 ++ [happy_var_5])
                                            in BracketExp l $ DeclBracket (happy_var_1 <^^> happy_var_5 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4,happy_var_5])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}}

happyReduce_476 = happySpecReduce_3  171# happyReduction_476
happyReduction_476 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn185
		 (let {l1 = happy_var_1 <^^> happy_var_3 <** [happy_var_1];
                                             l2 = happy_var_2 <^^> happy_var_3 <** [happy_var_2,happy_var_3];}
                                         in VarQuote l1 (unit_con_name l2)
	)}}}

happyReduce_477 = happySpecReduce_2  171# happyReduction_477
happyReduction_477 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut233 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_478 = happySpecReduce_2  171# happyReduction_478
happyReduction_478 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut236 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_479 = happySpecReduce_2  171# happyReduction_479
happyReduction_479 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) (UnQual (ann happy_var_2) happy_var_2)
	)}}

happyReduce_480 = happySpecReduce_2  171# happyReduction_480
happyReduction_480 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut116 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_481 = happySpecReduce_1  171# happyReduction_481
happyReduction_481 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn185
		 (let Loc l (THQuasiQuote (n,q)) = happy_var_1 in QuasiQuote (nIS l) n q
	)}

happyReduce_482 = happySpecReduce_2  172# happyReduction_482
happyReduction_482 happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	happyIn186
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_483 = happySpecReduce_1  172# happyReduction_483
happyReduction_483 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn186
		 ([happy_var_1]
	)}

happyReduce_484 = happySpecReduce_1  173# happyReduction_484
happyReduction_484 happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	happyIn187
		 (happy_var_1
	)}

happyReduce_485 = happySpecReduce_2  173# happyReduction_485
happyReduction_485 happy_x_2
	happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	case happyOut172 happy_x_2 of { happy_var_2 -> 
	happyIn187
		 (PreOp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_486 = happyMonadReduce 3# 173# happyReduction_486
happyReduction_486 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut217 happy_x_3 of { happy_var_3 -> 
	( do {checkEnabled ViewPatterns;
                                             return $ ViewPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3})}}}
	) (\r -> happyReturn (happyIn187 r))

happyReduce_487 = happySpecReduce_3  174# happyReduction_487
happyReduction_487 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOut188 happy_x_3 of { happy_var_3 -> 
	happyIn188
		 (let (mes, ss) = happy_var_3 in (replicate (length happy_var_1 - 1) Nothing ++ Just happy_var_2 : mes, ss ++ happy_var_1)
	)}}}

happyReduce_488 = happySpecReduce_3  174# happyReduction_488
happyReduction_488 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn188
		 ((replicate (length happy_var_1 - 1) Nothing ++ [Just happy_var_2], happy_var_3 : happy_var_1)
	)}}}

happyReduce_489 = happySpecReduce_2  174# happyReduction_489
happyReduction_489 happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn188
		 ((replicate (length happy_var_1) Nothing, happy_var_2 : happy_var_1)
	)}}

happyReduce_490 = happySpecReduce_3  175# happyReduction_490
happyReduction_490 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOut189 happy_x_3 of { happy_var_3 -> 
	happyIn189
		 (let (mes, ss) = happy_var_3 in (replicate (length happy_var_1 - 1) Nothing ++ Just happy_var_2 : mes, ss ++ happy_var_1)
	)}}}

happyReduce_491 = happySpecReduce_3  175# happyReduction_491
happyReduction_491 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn189
		 ((replicate (length happy_var_1 - 1) Nothing ++ [Just happy_var_2], happy_var_3 : happy_var_1)
	)}}}

happyReduce_492 = happySpecReduce_2  175# happyReduction_492
happyReduction_492 happy_x_2
	happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn189
		 ((replicate (length happy_var_1) Nothing, happy_var_2 : happy_var_1)
	)}}

happyReduce_493 = happySpecReduce_3  176# happyReduction_493
happyReduction_493 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut190 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn190
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_494 = happySpecReduce_1  176# happyReduction_494
happyReduction_494 happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	happyIn190
		 (([happy_var_1],[])
	)}

happyReduce_495 = happySpecReduce_3  177# happyReduction_495
happyReduction_495 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut191 happy_x_3 of { happy_var_3 -> 
	happyIn191
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_496 = happySpecReduce_3  177# happyReduction_496
happyReduction_496 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn191
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_497 = happyMonadReduce 10# 178# happyReduction_497
happyReduction_497 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOut198 happy_x_3 of { happy_var_3 -> 
	case happyOut200 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut193 happy_x_6 of { happy_var_6 -> 
	case happyOut177 happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 XCloseTagOpen) -> 
	case happyOut195 happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_9;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3;
                                                                             l  = happy_var_1 <^^> happy_var_10 <** [happy_var_1,happy_var_5] ++ happy_var_7 ++ [happy_var_8,srcInfoSpan (ann happy_var_9),happy_var_10] };
                                                                       return $ XTag l n as happy_var_4 cn })}}}}}}}}}}
	) (\r -> happyReturn (happyIn192 r))

happyReduce_498 = happyReduce 5# 178# happyReduction_498
happyReduction_498 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut195 happy_x_2 of { happy_var_2 -> 
	case happyOut198 happy_x_3 of { happy_var_3 -> 
	case happyOut200 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn192
		 (XETag   (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_499 = happySpecReduce_3  178# happyReduction_499
happyReduction_499 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XCodeTagOpen) -> 
	case happyOut171 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XCodeTagClose) -> 
	happyIn192
		 (XExpTag (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_500 = happyReduce 5# 178# happyReduction_500
happyReduction_500 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XChildTagOpen) -> 
	case happyOut193 happy_x_2 of { happy_var_2 -> 
	case happyOut177 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCloseTagOpen) -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XCodeTagClose) -> 
	happyIn192
		 (XChildTag (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3++[happy_var_4,happy_var_5])) (reverse happy_var_2)
	) `HappyStk` happyRest}}}}}

happyReduce_501 = happySpecReduce_2  179# happyReduction_501
happyReduction_501 happy_x_2
	happy_x_1
	 =  case happyOut193 happy_x_1 of { happy_var_1 -> 
	case happyOut194 happy_x_2 of { happy_var_2 -> 
	happyIn193
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_502 = happySpecReduce_0  179# happyReduction_502
happyReduction_502  =  happyIn193
		 ([]
	)

happyReduce_503 = happySpecReduce_1  180# happyReduction_503
happyReduction_503 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn194
		 (let Loc l (XPCDATA pcd) = happy_var_1 in XPcdata (nIS l) pcd
	)}

happyReduce_504 = happySpecReduce_3  180# happyReduction_504
happyReduction_504 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XRPatOpen) -> 
	case happyOut190 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XRPatClose) -> 
	happyIn194
		 (XRPats (happy_var_1 <^^> happy_var_3 <** (snd happy_var_2 ++ [happy_var_1,happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_505 = happySpecReduce_1  180# happyReduction_505
happyReduction_505 happy_x_1
	 =  case happyOut192 happy_x_1 of { happy_var_1 -> 
	happyIn194
		 (happy_var_1
	)}

happyReduce_506 = happySpecReduce_3  181# happyReduction_506
happyReduction_506 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Colon) -> 
	case happyOut196 happy_x_3 of { happy_var_3 -> 
	happyIn195
		 (let {Loc l1 s1 = happy_var_1; Loc l2 s2 = happy_var_3}
                                         in XDomName (nIS l1 <++> nIS l2 <** [l1,happy_var_2,l2]) s1 s2
	)}}}

happyReduce_507 = happySpecReduce_1  181# happyReduction_507
happyReduction_507 happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	happyIn195
		 (let Loc l str = happy_var_1 in XName (nIS l) str
	)}

happyReduce_508 = happySpecReduce_1  182# happyReduction_508
happyReduction_508 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (let Loc l (VarId  s) = happy_var_1 in Loc l s
	)}

happyReduce_509 = happySpecReduce_1  182# happyReduction_509
happyReduction_509 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (let Loc l (ConId  s) = happy_var_1 in Loc l s
	)}

happyReduce_510 = happySpecReduce_1  182# happyReduction_510
happyReduction_510 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (let Loc l (DVarId s) = happy_var_1 in Loc l $ mkDVar s
	)}

happyReduce_511 = happySpecReduce_1  182# happyReduction_511
happyReduction_511 happy_x_1
	 =  case happyOut197 happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (happy_var_1
	)}

happyReduce_512 = happySpecReduce_1  183# happyReduction_512
happyReduction_512 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	happyIn197
		 (Loc happy_var_1 "type"
	)}

happyReduce_513 = happySpecReduce_1  183# happyReduction_513
happyReduction_513 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	happyIn197
		 (Loc happy_var_1 "class"
	)}

happyReduce_514 = happySpecReduce_1  183# happyReduction_514
happyReduction_514 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn197
		 (Loc happy_var_1 "data"
	)}

happyReduce_515 = happySpecReduce_1  183# happyReduction_515
happyReduction_515 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	happyIn197
		 (Loc happy_var_1 "foreign"
	)}

happyReduce_516 = happySpecReduce_1  183# happyReduction_516
happyReduction_516 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Export) -> 
	happyIn197
		 (Loc happy_var_1 "export"
	)}

happyReduce_517 = happySpecReduce_1  183# happyReduction_517
happyReduction_517 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn197
		 (Loc happy_var_1 "safe"
	)}

happyReduce_518 = happySpecReduce_1  183# happyReduction_518
happyReduction_518 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn197
		 (Loc happy_var_1 "unsafe"
	)}

happyReduce_519 = happySpecReduce_1  183# happyReduction_519
happyReduction_519 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn197
		 (Loc happy_var_1 "interruptible"
	)}

happyReduce_520 = happySpecReduce_1  183# happyReduction_520
happyReduction_520 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn197
		 (Loc happy_var_1 "threadsafe"
	)}

happyReduce_521 = happySpecReduce_1  183# happyReduction_521
happyReduction_521 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn197
		 (Loc happy_var_1 "stdcall"
	)}

happyReduce_522 = happySpecReduce_1  183# happyReduction_522
happyReduction_522 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn197
		 (Loc happy_var_1 "ccall"
	)}

happyReduce_523 = happySpecReduce_1  183# happyReduction_523
happyReduction_523 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn197
		 (Loc happy_var_1 "cplusplus"
	)}

happyReduce_524 = happySpecReduce_1  183# happyReduction_524
happyReduction_524 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn197
		 (Loc happy_var_1 "dotnet"
	)}

happyReduce_525 = happySpecReduce_1  183# happyReduction_525
happyReduction_525 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn197
		 (Loc happy_var_1 "jvm"
	)}

happyReduce_526 = happySpecReduce_1  183# happyReduction_526
happyReduction_526 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn197
		 (Loc happy_var_1 "js"
	)}

happyReduce_527 = happySpecReduce_1  183# happyReduction_527
happyReduction_527 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn197
		 (Loc happy_var_1 "javascript"
	)}

happyReduce_528 = happySpecReduce_1  183# happyReduction_528
happyReduction_528 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn197
		 (Loc happy_var_1 "capi"
	)}

happyReduce_529 = happySpecReduce_1  183# happyReduction_529
happyReduction_529 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	happyIn197
		 (Loc happy_var_1 "as"
	)}

happyReduce_530 = happySpecReduce_1  183# happyReduction_530
happyReduction_530 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_By) -> 
	happyIn197
		 (Loc happy_var_1 "by"
	)}

happyReduce_531 = happySpecReduce_1  183# happyReduction_531
happyReduction_531 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Case) -> 
	happyIn197
		 (Loc happy_var_1 "case"
	)}

happyReduce_532 = happySpecReduce_1  183# happyReduction_532
happyReduction_532 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	happyIn197
		 (Loc happy_var_1 "default"
	)}

happyReduce_533 = happySpecReduce_1  183# happyReduction_533
happyReduction_533 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	happyIn197
		 (Loc happy_var_1 "deriving"
	)}

happyReduce_534 = happySpecReduce_1  183# happyReduction_534
happyReduction_534 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Do) -> 
	happyIn197
		 (Loc happy_var_1 "do"
	)}

happyReduce_535 = happySpecReduce_1  183# happyReduction_535
happyReduction_535 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Else) -> 
	happyIn197
		 (Loc happy_var_1 "else"
	)}

happyReduce_536 = happySpecReduce_1  183# happyReduction_536
happyReduction_536 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn197
		 (Loc happy_var_1 "family"
	)}

happyReduce_537 = happySpecReduce_1  183# happyReduction_537
happyReduction_537 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	happyIn197
		 (Loc happy_var_1 "forall"
	)}

happyReduce_538 = happySpecReduce_1  183# happyReduction_538
happyReduction_538 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Group) -> 
	happyIn197
		 (Loc happy_var_1 "group"
	)}

happyReduce_539 = happySpecReduce_1  183# happyReduction_539
happyReduction_539 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn197
		 (Loc happy_var_1 "hiding"
	)}

happyReduce_540 = happySpecReduce_1  183# happyReduction_540
happyReduction_540 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	happyIn197
		 (Loc happy_var_1 "if"
	)}

happyReduce_541 = happySpecReduce_1  183# happyReduction_541
happyReduction_541 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Import) -> 
	happyIn197
		 (Loc happy_var_1 "import"
	)}

happyReduce_542 = happySpecReduce_1  183# happyReduction_542
happyReduction_542 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_In) -> 
	happyIn197
		 (Loc happy_var_1 "in"
	)}

happyReduce_543 = happySpecReduce_1  183# happyReduction_543
happyReduction_543 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Infix) -> 
	happyIn197
		 (Loc happy_var_1 "infix"
	)}

happyReduce_544 = happySpecReduce_1  183# happyReduction_544
happyReduction_544 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixL) -> 
	happyIn197
		 (Loc happy_var_1 "infixl"
	)}

happyReduce_545 = happySpecReduce_1  183# happyReduction_545
happyReduction_545 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixR) -> 
	happyIn197
		 (Loc happy_var_1 "infixr"
	)}

happyReduce_546 = happySpecReduce_1  183# happyReduction_546
happyReduction_546 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Instance) -> 
	happyIn197
		 (Loc happy_var_1 "instance"
	)}

happyReduce_547 = happySpecReduce_1  183# happyReduction_547
happyReduction_547 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	happyIn197
		 (Loc happy_var_1 "let"
	)}

happyReduce_548 = happySpecReduce_1  183# happyReduction_548
happyReduction_548 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_MDo) -> 
	happyIn197
		 (Loc happy_var_1 "mdo"
	)}

happyReduce_549 = happySpecReduce_1  183# happyReduction_549
happyReduction_549 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	happyIn197
		 (Loc happy_var_1 "module"
	)}

happyReduce_550 = happySpecReduce_1  183# happyReduction_550
happyReduction_550 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_NewType) -> 
	happyIn197
		 (Loc happy_var_1 "newtype"
	)}

happyReduce_551 = happySpecReduce_1  183# happyReduction_551
happyReduction_551 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Of) -> 
	happyIn197
		 (Loc happy_var_1 "of"
	)}

happyReduce_552 = happySpecReduce_1  183# happyReduction_552
happyReduction_552 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Proc) -> 
	happyIn197
		 (Loc happy_var_1 "proc"
	)}

happyReduce_553 = happySpecReduce_1  183# happyReduction_553
happyReduction_553 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Rec) -> 
	happyIn197
		 (Loc happy_var_1 "rec"
	)}

happyReduce_554 = happySpecReduce_1  183# happyReduction_554
happyReduction_554 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	happyIn197
		 (Loc happy_var_1 "then"
	)}

happyReduce_555 = happySpecReduce_1  183# happyReduction_555
happyReduction_555 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Using) -> 
	happyIn197
		 (Loc happy_var_1 "using"
	)}

happyReduce_556 = happySpecReduce_1  183# happyReduction_556
happyReduction_556 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	happyIn197
		 (Loc happy_var_1 "where"
	)}

happyReduce_557 = happySpecReduce_1  183# happyReduction_557
happyReduction_557 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn197
		 (Loc happy_var_1 "qualified"
	)}

happyReduce_558 = happySpecReduce_2  184# happyReduction_558
happyReduction_558 happy_x_2
	happy_x_1
	 =  case happyOut198 happy_x_1 of { happy_var_1 -> 
	case happyOut199 happy_x_2 of { happy_var_2 -> 
	happyIn198
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_559 = happySpecReduce_0  184# happyReduction_559
happyReduction_559  =  happyIn198
		 ([]
	)

happyReduce_560 = happySpecReduce_3  185# happyReduction_560
happyReduction_560 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut195 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut183 happy_x_3 of { happy_var_3 -> 
	happyIn199
		 (XAttr (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_561 = happySpecReduce_1  186# happyReduction_561
happyReduction_561 happy_x_1
	 =  case happyOut183 happy_x_1 of { happy_var_1 -> 
	happyIn200
		 (Just happy_var_1
	)}

happyReduce_562 = happySpecReduce_0  186# happyReduction_562
happyReduction_562  =  happyIn200
		 (Nothing
	)

happyReduce_563 = happySpecReduce_1  187# happyReduction_563
happyReduction_563 happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	happyIn201
		 (\l -> List l [happy_var_1]
	)}

happyReduce_564 = happySpecReduce_1  187# happyReduction_564
happyReduction_564 happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	happyIn201
		 (\l -> let (ps,ss) = happy_var_1 in List (l <** reverse ss) (reverse ps)
	)}

happyReduce_565 = happySpecReduce_2  187# happyReduction_565
happyReduction_565 happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	happyIn201
		 (\l -> EnumFrom       (l <** [happy_var_2]) happy_var_1
	)}}

happyReduce_566 = happyReduce 4# 187# happyReduction_566
happyReduction_566 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	happyIn201
		 (\l -> EnumFromThen   (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_567 = happySpecReduce_3  187# happyReduction_567
happyReduction_567 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn201
		 (\l -> EnumFromTo     (l <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_568 = happyReduce 5# 187# happyReduction_568
happyReduction_568 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	case happyOut171 happy_x_5 of { happy_var_5 -> 
	happyIn201
		 (\l -> EnumFromThenTo (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_569 = happySpecReduce_3  187# happyReduction_569
happyReduction_569 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut203 happy_x_3 of { happy_var_3 -> 
	happyIn201
		 (\l -> let (stss, ss) = happy_var_3 in ParComp (l <** (happy_var_2:ss)) happy_var_1 (reverse stss)
	)}}}

happyReduce_570 = happySpecReduce_3  188# happyReduction_570
happyReduction_570 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	happyIn202
		 (let (es, ss) = happy_var_1 in (happy_var_3 : es, happy_var_2 : ss)
	)}}}

happyReduce_571 = happySpecReduce_3  188# happyReduction_571
happyReduction_571 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	happyIn202
		 (([happy_var_3,happy_var_1], [happy_var_2])
	)}}}

happyReduce_572 = happySpecReduce_3  189# happyReduction_572
happyReduction_572 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut204 happy_x_3 of { happy_var_3 -> 
	happyIn203
		 (let { (stss, ss1) = happy_var_1;
                                              (sts, ss2) = happy_var_3 }
                                         in (reverse sts : stss, ss1 ++ [happy_var_2] ++ reverse ss2)
	)}}}

happyReduce_573 = happySpecReduce_1  189# happyReduction_573
happyReduction_573 happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (let (sts, ss) = happy_var_1 in ([reverse sts], reverse ss)
	)}

happyReduce_574 = happySpecReduce_3  190# happyReduction_574
happyReduction_574 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut205 happy_x_3 of { happy_var_3 -> 
	happyIn204
		 (let (sts, ss) = happy_var_1 in (happy_var_3 : sts, happy_var_2 : ss)
	)}}}

happyReduce_575 = happySpecReduce_1  190# happyReduction_575
happyReduction_575 happy_x_1
	 =  case happyOut205 happy_x_1 of { happy_var_1 -> 
	happyIn204
		 (([happy_var_1],[])
	)}

happyReduce_576 = happySpecReduce_1  191# happyReduction_576
happyReduction_576 happy_x_1
	 =  case happyOut206 happy_x_1 of { happy_var_1 -> 
	happyIn205
		 (happy_var_1
	)}

happyReduce_577 = happySpecReduce_1  191# happyReduction_577
happyReduction_577 happy_x_1
	 =  case happyOut208 happy_x_1 of { happy_var_1 -> 
	happyIn205
		 (QualStmt (ann happy_var_1) happy_var_1
	)}

happyReduce_578 = happySpecReduce_2  192# happyReduction_578
happyReduction_578 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn206
		 (ThenTrans    (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_579 = happyReduce 4# 192# happyReduction_579
happyReduction_579 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	happyIn206
		 (ThenBy       (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_580 = happyReduce 4# 192# happyReduction_580
happyReduction_580 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	happyIn206
		 (GroupBy      (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2,happy_var_3]) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_581 = happyReduce 4# 192# happyReduction_581
happyReduction_581 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Using) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	happyIn206
		 (GroupUsing   (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2,happy_var_3]) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_582 = happyReduce 6# 192# happyReduction_582
happyReduction_582 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 KW_Using) -> 
	case happyOut170 happy_x_6 of { happy_var_6 -> 
	happyIn206
		 (GroupByUsing (nIS happy_var_1 <++> ann happy_var_6 <** [happy_var_1,happy_var_2,happy_var_3,happy_var_5]) happy_var_4 happy_var_6
	) `HappyStk` happyRest}}}}}}

happyReduce_583 = happySpecReduce_3  193# happyReduction_583
happyReduction_583 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut207 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut208 happy_x_3 of { happy_var_3 -> 
	happyIn207
		 (let (sts, ss) = happy_var_1 in (happy_var_3 : sts, happy_var_2 : ss)
	)}}}

happyReduce_584 = happySpecReduce_1  193# happyReduction_584
happyReduction_584 happy_x_1
	 =  case happyOut208 happy_x_1 of { happy_var_1 -> 
	happyIn207
		 (([happy_var_1],[])
	)}

happyReduce_585 = happySpecReduce_3  194# happyReduction_585
happyReduction_585 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut217 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrow) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	happyIn208
		 (Generator (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_586 = happySpecReduce_1  194# happyReduction_586
happyReduction_586 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn208
		 (Qualifier (ann happy_var_1) happy_var_1
	)}

happyReduce_587 = happySpecReduce_2  194# happyReduction_587
happyReduction_587 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn208
		 (LetStmt   (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_588 = happySpecReduce_0  195# happyReduction_588
happyReduction_588  =  happyIn209
		 (\l -> ParArray l []
	)

happyReduce_589 = happySpecReduce_1  195# happyReduction_589
happyReduction_589 happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	happyIn209
		 (\l -> ParArray l [happy_var_1]
	)}

happyReduce_590 = happySpecReduce_1  195# happyReduction_590
happyReduction_590 happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	happyIn209
		 (\l -> let (ps,ss) = happy_var_1 in ParArray (l <** reverse ss) (reverse ps)
	)}

happyReduce_591 = happySpecReduce_3  195# happyReduction_591
happyReduction_591 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn209
		 (\l -> ParArrayFromTo     (l <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_592 = happyReduce 5# 195# happyReduction_592
happyReduction_592 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	case happyOut171 happy_x_5 of { happy_var_5 -> 
	happyIn209
		 (\l -> ParArrayFromThenTo (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_593 = happySpecReduce_3  195# happyReduction_593
happyReduction_593 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut203 happy_x_3 of { happy_var_3 -> 
	happyIn209
		 (\l -> let (stss, ss) = happy_var_3 in ParArrayComp (l <** (happy_var_2:ss)) happy_var_1 (reverse stss)
	)}}}

happyReduce_594 = happySpecReduce_3  196# happyReduction_594
happyReduction_594 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut211 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn210
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_595 = happySpecReduce_3  196# happyReduction_595
happyReduction_595 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut211 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn210
		 (let l' =  ann . last $ fst happy_var_2
                                         in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_596 = happySpecReduce_3  197# happyReduction_596
happyReduction_596 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut212 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn211
		 ((reverse $ fst happy_var_2, happy_var_1 ++ snd happy_var_2 ++ happy_var_3)
	)}}}

happyReduce_597 = happySpecReduce_3  198# happyReduction_597
happyReduction_597 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut212 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut213 happy_x_3 of { happy_var_3 -> 
	happyIn212
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ happy_var_2)
	)}}}

happyReduce_598 = happySpecReduce_1  198# happyReduction_598
happyReduction_598 happy_x_1
	 =  case happyOut213 happy_x_1 of { happy_var_1 -> 
	happyIn212
		 (([happy_var_1],[])
	)}

happyReduce_599 = happySpecReduce_3  199# happyReduction_599
happyReduction_599 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut217 happy_x_1 of { happy_var_1 -> 
	case happyOut214 happy_x_2 of { happy_var_2 -> 
	case happyOut165 happy_x_3 of { happy_var_3 -> 
	happyIn213
		 (Alt (happy_var_1 <> happy_var_2 <+?> (fmap ann) (fst happy_var_3) <** snd happy_var_3) happy_var_1 happy_var_2 (fst happy_var_3)
	)}}}

happyReduce_600 = happySpecReduce_2  200# happyReduction_600
happyReduction_600 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RightArrow) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn214
		 (UnGuardedRhs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_601 = happySpecReduce_1  200# happyReduction_601
happyReduction_601 happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	happyIn214
		 (GuardedRhss  (snd happy_var_1) (reverse $ fst happy_var_1)
	)}

happyReduce_602 = happySpecReduce_2  201# happyReduction_602
happyReduction_602 happy_x_2
	happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	case happyOut216 happy_x_2 of { happy_var_2 -> 
	happyIn215
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <++> ann happy_var_2)
	)}}

happyReduce_603 = happySpecReduce_1  201# happyReduction_603
happyReduction_603 happy_x_1
	 =  case happyOut216 happy_x_1 of { happy_var_1 -> 
	happyIn215
		 (([happy_var_1], ann happy_var_1)
	)}

happyReduce_604 = happyMonadReduce 4# 202# happyReduction_604
happyReduction_604 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut207 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut170 happy_x_4 of { happy_var_4 -> 
	( do { checkPatternGuards (fst happy_var_2);
                                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** (happy_var_1:snd happy_var_2 ++ [happy_var_3])};
                                       return (GuardedRhs l (reverse (fst happy_var_2)) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn216 r))

happyReduce_605 = happyMonadReduce 1# 203# happyReduction_605
happyReduction_605 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut171 happy_x_1 of { happy_var_1 -> 
	( checkPattern happy_var_1)}
	) (\r -> happyReturn (happyIn217 r))

happyReduce_606 = happyMonadReduce 2# 203# happyReduction_606
happyReduction_606 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut183 happy_x_2 of { happy_var_2 -> 
	( checkPattern (BangPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2))}}
	) (\r -> happyReturn (happyIn217 r))

happyReduce_607 = happySpecReduce_3  204# happyReduction_607
happyReduction_607 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut219 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn218
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_608 = happySpecReduce_3  204# happyReduction_608
happyReduction_608 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut219 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn218
		 (let l' =  ann . last $ fst happy_var_2
                                           in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_609 = happySpecReduce_3  205# happyReduction_609
happyReduction_609 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut220 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn219
		 ((reverse $ fst happy_var_2, happy_var_1 ++ snd happy_var_2 ++ happy_var_3)
	)}}}

happyReduce_610 = happySpecReduce_3  206# happyReduction_610
happyReduction_610 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut216 happy_x_3 of { happy_var_3 -> 
	happyIn220
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ happy_var_2)
	)}}}

happyReduce_611 = happySpecReduce_1  206# happyReduction_611
happyReduction_611 happy_x_1
	 =  case happyOut216 happy_x_1 of { happy_var_1 -> 
	happyIn220
		 (([happy_var_1], [])
	)}

happyReduce_612 = happySpecReduce_3  207# happyReduction_612
happyReduction_612 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn221
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_613 = happySpecReduce_3  207# happyReduction_613
happyReduction_613 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	case happyOut262 happy_x_3 of { happy_var_3 -> 
	happyIn221
		 (let l' =  ann . last $ fst happy_var_2
                                         in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_614 = happySpecReduce_2  208# happyReduction_614
happyReduction_614 happy_x_2
	happy_x_1
	 =  case happyOut224 happy_x_1 of { happy_var_1 -> 
	case happyOut223 happy_x_2 of { happy_var_2 -> 
	happyIn222
		 ((happy_var_1 : fst happy_var_2, snd happy_var_2)
	)}}

happyReduce_615 = happySpecReduce_2  208# happyReduction_615
happyReduction_615 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	happyIn222
		 ((fst happy_var_2, happy_var_1 : snd happy_var_2)
	)}}

happyReduce_616 = happySpecReduce_0  208# happyReduction_616
happyReduction_616  =  happyIn222
		 (([],[])
	)

happyReduce_617 = happySpecReduce_2  209# happyReduction_617
happyReduction_617 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	happyIn223
		 ((fst happy_var_2, happy_var_1 : snd happy_var_2)
	)}}

happyReduce_618 = happySpecReduce_0  209# happyReduction_618
happyReduction_618  =  happyIn223
		 (([],[])
	)

happyReduce_619 = happySpecReduce_2  210# happyReduction_619
happyReduction_619 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn224
		 (LetStmt (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_620 = happySpecReduce_3  210# happyReduction_620
happyReduction_620 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut217 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrow) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	happyIn224
		 (Generator (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_621 = happySpecReduce_1  210# happyReduction_621
happyReduction_621 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn224
		 (Qualifier (ann happy_var_1) happy_var_1
	)}

happyReduce_622 = happySpecReduce_2  210# happyReduction_622
happyReduction_622 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Rec) -> 
	case happyOut221 happy_x_2 of { happy_var_2 -> 
	happyIn224
		 (let (stms,inf,ss) = happy_var_2 in RecStmt (nIS happy_var_1 <++> inf <** happy_var_1:ss) stms
	)}}

happyReduce_623 = happySpecReduce_3  211# happyReduction_623
happyReduction_623 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut226 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut225 happy_x_3 of { happy_var_3 -> 
	happyIn225
		 (let (fbs, ss) = happy_var_3 in (happy_var_1 : fbs, happy_var_2 : ss)
	)}}}

happyReduce_624 = happySpecReduce_1  211# happyReduction_624
happyReduction_624 happy_x_1
	 =  case happyOut226 happy_x_1 of { happy_var_1 -> 
	happyIn225
		 (([happy_var_1],[])
	)}

happyReduce_625 = happyMonadReduce 1# 211# happyReduction_625
happyReduction_625 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 DotDot) -> 
	( do { checkEnabled RecordWildCards `atSrcLoc` (getPointLoc happy_var_1);
                                              return ([FieldWildcard (nIS happy_var_1)], []) })}
	) (\r -> happyReturn (happyIn225 r))

happyReduce_626 = happySpecReduce_3  212# happyReduction_626
happyReduction_626 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut233 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	happyIn226
		 (FieldUpdate (happy_var_1 <>happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_627 = happyMonadReduce 1# 212# happyReduction_627
happyReduction_627 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	( checkEnabled NamedFieldPuns >> checkQualOrUnQual happy_var_1 >>= return . FieldPun (ann happy_var_1))}
	) (\r -> happyReturn (happyIn226 r))

happyReduce_628 = happySpecReduce_3  213# happyReduction_628
happyReduction_628 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut228 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn227
		 ((reverse (fst happy_var_2), reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_629 = happySpecReduce_3  214# happyReduction_629
happyReduction_629 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut229 happy_x_3 of { happy_var_3 -> 
	happyIn228
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_630 = happySpecReduce_1  214# happyReduction_630
happyReduction_630 happy_x_1
	 =  case happyOut229 happy_x_1 of { happy_var_1 -> 
	happyIn228
		 (([happy_var_1],[])
	)}

happyReduce_631 = happySpecReduce_3  215# happyReduction_631
happyReduction_631 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	happyIn229
		 (IPBind (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_632 = happySpecReduce_2  216# happyReduction_632
happyReduction_632 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn230
		 (p_unit_con              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_633 = happySpecReduce_2  216# happyReduction_633
happyReduction_633 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightSquare) -> 
	happyIn230
		 (List                    (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2]) []
	)}}

happyReduce_634 = happySpecReduce_3  216# happyReduction_634
happyReduction_634 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn230
		 (p_tuple_con             (happy_var_1 <^^> happy_var_3 <** happy_var_1:reverse (happy_var_3:happy_var_2)) Boxed (length happy_var_2)
	)}}}

happyReduce_635 = happySpecReduce_2  216# happyReduction_635
happyReduction_635 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn230
		 (p_unboxed_singleton_con (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_636 = happySpecReduce_3  216# happyReduction_636
happyReduction_636 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn230
		 (p_tuple_con             (happy_var_1 <^^> happy_var_3 <** happy_var_1:reverse (happy_var_3:happy_var_2)) Unboxed (length happy_var_2)
	)}}}

happyReduce_637 = happySpecReduce_1  216# happyReduction_637
happyReduction_637 happy_x_1
	 =  case happyOut236 happy_x_1 of { happy_var_1 -> 
	happyIn230
		 (Con (ann happy_var_1) happy_var_1
	)}

happyReduce_638 = happySpecReduce_1  217# happyReduction_638
happyReduction_638 happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	happyIn231
		 (happy_var_1
	)}

happyReduce_639 = happySpecReduce_3  217# happyReduction_639
happyReduction_639 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut257 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn231
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_640 = happySpecReduce_1  218# happyReduction_640
happyReduction_640 happy_x_1
	 =  case happyOut248 happy_x_1 of { happy_var_1 -> 
	happyIn232
		 (happy_var_1
	)}

happyReduce_641 = happySpecReduce_3  218# happyReduction_641
happyReduction_641 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut257 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn232
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_642 = happySpecReduce_1  219# happyReduction_642
happyReduction_642 happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	happyIn233
		 (happy_var_1
	)}

happyReduce_643 = happySpecReduce_3  219# happyReduction_643
happyReduction_643 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut255 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn233
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_644 = happySpecReduce_1  220# happyReduction_644
happyReduction_644 happy_x_1
	 =  case happyOut250 happy_x_1 of { happy_var_1 -> 
	happyIn234
		 (happy_var_1
	)}

happyReduce_645 = happySpecReduce_1  221# happyReduction_645
happyReduction_645 happy_x_1
	 =  case happyOut252 happy_x_1 of { happy_var_1 -> 
	happyIn235
		 (happy_var_1
	)}

happyReduce_646 = happySpecReduce_3  221# happyReduction_646
happyReduction_646 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut254 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn235
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_647 = happySpecReduce_1  222# happyReduction_647
happyReduction_647 happy_x_1
	 =  case happyOut251 happy_x_1 of { happy_var_1 -> 
	happyIn236
		 (happy_var_1
	)}

happyReduce_648 = happySpecReduce_3  222# happyReduction_648
happyReduction_648 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut245 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn236
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_649 = happySpecReduce_1  223# happyReduction_649
happyReduction_649 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn237
		 (happy_var_1
	)}

happyReduce_650 = happySpecReduce_3  223# happyReduction_650
happyReduction_650 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut249 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn237
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_651 = happySpecReduce_1  224# happyReduction_651
happyReduction_651 happy_x_1
	 =  case happyOut255 happy_x_1 of { happy_var_1 -> 
	happyIn238
		 (happy_var_1
	)}

happyReduce_652 = happySpecReduce_3  224# happyReduction_652
happyReduction_652 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn238
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_653 = happySpecReduce_1  225# happyReduction_653
happyReduction_653 happy_x_1
	 =  case happyOut256 happy_x_1 of { happy_var_1 -> 
	happyIn239
		 (happy_var_1
	)}

happyReduce_654 = happySpecReduce_3  225# happyReduction_654
happyReduction_654 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn239
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_655 = happySpecReduce_1  226# happyReduction_655
happyReduction_655 happy_x_1
	 =  case happyOut254 happy_x_1 of { happy_var_1 -> 
	happyIn240
		 (happy_var_1
	)}

happyReduce_656 = happySpecReduce_3  226# happyReduction_656
happyReduction_656 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut252 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn240
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_657 = happySpecReduce_1  227# happyReduction_657
happyReduction_657 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn241
		 (happy_var_1
	)}

happyReduce_658 = happySpecReduce_3  227# happyReduction_658
happyReduction_658 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut251 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn241
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_659 = happySpecReduce_1  228# happyReduction_659
happyReduction_659 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn242
		 (VarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_660 = happySpecReduce_1  228# happyReduction_660
happyReduction_660 happy_x_1
	 =  case happyOut240 happy_x_1 of { happy_var_1 -> 
	happyIn242
		 (ConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_661 = happySpecReduce_1  229# happyReduction_661
happyReduction_661 happy_x_1
	 =  case happyOut238 happy_x_1 of { happy_var_1 -> 
	happyIn243
		 (QVarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_662 = happySpecReduce_1  229# happyReduction_662
happyReduction_662 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn243
		 (QConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_663 = happySpecReduce_1  230# happyReduction_663
happyReduction_663 happy_x_1
	 =  case happyOut239 happy_x_1 of { happy_var_1 -> 
	happyIn244
		 (QVarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_664 = happySpecReduce_1  230# happyReduction_664
happyReduction_664 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn244
		 (QConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_665 = happySpecReduce_1  231# happyReduction_665
happyReduction_665 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Colon) -> 
	happyIn245
		 (list_cons_name (nIS happy_var_1)
	)}

happyReduce_666 = happySpecReduce_1  231# happyReduction_666
happyReduction_666 happy_x_1
	 =  case happyOut253 happy_x_1 of { happy_var_1 -> 
	happyIn245
		 (happy_var_1
	)}

happyReduce_667 = happySpecReduce_1  232# happyReduction_667
happyReduction_667 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (LabelVarId v) = happy_var_1 in OverloadedLabel
                                                                     (nIS l) v
	)}

happyReduce_668 = happySpecReduce_1  233# happyReduction_668
happyReduction_668 happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	happyIn247
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_669 = happySpecReduce_1  233# happyReduction_669
happyReduction_669 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn247
		 (let {Loc l (QVarId q) = happy_var_1; nis = nIS l}
                                 in Qual nis (ModuleName nis (fst q)) (Ident nis (snd q))
	)}

happyReduce_670 = happySpecReduce_1  234# happyReduction_670
happyReduction_670 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn248
		 (let Loc l (VarId v) = happy_var_1 in Ident (nIS l) v
	)}

happyReduce_671 = happySpecReduce_1  234# happyReduction_671
happyReduction_671 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	happyIn248
		 (as_name         (nIS happy_var_1)
	)}

happyReduce_672 = happySpecReduce_1  234# happyReduction_672
happyReduction_672 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn248
		 (qualified_name  (nIS happy_var_1)
	)}

happyReduce_673 = happySpecReduce_1  234# happyReduction_673
happyReduction_673 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn248
		 (hiding_name     (nIS happy_var_1)
	)}

happyReduce_674 = happySpecReduce_1  234# happyReduction_674
happyReduction_674 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Export) -> 
	happyIn248
		 (export_name     (nIS happy_var_1)
	)}

happyReduce_675 = happySpecReduce_1  234# happyReduction_675
happyReduction_675 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn248
		 (stdcall_name    (nIS happy_var_1)
	)}

happyReduce_676 = happySpecReduce_1  234# happyReduction_676
happyReduction_676 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn248
		 (ccall_name      (nIS happy_var_1)
	)}

happyReduce_677 = happySpecReduce_1  234# happyReduction_677
happyReduction_677 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn248
		 (cplusplus_name  (nIS happy_var_1)
	)}

happyReduce_678 = happySpecReduce_1  234# happyReduction_678
happyReduction_678 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn248
		 (dotnet_name     (nIS happy_var_1)
	)}

happyReduce_679 = happySpecReduce_1  234# happyReduction_679
happyReduction_679 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn248
		 (jvm_name        (nIS happy_var_1)
	)}

happyReduce_680 = happySpecReduce_1  234# happyReduction_680
happyReduction_680 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn248
		 (js_name         (nIS happy_var_1)
	)}

happyReduce_681 = happySpecReduce_1  234# happyReduction_681
happyReduction_681 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn248
		 (javascript_name (nIS happy_var_1)
	)}

happyReduce_682 = happySpecReduce_1  234# happyReduction_682
happyReduction_682 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn248
		 (capi_name       (nIS happy_var_1)
	)}

happyReduce_683 = happySpecReduce_1  235# happyReduction_683
happyReduction_683 happy_x_1
	 =  case happyOut248 happy_x_1 of { happy_var_1 -> 
	happyIn249
		 (happy_var_1
	)}

happyReduce_684 = happySpecReduce_1  235# happyReduction_684
happyReduction_684 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn249
		 (safe_name       (nIS happy_var_1)
	)}

happyReduce_685 = happySpecReduce_1  235# happyReduction_685
happyReduction_685 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn249
		 (unsafe_name     (nIS happy_var_1)
	)}

happyReduce_686 = happySpecReduce_1  235# happyReduction_686
happyReduction_686 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn249
		 (interruptible_name (nIS happy_var_1)
	)}

happyReduce_687 = happySpecReduce_1  235# happyReduction_687
happyReduction_687 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn249
		 (threadsafe_name (nIS happy_var_1)
	)}

happyReduce_688 = happySpecReduce_1  235# happyReduction_688
happyReduction_688 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	happyIn249
		 (forall_name	  (nIS happy_var_1)
	)}

happyReduce_689 = happySpecReduce_1  235# happyReduction_689
happyReduction_689 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn249
		 (family_name     (nIS happy_var_1)
	)}

happyReduce_690 = happySpecReduce_1  235# happyReduction_690
happyReduction_690 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Role) -> 
	happyIn249
		 (role_name  (nIS happy_var_1)
	)}

happyReduce_691 = happySpecReduce_1  236# happyReduction_691
happyReduction_691 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn250
		 (let Loc l (IDupVarId i) = happy_var_1 in IPDup (nIS l) i
	)}

happyReduce_692 = happySpecReduce_1  236# happyReduction_692
happyReduction_692 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn250
		 (let Loc l (ILinVarId i) = happy_var_1 in IPLin (nIS l) i
	)}

happyReduce_693 = happySpecReduce_1  237# happyReduction_693
happyReduction_693 happy_x_1
	 =  case happyOut252 happy_x_1 of { happy_var_1 -> 
	happyIn251
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_694 = happySpecReduce_1  237# happyReduction_694
happyReduction_694 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn251
		 (let {Loc l (QConId q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Ident nis (snd q))
	)}

happyReduce_695 = happySpecReduce_1  238# happyReduction_695
happyReduction_695 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn252
		 (let Loc l (ConId c) = happy_var_1 in Ident (nIS l) c
	)}

happyReduce_696 = happySpecReduce_1  239# happyReduction_696
happyReduction_696 happy_x_1
	 =  case happyOut254 happy_x_1 of { happy_var_1 -> 
	happyIn253
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_697 = happySpecReduce_1  239# happyReduction_697
happyReduction_697 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn253
		 (let {Loc l (QConSym q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Symbol nis (snd q))
	)}

happyReduce_698 = happySpecReduce_1  240# happyReduction_698
happyReduction_698 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn254
		 (let Loc l (ConSym c) = happy_var_1 in Symbol (nIS l) c
	)}

happyReduce_699 = happySpecReduce_1  241# happyReduction_699
happyReduction_699 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_700 = happySpecReduce_1  241# happyReduction_700
happyReduction_700 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn255
		 (happy_var_1
	)}

happyReduce_701 = happySpecReduce_1  242# happyReduction_701
happyReduction_701 happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	happyIn256
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_702 = happySpecReduce_1  242# happyReduction_702
happyReduction_702 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn256
		 (happy_var_1
	)}

happyReduce_703 = happySpecReduce_1  243# happyReduction_703
happyReduction_703 happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	happyIn257
		 (happy_var_1
	)}

happyReduce_704 = happySpecReduce_1  243# happyReduction_704
happyReduction_704 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	happyIn257
		 (minus_name (nIS happy_var_1)
	)}

happyReduce_705 = happySpecReduce_1  244# happyReduction_705
happyReduction_705 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn258
		 (let Loc l (VarSym v) = happy_var_1 in Symbol (nIS l) v
	)}

happyReduce_706 = happySpecReduce_1  244# happyReduction_706
happyReduction_706 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	happyIn258
		 (bang_name (nIS happy_var_1)
	)}

happyReduce_707 = happySpecReduce_1  244# happyReduction_707
happyReduction_707 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Dot) -> 
	happyIn258
		 (dot_name  (nIS happy_var_1)
	)}

happyReduce_708 = happySpecReduce_1  244# happyReduction_708
happyReduction_708 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Star) -> 
	happyIn258
		 (star_name (nIS happy_var_1)
	)}

happyReduce_709 = happySpecReduce_1  245# happyReduction_709
happyReduction_709 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (let {Loc l (QVarSym q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Symbol nis (snd q))
	)}

happyReduce_710 = happySpecReduce_1  246# happyReduction_710
happyReduction_710 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (IntTok        (i,raw)) = happy_var_1 in Int        (nIS l) i raw
	)}

happyReduce_711 = happySpecReduce_1  246# happyReduction_711
happyReduction_711 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (Character     (c,raw)) = happy_var_1 in Char       (nIS l) c raw
	)}

happyReduce_712 = happySpecReduce_1  246# happyReduction_712
happyReduction_712 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (FloatTok      (r,raw)) = happy_var_1 in Frac       (nIS l) r raw
	)}

happyReduce_713 = happySpecReduce_1  246# happyReduction_713
happyReduction_713 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (StringTok     (s,raw)) = happy_var_1 in String     (nIS l) s raw
	)}

happyReduce_714 = happySpecReduce_1  246# happyReduction_714
happyReduction_714 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (IntTokHash    (i,raw)) = happy_var_1 in PrimInt    (nIS l) i raw
	)}

happyReduce_715 = happySpecReduce_1  246# happyReduction_715
happyReduction_715 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (WordTokHash   (w,raw)) = happy_var_1 in PrimWord   (nIS l) w raw
	)}

happyReduce_716 = happySpecReduce_1  246# happyReduction_716
happyReduction_716 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (FloatTokHash  (f,raw)) = happy_var_1 in PrimFloat  (nIS l) f raw
	)}

happyReduce_717 = happySpecReduce_1  246# happyReduction_717
happyReduction_717 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (DoubleTokHash (d,raw)) = happy_var_1 in PrimDouble (nIS l) d raw
	)}

happyReduce_718 = happySpecReduce_1  246# happyReduction_718
happyReduction_718 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (CharacterHash (c,raw)) = happy_var_1 in PrimChar   (nIS l) c raw
	)}

happyReduce_719 = happySpecReduce_1  246# happyReduction_719
happyReduction_719 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (let Loc l (StringHash    (s,raw)) = happy_var_1 in PrimString (nIS l) s raw
	)}

happyReduce_720 = happyMonadReduce 0# 247# happyReduction_720
happyReduction_720 (happyRest) tk
	 = happyThen (( pushCurrentContext >> getSrcLoc >>= \s -> return $ mkSrcSpan s s {- >>= \x -> trace (show x) (return x) -})
	) (\r -> happyReturn (happyIn261 r))

happyReduce_721 = happySpecReduce_1  248# happyReduction_721
happyReduction_721 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 VRightCurly) -> 
	happyIn262
		 (happy_var_1 {- >>= \x -> trace (show x ++ show x ++ show x) (return x) -}
	)}

happyReduce_722 = happyMonadReduce 1# 248# happyReduction_722
happyReduction_722 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (( popContext >> getSrcLoc >>= \s -> return $ mkSrcSpan s s {- >>= \x -> trace (show x ++ show x) (return x) -})
	) (\r -> happyReturn (happyIn262 r))

happyReduce_723 = happyMonadReduce 1# 249# happyReduction_723
happyReduction_723 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut264 happy_x_1 of { happy_var_1 -> 
	( checkEnabled PatternSynonyms >> return happy_var_1)}
	) (\r -> happyReturn (happyIn263 r))

happyReduce_724 = happyReduce 4# 250# happyReduction_724
happyReduction_724 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut265 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut217 happy_x_4 of { happy_var_4 -> 
	happyIn264
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]
             in PatSyn l happy_var_2 happy_var_4 ImplicitBidirectional
	) `HappyStk` happyRest}}}}

happyReduce_725 = happyReduce 4# 250# happyReduction_725
happyReduction_725 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut265 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftArrow) -> 
	case happyOut217 happy_x_4 of { happy_var_4 -> 
	happyIn264
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]
               in PatSyn l happy_var_2 happy_var_4 Unidirectional
	) `HappyStk` happyRest}}}}

happyReduce_726 = happyReduce 5# 250# happyReduction_726
happyReduction_726 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut265 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftArrow) -> 
	case happyOut217 happy_x_4 of { happy_var_4 -> 
	case happyOut268 happy_x_5 of { happy_var_5 -> 
	happyIn264
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1, happy_var_3]
             in PatSyn l happy_var_2 happy_var_4 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_727 = happySpecReduce_2  251# happyReduction_727
happyReduction_727 happy_x_2
	happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	case happyOut266 happy_x_2 of { happy_var_2 -> 
	happyIn265
		 (let l = case happy_var_2 of
                                 [] -> ann happy_var_1
                                 (_:_) -> ann happy_var_1 <++> (ann $ last happy_var_2)
                        in PApp l (UnQual (ann happy_var_1) happy_var_1) happy_var_2
	)}}

happyReduce_728 = happySpecReduce_3  251# happyReduction_728
happyReduction_728 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	case happyOut253 happy_x_2 of { happy_var_2 -> 
	case happyOut249 happy_x_3 of { happy_var_3 -> 
	happyIn265
		 (PInfixApp (ann happy_var_1 <++> ann happy_var_3) (PVar (ann happy_var_1) happy_var_1) happy_var_2 (PVar (ann happy_var_3) happy_var_3)
	)}}}

happyReduce_729 = happyReduce 4# 251# happyReduction_729
happyReduction_729 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut235 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut267 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	happyIn265
		 (let { (ss, ns) = happy_var_3 ;
                                       qnames = (map (\n -> UnQual (ann n) n) ns) }
                                 in PRec (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2 : ss ++ [happy_var_4]))
                                         (UnQual (ann happy_var_1) happy_var_1) (map (\q -> PFieldPun (ann q) q) qnames)
	) `HappyStk` happyRest}}}}

happyReduce_730 = happySpecReduce_0  252# happyReduction_730
happyReduction_730  =  happyIn266
		 ([]
	)

happyReduce_731 = happySpecReduce_2  252# happyReduction_731
happyReduction_731 happy_x_2
	happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	case happyOut266 happy_x_2 of { happy_var_2 -> 
	happyIn266
		 (PVar (ann happy_var_1) happy_var_1 : happy_var_2
	)}}

happyReduce_732 = happySpecReduce_1  253# happyReduction_732
happyReduction_732 happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	happyIn267
		 (([], [happy_var_1] )
	)}

happyReduce_733 = happySpecReduce_3  253# happyReduction_733
happyReduction_733 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut267 happy_x_3 of { happy_var_3 -> 
	happyIn267
		 (let (ss, ns) = happy_var_3 in (happy_var_2 : ss, happy_var_1 : ns)
	)}}}

happyReduce_734 = happyMonadReduce 4# 254# happyReduction_734
happyReduction_734 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	(  checkExplicitPatSyn happy_var_1 happy_var_2 happy_var_3 happy_var_4)}}}}
	) (\r -> happyReturn (happyIn268 r))

happyReduce_735 = happyMonadReduce 4# 254# happyReduction_735
happyReduction_735 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut262 happy_x_4 of { happy_var_4 -> 
	(  checkExplicitPatSyn happy_var_1 happy_var_2 happy_var_3 happy_var_4)}}}}
	) (\r -> happyReturn (happyIn268 r))

happyReduce_736 = happyMonadReduce 4# 255# happyReduction_736
happyReduction_736 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut235 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut270 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled PatternSynonyms ;
                    let {(qtvs, ps, prov, req, ty) = happy_var_4} ;
                    let {sig = PatSynSig (nIS happy_var_1 <++> ann ty <** [happy_var_1, happy_var_3] ++ ps)  happy_var_2 qtvs prov req ty} ;
                    return sig })}}}}
	) (\r -> happyReturn (happyIn269 r))

happyReduce_737 = happyReduce 4# 256# happyReduction_737
happyReduction_737 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	case happyOut270 happy_x_4 of { happy_var_4 -> 
	happyIn270
		 (let (qtvs, ps, prov, req, ty) = happy_var_4
               in (Just (reverse (fst happy_var_2) ++ fromMaybe [] qtvs), (happy_var_1 : happy_var_3 : ps), prov, req, ty)
	) `HappyStk` happyRest}}}}

happyReduce_738 = happyMonadReduce 3# 256# happyReduction_738
happyReduction_738 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut121 happy_x_1 of { happy_var_1 -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	( do { c1 <- checkContext (Just happy_var_1) ;
                    c2 <- checkContext (Just happy_var_2) ;
                    t  <- checkType happy_var_3 ;
                    return $ (Nothing, [], c1, c2, t) })}}}
	) (\r -> happyReturn (happyIn270 r))

happyReduce_739 = happyMonadReduce 2# 256# happyReduction_739
happyReduction_739 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut121 happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	( do { c1 <- checkContext (Just happy_var_1);
                     t <- checkType happy_var_2;
                     return (Nothing, [], c1, Nothing, t) })}}
	) (\r -> happyReturn (happyIn270 r))

happyReduce_740 = happyMonadReduce 1# 256# happyReduction_740
happyReduction_740 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut107 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1 >>= \t -> return (Nothing, [], Nothing, Nothing, t))}
	) (\r -> happyReturn (happyIn270 r))

happyReduce_741 = happySpecReduce_1  257# happyReduction_741
happyReduction_741 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (let Loc l (ConId  n) = happy_var_1 in ModuleName (nIS l) n
	)}

happyReduce_742 = happySpecReduce_1  257# happyReduction_742
happyReduction_742 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn271
		 (let Loc l (QConId n) = happy_var_1 in ModuleName (nIS l) (fst n ++ '.':snd n)
	)}

happyReduce_743 = happySpecReduce_1  258# happyReduction_743
happyReduction_743 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn272
		 (happy_var_1
	)}

happyReduce_744 = happySpecReduce_1  259# happyReduction_744
happyReduction_744 happy_x_1
	 =  case happyOut236 happy_x_1 of { happy_var_1 -> 
	happyIn273
		 (happy_var_1
	)}

happyReduce_745 = happySpecReduce_1  260# happyReduction_745
happyReduction_745 happy_x_1
	 =  case happyOut275 happy_x_1 of { happy_var_1 -> 
	happyIn274
		 (happy_var_1
	)}

happyReduce_746 = happySpecReduce_1  261# happyReduction_746
happyReduction_746 happy_x_1
	 =  case happyOut248 happy_x_1 of { happy_var_1 -> 
	happyIn275
		 (happy_var_1
	)}

happyReduce_747 = happySpecReduce_1  261# happyReduction_747
happyReduction_747 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn275
		 (safe_name       (nIS happy_var_1)
	)}

happyReduce_748 = happySpecReduce_1  261# happyReduction_748
happyReduction_748 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn275
		 (unsafe_name     (nIS happy_var_1)
	)}

happyReduce_749 = happySpecReduce_1  261# happyReduction_749
happyReduction_749 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn275
		 (threadsafe_name (nIS happy_var_1)
	)}

happyReduce_750 = happySpecReduce_3  262# happyReduction_750
happyReduction_750 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut274 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn276
		 (UnQual (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_751 = happySpecReduce_1  262# happyReduction_751
happyReduction_751 happy_x_1
	 =  case happyOut277 happy_x_1 of { happy_var_1 -> 
	happyIn276
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_752 = happySpecReduce_1  263# happyReduction_752
happyReduction_752 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn277
		 (let Loc l (VarSym x) = happy_var_1 in Symbol (nIS l) x
	)}

happyReduce_753 = happySpecReduce_1  263# happyReduction_753
happyReduction_753 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	happyIn277
		 (Symbol (nIS happy_var_1) "-"
	)}

happyReduce_754 = happyReduce 5# 264# happyReduction_754
happyReduction_754 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut28 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightCurly) -> 
	happyIn278
		 (let (ids, ss) = happy_var_3 in (ids, happy_var_1 : reverse happy_var_2 ++ ss ++ reverse happy_var_4 ++ [happy_var_5], happy_var_1 <^^> happy_var_5)
	) `HappyStk` happyRest}}}}}

happyReduce_755 = happyReduce 5# 264# happyReduction_755
happyReduction_755 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut261 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut28 happy_x_4 of { happy_var_4 -> 
	case happyOut262 happy_x_5 of { happy_var_5 -> 
	happyIn278
		 (let (ids, ss) = happy_var_3 in (ids, happy_var_1 : reverse happy_var_2 ++ ss ++ reverse happy_var_4 ++ [happy_var_5], happy_var_1 <^^> happy_var_5)
	) `HappyStk` happyRest}}}}}

happyReduce_756 = happySpecReduce_3  265# happyReduction_756
happyReduction_756 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut271 happy_x_3 of { happy_var_3 -> 
	happyIn279
		 ((happy_var_1, Just happy_var_3)
	)}}

happyReduce_757 = happySpecReduce_1  265# happyReduction_757
happyReduction_757 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn279
		 ((happy_var_1, Nothing)
	)}

happyReduce_758 = happySpecReduce_2  266# happyReduction_758
happyReduction_758 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn280
		 ((happy_var_1, happy_var_2)
	)}}

happyReduce_759 = happySpecReduce_3  267# happyReduction_759
happyReduction_759 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut278 happy_x_3 of { happy_var_3 -> 
	happyIn281
		 ((happy_var_1, happy_var_2, Just happy_var_3)
	)}}}

happyReduce_760 = happySpecReduce_2  267# happyReduction_760
happyReduction_760 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn281
		 ((happy_var_1, happy_var_2, Nothing)
	)}}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Loc _ EOF -> happyDoAction 150# tk action sts stk;
	Loc _ (VarId _) -> cont 1#;
	Loc _ (LabelVarId _) -> cont 2#;
	Loc _ (QVarId _) -> cont 3#;
	Loc _ (IDupVarId _) -> cont 4#;
	Loc _ (ILinVarId _) -> cont 5#;
	Loc _ (ConId _) -> cont 6#;
	Loc _ (QConId _) -> cont 7#;
	Loc _ (DVarId _) -> cont 8#;
	Loc _ (VarSym _) -> cont 9#;
	Loc _ (ConSym _) -> cont 10#;
	Loc _ (QVarSym _) -> cont 11#;
	Loc _ (QConSym _) -> cont 12#;
	Loc _ (IntTok _) -> cont 13#;
	Loc _ (FloatTok _) -> cont 14#;
	Loc _ (Character _) -> cont 15#;
	Loc _ (StringTok _) -> cont 16#;
	Loc _ (IntTokHash _) -> cont 17#;
	Loc _ (WordTokHash _) -> cont 18#;
	Loc _ (FloatTokHash _) -> cont 19#;
	Loc _ (DoubleTokHash _) -> cont 20#;
	Loc _ (CharacterHash _) -> cont 21#;
	Loc _ (StringHash _) -> cont 22#;
	Loc happy_dollar_dollar LeftParen -> cont 23#;
	Loc happy_dollar_dollar RightParen -> cont 24#;
	Loc happy_dollar_dollar LeftHashParen -> cont 25#;
	Loc happy_dollar_dollar RightHashParen -> cont 26#;
	Loc happy_dollar_dollar SemiColon -> cont 27#;
	Loc happy_dollar_dollar LeftCurly -> cont 28#;
	Loc happy_dollar_dollar RightCurly -> cont 29#;
	Loc happy_dollar_dollar VRightCurly -> cont 30#;
	Loc happy_dollar_dollar LeftSquare -> cont 31#;
	Loc happy_dollar_dollar RightSquare -> cont 32#;
	Loc happy_dollar_dollar ParArrayLeftSquare -> cont 33#;
	Loc happy_dollar_dollar ParArrayRightSquare -> cont 34#;
	Loc happy_dollar_dollar Comma -> cont 35#;
	Loc happy_dollar_dollar Underscore -> cont 36#;
	Loc happy_dollar_dollar BackQuote -> cont 37#;
	Loc happy_dollar_dollar Dot -> cont 38#;
	Loc happy_dollar_dollar DotDot -> cont 39#;
	Loc happy_dollar_dollar Colon -> cont 40#;
	Loc happy_dollar_dollar DoubleColon -> cont 41#;
	Loc happy_dollar_dollar Equals -> cont 42#;
	Loc happy_dollar_dollar Backslash -> cont 43#;
	Loc happy_dollar_dollar Bar -> cont 44#;
	Loc happy_dollar_dollar LeftArrow -> cont 45#;
	Loc happy_dollar_dollar RightArrow -> cont 46#;
	Loc happy_dollar_dollar At -> cont 47#;
	Loc happy_dollar_dollar TApp -> cont 48#;
	Loc happy_dollar_dollar Tilde -> cont 49#;
	Loc happy_dollar_dollar DoubleArrow -> cont 50#;
	Loc happy_dollar_dollar Minus -> cont 51#;
	Loc happy_dollar_dollar Exclamation -> cont 52#;
	Loc happy_dollar_dollar Star -> cont 53#;
	Loc happy_dollar_dollar LeftArrowTail -> cont 54#;
	Loc happy_dollar_dollar RightArrowTail -> cont 55#;
	Loc happy_dollar_dollar LeftDblArrowTail -> cont 56#;
	Loc happy_dollar_dollar RightDblArrowTail -> cont 57#;
	Loc happy_dollar_dollar RPGuardOpen -> cont 58#;
	Loc happy_dollar_dollar RPGuardClose -> cont 59#;
	Loc happy_dollar_dollar RPCAt -> cont 60#;
	Loc _ (THIdEscape _) -> cont 61#;
	Loc happy_dollar_dollar THParenEscape -> cont 62#;
	Loc happy_dollar_dollar THExpQuote -> cont 63#;
	Loc happy_dollar_dollar THPatQuote -> cont 64#;
	Loc happy_dollar_dollar THTypQuote -> cont 65#;
	Loc happy_dollar_dollar THDecQuote -> cont 66#;
	Loc happy_dollar_dollar THCloseQuote -> cont 67#;
	Loc happy_dollar_dollar THVarQuote -> cont 68#;
	Loc happy_dollar_dollar THTyQuote -> cont 69#;
	Loc _ (THQuasiQuote _) -> cont 70#;
	Loc _ (XPCDATA _) -> cont 71#;
	Loc happy_dollar_dollar XStdTagOpen -> cont 72#;
	Loc happy_dollar_dollar XCloseTagOpen -> cont 73#;
	Loc happy_dollar_dollar XCodeTagOpen -> cont 74#;
	Loc happy_dollar_dollar XChildTagOpen -> cont 75#;
	Loc happy_dollar_dollar XStdTagClose -> cont 76#;
	Loc happy_dollar_dollar XEmptyTagClose -> cont 77#;
	Loc happy_dollar_dollar XCodeTagClose -> cont 78#;
	Loc happy_dollar_dollar XRPatOpen -> cont 79#;
	Loc happy_dollar_dollar XRPatClose -> cont 80#;
	Loc happy_dollar_dollar KW_Foreign -> cont 81#;
	Loc happy_dollar_dollar KW_Export -> cont 82#;
	Loc happy_dollar_dollar KW_Safe -> cont 83#;
	Loc happy_dollar_dollar KW_Unsafe -> cont 84#;
	Loc happy_dollar_dollar KW_Threadsafe -> cont 85#;
	Loc happy_dollar_dollar KW_Interruptible -> cont 86#;
	Loc happy_dollar_dollar KW_StdCall -> cont 87#;
	Loc happy_dollar_dollar KW_CCall -> cont 88#;
	Loc happy_dollar_dollar KW_CPlusPlus -> cont 89#;
	Loc happy_dollar_dollar KW_DotNet -> cont 90#;
	Loc happy_dollar_dollar KW_Jvm -> cont 91#;
	Loc happy_dollar_dollar KW_Js -> cont 92#;
	Loc happy_dollar_dollar KW_JavaScript -> cont 93#;
	Loc happy_dollar_dollar KW_CApi -> cont 94#;
	Loc happy_dollar_dollar KW_As -> cont 95#;
	Loc happy_dollar_dollar KW_By -> cont 96#;
	Loc happy_dollar_dollar KW_Case -> cont 97#;
	Loc happy_dollar_dollar KW_Class -> cont 98#;
	Loc happy_dollar_dollar KW_Data -> cont 99#;
	Loc happy_dollar_dollar KW_Default -> cont 100#;
	Loc happy_dollar_dollar KW_Deriving -> cont 101#;
	Loc happy_dollar_dollar KW_Do -> cont 102#;
	Loc happy_dollar_dollar KW_Else -> cont 103#;
	Loc happy_dollar_dollar KW_Family -> cont 104#;
	Loc happy_dollar_dollar KW_Forall -> cont 105#;
	Loc happy_dollar_dollar KW_Group -> cont 106#;
	Loc happy_dollar_dollar KW_Hiding -> cont 107#;
	Loc happy_dollar_dollar KW_If -> cont 108#;
	Loc happy_dollar_dollar KW_Import -> cont 109#;
	Loc happy_dollar_dollar KW_In -> cont 110#;
	Loc happy_dollar_dollar KW_Infix -> cont 111#;
	Loc happy_dollar_dollar KW_InfixL -> cont 112#;
	Loc happy_dollar_dollar KW_InfixR -> cont 113#;
	Loc happy_dollar_dollar KW_Instance -> cont 114#;
	Loc happy_dollar_dollar KW_Let -> cont 115#;
	Loc happy_dollar_dollar KW_MDo -> cont 116#;
	Loc happy_dollar_dollar KW_Module -> cont 117#;
	Loc happy_dollar_dollar KW_NewType -> cont 118#;
	Loc happy_dollar_dollar KW_Of -> cont 119#;
	Loc happy_dollar_dollar KW_Proc -> cont 120#;
	Loc happy_dollar_dollar KW_Rec -> cont 121#;
	Loc happy_dollar_dollar KW_Then -> cont 122#;
	Loc happy_dollar_dollar KW_Type -> cont 123#;
	Loc happy_dollar_dollar KW_Using -> cont 124#;
	Loc happy_dollar_dollar KW_Where -> cont 125#;
	Loc happy_dollar_dollar KW_Qualified -> cont 126#;
	Loc happy_dollar_dollar KW_Role -> cont 127#;
	Loc happy_dollar_dollar KW_Pattern -> cont 128#;
	Loc _ (INLINE _) -> cont 129#;
	Loc happy_dollar_dollar INLINE_CONLIKE -> cont 130#;
	Loc happy_dollar_dollar SPECIALISE -> cont 131#;
	Loc _ (SPECIALISE_INLINE _) -> cont 132#;
	Loc happy_dollar_dollar SOURCE -> cont 133#;
	Loc happy_dollar_dollar RULES -> cont 134#;
	Loc happy_dollar_dollar CORE -> cont 135#;
	Loc happy_dollar_dollar SCC -> cont 136#;
	Loc happy_dollar_dollar GENERATED -> cont 137#;
	Loc happy_dollar_dollar DEPRECATED -> cont 138#;
	Loc happy_dollar_dollar WARNING -> cont 139#;
	Loc happy_dollar_dollar UNPACK -> cont 140#;
	Loc happy_dollar_dollar NOUNPACK -> cont 141#;
	Loc _ (OPTIONS _) -> cont 142#;
	Loc happy_dollar_dollar LANGUAGE -> cont 143#;
	Loc happy_dollar_dollar ANN -> cont 144#;
	Loc happy_dollar_dollar MINIMAL -> cont 145#;
	Loc happy_dollar_dollar NO_OVERLAP -> cont 146#;
	Loc happy_dollar_dollar OVERLAP -> cont 147#;
	Loc happy_dollar_dollar INCOHERENT -> cont 148#;
	Loc happy_dollar_dollar PragmaEnd -> cont 149#;
	_ -> happyError' tk
	})

happyError_ 150# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => P a -> (a -> P b) -> P b
happyThen = (>>=)
happyReturn :: () => a -> P a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> P a
happyReturn1 = happyReturn
happyError' :: () => (Loc Token) -> P a
happyError' tk = parseError tk

mparseModule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut16 x))

mparseExp = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut170 x))

mparsePat = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut217 x))

mparseDeclAux = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut25 x))

mparseType = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut119 x))

mparseStmt = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut224 x))

mparseImportDecl = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut38 x))

ngparseModulePragmas = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut18 x))

ngparseModuleHeadAndImports = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut281 x))

ngparsePragmasAndModuleHead = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut280 x))

ngparsePragmasAndModuleName = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut279 x))

happySeq = happyDontSeq


type L = SrcSpanInfo -- just for convenience
type S = SrcSpan

parseError :: Loc Token -> P a
parseError t = fail $ "Parse error: " ++ showToken (unLoc t)

(<>) :: (Annotated a, Annotated b) => a SrcSpanInfo -> b SrcSpanInfo -> SrcSpanInfo
a <> b = ann a <++> ann b
infixl 6 <>

nIS = noInfoSpan
iS = infoSpan

mparseDecl :: P (Decl SrcSpanInfo)
mparseDecl = do
    (is, ds, _, _) <- mparseDeclAux
    when (not $ null is) $
       fail $ "Expected single declaration, found import declaration"
    checkSingleDecl ds
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 19 "<built-in>" #-}
{-# LINE 1 "/Users/matt/Downloads/ghc-7.10.1.app/Contents/lib/ghc-7.10.1/include/ghcversion.h" #-}


















{-# LINE 20 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 


{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList






{-# LINE 67 "templates/GenericTemplate.hs" #-}


{-# LINE 77 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

