#!/usr/bin/env python

# Todo list to prepare a release:
#  - run: ./pyflakes.sh
#  - run: ./test_doc.py
#  - run: sudo bash -c "PYTHONPATH=$PWD ./fuzzers/fusil-gettext"
#  - edit fusil/version.py: check/set version
#  - edit ChangeLog: set release date
#  - hg ci
#  - hg tag fusil-x.y
#  - hg push
#  - ./setup.py sdist register upload
#  - upload the tarball to Python Package Index
#  - update the website home page (url, md5 and news)
#
# After the release:
#  - set version to n+1
#  - add a new empty section in the changelog for version n+1

from imp import load_source
from os import path
from sys import argv
from glob import glob

CLASSIFIERS = [
    'Intended Audience :: Developers',
    'Development Status :: 5 - Production/Stable',
    'Environment :: Console',
    'License :: OSI Approved :: GNU General Public License (GPL)',
    'Operating System :: OS Independent',
    'Natural Language :: English',
    'Programming Language :: Python',
    'Programming Language :: Python :: 3',
]

MODULES = (
    "fusil",
    "fusil.linux",
    "fusil.mas",
    "fusil.network",
    "fusil.process",
)

SCRIPTS = glob("fuzzers/fusil-*")

def main():
    if "--setuptools" in argv:
        argv.remove("--setuptools")
        from setuptools import setup
        use_setuptools = True
    else:
        from distutils.core import setup
        use_setuptools = False

    fusil = load_source("version", path.join("fusil", "version.py"))
    PACKAGES = {}
    for name in MODULES:
        PACKAGES[name] = name.replace(".", "/")

    with open('README') as fp:
        long_description = fp.read()
    with open('ChangeLog') as fp:
        long_description += fp.read()

    install_options = {
        "name": fusil.PACKAGE,
        "version": fusil.VERSION,
        "url": fusil.WEBSITE,
        "download_url": fusil.WEBSITE,
        "author": "Victor Stinner",
        "description": "Fuzzing framework",
        "long_description": long_description,
        "classifiers": CLASSIFIERS,
        "license": fusil.LICENSE,
        "packages": PACKAGES.keys(),
        "package_dir": PACKAGES,
        "scripts": SCRIPTS,
    }

    # Python 3: run 2to3
    try:
        from distutils.command.build_py import build_py_2to3
        from distutils.command.build_scripts import build_scripts_2to3
    except ImportError:
        pass
    else:
        install_options['cmdclass'] = {
            'build_py': build_py_2to3,
            'build_scripts': build_scripts_2to3,
        }

    if use_setuptools:
        install_options["install_requires"] = ["python-ptrace>=0.6.3"]
    setup(**install_options)

if __name__ == "__main__":
    main()

