-- $Id: deterministic.vhdl 4965 2010-10-18 13:08:25Z potyra $ 

-- test case for deterministic behaviour of driver->signal updates.

-- Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


ENTITY determin IS
	PORT (
		a : in boolean;
		b : in boolean;
		q : out boolean
	);
END;

ARCHITECTURE impl of determin is
	signal clk : boolean;
	signal d : boolean;
	signal l_clk : boolean;
BEGIN
	andgate : process(a,b)
	begin
		clk <= a and b;
	end process;

	inverter : process(b)
	begin
		d <= not b;
	end process;

	reg : process(clk,d)
	begin
		if l_clk = false and clk = true then
			q <= d;
		end if;
		l_clk <= clk;
	end process;
END;

ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE tb of test_bench IS
	signal  ta, tb, tq : boolean;
BEGIN
	d : determin PORT MAP (
		a => ta,
		b => tb,
		q => tq
	);

	test : process
	begin
		ta <= true;
		tb <= false;
		wait for 10 ms;
		tb <= true;
		wait for 10 ms;
		assert false report "simulation finished" severity note;
		wait;
	end process;
END;
