C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

       PROGRAM CREXEXP
C
C**** *CREXEXP*
C
C
C     PURPOSE.
C     --------
C         Expands list of CREX data descriptors.
C
C
C**   INTERFACE.
C     ----------
C
C          NONE.
C
C     METHOD.
C     -------
C
C          NONE.
C
C
C     EXTERNALS.
C     ----------
C
C
C     REFERENCE.
C     ----------
C
C          NONE.
C
C     AUTHOR.
C     -------
C
C          M. DRAGOSAVAC    *ECMWF*       07/01/2004.
C
C
C     MODIFICATIONS.
C     --------------
C
C          NONE.
C
C
      IMPLICIT LOGICAL(L,O,G), CHARACTER*8(C,H,Y)
C
      PARAMETER(JSEC1=40,JSEC3=4)
      PARAMETER (KDLEN=200,KELEM=4000)
C 
      DIMENSION KSEC1(JSEC1) 
C
      DIMENSION KDATA(KDLEN)
C
      CHARACTER*64 CNAMES(KELEM)
      CHARACTER*24 CUNITS(KELEM)
      CHARACTER*6  CREXKTDLST(KELEM)
      CHARACTER*6  CREXKTDEXP(KELEM)
C
      REAL*8 RVIND
C                                                                       
C
C     ------------------------------------------------------------------
C*          1. INITIALIZE CONSTANTS AND VARIABLES.
C              -----------------------------------
 100  CONTINUE
C
C
      RVIND=1.7E38
C
C     INITIALIZE DELAYED REPLICATION FACTORS 
C
      DO I=1,KDLEN
      KDATA(I)=1
      END DO
C
C     SET DATA DECSRIPTORS
C
      N=1
      CREXKTDLST( N)="D01090"
      N=N+1
      CREXKTDLST( N)="D02031"
      N=N+1
      CREXKTDLST( N)="D02032"
      N=N+1
      CREXKTDLST( N)="D02033"
      N=N+1
      CREXKTDLST( N)="D02004"
      N=N+1
      CREXKTDLST( N)="R01000"
      N=N+1
      CREXKTDLST( N)="D02005"
      N=N+1
      CREXKTDLST( N)="D02038"
      N=N+1
      CREXKTDLST( N)="D02044"
      N=N+1
      CREXKTDLST( N)="R01002"
      N=N+1
      CREXKTDLST( N)="D02039"
      N=N+1
      CREXKTDLST( N)="R02002"
      N=N+1
      CREXKTDLST( N)="B04024"
      N=N+1
      CREXKTDLST( N)="B13011"
      N=N+1
      CREXKTDLST( N)="B07032"
      N=N+1
      CREXKTDLST( N)="B04024"
      N=N+1
      CREXKTDLST( N)="B12111"
      N=N+1
      CREXKTDLST( N)="B04024"
      N=N+1
      CREXKTDLST( N)="B12112"
      N=N+1
      CREXKTDLST( N)="B07032"
      N=N+1
      CREXKTDLST( N)="B02002"
      N=N+1
      CREXKTDLST( N)="B08021"
      N=N+1
      CREXKTDLST( N)="B04025"
      N=N+1
      CREXKTDLST( N)="B11001"
      N=N+1
      CREXKTDLST( N)="B11002"
      N=N+1
      CREXKTDLST( N)="B08021"

      KTDLEN=N
C
C     SECTION 1 CONTENT
C
      KSEC1(2)=2     ! CREX EDITION NUMBER
      KSEC1(3)=98    ! Originating Centre ( oooo)
      KSEC1(4)=0     ! Update sequence number (uu)
      KSEC1(5)=1     ! Number of subsets ( sss)
      KSEC1(6)=0     ! CREX data category (nnn)
      KSEC1(7)=1     ! International data sub-category (mmm)
      KSEC1(8)=1     ! Version number of local table used
      KSEC1(9)=2004  ! Year
      KSEC1(10)=11   ! Month
      KSEC1(11)=29   ! Daay
      KSEC1(12)=12   ! Hour
      KSEC1(13)=00   ! Minute
      KSEC1(14)=0    ! CREX Master table (tt)
      KSEC1(15)=3    ! Version number of Master table used (vv)
      KSEC1(16)=0    ! Originating sub-centre (ppp)
      KSEC1(17)=12   ! Bufr master table version number
      KSEC1(18)=0    ! Bufr version number of local table used
C
C     SECTION 3 CONTENT
C
      K=1
      CALL CREXDES(K,KSEC1,KTDLEN,CREXKTDLST,KDLEN,KDATA,KELEM,
     1            KTDEXL,CREXKTDEXP,CNAMES,CUNITS,KERR)
C
      END
