/*
 * Timed.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */

#pragma once

#include "UnitEffect.h"

struct Bonus;
struct SetStackEffect;
struct MetaString;

namespace spells
{
namespace effects
{

class Timed : public UnitEffect
{
public:
	bool cumulative;
	std::vector<std::shared_ptr<Bonus>> bonus;

	Timed();
	virtual ~Timed();

	void apply(BattleStateProxy * battleState, RNG & rng, const Mechanics * m, const EffectTarget & target) const override;

protected:
	void serializeJsonUnitEffect(JsonSerializeFormat & handler) override final;

private:
	void convertBonus(const Mechanics * m, int32_t & duration, std::vector<Bonus> & converted) const;
	void describeEffect(std::vector<MetaString> & log, const Mechanics * m, const std::vector<Bonus> & bonuses, const battle::Unit * target) const;
	void prepareEffects(SetStackEffect & sse, const Mechanics * m, const EffectTarget & target, bool describe) const;
};

}
}
