NOTES FOR GITHUB DEVELOPERS
---------------------------

The official issue tracker for Slurm is at
  https://bugs.schedmd.com/

We welcome code contributions and patches, but **we do not accept Pull Requests
through GitHub at this time.** Please submit patches as attachments to new
bugs under the "C - Contributions" severity level.

TARGET RELEASES
---------------
Changes involving adding new functionality, functional changes to the command
line tools (either in adding new options, or changing the output formats), any
RPC protocol changes or state file format modifications, and similar work is
only considered for inclusion on the master branch (which will become the next
stable Slurm release).

Bug fixes themselves are considered for inclusion on the most recent stable
release, although may be deferred to the next major release at the reviewers'
discretion.

All contributed patches are subject to review by SchedMD.

CODING GUIDELINES
-----------------
Slurm loosely follows the Linux Kernel style guidelines
(https://www.kernel.org/doc/html/latest/process/coding-style.html).
If in doubt, please follow their example.

A brief overview, with some notable exceptions:
- Tabs not spaces, tabs are 8-spaces wide.
- Lines should be less than 80-characters wide.
- Except that error message and other log messages should not be broken up
  mid-sentence. They should be split on a format sequence, comma, or period
  instead. (This is to make it easier to grep for that string in the source
  code at a later point.)
- Use K&R style for braces.
- Slurm does use typedef's for certain types, ignore Chapter 5 of the kernel
  guidelines.
- Comments can be in either C-style `/* comment */` or C++ style  `// comment`
  formats. Follow the rest of Chapter 8's recommendations for multi-line
  comments though.

BUILD SYSTEM CHANGES
--------------------
Please submit changes to `Makefile.am`, but not to `Makefile.in`. We will
regenerate those files to minimize the differences in the commit. We want to
avoid noise generated by differences in libtool installations.

Changes to `configure.ac` or `auxdir/*` will take additional time to review -
Slurm is built on a wide variety of distributions and architectures, and even
minor differences can cause unintended consequences.

PATCH SUBMISSION
----------------
An entry in `NEWS` should describe the change or new functionality.

Please break patches up into logically separate chunks, while ensuring that
each patch can still be compiled. (Anticipate that a developer using `git
bisect` may pick any intermediate commit at some point.)

If you decided to reformat a file, please submit non-functional changes
(spelling corrections, formatting discrepancies) in a separate patch. This
makes reviewing substantially easier, and allows us to focus our attention on
the functional differences.

If you make an automated change (changing a function name, fixing a pervasive
spelling mistake), please send the command/regex used to generate the changes
along with the patch, or note it in the commit message.

While not required, we encourage use of `git format-patch` to generate the
patch. This ensures the relevant author line and commit message stay attached.
Plain `diff`'d output is also okay. In either case, please attach them to the
bug for us to review. Spelling corrections or documentation improvements can be
suggested without attaching the patch as long as you describe their location.

LEGAL
-----

We ask that a contributor licensing agreement be signed for all substantial
contributions. Please see https://slurm.schedmd.com/contributor.html for
details.
