#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# AGS games published by Wadjet Eye Games:
# - The Shivah
# - Gemini Rue
# - Resonance
# - Technobabylon
# - Shardlight
# - Unavowed
###

script_version=20240127.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_SHIVAH='the-shivah'
GAME_NAME_SHIVAH='The Shivah'

GAME_ID_GEMINIRUE='gemini-rue'
GAME_NAME_GEMINIRUE='Gemini Rue'

GAME_ID_RESONANCE='resonance'
GAME_NAME_RESONANCE='Resonance'

GAME_ID_TECHNOBABYLON='technobabylon'
GAME_NAME_TECHNOBABYLON='Technobabylon'

GAME_ID_SHARDLIGHT='shardlight'
GAME_NAME_SHARDLIGHT='Shardlight'

GAME_ID_UNAVOWED='unavowed'
GAME_NAME_UNAVOWED='Unavowed'

# Game archives

## The Shivah

ARCHIVE_BASE_SHIVAH_1_NAME='the_shivah_3_0_66477.sh'
ARCHIVE_BASE_SHIVAH_1_MD5='350e0e292792b1e44df1f54276843f4d'
ARCHIVE_BASE_SHIVAH_1_SIZE='170000'
ARCHIVE_BASE_SHIVAH_1_VERSION='3.0-gog66477'
ARCHIVE_BASE_SHIVAH_1_URL='https://www.gog.com/game/the_shivah'

ARCHIVE_BASE_SHIVAH_0_NAME='the_shivah_2_0_53607.sh'
ARCHIVE_BASE_SHIVAH_0_MD5='da6d89db273313fe00a680c52554aea3'
ARCHIVE_BASE_SHIVAH_0_SIZE='170000'
ARCHIVE_BASE_SHIVAH_0_VERSION='2.0-gog53607'

## Gemini Rue

ARCHIVE_BASE_GEMINIRUE_3_NAME='gemini_rue_3_0_1_66504.sh'
ARCHIVE_BASE_GEMINIRUE_3_MD5='e117463c6b002dbfc57b2adf4d26161b'
ARCHIVE_BASE_GEMINIRUE_3_SIZE='350000'
ARCHIVE_BASE_GEMINIRUE_3_VERSION='3.0.1-gog66504'
ARCHIVE_BASE_GEMINIRUE_3_URL='https://www.gog.com/game/gemini_rue'

ARCHIVE_BASE_GEMINIRUE_2_NAME='gemini_rue_3_0_66190.sh'
ARCHIVE_BASE_GEMINIRUE_2_MD5='3ad7b458713f1ba1d187d90b0dee8eaa'
ARCHIVE_BASE_GEMINIRUE_2_SIZE='350000'
ARCHIVE_BASE_GEMINIRUE_2_VERSION='3.0-gog66190'

ARCHIVE_BASE_GEMINIRUE_1_NAME='gemini_rue_2_3_56797.sh'
ARCHIVE_BASE_GEMINIRUE_1_MD5='f7883371b14f945163ffa040ee47806e'
ARCHIVE_BASE_GEMINIRUE_1_SIZE='340000'
ARCHIVE_BASE_GEMINIRUE_1_VERSION='2.3-gog56797'

ARCHIVE_BASE_GEMINIRUE_0_NAME='gemini_rue_2_0a_53346.sh'
ARCHIVE_BASE_GEMINIRUE_0_MD5='9626ba73b964458b26e25ed9e1ec737d'
ARCHIVE_BASE_GEMINIRUE_0_SIZE='340000'
ARCHIVE_BASE_GEMINIRUE_0_VERSION='2.0a-gog53346'

## Resonance

ARCHIVE_BASE_RESONANCE_1_NAME='resonance_3_0_66305.sh'
ARCHIVE_BASE_RESONANCE_1_MD5='87786f1035c3dbe8ebc35d1fb54f6d1a'
ARCHIVE_BASE_RESONANCE_1_SIZE='1100000'
ARCHIVE_BASE_RESONANCE_1_VERSION='3.0-gog66305'
ARCHIVE_BASE_RESONANCE_1_URL='https://www.gog.com/game/resonance'

ARCHIVE_BASE_RESONANCE_0_NAME='resonance_2_2_53439.sh'
ARCHIVE_BASE_RESONANCE_0_MD5='5c86f3f82974b65ad3d2852c6a9338ed'
ARCHIVE_BASE_RESONANCE_0_SIZE='1200000'
ARCHIVE_BASE_RESONANCE_0_VERSION='2.2-gog53439'

## Technobabylon

ARCHIVE_BASE_TECHNOBABYLON_3_NAME='technobabylon_3_0_1_66582.sh'
ARCHIVE_BASE_TECHNOBABYLON_3_MD5='6ddf6ed6e8df026f548025a90585a382'
ARCHIVE_BASE_TECHNOBABYLON_3_SIZE='1400000'
ARCHIVE_BASE_TECHNOBABYLON_3_VERSION='3.0.1-gog66582'
ARCHIVE_BASE_TECHNOBABYLON_3_URL='https://www.gog.com/game/technobabylon'

ARCHIVE_BASE_TECHNOBABYLON_2_NAME='technobabylon_3_0_66305.sh'
ARCHIVE_BASE_TECHNOBABYLON_2_MD5='5d522aa6349e26596e7a6e0ad3c5ff19'
ARCHIVE_BASE_TECHNOBABYLON_2_SIZE='1400000'
ARCHIVE_BASE_TECHNOBABYLON_2_VERSION='3.0-gog66305'

ARCHIVE_BASE_TECHNOBABYLON_1_NAME='technobabylon_2_5a_57810.sh'
ARCHIVE_BASE_TECHNOBABYLON_1_MD5='108abcf43ca17438717ddbad13a00f69'
ARCHIVE_BASE_TECHNOBABYLON_1_SIZE='1400000'
ARCHIVE_BASE_TECHNOBABYLON_1_VERSION='2.5a-gog57810'

ARCHIVE_BASE_TECHNOBABYLON_0_NAME='technobabylon_2_1_53388.sh'
ARCHIVE_BASE_TECHNOBABYLON_0_MD5='6bb58eccb57e2195d49266bd8798a9a1'
ARCHIVE_BASE_TECHNOBABYLON_0_SIZE='1400000'
ARCHIVE_BASE_TECHNOBABYLON_0_VERSION='2.1-gog53388'

## Shardlight

ARCHIVE_BASE_SHARDLIGHT_3_NAME='shardlight_3_1_70695.sh'
ARCHIVE_BASE_SHARDLIGHT_3_MD5='824cd0bf02463cfce8acd9c491399197'
ARCHIVE_BASE_SHARDLIGHT_3_SIZE='952796'
ARCHIVE_BASE_SHARDLIGHT_3_VERSION='3.1-gog70695'
ARCHIVE_BASE_SHARDLIGHT_3_URL='https://www.gog.com/game/shardlight'

ARCHIVE_BASE_SHARDLIGHT_2_NAME='shardlight_3_0_66305.sh'
ARCHIVE_BASE_SHARDLIGHT_2_MD5='2c3d7b7e0a541ee3a635189449608713'
ARCHIVE_BASE_SHARDLIGHT_2_SIZE='960000'
ARCHIVE_BASE_SHARDLIGHT_2_VERSION='3.0-gog66305'

ARCHIVE_BASE_SHARDLIGHT_1_NAME='shardlight_2_4_56258.sh'
ARCHIVE_BASE_SHARDLIGHT_1_MD5='854c59dcb914d934468a9475d17181e4'
ARCHIVE_BASE_SHARDLIGHT_1_SIZE='1200000'
ARCHIVE_BASE_SHARDLIGHT_1_VERSION='2.4-gog56258'

ARCHIVE_BASE_SHARDLIGHT_0_NAME='shardlight_2_2_53577.sh'
ARCHIVE_BASE_SHARDLIGHT_0_MD5='b48f7b1aac9b32ee7f5b236b6cc82e81'
ARCHIVE_BASE_SHARDLIGHT_0_SIZE='1200000'
ARCHIVE_BASE_SHARDLIGHT_0_VERSION='2.2-gog53577'

## Unavowed

ARCHIVE_BASE_UNAVOWED_7_NAME='unavowed_2_0_2_70667.sh'
ARCHIVE_BASE_UNAVOWED_7_MD5='00c9f35c3e3e506f8238de49c8ac781a'
ARCHIVE_BASE_UNAVOWED_7_SIZE='2310224'
ARCHIVE_BASE_UNAVOWED_7_VERSION='2.0.2-gog70667'
ARCHIVE_BASE_UNAVOWED_7_URL='https://www.gog.com/game/unavowed'

ARCHIVE_BASE_UNAVOWED_6_NAME='unavowed_2_0_2_70012.sh'
ARCHIVE_BASE_UNAVOWED_6_MD5='a9cfabc33e91f0d7b7649e302966b591'
ARCHIVE_BASE_UNAVOWED_6_SIZE='2310224'
ARCHIVE_BASE_UNAVOWED_6_VERSION='2.0.2-gog70012'

ARCHIVE_BASE_UNAVOWED_5_NAME='unavowed_2_0_1_66601.sh'
ARCHIVE_BASE_UNAVOWED_5_MD5='bacc5d7cf9da4970da580c7ee43e1a2e'
ARCHIVE_BASE_UNAVOWED_5_SIZE='2400000'
ARCHIVE_BASE_UNAVOWED_5_VERSION='2.0.1-gog66601'

ARCHIVE_BASE_UNAVOWED_4_NAME='unavowed_2_0_66472.sh'
ARCHIVE_BASE_UNAVOWED_4_MD5='771d43bf86a85da9a70d02da80a6eb01'
ARCHIVE_BASE_UNAVOWED_4_SIZE='2400000'
ARCHIVE_BASE_UNAVOWED_4_VERSION='2.0-gog66472'

ARCHIVE_BASE_UNAVOWED_3_NAME='unavowed_1_5_64507.sh'
ARCHIVE_BASE_UNAVOWED_3_MD5='0029204a1edc703c2fc90bcc2741c442'
ARCHIVE_BASE_UNAVOWED_3_SIZE='2500000'
ARCHIVE_BASE_UNAVOWED_3_VERSION='1.5-gog64507'

ARCHIVE_BASE_UNAVOWED_2_NAME='unavowed_1_4_57370.sh'
ARCHIVE_BASE_UNAVOWED_2_MD5='c785b049e60d60e45296acda30bd9aa2'
ARCHIVE_BASE_UNAVOWED_2_SIZE='2500000'
ARCHIVE_BASE_UNAVOWED_2_VERSION='1.4-gog57370'

ARCHIVE_BASE_UNAVOWED_1_NAME='unavowed_1_32_55233.sh'
ARCHIVE_BASE_UNAVOWED_1_MD5='6d92c60a1a3406f619b4fb4c204adecc'
ARCHIVE_BASE_UNAVOWED_1_SIZE='2500000'
ARCHIVE_BASE_UNAVOWED_1_VERSION='1.3.2-gog55233'

ARCHIVE_BASE_UNAVOWED_0_NAME='unavowed_1_31_54237.sh'
ARCHIVE_BASE_UNAVOWED_0_MD5='f0060c808571a4324714c69f653a4caa'
ARCHIVE_BASE_UNAVOWED_0_SIZE='2500000'
ARCHIVE_BASE_UNAVOWED_0_VERSION='1.3.1-gog54237'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of optional extra archives

case "$(current_archive)" in
	('ARCHIVE_BASE_SHIVAH_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='the-shivah_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='76cb6554e1c09596842391a71e696ded'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/the-shivah/'
	;;
	('ARCHIVE_BASE_GEMINIRUE_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='gemini-rue_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='329019f63b1acdfe7c4d5219a562efab'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/gemini-rue/'
	;;
	('ARCHIVE_BASE_RESONANCE_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='resonance_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='0a24712adffd9f5f2998bf355fc161b7'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/resonance/'
	;;
	('ARCHIVE_BASE_TECHNOBABYLON_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='technobabylon_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='84a7104801c25d5e931fbdd4cc3d1916'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/technobabylon/'
	;;
	('ARCHIVE_BASE_SHARDLIGHT_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='shardlight_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='59bce49abce9678d963cecd72be8b512'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/shardlight/'
	;;
	('ARCHIVE_BASE_UNAVOWED_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='unavowed_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='359eae49cc167a34a1cc5525cf6ab340'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/unavowed/'
	;;
esac
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'

# Extract game data

archive_extraction_default
if archive_is_available 'ARCHIVE_ICONS'; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

if archive_is_available 'ARCHIVE_ICONS'; then
	case "$(current_archive)" in
		('ARCHIVE_BASE_SHIVAH_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			16x16
			24x24
			32x32
			48x48
			256x256'
		;;
		('ARCHIVE_BASE_GEMINIRUE_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			256x256'
		;;
		('ARCHIVE_BASE_RESONANCE_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			16x16
			24x24
			32x32
			48x48
			256x256'
		;;
		('ARCHIVE_BASE_TECHNOBABYLON_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			64x64'
		;;
		('ARCHIVE_BASE_SHARDLIGHT_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			16x16
			32x32'
		;;
		('ARCHIVE_BASE_UNAVOWED_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			16x16
			24x24
			32x32
			48x48
			256x256'
		;;
	esac
	content_inclusion 'ICONS_DATA' 'PKG_MAIN' "$(path_icons)"
else
	case "$(current_archive)" in
		('ARCHIVE_BASE_SHIVAH_0')
			APP_MAIN_ICON='Shivah.exe'
		;;
		('ARCHIVE_BASE_GEMINIRUE_0'|'ARCHIVE_BASE_GEMINIRUE_1')
			APP_MAIN_ICON='Gemini Rue.exe'
		;;
		('ARCHIVE_BASE_RESONANCE_0')
			APP_MAIN_ICON='Resonance.exe'
		;;
		('ARCHIVE_BASE_TECHNOBABYLON_0'|'ARCHIVE_BASE_TECHNOBABYLON_1')
			APP_MAIN_ICON='Technobabylon.exe'
		;;
		('ARCHIVE_BASE_SHARDLIGHT_0'|'ARCHIVE_BASE_SHARDLIGHT_1')
			APP_MAIN_ICON='Shardlight.exe'
		;;
		('ARCHIVE_BASE_UNAVOWED_0'|'ARCHIVE_BASE_UNAVOWED_1'|'ARCHIVE_BASE_UNAVOWED_2'|'ARCHIVE_BASE_UNAVOWED_3')
			APP_MAIN_ICON='Unavowed.exe'
		;;
		(*)
			APP_MAIN_ICON='../support/icon.png'
		;;
	esac
	icons_inclusion
fi
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
