#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# MechaNika
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.2

GAME_ID='mechanika'
GAME_NAME='MechaNika'

ARCHIVE_BASE_32BIT_0='MechaNika_linux32_1.1.10.zip'
ARCHIVE_BASE_32BIT_0_MD5='177e488fd1fde7efd89b7bb5a86fe49e'
ARCHIVE_BASE_32BIT_0_SIZE='220000'
ARCHIVE_BASE_32BIT_0_VERSION='1.1.10-humble160417'
ARCHIVE_BASE_32BIT_0_URL='https://www.humblebundle.com/store/mechanika'

ARCHIVE_BASE_64BIT_0='MechaNika_linux64_1.1.10.zip'
ARCHIVE_BASE_64BIT_0_MD5='20fecb0fb6e7324c7c8d4b40040ed434'
ARCHIVE_BASE_64BIT_0_SIZE='220000'
ARCHIVE_BASE_64BIT_0_VERSION='1.1.10-humble160417'
ARCHIVE_BASE_64BIT_0_URL='https://www.humblebundle.com/store/mechanika'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_SHIPPED_FILES='
jre
MechaNika
config.json'
CONTENT_GAME_DATA_FILES='
MechaNika.jar'

APP_MAIN_EXE='MechaNika'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_32 APP_MAIN_ICON_128'
APP_MAIN_ICON_32='graphics/icons/mechanika_icon_32.png'
APP_MAIN_ICON_128='graphics/icons/mechanika_icon_128.png'

# Launchers

APPLICATIONS_LIST='APP_MAIN'

APP_MAIN_ICONS_LIST='APP_MAIN_ICON_32 APP_MAIN_ICON_128'
APP_MAIN_ICON_32='graphics/icons/mechanika_icon_32.png'
APP_MAIN_ICON_128='graphics/icons/mechanika_icon_128.png'

## Using system-provided Java

APP_MAIN_TYPE_BIN_SYSTEM='java'
APP_MAIN_EXE_BIN_SYSTEM='MechaNika.jar'

## Using shipped binaries

APP_MAIN_EXE_BIN_SHIPPED='MechaNika'

# Packages

## Common

PACKAGES_LIST='PKG_BIN_SHIPPED PKG_BIN_SYSTEM PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"

## Using system-provided Java

PKG_BIN_SYSTEM_ID="${PKG_BIN_ID}-bin-system"
PKG_BIN_SYSTEM_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SYSTEM_DEPS="$PKG_DATA_ID java"
PKG_BIN_SYSTEM_DESCRIPTION='Using system-provided Java'

## Using shipped binaries

PKG_BIN_SHIPPED_ARCH_32BIT='32'
PKG_BIN_SHIPPED_ARCH_64BIT='64'
PKG_BIN_SHIPPED_ID="${PKG_BIN_ID}-bin-shipped"
PKG_BIN_SHIPPED_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SHIPPED_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6
libthread_db.so.1'
PKG_BIN_SYSTEM_DESCRIPTION='Using shipped binaries'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
ARCHIVE_JAVA="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/MechaNika.jar"
ARCHIVE_JAVA_TYPE='zip'
archive_extraction 'ARCHIVE_JAVA'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN_SHIPPED' 'PKG_BIN_SYSTEM'; do
	launchers_write
done

# Build packages

write_metadata
build_pkg

# Print instructions

case "${LANG%_*}" in
	('fr')
		message='Utilisation des binaires fournis par %s :'
		bin_shipped='les développeurs'
		bin_system='le système'
	;;
	('en'|*)
		message='Using binaries provided by %s:'
		bin_shipped='the developers'
		bin_system='the system'
	;;
esac
printf '\n'
printf "$message" "$bin_shipped"
print_instructions 'PKG_BIN_SHIPPED' 'PKG_DATA'
printf "$message" "$bin_system"
print_instructions 'PKG_BIN_SYSTEM' 'PKG_DATA'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
