#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Oddworld: Abe's Oddysee
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220705.1

GAME_ID='oddworld-abes-oddysee'
GAME_NAME='Oddworld: Abeʼs Oddysee'

ARCHIVE_BASE_1='setup_abes_oddysee_1.0_(19071).exe'
ARCHIVE_BASE_1_MD5='1c60cd9f43cc6392fc7c5185580eb048'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='650000'
ARCHIVE_BASE_1_VERSION='1.0-gog19071'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/oddworld_abes_oddysee'

ARCHIVE_BASE_0='setup_abes_oddysee_2.0.0.4.exe'
ARCHIVE_BASE_0_MD5='c22a44d208e524dc2760ea6ce57829d5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='660000'
ARCHIVE_BASE_0_VERSION='2.1-gog2.0.0.4'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_DOC_DATA_FILES='
*.txt
*.pdf'
ARCHIVE_GAME_BIN_FILES='
abewin.exe'
ARCHIVE_GAME_DATA_FILES='
*.ddv
*.lvl'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='abewin.exe'
APP_MAIN_ICON='abewin.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

DATA_DIRS='save'
DATA_FILES='*.ini'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
