/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSELEMENT_H_
#define OPENDRIM_BIOSELEMENT_H_

#include <Instance.h>

const static char* OpenDRIM_BIOSElement_classnames[] = {"OpenDRIM_BIOSElement"};
static string OpenDRIM_BIOSElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_BIOSElement {

public:
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	string Version;
	bool Version_isNULL;
	
	unsigned short SoftwareElementState;
	bool SoftwareElementState_isNULL;
	
	string SoftwareElementID;
	bool SoftwareElementID_isNULL;
	
	unsigned short TargetOperatingSystem;
	bool TargetOperatingSystem_isNULL;
	
	string OtherTargetOS;
	bool OtherTargetOS_isNULL;
	
	string BuildNumber;
	bool BuildNumber_isNULL;
	
	string SerialNumber;
	bool SerialNumber_isNULL;
	
	string CodeSet;
	bool CodeSet_isNULL;
	
	string IdentificationCode;
	bool IdentificationCode_isNULL;
	
	string LanguageEdition;
	bool LanguageEdition_isNULL;
	
	string Manufacturer;
	bool Manufacturer_isNULL;
	
	bool PrimaryBIOS;
	bool PrimaryBIOS_isNULL;
	
	vector<string> ListOfLanguages;
	bool ListOfLanguages_isNULL;
	
	string CurrentLanguage;
	bool CurrentLanguage_isNULL;
	
	unsigned long long LoadedStartingAddress;
	bool LoadedStartingAddress_isNULL;
	
	unsigned long long LoadedEndingAddress;
	bool LoadedEndingAddress_isNULL;
	
	string LoadUtilityInformation;
	bool LoadUtilityInformation_isNULL;
	
	string ReleaseDate;
	bool ReleaseDate_isNULL;
	
	vector<string> RegistryURIs;
	bool RegistryURIs_isNULL;
	
	OpenDRIM_BIOSElement() {
		InstanceID_isNULL = true;
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		CommunicationStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		PrimaryStatus_isNULL = true;
		Name_isNULL = true;
		Version_isNULL = true;
		SoftwareElementState_isNULL = true;
		SoftwareElementID_isNULL = true;
		TargetOperatingSystem_isNULL = true;
		OtherTargetOS_isNULL = true;
		BuildNumber_isNULL = true;
		SerialNumber_isNULL = true;
		CodeSet_isNULL = true;
		IdentificationCode_isNULL = true;
		LanguageEdition_isNULL = true;
		Manufacturer_isNULL = true;
		PrimaryBIOS_isNULL = true;
		ListOfLanguages_isNULL = true;
		CurrentLanguage_isNULL = true;
		LoadedStartingAddress_isNULL = true;
		LoadedEndingAddress_isNULL = true;
		LoadUtilityInformation_isNULL = true;
		ReleaseDate_isNULL = true;
		RegistryURIs_isNULL = true;
	}
	
	~OpenDRIM_BIOSElement() {}
	
	string getKeys() const {
		return CF_toLowCase(".Name=\"" + CF_quoteString(Name) + "\""".Version=\"" + CF_quoteString(Version) + "\""".SoftwareElementState=\"" + CF_intToStr(SoftwareElementState) + "\""".SoftwareElementID=\"" + CF_quoteString(SoftwareElementID) + "\""".TargetOperatingSystem=\"" + CF_intToStr(TargetOperatingSystem) + "\"");
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getVersion(string& value) const {
		if (Version_isNULL==true)
			return NOT_FOUND;
		value = Version;
		return OK;
	}
	
	int setVersion(const string& newValue) {
		Version = newValue;
		Version_isNULL = false;
		return OK;
	}

	int getSoftwareElementState(unsigned short& value) const {
		if (SoftwareElementState_isNULL==true)
			return NOT_FOUND;
		value = SoftwareElementState;
		return OK;
	}
	
	int setSoftwareElementState(const unsigned short& newValue) {
		SoftwareElementState = newValue;
		SoftwareElementState_isNULL = false;
		return OK;
	}

	int getSoftwareElementID(string& value) const {
		if (SoftwareElementID_isNULL==true)
			return NOT_FOUND;
		value = SoftwareElementID;
		return OK;
	}
	
	int setSoftwareElementID(const string& newValue) {
		SoftwareElementID = newValue;
		SoftwareElementID_isNULL = false;
		return OK;
	}

	int getTargetOperatingSystem(unsigned short& value) const {
		if (TargetOperatingSystem_isNULL==true)
			return NOT_FOUND;
		value = TargetOperatingSystem;
		return OK;
	}
	
	int setTargetOperatingSystem(const unsigned short& newValue) {
		TargetOperatingSystem = newValue;
		TargetOperatingSystem_isNULL = false;
		return OK;
	}

	int getOtherTargetOS(string& value) const {
		if (OtherTargetOS_isNULL==true)
			return NOT_FOUND;
		value = OtherTargetOS;
		return OK;
	}
	
	int setOtherTargetOS(const string& newValue) {
		OtherTargetOS = newValue;
		OtherTargetOS_isNULL = false;
		return OK;
	}

	int getBuildNumber(string& value) const {
		if (BuildNumber_isNULL==true)
			return NOT_FOUND;
		value = BuildNumber;
		return OK;
	}
	
	int setBuildNumber(const string& newValue) {
		BuildNumber = newValue;
		BuildNumber_isNULL = false;
		return OK;
	}

	int getSerialNumber(string& value) const {
		if (SerialNumber_isNULL==true)
			return NOT_FOUND;
		value = SerialNumber;
		return OK;
	}
	
	int setSerialNumber(const string& newValue) {
		SerialNumber = newValue;
		SerialNumber_isNULL = false;
		return OK;
	}

	int getCodeSet(string& value) const {
		if (CodeSet_isNULL==true)
			return NOT_FOUND;
		value = CodeSet;
		return OK;
	}
	
	int setCodeSet(const string& newValue) {
		CodeSet = newValue;
		CodeSet_isNULL = false;
		return OK;
	}

	int getIdentificationCode(string& value) const {
		if (IdentificationCode_isNULL==true)
			return NOT_FOUND;
		value = IdentificationCode;
		return OK;
	}
	
	int setIdentificationCode(const string& newValue) {
		IdentificationCode = newValue;
		IdentificationCode_isNULL = false;
		return OK;
	}

	int getLanguageEdition(string& value) const {
		if (LanguageEdition_isNULL==true)
			return NOT_FOUND;
		value = LanguageEdition;
		return OK;
	}
	
	int setLanguageEdition(const string& newValue) {
		LanguageEdition = newValue;
		LanguageEdition_isNULL = false;
		return OK;
	}

	int getManufacturer(string& value) const {
		if (Manufacturer_isNULL==true)
			return NOT_FOUND;
		value = Manufacturer;
		return OK;
	}
	
	int setManufacturer(const string& newValue) {
		Manufacturer = newValue;
		Manufacturer_isNULL = false;
		return OK;
	}

	int getPrimaryBIOS(bool& value) const {
		if (PrimaryBIOS_isNULL==true)
			return NOT_FOUND;
		value = PrimaryBIOS;
		return OK;
	}
	
	int setPrimaryBIOS(const bool& newValue) {
		PrimaryBIOS = newValue;
		PrimaryBIOS_isNULL = false;
		return OK;
	}

	int getListOfLanguages(vector<string>& value) const {
		if (ListOfLanguages_isNULL==true)
			return NOT_FOUND;
		value = ListOfLanguages;
		return OK;
	}
	
	int setListOfLanguages(const vector<string>& newValue) {
		ListOfLanguages = newValue;
		ListOfLanguages_isNULL = false;
		return OK;
	}

	int getCurrentLanguage(string& value) const {
		if (CurrentLanguage_isNULL==true)
			return NOT_FOUND;
		value = CurrentLanguage;
		return OK;
	}
	
	int setCurrentLanguage(const string& newValue) {
		CurrentLanguage = newValue;
		CurrentLanguage_isNULL = false;
		return OK;
	}

	int getLoadedStartingAddress(unsigned long long& value) const {
		if (LoadedStartingAddress_isNULL==true)
			return NOT_FOUND;
		value = LoadedStartingAddress;
		return OK;
	}
	
	int setLoadedStartingAddress(const unsigned long long& newValue) {
		LoadedStartingAddress = newValue;
		LoadedStartingAddress_isNULL = false;
		return OK;
	}

	int getLoadedEndingAddress(unsigned long long& value) const {
		if (LoadedEndingAddress_isNULL==true)
			return NOT_FOUND;
		value = LoadedEndingAddress;
		return OK;
	}
	
	int setLoadedEndingAddress(const unsigned long long& newValue) {
		LoadedEndingAddress = newValue;
		LoadedEndingAddress_isNULL = false;
		return OK;
	}

	int getLoadUtilityInformation(string& value) const {
		if (LoadUtilityInformation_isNULL==true)
			return NOT_FOUND;
		value = LoadUtilityInformation;
		return OK;
	}
	
	int setLoadUtilityInformation(const string& newValue) {
		LoadUtilityInformation = newValue;
		LoadUtilityInformation_isNULL = false;
		return OK;
	}

	int getReleaseDate(string& value) const {
		if (ReleaseDate_isNULL==true)
			return NOT_FOUND;
		value = ReleaseDate;
		return OK;
	}
	
	int setReleaseDate(const string& newValue) {
		ReleaseDate = newValue;
		ReleaseDate_isNULL = false;
		return OK;
	}

	int getRegistryURIs(vector<string>& value) const {
		if (RegistryURIs_isNULL==true)
			return NOT_FOUND;
		value = RegistryURIs;
		return OK;
	}
	
	int setRegistryURIs(const vector<string>& newValue) {
		RegistryURIs = newValue;
		RegistryURIs_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BIOSELEMENT_H_*/
