const char cgGLFragmentFunctionShader[] = 
"// this is the fragment program\n"
"\n"
"/*struct inputs\n"
"{\n"
"	float4 color : COLOR0;\n"
"	float4 color1 : COLOR1;\n"
"	//float4 texcoord : TEXCOORD0;\n"
"	//float4 texcoord1 : TEXCOORD1;\n"
"};*/\n"
"\n"
"struct inputs\n"
"{\n"
"	float4 HPOS : POSITION;\n"
"	float4 texcoord : TEXCOORD0;\n"
"	float4 texcoord1 : TEXCOORD1;\n"
"	float4 texcoord2 : TEXCOORD2;\n"
"	float4 texcoord3 : TEXCOORD3;	// duplicate of HPOS to read it\n"
"	float4 primarycolor : COLOR0;\n"
"	float3 secondarycolor : COLOR1;\n"
"};\n"
"\n"
"float3 expand(float3 vector)\n"
"{\n"
"    return 2.0 * (vector - 0.5);\n"
"}\n"
"\n"
"// register combiner vector normalization function\n"
"float3 normalize(float3 vector)\n"
"{\n"
"    float3 VdotV = dot(expand(vector), expand(vector));\n"
"    return (1-saturate(VdotV)) * (vector-0.5) + expand(vector);\n"
"}\n"
"\n"
"float3 interpolateColor( float3 color1, float3 color2, float left, float right, float val )\n"
"{\n"
"	float t = (val - left ) / ( right - left );\n"
"	return (1-t)*color1 + t*color2;\n"
"}\n"
"\n"
"float4 main(inputs IN, out float depth: DEPTH,\n"
"			uniform float4 maincolor,\n"
"			uniform sampler2D normalmap,\n"
"			uniform sampler2D depthmap,\n"
"			uniform sampler3D functionmap,\n"
"			uniform float4x4 ModelViewProjInverse,\n"
"			uniform float3 minExtent,\n"
"			uniform float3 maxExtent\n"
"			) : COLOR\n"
"{\n"
"	// calculate depth\n"
"    float3 depthVal = tex2D(depthmap, IN.texcoord.xy).rgb;\n"
"    float z = dot(IN.texcoord1.xyz, depthVal);\n"
"    float w = dot(IN.texcoord2.xyz, depthVal);\n"
"    depth = (z / w);//*0.5+0.5;    \n"
"\n"
"	float mydepth = depth-0.5;\n"
"	mydepth = mydepth*2.0;\n"
"	// get object pos to look up into texture\n"
"	float4 ndcPos = float4( IN.texcoord3.x, IN.texcoord3.y, mydepth, 1.0 );\n"
"	//float4 ndcPos = IN.texcoord3;\n"
"	float4 objectPos = mul(ModelViewProjInverse,ndcPos);\n"
"\n"
"	// compress object pos into unit cube\n"
"	float unitx = (objectPos.x - minExtent[0]) / (maxExtent[0] - minExtent[0]);\n"
"	float unity = (objectPos.y - minExtent[1]) / (maxExtent[1] - minExtent[1]);\n"
"	float unitz = (objectPos.z - minExtent[2]) / (maxExtent[2] - minExtent[2]);\n"
"	\n"
"	// do a color map lookup, but now just do something ....\n"
"	float4 dens = tex3D( functionmap, float3(unitx, unity, unitz));\n"
"\n"
"	float3 surfaceColor;\n"
"\n"
"	if( dens.r >= 0 && dens.r < 0.46 )\n"
"	{\n"
"		surfaceColor = interpolateColor( float3(0.5,0,0), float3(1,0,0), 0, 0.46, dens.r );\n"
"	}\n"
"	if( dens.r >= 0.46 && dens.r < 0.5 )\n"
"	{\n"
"		surfaceColor = interpolateColor( float3(1,0,0), float3(0,0,0), 0.46, 0.5, dens.r );\n"
"	}\n"
"	if( dens.r >= 0.5 && dens.r < 0.529 )\n"
"	{\n"
"		surfaceColor = interpolateColor( float3(0,0,0), float3(0,1,0), 0.5, 0.529, dens.r );\n"
"	}\n"
"	if( dens.r >= 0.529 && dens.r <= 1.0 )\n"
"	{\n"
"		surfaceColor = interpolateColor( float3(0,1,0), float3(0,0.5,0), 0.529, 1.0, dens.r );\n"
"	}	\n"
"	\n"
"	//float3 normal = (tex2D(normalmap, IN.texcoord1.xy)).rgb;\n"
"	float4 normal = 2.0 * (tex2D(normalmap, IN.texcoord.xy) - 0.5);\n"
"	\n"
"	//IN.secondarycolor.rgb = 2.0*(IN.secondarycolor.rgb-0.5);\n"
"	IN.secondarycolor.rgb = normalize(IN.secondarycolor.rgb);\n"
"\n"
"	float3 NdotL = dot(normal.rgb, IN.secondarycolor);\n"
"	// instead of using input color, use the newly computed surface color\n"
"	//float3 color = IN.primarycolor.rgb*(saturate(NdotL) + IN.primarycolor.w);\n"
"	float3 color = surfaceColor.rgb*(saturate(NdotL) + IN.primarycolor.w);\n"
"\n"
"    // calculate reflection vector\n"
"    // R = 2 * (N * (N dot L) - L/2)\n"
"    //   = 2 * N * (N dot L) - L\n"
"    float3 reflectVec = ((NdotL * normal.rgb) + (-0.5 * IN.secondarycolor)) * 2.0;\n"
"\n"
"    // eye vector E = (0, 0, 1)\n"
"    // R dot E = (R.r*0 + R.g*0 + 1*R.b) = R.b\n"
"    float RdotE = saturate(reflectVec.b);   // max(0, RdotE);\n"
"\n"
"    // calculate specular as pow(RdotE, 16)\n"
"	float specular = pow(RdotE, 16); \n"
"\n"
"	// add specular light contribution to final color\n"
"    //finalColor += specular;\n"
"	color += specular;\n"
"\n"
"	float4 outcolor = float4(color, normal.w);    \n"
"	return outcolor;\n"
"}\n";
