#!/bin/csh
#	Block Processor script
#		process.csh <multiple alignment>
#		m.a. must be in FASTA, CLUSTAL, MSF or STOCKHOLM format

setenv BLIMPS_DIR ../..
set bin = $BLIMPS_DIR/bin

#	1. mablock carves ungapped regions in all sequences out of m.a.
#	   Set min and max width of blocks
#	   Creates files $1.blks and $1.seqs
set minwidth=10
set maxwidth=60
$bin/mablock $1 $1 B $minwidth $maxwidth

#	2. Calibrate blocks for searching with blimps program
./calibrate.csh $1.blks $1.cblks > /dev/null

#	3. Add sequence weights to calibrated blocks
$bin/blweight $1.cblks $1.wblks P M > /dev/null

echo "Final blocks are in $1.wblks"

exit
