/* timsort.c generated by valac 0.56.17, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib-object.h>
#include "gee.h"
#include <glib.h>
#include <string.h>

#define GEE_TIM_SORT_MINIMUM_GALLOP 7
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
enum  {
	GEE_TIM_SORT_0_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC,
	GEE_TIM_SORT_NUM_PROPERTIES
};
static GParamSpec* gee_tim_sort_properties[GEE_TIM_SORT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gee_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (gee_tim_sort_slice_free (var), NULL)))
typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareDataFunc compare;
	gpointer compare_target;
};

struct _GeeTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

static gint GeeTimSort_private_offset;
static gpointer gee_tim_sort_parent_class = NULL;

 G_GNUC_INTERNAL GType gee_tim_sort_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gee_tim_sort_slice_free (GeeTimSortSlice * self);
 G_GNUC_INTERNAL void gee_tim_sort_sort (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        GeeList* list,
                        GCompareDataFunc compare,
                        gpointer compare_target);
static void gee_tim_sort_sort_arraylist (GType g_type,
                                  GBoxedCopyFunc g_dup_func,
                                  GDestroyNotify g_destroy_func,
                                  GeeArrayList* list,
                                  GCompareDataFunc compare,
                                  gpointer compare_target);
static void gee_tim_sort_sort_list (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             GeeList* list,
                             GCompareDataFunc compare,
                             gpointer compare_target);
 G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func);
 G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func);
static void gee_tim_sort_do_sort (GeeTimSort* self);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list,
                                         gint index,
                                         gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self,
                                              gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self,
                                                   GeeTimSortSlice* a,
                                                   gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self,
                                  GeeTimSortSlice* a,
                                  gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self,
                                       gint n);
static void _vala_array_add3 (GeeTimSortSlice** * array,
                       gint* length,
                       gint* size,
                       GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self,
                                  gconstpointer left,
                                  gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self,
                                              gconstpointer left,
                                              gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self,
                            gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self,
                                    gconstpointer key,
                                    GeeTimSortSlice* a,
                                    gint hint);
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self,
                                   gconstpointer key,
                                   GeeTimSortSlice* a,
                                   gint hint);
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self,
                             GeeTimSortSlice* a,
                             GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self,
                              GeeTimSortSlice* a,
                              GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self,
                                  void** dest_array,
                                  gint index,
                                  gint dest_index,
                                  gint count);
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self,
                                           void** dest_array,
                                           gint index,
                                           gint dest_index,
                                           gint count);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self,
                                     gint n);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self,
                              gint i,
                              gint j);
static void gee_tim_sort_finalize (GObject * obj);
static GType gee_tim_sort_get_type_once (void);
static void _vala_gee_tim_sort_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gee_tim_sort_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gssize src,
                       gssize dest,
                       gssize length);

static inline gpointer
gee_tim_sort_get_instance_private (GeeTimSort* self)
{
	return G_STRUCT_MEMBER_P (self, GeeTimSort_private_offset);
}

 G_GNUC_INTERNAL void
gee_tim_sort_sort (GType g_type,
                   GBoxedCopyFunc g_dup_func,
                   GDestroyNotify g_destroy_func,
                   GeeList* list,
                   GCompareDataFunc compare,
                   gpointer compare_target)
{
	g_return_if_fail (list != NULL);
	if (GEE_IS_ARRAY_LIST (list)) {
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ARRAY_LIST, GeeArrayList), compare, compare_target);
	} else {
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, list, compare, compare_target);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gee_tim_sort_sort_list (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        GeeList* list,
                        GCompareDataFunc compare,
                        gpointer compare_target)
{
	GeeTimSort* helper = NULL;
	GeeTimSort* _tmp0_;
	GeeTimSort* _tmp1_;
	GeeList* _tmp2_;
	GeeTimSort* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	GeeTimSort* _tmp6_;
	GeeTimSort* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	GeeTimSort* _tmp9_;
	GeeTimSort* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeTimSort* _tmp13_;
	GeeTimSort* _tmp14_;
	GeeTimSort* _tmp15_;
	gpointer* _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = helper;
	_tmp2_ = _g_object_ref0 (list);
	_g_object_unref0 (_tmp1_->priv->list_collection);
	_tmp1_->priv->list_collection = _tmp2_;
	_tmp3_ = helper;
	_tmp5_ = gee_collection_to_array ((GeeCollection*) list, &_tmp4_);
	_tmp3_->priv->array = (_vala_array_free (_tmp3_->priv->array, _tmp3_->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	_tmp3_->priv->array = _tmp5_;
	_tmp3_->priv->array_length1 = _tmp4_;
	_tmp3_->priv->_array_size_ = _tmp3_->priv->array_length1;
	_tmp6_ = helper;
	_tmp7_ = helper;
	_tmp8_ = _tmp7_->priv->array;
	_tmp8__length1 = _tmp7_->priv->array_length1;
	_tmp6_->priv->list = _tmp8_;
	_tmp9_ = helper;
	_tmp9_->priv->index = 0;
	_tmp10_ = helper;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) list);
	_tmp12_ = _tmp11_;
	_tmp10_->priv->size = _tmp12_;
	_tmp13_ = helper;
	_tmp13_->priv->compare = compare;
	_tmp13_->priv->compare_target = compare_target;
	_tmp14_ = helper;
	gee_tim_sort_do_sort (_tmp14_);
	gee_collection_clear ((GeeCollection*) list);
	_tmp15_ = helper;
	_tmp16_ = _tmp15_->priv->array;
	_tmp16__length1 = _tmp15_->priv->array_length1;
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp16_;
		item_collection_length1 = _tmp16__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			gpointer _tmp17_;
			gpointer item = NULL;
			_tmp17_ = ((item_collection[item_it] != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item_collection[item_it]) : ((gpointer) item_collection[item_it]);
			item = _tmp17_;
			{
				gconstpointer _tmp18_;
				_tmp18_ = item;
				gee_collection_add ((GeeCollection*) list, _tmp18_);
				((item == NULL) || (g_destroy_func == NULL)) ? NULL : (item = (g_destroy_func (item), NULL));
			}
		}
	}
	_g_object_unref0 (helper);
}

static void
gee_tim_sort_sort_arraylist (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             GeeArrayList* list,
                             GCompareDataFunc compare,
                             gpointer compare_target)
{
	GeeTimSort* helper = NULL;
	GeeTimSort* _tmp0_;
	GeeList* _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GeeList*) list);
	_g_object_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp1_;
	_tmp2_ = list->_items;
	_tmp2__length1 = list->_items_length1;
	helper->priv->list = _tmp2_;
	helper->priv->index = 0;
	helper->priv->size = list->_size;
	helper->priv->compare = compare;
	helper->priv->compare_target = compare_target;
	gee_tim_sort_do_sort (helper);
	_g_object_unref0 (helper);
}

static void
_vala_array_add3 (GeeTimSortSlice** * array,
                  gint* length,
                  gint* size,
                  GeeTimSortSlice* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gee_tim_sort_do_sort (GeeTimSort* self)
{
	GeeTimSortSlice** _tmp0_;
	GeeTimSortSlice* remaining = NULL;
	void** _tmp1_;
	GeeTimSortSlice* _tmp2_;
	gint minimum_length = 0;
	GeeTimSortSlice* _tmp3_;
	GeeTimSortSlice* _tmp17_;
	GeeTimSortSlice** _tmp18_;
	gint _tmp18__length1;
	GeeTimSortSlice** _tmp19_;
	gint _tmp19__length1;
	GeeTimSortSlice* _tmp20_;
	GeeTimSortSlice** _tmp21_;
	gint _tmp21__length1;
	GeeTimSortSlice* _tmp22_;
	g_return_if_fail (self != NULL);
	if (self->priv->size < 2) {
		return;
	}
	_tmp0_ = g_new0 (GeeTimSortSlice*, 0 + 1);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	self->priv->pending = _tmp0_;
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
	_tmp1_ = self->priv->list;
	_tmp2_ = gee_tim_sort_slice_new (_tmp1_, self->priv->index, self->priv->size);
	remaining = _tmp2_;
	_tmp3_ = remaining;
	minimum_length = gee_tim_sort_compute_minimum_run_length (self, _tmp3_->length);
	while (TRUE) {
		GeeTimSortSlice* _tmp4_;
		gboolean descending = FALSE;
		GeeTimSortSlice* run = NULL;
		GeeTimSortSlice* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GeeTimSortSlice* _tmp7_;
		GeeTimSortSlice* _tmp9_;
		GeeTimSortSlice* _tmp14_;
		GeeTimSortSlice* _tmp15_;
		GeeTimSortSlice* _tmp16_;
		_tmp4_ = remaining;
		if (!(_tmp4_->length > 0)) {
			break;
		}
		_tmp5_ = remaining;
		_tmp7_ = gee_tim_sort_compute_longest_run (self, _tmp5_, &_tmp6_);
		descending = _tmp6_;
		run = _tmp7_;
		if (descending) {
			GeeTimSortSlice* _tmp8_;
			_tmp8_ = run;
			gee_tim_sort_slice_reverse (_tmp8_);
		}
		_tmp9_ = run;
		if (_tmp9_->length < minimum_length) {
			gint sorted_count = 0;
			GeeTimSortSlice* _tmp10_;
			GeeTimSortSlice* _tmp11_;
			GeeTimSortSlice* _tmp12_;
			GeeTimSortSlice* _tmp13_;
			_tmp10_ = run;
			sorted_count = _tmp10_->length;
			_tmp11_ = run;
			_tmp12_ = remaining;
			_tmp11_->length = MIN (minimum_length, _tmp12_->length);
			_tmp13_ = run;
			gee_tim_sort_insertion_sort (self, _tmp13_, sorted_count);
		}
		_tmp14_ = remaining;
		_tmp15_ = run;
		gee_tim_sort_slice_shorten_start (_tmp14_, _tmp15_->length);
		_tmp16_ = run;
		run = NULL;
		_vala_array_add3 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp16_);
		gee_tim_sort_merge_collapse (self);
		_gee_tim_sort_slice_free0 (run);
	}
	_tmp17_ = remaining;
	_vala_assert (_tmp17_->index == self->priv->size, "remaining.index == size");
	gee_tim_sort_merge_force_collapse (self);
	_tmp18_ = self->priv->pending;
	_tmp18__length1 = self->priv->pending_length1;
	_vala_assert (_tmp18__length1 == 1, "pending.length == 1");
	_tmp19_ = self->priv->pending;
	_tmp19__length1 = self->priv->pending_length1;
	_tmp20_ = _tmp19_[0];
	_vala_assert (_tmp20_->index == 0, "pending[0].index == 0");
	_tmp21_ = self->priv->pending;
	_tmp21__length1 = self->priv->pending_length1;
	_tmp22_ = _tmp21_[0];
	_vala_assert (_tmp22_->length == self->priv->size, "pending[0].length == size");
	_gee_tim_sort_slice_free0 (remaining);
}

static inline gboolean
gee_tim_sort_lower_than (GeeTimSort* self,
                         gconstpointer left,
                         gconstpointer right)
{
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	result = _tmp0_ (left, right, _tmp0__target) < 0;
	return result;
}

static inline gboolean
gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self,
                                     gconstpointer left,
                                     gconstpointer right)
{
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	result = _tmp0_ (left, right, _tmp0__target) <= 0;
	return result;
}

static gint
gee_tim_sort_compute_minimum_run_length (GeeTimSort* self,
                                         gint length)
{
	gint run_length = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		if (!(length >= 64)) {
			break;
		}
		run_length |= length & 1;
		length = length >> 1;
	}
	result = length + run_length;
	return result;
}

static GeeTimSortSlice*
gee_tim_sort_compute_longest_run (GeeTimSort* self,
                                  GeeTimSortSlice* a,
                                  gboolean* descending)
{
	gboolean _vala_descending = FALSE;
	gint run_length = 0;
	void** _tmp18_;
	GeeTimSortSlice* _tmp19_;
	GeeTimSortSlice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	if (a->length <= 1) {
		run_length = a->length;
		_vala_descending = FALSE;
	} else {
		void** _tmp0_;
		void* _tmp1_;
		void** _tmp2_;
		void* _tmp3_;
		run_length = 2;
		_tmp0_ = a->list;
		_tmp1_ = _tmp0_[a->index + 1];
		_tmp2_ = a->list;
		_tmp3_ = _tmp2_[a->index];
		if (gee_tim_sort_lower_than (self, _tmp1_, _tmp3_)) {
			_vala_descending = TRUE;
			{
				gint i = 0;
				i = a->index + 2;
				{
					gboolean _tmp4_ = FALSE;
					_tmp4_ = TRUE;
					while (TRUE) {
						void** _tmp6_;
						void* _tmp7_;
						void** _tmp8_;
						void* _tmp9_;
						if (!_tmp4_) {
							gint _tmp5_;
							_tmp5_ = i;
							i = _tmp5_ + 1;
						}
						_tmp4_ = FALSE;
						if (!(i < (a->index + a->length))) {
							break;
						}
						_tmp6_ = a->list;
						_tmp7_ = _tmp6_[i];
						_tmp8_ = a->list;
						_tmp9_ = _tmp8_[i - 1];
						if (gee_tim_sort_lower_than (self, _tmp7_, _tmp9_)) {
							gint _tmp10_;
							_tmp10_ = run_length;
							run_length = _tmp10_ + 1;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_vala_descending = FALSE;
			{
				gint i = 0;
				i = a->index + 2;
				{
					gboolean _tmp11_ = FALSE;
					_tmp11_ = TRUE;
					while (TRUE) {
						void** _tmp13_;
						void* _tmp14_;
						void** _tmp15_;
						void* _tmp16_;
						if (!_tmp11_) {
							gint _tmp12_;
							_tmp12_ = i;
							i = _tmp12_ + 1;
						}
						_tmp11_ = FALSE;
						if (!(i < (a->index + a->length))) {
							break;
						}
						_tmp13_ = a->list;
						_tmp14_ = _tmp13_[i];
						_tmp15_ = a->list;
						_tmp16_ = _tmp15_[i - 1];
						if (gee_tim_sort_lower_than (self, _tmp14_, _tmp16_)) {
							break;
						} else {
							gint _tmp17_;
							_tmp17_ = run_length;
							run_length = _tmp17_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp18_ = a->list;
	_tmp19_ = gee_tim_sort_slice_new (_tmp18_, a->index, run_length);
	result = _tmp19_;
	if (descending) {
		*descending = _vala_descending;
	}
	return result;
}

static void
gee_tim_sort_insertion_sort (GeeTimSort* self,
                             GeeTimSortSlice* a,
                             gint offset)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		gint start = 0;
		start = a->index + offset;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint left = 0;
				gint right = 0;
				void* pivot = NULL;
				void** _tmp2_;
				void* _tmp3_;
				void** _tmp7_;
				void** _tmp8_;
				void** _tmp9_;
				void* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = start;
					start = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(start < (a->index + a->length))) {
					break;
				}
				left = a->index;
				right = start;
				_tmp2_ = a->list;
				_tmp3_ = _tmp2_[right];
				pivot = _tmp3_;
				while (TRUE) {
					gint p = 0;
					void* _tmp4_;
					void** _tmp5_;
					void* _tmp6_;
					if (!(left < right)) {
						break;
					}
					p = left + ((right - left) >> 1);
					_tmp4_ = pivot;
					_tmp5_ = a->list;
					_tmp6_ = _tmp5_[p];
					if (gee_tim_sort_lower_than (self, _tmp4_, _tmp6_)) {
						right = p;
					} else {
						left = p + 1;
					}
				}
				_vala_assert (left == right, "left == right");
				_tmp7_ = a->list;
				_tmp8_ = a->list;
				memmove (&_tmp7_[left + 1], &_tmp8_[left], (gsize) (sizeof (gpointer) * (start - left)));
				_tmp9_ = a->list;
				_tmp10_ = pivot;
				_tmp9_[left] = _tmp10_;
			}
		}
	}
}

static void
gee_tim_sort_merge_collapse (GeeTimSort* self)
{
	gint count = 0;
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GeeTimSortSlice** _tmp16_;
		gint _tmp16__length1;
		if (!(count > 1)) {
			break;
		}
		if (count >= 3) {
			GeeTimSortSlice** _tmp2_;
			gint _tmp2__length1;
			GeeTimSortSlice* _tmp3_;
			GeeTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			GeeTimSortSlice* _tmp5_;
			GeeTimSortSlice** _tmp6_;
			gint _tmp6__length1;
			GeeTimSortSlice* _tmp7_;
			_tmp2_ = self->priv->pending;
			_tmp2__length1 = self->priv->pending_length1;
			_tmp3_ = _tmp2_[count - 3];
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = _tmp4_[count - 2];
			_tmp6_ = self->priv->pending;
			_tmp6__length1 = self->priv->pending_length1;
			_tmp7_ = _tmp6_[count - 1];
			_tmp1_ = _tmp3_->length <= (_tmp5_->length + _tmp7_->length);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GeeTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			GeeTimSortSlice* _tmp9_;
			GeeTimSortSlice** _tmp10_;
			gint _tmp10__length1;
			GeeTimSortSlice* _tmp11_;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = _tmp8_[count - 3];
			_tmp10_ = self->priv->pending;
			_tmp10__length1 = self->priv->pending_length1;
			_tmp11_ = _tmp10_[count - 1];
			if (_tmp9_->length < _tmp11_->length) {
				gee_tim_sort_merge_at (self, count - 3);
			} else {
				gee_tim_sort_merge_at (self, count - 2);
			}
		} else {
			GeeTimSortSlice** _tmp12_;
			gint _tmp12__length1;
			GeeTimSortSlice* _tmp13_;
			GeeTimSortSlice** _tmp14_;
			gint _tmp14__length1;
			GeeTimSortSlice* _tmp15_;
			_tmp12_ = self->priv->pending;
			_tmp12__length1 = self->priv->pending_length1;
			_tmp13_ = _tmp12_[count - 2];
			_tmp14_ = self->priv->pending;
			_tmp14__length1 = self->priv->pending_length1;
			_tmp15_ = _tmp14_[count - 1];
			if (_tmp13_->length <= _tmp15_->length) {
				gee_tim_sort_merge_at (self, count - 2);
			} else {
				break;
			}
		}
		_tmp16_ = self->priv->pending;
		_tmp16__length1 = self->priv->pending_length1;
		count = _tmp16__length1;
	}
}

static void
gee_tim_sort_merge_force_collapse (GeeTimSort* self)
{
	gint count = 0;
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GeeTimSortSlice** _tmp6_;
		gint _tmp6__length1;
		if (!(count > 1)) {
			break;
		}
		if (count >= 3) {
			GeeTimSortSlice** _tmp2_;
			gint _tmp2__length1;
			GeeTimSortSlice* _tmp3_;
			GeeTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			GeeTimSortSlice* _tmp5_;
			_tmp2_ = self->priv->pending;
			_tmp2__length1 = self->priv->pending_length1;
			_tmp3_ = _tmp2_[count - 3];
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = _tmp4_[count - 1];
			_tmp1_ = _tmp3_->length < _tmp5_->length;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gee_tim_sort_merge_at (self, count - 3);
		} else {
			gee_tim_sort_merge_at (self, count - 2);
		}
		_tmp6_ = self->priv->pending;
		_tmp6__length1 = self->priv->pending_length1;
		count = _tmp6__length1;
	}
}

static void
gee_tim_sort_merge_at (GeeTimSort* self,
                       gint index)
{
	GeeTimSortSlice* a = NULL;
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	GeeTimSortSlice* _tmp1_;
	GeeTimSortSlice* b = NULL;
	GeeTimSortSlice** _tmp2_;
	gint _tmp2__length1;
	GeeTimSortSlice* _tmp3_;
	GeeTimSortSlice* _tmp4_;
	GeeTimSortSlice* _tmp5_;
	GeeTimSortSlice* _tmp6_;
	GeeTimSortSlice* _tmp7_;
	GeeTimSortSlice* _tmp8_;
	GeeTimSortSlice** _tmp9_;
	gint _tmp9__length1;
	void** _tmp10_;
	GeeTimSortSlice* _tmp11_;
	GeeTimSortSlice* _tmp12_;
	GeeTimSortSlice* _tmp13_;
	GeeTimSortSlice* _tmp14_;
	GeeTimSortSlice** _tmp15_;
	gint _tmp15__length1;
	gint sorted_count = 0;
	GeeTimSortSlice* _tmp16_;
	void* _tmp17_;
	GeeTimSortSlice* _tmp18_;
	GeeTimSortSlice* _tmp19_;
	GeeTimSortSlice* _tmp20_;
	GeeTimSortSlice* _tmp21_;
	GeeTimSortSlice* _tmp22_;
	void* _tmp23_;
	GeeTimSortSlice* _tmp24_;
	GeeTimSortSlice* _tmp25_;
	GeeTimSortSlice* _tmp26_;
	GeeTimSortSlice* _tmp27_;
	GeeTimSortSlice* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	a = _tmp1_;
	_tmp2_ = self->priv->pending;
	_tmp2__length1 = self->priv->pending_length1;
	_tmp3_ = _tmp2_[index + 1];
	_tmp2_[index + 1] = NULL;
	b = _tmp3_;
	_tmp4_ = a;
	_vala_assert (_tmp4_->length > 0, "a.length > 0");
	_tmp5_ = b;
	_vala_assert (_tmp5_->length > 0, "b.length > 0");
	_tmp6_ = a;
	_tmp7_ = a;
	_tmp8_ = b;
	_vala_assert ((_tmp6_->index + _tmp7_->length) == _tmp8_->index, "a.index + a.length == b.index");
	_tmp9_ = self->priv->pending;
	_tmp9__length1 = self->priv->pending_length1;
	_tmp10_ = self->priv->list;
	_tmp11_ = a;
	_tmp12_ = a;
	_tmp13_ = b;
	_tmp14_ = gee_tim_sort_slice_new (_tmp10_, _tmp11_->index, _tmp12_->length + _tmp13_->length);
	_gee_tim_sort_slice_free0 (_tmp9_[index]);
	_tmp9_[index] = _tmp14_;
	_tmp15_ = self->priv->pending;
	_tmp15__length1 = self->priv->pending_length1;
	_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), index + 2, index + 1, (_tmp15__length1 - index) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp16_ = b;
	_tmp17_ = gee_tim_sort_slice_peek_first (_tmp16_);
	_tmp18_ = a;
	sorted_count = gee_tim_sort_gallop_rightmost (self, _tmp17_, _tmp18_, 0);
	_tmp19_ = a;
	gee_tim_sort_slice_shorten_start (_tmp19_, sorted_count);
	_tmp20_ = a;
	if (_tmp20_->length == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp21_ = b;
	_tmp22_ = a;
	_tmp23_ = gee_tim_sort_slice_peek_last (_tmp22_);
	_tmp24_ = b;
	_tmp25_ = b;
	_tmp21_->length = gee_tim_sort_gallop_leftmost (self, _tmp23_, _tmp24_, _tmp25_->length - 1);
	_tmp26_ = b;
	if (_tmp26_->length == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp27_ = a;
	_tmp28_ = b;
	if (_tmp27_->length <= _tmp28_->length) {
		GeeTimSortSlice* _tmp29_;
		GeeTimSortSlice* _tmp30_;
		_tmp29_ = a;
		a = NULL;
		_tmp30_ = b;
		b = NULL;
		gee_tim_sort_merge_low (self, _tmp29_, _tmp30_);
	} else {
		GeeTimSortSlice* _tmp31_;
		GeeTimSortSlice* _tmp32_;
		_tmp31_ = a;
		a = NULL;
		_tmp32_ = b;
		b = NULL;
		gee_tim_sort_merge_high (self, _tmp31_, _tmp32_);
	}
	_gee_tim_sort_slice_free0 (b);
	_gee_tim_sort_slice_free0 (a);
}

static gint
gee_tim_sort_gallop_leftmost (GeeTimSort* self,
                              gconstpointer key,
                              GeeTimSortSlice* a,
                              gint hint)
{
	gint p = 0;
	gint last_offset = 0;
	gint offset = 0;
	void** _tmp0_;
	void* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_vala_assert (0 <= hint, "0 <= hint");
	_vala_assert (hint < a->length, "hint < a.length");
	p = a->index + hint;
	last_offset = 0;
	offset = 1;
	_tmp0_ = a->list;
	_tmp1_ = _tmp0_[p];
	if (gee_tim_sort_lower_than (self, _tmp1_, key)) {
		gint max_offset = 0;
		max_offset = a->length - hint;
		while (TRUE) {
			void** _tmp2_;
			void* _tmp3_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp2_ = a->list;
			_tmp3_ = _tmp2_[p + offset];
			if (gee_tim_sort_lower_than (self, _tmp3_, key)) {
				gint _tmp4_;
				last_offset = offset;
				offset <<= 1;
				_tmp4_ = offset;
				offset = _tmp4_ + 1;
			} else {
				break;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		last_offset = hint + last_offset;
		offset = hint + offset;
	} else {
		gint max_offset = 0;
		gint temp_last_offset = 0;
		gint temp_offset = 0;
		max_offset = hint + 1;
		while (TRUE) {
			void** _tmp5_;
			void* _tmp6_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp5_ = a->list;
			_tmp6_ = _tmp5_[p - offset];
			if (gee_tim_sort_lower_than (self, _tmp6_, key)) {
				break;
			} else {
				gint _tmp7_;
				last_offset = offset;
				offset <<= 1;
				_tmp7_ = offset;
				offset = _tmp7_ + 1;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		temp_last_offset = last_offset;
		temp_offset = offset;
		last_offset = hint - temp_offset;
		offset = hint - temp_last_offset;
	}
	_vala_assert (-1 <= last_offset, "-1 <= last_offset");
	_vala_assert (last_offset < offset, "last_offset < offset");
	_vala_assert (offset <= a->length, "offset <= a.length");
	last_offset += 1;
	while (TRUE) {
		gint m = 0;
		void** _tmp8_;
		void* _tmp9_;
		if (!(last_offset < offset)) {
			break;
		}
		m = last_offset + ((offset - last_offset) >> 1);
		_tmp8_ = a->list;
		_tmp9_ = _tmp8_[a->index + m];
		if (gee_tim_sort_lower_than (self, _tmp9_, key)) {
			last_offset = m + 1;
		} else {
			offset = m;
		}
	}
	_vala_assert (last_offset == offset, "last_offset == offset");
	result = offset;
	return result;
}

static gint
gee_tim_sort_gallop_rightmost (GeeTimSort* self,
                               gconstpointer key,
                               GeeTimSortSlice* a,
                               gint hint)
{
	gint p = 0;
	gint last_offset = 0;
	gint offset = 0;
	void** _tmp0_;
	void* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_vala_assert (0 <= hint, "0 <= hint");
	_vala_assert (hint < a->length, "hint < a.length");
	p = a->index + hint;
	last_offset = 0;
	offset = 1;
	_tmp0_ = a->list;
	_tmp1_ = _tmp0_[p];
	if (gee_tim_sort_lower_than_or_equal_to (self, _tmp1_, key)) {
		gint max_offset = 0;
		max_offset = a->length - hint;
		while (TRUE) {
			void** _tmp2_;
			void* _tmp3_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp2_ = a->list;
			_tmp3_ = _tmp2_[p + offset];
			if (gee_tim_sort_lower_than_or_equal_to (self, _tmp3_, key)) {
				gint _tmp4_;
				last_offset = offset;
				offset <<= 1;
				_tmp4_ = offset;
				offset = _tmp4_ + 1;
			} else {
				break;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		last_offset = hint + last_offset;
		offset = hint + offset;
	} else {
		gint max_offset = 0;
		gint temp_last_offset = 0;
		gint temp_offset = 0;
		max_offset = hint + 1;
		while (TRUE) {
			void** _tmp5_;
			void* _tmp6_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp5_ = a->list;
			_tmp6_ = _tmp5_[p - offset];
			if (gee_tim_sort_lower_than_or_equal_to (self, _tmp6_, key)) {
				break;
			} else {
				gint _tmp7_;
				last_offset = offset;
				offset <<= 1;
				_tmp7_ = offset;
				offset = _tmp7_ + 1;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		temp_last_offset = last_offset;
		temp_offset = offset;
		last_offset = hint - temp_offset;
		offset = hint - temp_last_offset;
	}
	_vala_assert (-1 <= last_offset, "-1 <= last_offset");
	_vala_assert (last_offset < offset, "last_offset < offset");
	_vala_assert (offset <= a->length, "offset <= a.length");
	last_offset += 1;
	while (TRUE) {
		gint m = 0;
		void** _tmp8_;
		void* _tmp9_;
		if (!(last_offset < offset)) {
			break;
		}
		m = last_offset + ((offset - last_offset) >> 1);
		_tmp8_ = a->list;
		_tmp9_ = _tmp8_[a->index + m];
		if (gee_tim_sort_lower_than_or_equal_to (self, _tmp9_, key)) {
			last_offset = m + 1;
		} else {
			offset = m;
		}
	}
	_vala_assert (last_offset == offset, "last_offset == offset");
	result = offset;
	return result;
}

static void
gee_tim_sort_merge_low (GeeTimSort* self,
                        GeeTimSortSlice* a,
                        GeeTimSortSlice* b)
{
	gint minimum_gallop = 0;
	gint dest = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_vala_assert (a->length > 0, "a.length > 0");
	_vala_assert (b->length > 0, "b.length > 0");
	_vala_assert ((a->index + a->length) == b->index, "a.index + a.length == b.index");
	minimum_gallop = self->priv->minimum_gallop;
	dest = a->index;
	gee_tim_sort_slice_copy (a);
	{
		void** _tmp0_;
		gint _tmp1_;
		void* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = self->priv->list;
		_tmp1_ = dest;
		dest = _tmp1_ + 1;
		_tmp2_ = gee_tim_sort_slice_pop_first (b);
		_tmp0_[_tmp1_] = _tmp2_;
		if (a->length == 1) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = b->length == 0;
		}
		if (_tmp3_) {
			{
				void** _tmp4_;
				void** _tmp5_;
				_vala_assert (a->length >= 0, "a.length >= 0");
				_vala_assert (b->length >= 0, "b.length >= 0");
				_tmp4_ = self->priv->list;
				gee_tim_sort_slice_merge_in (b, _tmp4_, b->index, dest, b->length);
				_tmp5_ = self->priv->list;
				gee_tim_sort_slice_merge_in (a, _tmp5_, a->index, dest + b->length, a->length);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp20_;
			gint _tmp41_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				void* _tmp6_;
				void* _tmp7_;
				_tmp6_ = gee_tim_sort_slice_peek_first (b);
				_tmp7_ = gee_tim_sort_slice_peek_first (a);
				if (gee_tim_sort_lower_than (self, _tmp6_, _tmp7_)) {
					void** _tmp8_;
					gint _tmp9_;
					void* _tmp10_;
					gint _tmp13_;
					_tmp8_ = self->priv->list;
					_tmp9_ = dest;
					dest = _tmp9_ + 1;
					_tmp10_ = gee_tim_sort_slice_pop_first (b);
					_tmp8_[_tmp9_] = _tmp10_;
					if (b->length == 0) {
						{
							void** _tmp11_;
							void** _tmp12_;
							_vala_assert (a->length >= 0, "a.length >= 0");
							_vala_assert (b->length >= 0, "b.length >= 0");
							_tmp11_ = self->priv->list;
							gee_tim_sort_slice_merge_in (b, _tmp11_, b->index, dest, b->length);
							_tmp12_ = self->priv->list;
							gee_tim_sort_slice_merge_in (a, _tmp12_, a->index, dest + b->length, a->length);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp13_ = b_count;
					b_count = _tmp13_ + 1;
					a_count = 0;
					if (b_count >= minimum_gallop) {
						break;
					}
				} else {
					void** _tmp14_;
					gint _tmp15_;
					void* _tmp16_;
					gint _tmp19_;
					_tmp14_ = self->priv->list;
					_tmp15_ = dest;
					dest = _tmp15_ + 1;
					_tmp16_ = gee_tim_sort_slice_pop_first (a);
					_tmp14_[_tmp15_] = _tmp16_;
					if (a->length == 1) {
						{
							void** _tmp17_;
							void** _tmp18_;
							_vala_assert (a->length >= 0, "a.length >= 0");
							_vala_assert (b->length >= 0, "b.length >= 0");
							_tmp17_ = self->priv->list;
							gee_tim_sort_slice_merge_in (b, _tmp17_, b->index, dest, b->length);
							_tmp18_ = self->priv->list;
							gee_tim_sort_slice_merge_in (a, _tmp18_, a->index, dest + b->length, a->length);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp19_ = a_count;
					a_count = _tmp19_ + 1;
					b_count = 0;
					if (a_count >= minimum_gallop) {
						break;
					}
				}
			}
			_tmp20_ = minimum_gallop;
			minimum_gallop = _tmp20_ + 1;
			while (TRUE) {
				gint _tmp21_ = 0;
				void* _tmp22_;
				void** _tmp23_;
				void** _tmp26_;
				gint _tmp27_;
				void* _tmp28_;
				void* _tmp31_;
				void** _tmp32_;
				void** _tmp35_;
				gint _tmp36_;
				void* _tmp37_;
				gboolean _tmp40_ = FALSE;
				if (minimum_gallop > 1) {
					_tmp21_ = 1;
				} else {
					_tmp21_ = 0;
				}
				minimum_gallop -= _tmp21_;
				self->priv->minimum_gallop = minimum_gallop;
				_tmp22_ = gee_tim_sort_slice_peek_first (b);
				a_count = gee_tim_sort_gallop_rightmost (self, _tmp22_, a, 0);
				_tmp23_ = self->priv->list;
				gee_tim_sort_slice_merge_in (a, _tmp23_, a->index, dest, a_count);
				dest += a_count;
				gee_tim_sort_slice_shorten_start (a, a_count);
				if (a->length <= 1) {
					{
						void** _tmp24_;
						void** _tmp25_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp24_ = self->priv->list;
						gee_tim_sort_slice_merge_in (b, _tmp24_, b->index, dest, b->length);
						_tmp25_ = self->priv->list;
						gee_tim_sort_slice_merge_in (a, _tmp25_, a->index, dest + b->length, a->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp26_ = self->priv->list;
				_tmp27_ = dest;
				dest = _tmp27_ + 1;
				_tmp28_ = gee_tim_sort_slice_pop_first (b);
				_tmp26_[_tmp27_] = _tmp28_;
				if (b->length == 0) {
					{
						void** _tmp29_;
						void** _tmp30_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp29_ = self->priv->list;
						gee_tim_sort_slice_merge_in (b, _tmp29_, b->index, dest, b->length);
						_tmp30_ = self->priv->list;
						gee_tim_sort_slice_merge_in (a, _tmp30_, a->index, dest + b->length, a->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp31_ = gee_tim_sort_slice_peek_first (a);
				b_count = gee_tim_sort_gallop_leftmost (self, _tmp31_, b, 0);
				_tmp32_ = self->priv->list;
				gee_tim_sort_slice_merge_in (b, _tmp32_, b->index, dest, b_count);
				dest += b_count;
				gee_tim_sort_slice_shorten_start (b, b_count);
				if (b->length == 0) {
					{
						void** _tmp33_;
						void** _tmp34_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp33_ = self->priv->list;
						gee_tim_sort_slice_merge_in (b, _tmp33_, b->index, dest, b->length);
						_tmp34_ = self->priv->list;
						gee_tim_sort_slice_merge_in (a, _tmp34_, a->index, dest + b->length, a->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp35_ = self->priv->list;
				_tmp36_ = dest;
				dest = _tmp36_ + 1;
				_tmp37_ = gee_tim_sort_slice_pop_first (a);
				_tmp35_[_tmp36_] = _tmp37_;
				if (a->length == 1) {
					{
						void** _tmp38_;
						void** _tmp39_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp38_ = self->priv->list;
						gee_tim_sort_slice_merge_in (b, _tmp38_, b->index, dest, b->length);
						_tmp39_ = self->priv->list;
						gee_tim_sort_slice_merge_in (a, _tmp39_, a->index, dest + b->length, a->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
					_tmp40_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					break;
				}
			}
			_tmp41_ = minimum_gallop;
			minimum_gallop = _tmp41_ + 1;
			self->priv->minimum_gallop = minimum_gallop;
		}
	}
	__finally0:
	{
		void** _tmp42_;
		void** _tmp43_;
		_vala_assert (a->length >= 0, "a.length >= 0");
		_vala_assert (b->length >= 0, "b.length >= 0");
		_tmp42_ = self->priv->list;
		gee_tim_sort_slice_merge_in (b, _tmp42_, b->index, dest, b->length);
		_tmp43_ = self->priv->list;
		gee_tim_sort_slice_merge_in (a, _tmp43_, a->index, dest + b->length, a->length);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return;
}

static void
gee_tim_sort_merge_high (GeeTimSort* self,
                         GeeTimSortSlice* a,
                         GeeTimSortSlice* b)
{
	gint minimum_gallop = 0;
	gint dest = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_vala_assert (a->length > 0, "a.length > 0");
	_vala_assert (b->length > 0, "b.length > 0");
	_vala_assert ((a->index + a->length) == b->index, "a.index + a.length == b.index");
	minimum_gallop = self->priv->minimum_gallop;
	dest = b->index + b->length;
	gee_tim_sort_slice_copy (b);
	{
		void** _tmp0_;
		gint _tmp1_;
		void* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = self->priv->list;
		dest = dest - 1;
		_tmp1_ = dest;
		_tmp2_ = gee_tim_sort_slice_pop_last (a);
		_tmp0_[_tmp1_] = _tmp2_;
		if (a->length == 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = b->length == 1;
		}
		if (_tmp3_) {
			{
				void** _tmp4_;
				void** _tmp5_;
				_vala_assert (a->length >= 0, "a.length >= 0");
				_vala_assert (b->length >= 0, "b.length >= 0");
				_tmp4_ = self->priv->list;
				gee_tim_sort_slice_merge_in_reversed (a, _tmp4_, a->index, dest - a->length, a->length);
				_tmp5_ = self->priv->list;
				gee_tim_sort_slice_merge_in_reversed (b, _tmp5_, b->index, (dest - a->length) - b->length, b->length);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp20_;
			gint _tmp41_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				void* _tmp6_;
				void* _tmp7_;
				_tmp6_ = gee_tim_sort_slice_peek_last (b);
				_tmp7_ = gee_tim_sort_slice_peek_last (a);
				if (gee_tim_sort_lower_than (self, _tmp6_, _tmp7_)) {
					void** _tmp8_;
					gint _tmp9_;
					void* _tmp10_;
					gint _tmp13_;
					_tmp8_ = self->priv->list;
					dest = dest - 1;
					_tmp9_ = dest;
					_tmp10_ = gee_tim_sort_slice_pop_last (a);
					_tmp8_[_tmp9_] = _tmp10_;
					if (a->length == 0) {
						{
							void** _tmp11_;
							void** _tmp12_;
							_vala_assert (a->length >= 0, "a.length >= 0");
							_vala_assert (b->length >= 0, "b.length >= 0");
							_tmp11_ = self->priv->list;
							gee_tim_sort_slice_merge_in_reversed (a, _tmp11_, a->index, dest - a->length, a->length);
							_tmp12_ = self->priv->list;
							gee_tim_sort_slice_merge_in_reversed (b, _tmp12_, b->index, (dest - a->length) - b->length, b->length);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp13_ = a_count;
					a_count = _tmp13_ + 1;
					b_count = 0;
					if (a_count >= minimum_gallop) {
						break;
					}
				} else {
					void** _tmp14_;
					gint _tmp15_;
					void* _tmp16_;
					gint _tmp19_;
					_tmp14_ = self->priv->list;
					dest = dest - 1;
					_tmp15_ = dest;
					_tmp16_ = gee_tim_sort_slice_pop_last (b);
					_tmp14_[_tmp15_] = _tmp16_;
					if (b->length == 1) {
						{
							void** _tmp17_;
							void** _tmp18_;
							_vala_assert (a->length >= 0, "a.length >= 0");
							_vala_assert (b->length >= 0, "b.length >= 0");
							_tmp17_ = self->priv->list;
							gee_tim_sort_slice_merge_in_reversed (a, _tmp17_, a->index, dest - a->length, a->length);
							_tmp18_ = self->priv->list;
							gee_tim_sort_slice_merge_in_reversed (b, _tmp18_, b->index, (dest - a->length) - b->length, b->length);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp19_ = b_count;
					b_count = _tmp19_ + 1;
					a_count = 0;
					if (b_count >= minimum_gallop) {
						break;
					}
				}
			}
			_tmp20_ = minimum_gallop;
			minimum_gallop = _tmp20_ + 1;
			while (TRUE) {
				gint _tmp21_ = 0;
				gint k = 0;
				void* _tmp22_;
				void** _tmp23_;
				void** _tmp26_;
				gint _tmp27_;
				void* _tmp28_;
				void* _tmp31_;
				void** _tmp32_;
				void** _tmp35_;
				gint _tmp36_;
				void* _tmp37_;
				gboolean _tmp40_ = FALSE;
				if (minimum_gallop > 1) {
					_tmp21_ = 1;
				} else {
					_tmp21_ = 0;
				}
				minimum_gallop -= _tmp21_;
				self->priv->minimum_gallop = minimum_gallop;
				_tmp22_ = gee_tim_sort_slice_peek_last (b);
				k = gee_tim_sort_gallop_rightmost (self, _tmp22_, a, a->length - 1);
				a_count = a->length - k;
				_tmp23_ = self->priv->list;
				gee_tim_sort_slice_merge_in_reversed (a, _tmp23_, a->index + k, dest - a_count, a_count);
				dest -= a_count;
				gee_tim_sort_slice_shorten_end (a, a_count);
				if (a->length == 0) {
					{
						void** _tmp24_;
						void** _tmp25_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp24_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (a, _tmp24_, a->index, dest - a->length, a->length);
						_tmp25_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (b, _tmp25_, b->index, (dest - a->length) - b->length, b->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp26_ = self->priv->list;
				dest = dest - 1;
				_tmp27_ = dest;
				_tmp28_ = gee_tim_sort_slice_pop_last (b);
				_tmp26_[_tmp27_] = _tmp28_;
				if (b->length == 1) {
					{
						void** _tmp29_;
						void** _tmp30_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp29_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (a, _tmp29_, a->index, dest - a->length, a->length);
						_tmp30_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (b, _tmp30_, b->index, (dest - a->length) - b->length, b->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp31_ = gee_tim_sort_slice_peek_last (a);
				k = gee_tim_sort_gallop_leftmost (self, _tmp31_, b, b->length - 1);
				b_count = b->length - k;
				_tmp32_ = self->priv->list;
				gee_tim_sort_slice_merge_in_reversed (b, _tmp32_, b->index + k, dest - b_count, b_count);
				dest -= b_count;
				gee_tim_sort_slice_shorten_end (b, b_count);
				if (b->length <= 1) {
					{
						void** _tmp33_;
						void** _tmp34_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp33_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (a, _tmp33_, a->index, dest - a->length, a->length);
						_tmp34_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (b, _tmp34_, b->index, (dest - a->length) - b->length, b->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp35_ = self->priv->list;
				dest = dest - 1;
				_tmp36_ = dest;
				_tmp37_ = gee_tim_sort_slice_pop_last (a);
				_tmp35_[_tmp36_] = _tmp37_;
				if (a->length == 0) {
					{
						void** _tmp38_;
						void** _tmp39_;
						_vala_assert (a->length >= 0, "a.length >= 0");
						_vala_assert (b->length >= 0, "b.length >= 0");
						_tmp38_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (a, _tmp38_, a->index, dest - a->length, a->length);
						_tmp39_ = self->priv->list;
						gee_tim_sort_slice_merge_in_reversed (b, _tmp39_, b->index, (dest - a->length) - b->length, b->length);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
					_tmp40_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					break;
				}
			}
			_tmp41_ = minimum_gallop;
			minimum_gallop = _tmp41_ + 1;
			self->priv->minimum_gallop = minimum_gallop;
		}
	}
	__finally0:
	{
		void** _tmp42_;
		void** _tmp43_;
		_vala_assert (a->length >= 0, "a.length >= 0");
		_vala_assert (b->length >= 0, "b.length >= 0");
		_tmp42_ = self->priv->list;
		gee_tim_sort_slice_merge_in_reversed (a, _tmp42_, a->index, dest - a->length, a->length);
		_tmp43_ = self->priv->list;
		gee_tim_sort_slice_merge_in_reversed (b, _tmp43_, b->index, (dest - a->length) - b->length, b->length);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return;
}

 G_GNUC_INTERNAL GeeTimSort*
gee_tim_sort_construct (GType object_type,
                        GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func)
{
	GeeTimSort * self = NULL;
	self = (GeeTimSort*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}

 G_GNUC_INTERNAL GeeTimSort*
gee_tim_sort_new (GType g_type,
                  GBoxedCopyFunc g_dup_func,
                  GDestroyNotify g_destroy_func)
{
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}

static GeeTimSortSlice*
gee_tim_sort_slice_new (void** list,
                        gint index,
                        gint length)
{
	GeeTimSortSlice* self;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
	self->list = list;
	self->index = index;
	self->length = length;
	return self;
}

static void
gee_tim_sort_slice_copy (GeeTimSortSlice* self)
{
	gsize size = 0UL;
	void* _tmp0_;
	void** _tmp1_;
	void** _tmp2_;
	void** _tmp3_;
	g_return_if_fail (self != NULL);
	size = (gsize) (sizeof (gpointer) * self->length);
	_tmp0_ = g_malloc (size);
	self->new_list = _tmp0_;
	_tmp1_ = self->new_list;
	_tmp2_ = self->list;
	memcpy (_tmp1_, &_tmp2_[self->index], size);
	_tmp3_ = self->new_list;
	self->list = _tmp3_;
	self->index = 0;
}

static inline void
gee_tim_sort_slice_merge_in (GeeTimSortSlice* self,
                             void** dest_array,
                             gint index,
                             gint dest_index,
                             gint count)
{
	void** _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	memmove (&dest_array[dest_index], &_tmp0_[index], (gsize) (sizeof (gpointer) * count));
}

static inline void
gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self,
                                      void** dest_array,
                                      gint index,
                                      gint dest_index,
                                      gint count)
{
	void** _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	memmove (&dest_array[dest_index], &_tmp0_[index], (gsize) (sizeof (gpointer) * count));
}

static inline void
gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self,
                                  gint n)
{
	g_return_if_fail (self != NULL);
	self->index = self->index + n;
	self->length = self->length - n;
}

static inline void
gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self,
                                gint n)
{
	g_return_if_fail (self != NULL);
	self->length = self->length - n;
}

static inline void*
gee_tim_sort_slice_pop_first (GeeTimSortSlice* self)
{
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	self->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}

static inline void*
gee_tim_sort_slice_pop_last (GeeTimSortSlice* self)
{
	gint _tmp0_;
	void** _tmp1_;
	void* _tmp2_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = _tmp1_[self->index + self->length];
	result = _tmp2_;
	return result;
}

static inline void*
gee_tim_sort_slice_peek_first (GeeTimSortSlice* self)
{
	void** _tmp0_;
	void* _tmp1_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = _tmp0_[self->index];
	result = _tmp1_;
	return result;
}

static inline void*
gee_tim_sort_slice_peek_last (GeeTimSortSlice* self)
{
	void** _tmp0_;
	void* _tmp1_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = _tmp0_[(self->index + self->length) - 1];
	result = _tmp1_;
	return result;
}

static void
gee_tim_sort_slice_reverse (GeeTimSortSlice* self)
{
	gint low = 0;
	gint high = 0;
	g_return_if_fail (self != NULL);
	low = self->index;
	high = (self->index + self->length) - 1;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		if (!(low < high)) {
			break;
		}
		_tmp0_ = low;
		low = _tmp0_ + 1;
		_tmp1_ = high;
		high = _tmp1_ - 1;
		gee_tim_sort_slice_swap (self, _tmp0_, _tmp1_);
	}
}

static inline void
gee_tim_sort_slice_swap (GeeTimSortSlice* self,
                         gint i,
                         gint j)
{
	void* temp = NULL;
	void** _tmp0_;
	void* _tmp1_;
	void** _tmp2_;
	void** _tmp3_;
	void* _tmp4_;
	void** _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = _tmp0_[i];
	temp = _tmp1_;
	_tmp2_ = self->list;
	_tmp3_ = self->list;
	_tmp4_ = _tmp3_[j];
	_tmp2_[i] = _tmp4_;
	_tmp5_ = self->list;
	_tmp5_[j] = temp;
}

static void
gee_tim_sort_slice_instance_init (GeeTimSortSlice * self)
{
}

static void
gee_tim_sort_slice_free (GeeTimSortSlice * self)
{
	void** _tmp0_;
	_tmp0_ = self->new_list;
	if (_tmp0_ != NULL) {
		void** _tmp1_;
		_tmp1_ = self->new_list;
		g_free (_tmp1_);
	}
	g_slice_free (GeeTimSortSlice, self);
}

static void
gee_tim_sort_class_init (GeeTimSortClass * klass,
                         gpointer klass_data)
{
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeTimSort_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gee_tim_sort_instance_init (GeeTimSort * self,
                            gpointer klass)
{
	self->priv = gee_tim_sort_get_instance_private (self);
}

static void
gee_tim_sort_finalize (GObject * obj)
{
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_TIM_SORT, GeeTimSort);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}

/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
static GType
gee_tim_sort_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
	GType gee_tim_sort_type_id;
	gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
	GeeTimSort_private_offset = g_type_add_instance_private (gee_tim_sort_type_id, sizeof (GeeTimSortPrivate));
	return gee_tim_sort_type_id;
}

 G_GNUC_INTERNAL GType
gee_tim_sort_get_type (void)
{
	static volatile gsize gee_tim_sort_type_id__once = 0;
	if (g_once_init_enter (&gee_tim_sort_type_id__once)) {
		GType gee_tim_sort_type_id;
		gee_tim_sort_type_id = gee_tim_sort_get_type_once ();
		g_once_init_leave (&gee_tim_sort_type_id__once, gee_tim_sort_type_id);
	}
	return gee_tim_sort_type_id__once;
}

static void
_vala_gee_tim_sort_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		case GEE_TIM_SORT_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_tim_sort_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gssize src,
                  gssize dest,
                  gssize length)
{
	memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}

